/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.eof;

import com.webobjects.eoaccess.EODatabaseContext;
import com.webobjects.eoaccess.EOEntity;
import com.webobjects.eoaccess.EORelationship;
import com.webobjects.eoaccess.EOUtilities;
import com.webobjects.eocontrol.EOEditingContext;
import com.webobjects.eocontrol.EOEnterpriseObject;
import com.webobjects.eocontrol.EOObjectStoreCoordinator;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSRange;
import er.extensions.eof.ERXEOAccessUtilities;
import er.extensions.eof.ERXKey;
import java.util.Enumeration;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ERXBatchFetchUtilities {
    private static Logger log = Logger.getLogger(ERXBatchFetchUtilities.class);

    public static void batchFetch(NSArray sourceObjects, NSArray keypaths) {
        ERXBatchFetchUtilities.batchFetch(sourceObjects, keypaths, false);
    }

    public static void batchFetch(NSArray<? extends EOEnterpriseObject> sourceObjects, ERXKey<?> ... keys) {
        NSMutableArray<String> keypaths = new NSMutableArray<String>();
        for (ERXKey<?> key : keys) {
            keypaths.addObject(key.key());
        }
        ERXBatchFetchUtilities.batchFetch(sourceObjects, keypaths, true);
    }

    public static void batchFetch(EOEnterpriseObject sourceObject, NSArray keypaths, boolean skipFaultedSourceObjects) {
        ERXBatchFetchUtilities.batchFetch(new NSArray<EOEnterpriseObject>(sourceObject), keypaths, skipFaultedSourceObjects);
    }

    public static void batchFetch(NSArray sourceObjects, String keypath) {
        ERXBatchFetchUtilities.batchFetch(sourceObjects, keypath, true);
    }

    public static void batchFetch(NSArray sourceObjects, String keypath, boolean skipFaultedSourceObjects) {
        ERXBatchFetchUtilities.batchFetch(sourceObjects, new NSArray<String>(keypath), skipFaultedSourceObjects);
    }

    public static NSArray batchFetchAndRetrieve(NSArray sourceObjects, String keypath) {
        return ERXBatchFetchUtilities.batchFetchAndRetrieve(sourceObjects, keypath, true);
    }

    public static NSArray batchFetchAndRetrieve(NSArray sourceObjects, String keypath, boolean skipFaultedSourceObjects) {
        ERXBatchFetchUtilities.batchFetch(sourceObjects, keypath, skipFaultedSourceObjects);
        return (NSArray)sourceObjects.valueForKeyPath(keypath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void batchFetch(NSArray sourceObjects, NSArray keypaths, boolean skipFaultedSourceObjects) {
        if (sourceObjects.count() == 0) {
            return;
        }
        EOEnterpriseObject sample = (EOEnterpriseObject)sourceObjects.objectAtIndex(0);
        EOEditingContext ec = sample.editingContext();
        EOObjectStoreCoordinator osc = (EOObjectStoreCoordinator)ec.rootObjectStore();
        osc.lock();
        try {
            NSArray<KeyPath> rootKeyPathObjects = KeyPath.parseKeyPathStrings(keypaths);
            Enumeration<KeyPath> keyPathObjectsEnum = rootKeyPathObjects.objectEnumerator();
            while (keyPathObjectsEnum.hasMoreElements()) {
                KeyPath kp = keyPathObjectsEnum.nextElement();
                kp.traverseForObjects(sourceObjects, skipFaultedSourceObjects);
            }
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            osc.unlock();
            throw throwable;
        }
        osc.unlock();
    }

    public static void batchFetch(NSArray sourceObjects, NSArray keypaths, boolean skipFaultedSourceObjects, int batchSize) {
        for (int i = 0; i < sourceObjects.count(); i += batchSize) {
            int rangeSize = batchSize;
            if (i + batchSize > sourceObjects.count()) {
                rangeSize = sourceObjects.count() - i;
            }
            NSRange range = new NSRange(i, rangeSize);
            NSArray batchedSourceObjects = sourceObjects.subarrayWithRange(range);
            ERXBatchFetchUtilities.batchFetch(batchedSourceObjects, keypaths, skipFaultedSourceObjects);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class KeyPath {
        private String path;
        private NSArray subPaths;

        public KeyPath(String path, NSArray subPaths) {
            this.path = path;
            this.subPaths = subPaths;
        }

        public void traverseForObjects(NSArray sourceObjects, boolean skipFaultedSourceObjects) {
            if (sourceObjects == null || sourceObjects.count() < 1) {
                return;
            }
            NSDictionary objectsByEntity = this.splitObjectsByEntity(sourceObjects);
            Enumeration e = objectsByEntity.allValues().objectEnumerator();
            while (e.hasMoreElements()) {
                NSArray homogeniousObjects = (NSArray)e.nextElement();
                this.traverseForHomogeniousObjects(homogeniousObjects, skipFaultedSourceObjects);
            }
        }

        public String path() {
            return this.path;
        }

        public NSArray subPaths() {
            return this.subPaths;
        }

        public static NSArray<KeyPath> parseKeyPathStrings(NSArray keypathStrings) {
            NSDictionary subPathsKeyedByTopLevel = KeyPath.subPathsKeyedByTopLevel(keypathStrings);
            NSMutableArray<KeyPath> keyPathObjects = new NSMutableArray<KeyPath>();
            Enumeration e = subPathsKeyedByTopLevel.keyEnumerator();
            while (e.hasMoreElements()) {
                String path = (String)e.nextElement();
                NSArray subPaths = (NSArray)subPathsKeyedByTopLevel.valueForKey(path);
                KeyPath kp = new KeyPath(path, KeyPath.parseKeyPathStrings(subPaths));
                keyPathObjects.addObject(kp);
            }
            return keyPathObjects;
        }

        private void traverseForHomogeniousObjects(NSArray sourceObjects, boolean skipFaultedSourceObjects) {
            if (sourceObjects == null || sourceObjects.count() < 1) {
                return;
            }
            EOEnterpriseObject eo = (EOEnterpriseObject)sourceObjects.objectAtIndex(0);
            EOEditingContext ec = eo.editingContext();
            EOEntity entity = EOUtilities.entityForObject((EOEditingContext)ec, (EOEnterpriseObject)eo);
            EORelationship relationship = entity.relationshipNamed(this.path);
            if (relationship == null) {
                return;
            }
            this.batchFetchRelationshipOnSourceObjects(relationship, sourceObjects, skipFaultedSourceObjects);
            Enumeration subPathsEnum = this.subPaths.objectEnumerator();
            while (subPathsEnum.hasMoreElements()) {
                KeyPath subPath = (KeyPath)subPathsEnum.nextElement();
                NSArray destinationObjects = this.destinationObjectsForRelationship(relationship, sourceObjects);
                subPath.traverseForObjects(destinationObjects, skipFaultedSourceObjects);
            }
        }

        private static NSDictionary subPathsKeyedByTopLevel(NSArray keypathStrings) {
            NSMutableDictionary subPathsKeyedByTopLevel = new NSMutableDictionary();
            Enumeration e = keypathStrings.objectEnumerator();
            while (e.hasMoreElements()) {
                String subPath;
                String keypath = (String)e.nextElement();
                String path = KeyPath.directPathFromKeyPath(keypath);
                NSMutableArray<String> subPaths = (NSMutableArray<String>)subPathsKeyedByTopLevel.valueForKey(path);
                if (subPaths == null) {
                    subPaths = new NSMutableArray<String>();
                    subPathsKeyedByTopLevel.takeValueForKey(subPaths, path);
                }
                if ((subPath = KeyPath.indirectPathFromKeyPath(keypath)) == null) continue;
                subPaths.addObject(subPath);
            }
            return subPathsKeyedByTopLevel;
        }

        private NSArray destinationObjectsForRelationship(EORelationship relationship, NSArray sourceObjects) {
            NSMutableArray<Object> destinationObjects = new NSMutableArray<Object>();
            Enumeration e = sourceObjects.objectEnumerator();
            while (e.hasMoreElements()) {
                EOEnterpriseObject nextEO = (EOEnterpriseObject)e.nextElement();
                if (relationship.isToMany()) {
                    destinationObjects.addObjectsFromArray((NSArray)nextEO.valueForKey(this.path));
                    continue;
                }
                Object o = nextEO.valueForKey(this.path);
                if (o == null) continue;
                destinationObjects.addObject(o);
            }
            return destinationObjects;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void batchFetchRelationshipOnSourceObjects(EORelationship relationship, NSArray sourceObjects, boolean skipFaultedSourceObjects) {
            EOEnterpriseObject eo = (EOEnterpriseObject)sourceObjects.objectAtIndex(0);
            EOEditingContext ec = eo.editingContext();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Batch fetching '" + this.path + "' relationship on " + sourceObjects));
            }
            EODatabaseContext dbContext = ERXEOAccessUtilities.databaseContextForObject(eo);
            dbContext.lock();
            try {
                ERXEOAccessUtilities.batchFetchRelationship(dbContext, relationship, sourceObjects, ec, skipFaultedSourceObjects);
                Object var8_7 = null;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                dbContext.unlock();
                throw throwable;
            }
            dbContext.unlock();
        }

        private NSDictionary splitObjectsByEntity(NSArray objects) {
            NSMutableDictionary objectsByEntityName = new NSMutableDictionary();
            Enumeration e = objects.objectEnumerator();
            while (e.hasMoreElements()) {
                EOEnterpriseObject eo = (EOEnterpriseObject)e.nextElement();
                NSMutableArray<EOEnterpriseObject> objectsForEntity = (NSMutableArray<EOEnterpriseObject>)objectsByEntityName.valueForKey(eo.entityName());
                if (objectsForEntity == null) {
                    objectsForEntity = new NSMutableArray<EOEnterpriseObject>();
                    objectsByEntityName.takeValueForKey(objectsForEntity, eo.entityName());
                }
                objectsForEntity.addObject(eo);
            }
            return objectsByEntityName;
        }

        private static String directPathFromKeyPath(String keypath) {
            String path = keypath;
            int indexOfDot = keypath.indexOf(".");
            if (indexOfDot >= 0) {
                path = keypath.substring(0, indexOfDot);
            }
            return path;
        }

        private static String indirectPathFromKeyPath(String keypath) {
            String indirectPath = null;
            int indexOfDot = keypath.indexOf(".");
            if (indexOfDot >= 0) {
                indirectPath = keypath.substring(indexOfDot + 1);
            }
            return indirectPath;
        }
    }
}

