/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.eof;

import com.webobjects.eoaccess.EODatabase;
import com.webobjects.eoaccess.EODatabaseContext;
import com.webobjects.eocontrol.EOEditingContext;
import com.webobjects.eocontrol.EOEnterpriseObject;
import com.webobjects.eocontrol.EOFaultHandler;
import com.webobjects.eocontrol.EOFetchSpecification;
import com.webobjects.eocontrol.EOGlobalID;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSMutableArray;
import er.extensions.eof.ERXEOControlUtilities;
import er.extensions.eof.ERXFetchSpecification;
import er.extensions.foundation.ERXExpiringCache;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ERXFetchResultCache {
    private static EODatabase currentDatabase;
    private ERXExpiringCache<String, NSArray<EOGlobalID>> cache = new ERXExpiringCache<String, NSArray<EOGlobalID>>(){

        @Override
        protected synchronized void removeEntryForKey(ERXExpiringCache.Entry<NSArray<EOGlobalID>> entry, String key) {
            for (EOGlobalID gid : entry.object()) {
                currentDatabase.decrementSnapshotCountForGlobalID(gid);
            }
            super.removeEntryForKey(entry, key);
        }

        @Override
        protected synchronized void setEntryForKey(ERXExpiringCache.Entry<NSArray<EOGlobalID>> entry, String key) {
            super.setEntryForKey(entry, key);
            for (EOGlobalID gid : entry.object()) {
                currentDatabase.incrementSnapshotCountForGlobalID(gid);
            }
        }
    };
    private static final Logger log;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NSArray<? extends EOEnterpriseObject> objectsForFetchSpecification(EODatabaseContext dbc, EOEditingContext ec, EOFetchSpecification fs) {
        String identifier = ERXFetchSpecification.identifierForFetchSpec(fs);
        ERXExpiringCache<String, NSArray<EOGlobalID>> eRXExpiringCache = this.cache;
        synchronized (eRXExpiringCache) {
            currentDatabase = dbc.database();
            NSArray<EOGlobalID> gids = this.cache.objectForKey(identifier);
            NSMutableArray<int> result = null;
            if (gids != null) {
                NSMutableArray<int> eos = new NSMutableArray<int>(gids.count());
                EODatabase database = dbc.database();
                for (EOGlobalID gid : gids) {
                    NSDictionary snapshotForGlobalID = database.snapshotForGlobalID(gid);
                    if (snapshotForGlobalID == null || dbc.snapshotForGlobalID(gid, ec.fetchTimestamp()) == null) {
                        return null;
                    }
                    database.recordSnapshotForGlobalID(snapshotForGlobalID, gid);
                    EOEnterpriseObject eo = ec.faultForGlobalID(gid, ec);
                    eos.addObject((int)eo);
                }
                result = eos;
            }
            currentDatabase = null;
            if (log.isDebugEnabled()) {
                boolean hit = result != null;
                log.info((Object)("Cache : " + (hit ? "HIT" : "MISS") + " on " + fs.entityName()));
            }
            return result;
        }
    }

    protected NSArray<String> excludedEntities() {
        return NSArray.EmptyArray;
    }

    protected long cacheTime(NSArray eos, EOFetchSpecification fs) {
        if (fs.fetchesRawRows() || fs.refreshesRefetchedObjects()) {
            return 0L;
        }
        for (Object object : eos) {
            if (!(object instanceof EOEnterpriseObject)) {
                return 0L;
            }
            if (EOFaultHandler.isFault(object)) {
                return 0L;
            }
            if (!this.excludedEntities().containsObject(((EOEnterpriseObject)object).entityName())) continue;
            return 0L;
        }
        return 100L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setObjectsForFetchSpecification(EODatabaseContext dbc, EOEditingContext ec, NSArray<?> eos, EOFetchSpecification fs) {
        String identifier = ERXFetchSpecification.identifierForFetchSpec(fs);
        ERXExpiringCache<String, NSArray<EOGlobalID>> eRXExpiringCache = this.cache;
        synchronized (eRXExpiringCache) {
            currentDatabase = dbc.database();
            long cacheTime = this.cacheTime(eos, fs);
            if (cacheTime > 0L) {
                NSArray gids = ERXEOControlUtilities.globalIDsForObjects(eos);
                this.cache.setObjectForKeyWithVersion(gids, identifier, null, cacheTime);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Cache : " + (cacheTime > 0L ? "SET" : "DROP") + " on " + fs.entityName()));
            }
            currentDatabase = null;
        }
    }

    static {
        log = Logger.getLogger(ERXFetchResultCache.class);
    }
}

