/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.eof;

import com.webobjects.eocontrol.EOQualifier;
import com.webobjects.eocontrol.EOQualifierEvaluation;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSKeyValueCodingAdditions;
import com.webobjects.foundation.NSRange;
import com.webobjects.foundation.NSTimestamp;
import er.extensions.eof.ERXQ;
import er.extensions.eof.ERXS;
import er.extensions.eof.ERXSortOrdering;
import er.extensions.qualifiers.ERXAndQualifier;
import er.extensions.qualifiers.ERXKeyComparisonQualifier;
import er.extensions.qualifiers.ERXKeyValueQualifier;
import er.extensions.qualifiers.ERXOrQualifier;
import er.extensions.qualifiers.ERXPrefixQualifierTraversal;
import java.math.BigDecimal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ERXKey<T> {
    private static final ERXKey<BigDecimal> AVG = new ERXKey("@avg");
    private static final ERXKey<BigDecimal> SUM = new ERXKey("@sum");
    private static final ERXKey<?> MIN = new ERXKey("@min");
    private static final ERXKey<?> MAX = new ERXKey("@max");
    private static final ERXKey<Integer> COUNT = new ERXKey("@count");
    private static final ERXKey<BigDecimal> AVG_NON_NULL = new ERXKey("@avgNonNull");
    private static final ERXKey<?> FETCH_SPEC = new ERXKey("@fetchSpec");
    private static final ERXKey<?> FLATTEN = new ERXKey("@flatten");
    private static final ERXKey<Boolean> IS_EMPTY = new ERXKey("@isEmpty");
    private static final ERXKey<?> LIMIT = new ERXKey("@limit");
    private static final ERXKey<BigDecimal> MEDIAN = new ERXKey("@median");
    private static final ERXKey<?> OBJECT_AT_INDEX = new ERXKey("@objectAtIndex");
    private static final ERXKey<BigDecimal> POP_STD_DEV = new ERXKey("@popStdDev");
    private static final ERXKey<?> REMOVE_NULL_VALUES = new ERXKey("@removeNullValues");
    private static final ERXKey<?> REVERSE = new ERXKey("@reverse");
    private static final ERXKey<?> SORT = new ERXKey("@sort");
    private static final ERXKey<?> SORT_ASC = new ERXKey("@sortAsc");
    private static final ERXKey<?> SORT_DESC = new ERXKey("@sortDesc");
    private static final ERXKey<?> SORT_INSENSITIVE_ASC = new ERXKey("@sortInsensitiveAsc");
    private static final ERXKey<?> SORT_INSENSITIVE_DESC = new ERXKey("@sortInsensitiveDesc");
    private static final ERXKey<BigDecimal> STD_DEV = new ERXKey("@stdDev");
    private static final ERXKey<?> SUBARRAY_WITH_RANGE = new ERXKey("@subarrayWithRange");
    private static final ERXKey<?> UNIQUE = new ERXKey("@unique");
    private String _key;

    public static ERXKey<BigDecimal> avgNonNull(ERXKey<?> key) {
        return ERXKey.avgNonNull().append(key);
    }

    public static ERXKey<BigDecimal> avgNonNull() {
        return AVG_NON_NULL;
    }

    public ERXKey<BigDecimal> atAvgNonNull(ERXKey<?> key) {
        return this.append(ERXKey.avgNonNull(key));
    }

    public ERXKey<BigDecimal> atAvgNonNull() {
        return this.append(ERXKey.avgNonNull());
    }

    public static <U> ERXKey<NSArray<U>> fetchSpec(String fetchSpecName, ERXKey<U> key) {
        return FETCH_SPEC.append(fetchSpecName).appendAsArray(key);
    }

    public <U> ERXKey<NSArray<U>> atFetchSpec(String fetchSpecName, ERXKey<U> key) {
        return this.append(ERXKey.fetchSpec(fetchSpecName, key));
    }

    public static <U> ERXKey<U> fetchSpec(String fetchSpecName) {
        return FETCH_SPEC.append(fetchSpecName);
    }

    public <U> ERXKey<U> atFetchSpec(String fetchSpecName) {
        return this.append(ERXKey.fetchSpec(fetchSpecName));
    }

    public static <U> ERXKey<NSArray<U>> flatten(ERXKey<U> key) {
        return FLATTEN.appendAsArray(key);
    }

    public <U> ERXKey<NSArray<U>> atFlatten(ERXKey<U> key) {
        return this.append(ERXKey.flatten(key));
    }

    public static <U> ERXKey<U> flatten() {
        return FLATTEN;
    }

    public <U> ERXKey<U> atFlatten() {
        return this.append(ERXKey.<U>flatten());
    }

    public static ERXKey<Boolean> isEmpty() {
        return IS_EMPTY;
    }

    public ERXKey<Boolean> atIsEmpty() {
        return this.append(ERXKey.isEmpty());
    }

    public static <U> ERXKey<NSArray<U>> limit(Integer limit, ERXKey<U> key) {
        return LIMIT.append(limit.toString()).appendAsArray(key);
    }

    public <U> ERXKey<NSArray<U>> atLimit(Integer limit, ERXKey<U> key) {
        return this.append(ERXKey.limit(limit, key));
    }

    public static <U> ERXKey<U> limit(Integer limit) {
        return LIMIT.append(limit.toString());
    }

    public <U> ERXKey<U> atLimit(Integer limit) {
        return this.append(ERXKey.limit(limit));
    }

    public static ERXKey<BigDecimal> median() {
        return MEDIAN;
    }

    public static ERXKey<BigDecimal> median(ERXKey<?> key) {
        return MEDIAN.append(key);
    }

    public ERXKey<BigDecimal> atMedian() {
        return this.append(ERXKey.median());
    }

    public ERXKey<BigDecimal> atMedian(ERXKey<?> key) {
        return this.append(ERXKey.median(key));
    }

    public static <U> ERXKey<U> objectAtIndex(Integer index, ERXKey<U> key) {
        return OBJECT_AT_INDEX.append(index.toString()).append(key);
    }

    public <U> ERXKey<U> atObjectAtIndex(Integer index, ERXKey<U> key) {
        return this.append(ERXKey.objectAtIndex(index, key));
    }

    public static <U> ERXKey<U> objectAtIndex(Integer index) {
        return OBJECT_AT_INDEX.append(index.toString());
    }

    public <U> ERXKey<U> atObjectAtIndex(Integer index) {
        return this.append(ERXKey.objectAtIndex(index));
    }

    public static <U> ERXKey<U> removeNullValues(ERXKey<U> key) {
        return REMOVE_NULL_VALUES.append(key);
    }

    public <U> ERXKey<U> atRemoveNullValues(ERXKey<U> key) {
        return this.append(ERXKey.removeNullValues(key));
    }

    public static <U> ERXKey<U> removeNullValues() {
        return REMOVE_NULL_VALUES;
    }

    public <U> ERXKey<U> atRemoveNullValues() {
        return this.append(ERXKey.<U>removeNullValues());
    }

    public static <U> ERXKey<NSArray<U>> reverse(ERXKey<U> key) {
        return REVERSE.appendAsArray(key);
    }

    public <U> ERXKey<NSArray<U>> atReverse(ERXKey<U> key) {
        return this.append(ERXKey.reverse(key));
    }

    public static <U> ERXKey<U> reverse() {
        return REVERSE;
    }

    public <U> ERXKey<U> atReverse() {
        return this.append(ERXKey.<U>reverse());
    }

    public static <U> ERXKey<U> sort(ERXKey<?> ... sortKeys) {
        NSArray keyArray = (NSArray)new NSArray((E[])sortKeys).valueForKey("key");
        return SORT.append(keyArray.componentsJoinedByString(","));
    }

    public <U> ERXKey<U> atSort(ERXKey<?> ... sortKeys) {
        return this.append(ERXKey.sort(sortKeys));
    }

    public static <U> ERXKey<U> sortAsc(ERXKey<?> ... sortKeys) {
        NSArray keyArray = (NSArray)new NSArray((E[])sortKeys).valueForKey("key");
        return SORT_ASC.append(keyArray.componentsJoinedByString(","));
    }

    public <U> ERXKey<U> atSortAsc(ERXKey<?> ... sortKeys) {
        return this.append(ERXKey.sortAsc(sortKeys));
    }

    public static <U> ERXKey<U> sortDesc(ERXKey<?> ... sortKeys) {
        NSArray keyArray = (NSArray)new NSArray((E[])sortKeys).valueForKey("key");
        return SORT_DESC.append(keyArray.componentsJoinedByString(","));
    }

    public <U> ERXKey<U> atSortDesc(ERXKey<?> ... sortKeys) {
        return this.append(ERXKey.sortDesc(sortKeys));
    }

    public static <U> ERXKey<U> sortInsensitiveAsc(ERXKey<?> ... sortKeys) {
        NSArray keyArray = (NSArray)new NSArray((E[])sortKeys).valueForKey("key");
        return SORT_INSENSITIVE_ASC.append(keyArray.componentsJoinedByString(","));
    }

    public <U> ERXKey<U> atSortInsensitiveAsc(ERXKey<?> ... sortKeys) {
        return this.append(ERXKey.sortInsensitiveAsc(sortKeys));
    }

    public static <U> ERXKey<U> sortInsensitiveDesc(ERXKey<?> ... sortKeys) {
        NSArray keyArray = (NSArray)new NSArray((E[])sortKeys).valueForKey("key");
        return SORT_INSENSITIVE_DESC.append(keyArray.componentsJoinedByString(","));
    }

    public <U> ERXKey<U> atSortInsensitiveDesc(ERXKey<?> ... sortKeys) {
        return this.append(ERXKey.sortInsensitiveDesc(sortKeys));
    }

    public static <U> ERXKey<NSArray<U>> subarrayWithRange(NSRange range, ERXKey<U> key) {
        return SUBARRAY_WITH_RANGE.append(range.location() + "-" + range.length()).appendAsArray(key);
    }

    public <U> ERXKey<NSArray<U>> atSubarrayWithRange(NSRange range, ERXKey<U> key) {
        return this.append(ERXKey.subarrayWithRange(range, key));
    }

    public static <U> ERXKey<U> subarrayWithRange(NSRange range) {
        return SUBARRAY_WITH_RANGE.append(range.location() + "-" + range.length());
    }

    public <U> ERXKey<U> atSubarrayWithRange(NSRange range) {
        return this.append(ERXKey.subarrayWithRange(range));
    }

    public static <U> ERXKey<NSArray<U>> unique(ERXKey<U> key) {
        return UNIQUE.appendAsArray(key);
    }

    public <U> ERXKey<NSArray<U>> atUnique(ERXKey<U> key) {
        return this.append(ERXKey.unique(key));
    }

    public static <U> ERXKey<U> unique() {
        return UNIQUE;
    }

    public <U> ERXKey<U> atUnique() {
        return this.append(ERXKey.<U>unique());
    }

    public static ERXKey<BigDecimal> sum(ERXKey<?> key) {
        return SUM.append(key);
    }

    public ERXKey<BigDecimal> atSum(ERXKey<?> key) {
        return this.append(ERXKey.sum(key));
    }

    public ERXKey<BigDecimal> atSum() {
        return this.append(ERXKey.sum());
    }

    public static ERXKey<BigDecimal> sum() {
        return SUM;
    }

    public static ERXKey<BigDecimal> popStdDev() {
        return POP_STD_DEV;
    }

    public ERXKey<BigDecimal> atPopStdDev() {
        return this.append(ERXKey.popStdDev());
    }

    public static ERXKey<BigDecimal> popStdDev(ERXKey<?> key) {
        return ERXKey.popStdDev().append(key);
    }

    public ERXKey<BigDecimal> atPopStdDev(ERXKey<?> key) {
        return this.append(ERXKey.popStdDev(key));
    }

    public static ERXKey<BigDecimal> stdDev() {
        return STD_DEV;
    }

    public ERXKey<BigDecimal> atStdDev() {
        return this.append(ERXKey.stdDev());
    }

    public static ERXKey<BigDecimal> stdDev(ERXKey<?> key) {
        return ERXKey.stdDev().append(key);
    }

    public ERXKey<BigDecimal> atStdDev(ERXKey<?> key) {
        return this.append(ERXKey.stdDev(key));
    }

    public static ERXKey<BigDecimal> avg(ERXKey<?> key) {
        return AVG.append(key);
    }

    public ERXKey<BigDecimal> atAvg(ERXKey<?> key) {
        return this.append(ERXKey.avg(key));
    }

    public static ERXKey<BigDecimal> avg() {
        return AVG;
    }

    public ERXKey<BigDecimal> atAvg() {
        return this.append(ERXKey.avg());
    }

    public static <U> ERXKey<U> min(ERXKey<U> key) {
        return MIN.append(key);
    }

    public <U> ERXKey<U> atMin(ERXKey<U> key) {
        return this.append(ERXKey.min(key));
    }

    public static <U> ERXKey<U> min() {
        return MIN;
    }

    public <U> ERXKey<U> atMin() {
        return this.append(ERXKey.<U>min());
    }

    public static <U> ERXKey<U> max(ERXKey<U> key) {
        return MAX.append(key);
    }

    public <U> ERXKey<U> atMax(ERXKey<U> key) {
        return this.append(ERXKey.max(key));
    }

    public static <U> ERXKey<U> max() {
        return MAX;
    }

    public <U> ERXKey<U> atMax() {
        return this.append(ERXKey.<U>max());
    }

    public static ERXKey<Integer> count() {
        return COUNT;
    }

    public ERXKey<Integer> atCount() {
        return this.append(ERXKey.count());
    }

    public ERXKey(String key) {
        this._key = key;
    }

    public ERXSortOrdering asc() {
        return ERXS.asc(this.key());
    }

    public ERXSortOrdering.ERXSortOrderings ascs() {
        return ERXS.ascs(this.key());
    }

    public ERXSortOrdering desc() {
        return ERXS.desc(this.key());
    }

    public ERXSortOrdering.ERXSortOrderings descs() {
        return ERXS.descs(this.key());
    }

    public ERXSortOrdering ascInsensitive() {
        return ERXS.ascInsensitive(this.key());
    }

    public ERXSortOrdering.ERXSortOrderings ascInsensitives() {
        return ERXS.ascInsensitives(this.key());
    }

    public ERXSortOrdering descInsensitive() {
        return ERXS.descInsensitive(this.key());
    }

    public ERXSortOrdering.ERXSortOrderings descInsensitives() {
        return ERXS.descInsensitives(this.key());
    }

    public String key() {
        return this._key;
    }

    public ERXKeyValueQualifier isTrue() {
        return ERXQ.isTrue(this._key);
    }

    public ERXKeyValueQualifier isFalse() {
        return ERXQ.isFalse(this._key);
    }

    public ERXKeyValueQualifier isUnlessNull(T value) {
        return value == null ? null : this.is(value);
    }

    public ERXKeyValueQualifier is(T value) {
        return ERXQ.equals(this._key, value);
    }

    public ERXKeyComparisonQualifier is(ERXKey<T> value) {
        return ERXQ.equals(this, value);
    }

    public ERXKeyValueQualifier eq(T value) {
        return ERXQ.equals(this._key, value);
    }

    public ERXKeyComparisonQualifier eq(ERXKey<T> value) {
        return ERXQ.equals(this, value);
    }

    public ERXKeyValueQualifier isNot(T value) {
        return ERXQ.notEquals(this._key, value);
    }

    public ERXKeyComparisonQualifier isNot(ERXKey<T> value) {
        return ERXQ.notEquals(this, value);
    }

    public ERXKeyValueQualifier ne(T value) {
        return ERXQ.notEquals(this._key, value);
    }

    public ERXKeyComparisonQualifier ne(ERXKey<T> value) {
        return ERXQ.notEquals(this, value);
    }

    public ERXKeyValueQualifier greaterThan(T value) {
        return ERXQ.greaterThan(this._key, value);
    }

    public ERXKeyComparisonQualifier greaterThan(ERXKey<T> value) {
        return ERXQ.greaterThan(this, value);
    }

    public ERXKeyValueQualifier gt(T value) {
        return ERXQ.greaterThan(this._key, value);
    }

    public ERXKeyComparisonQualifier gt(ERXKey<T> value) {
        return ERXQ.greaterThan(this, value);
    }

    public ERXKeyValueQualifier lessThan(T value) {
        return ERXQ.lessThan(this._key, value);
    }

    public ERXKeyComparisonQualifier lessThan(ERXKey<T> value) {
        return ERXQ.lessThan(this, value);
    }

    public ERXKeyValueQualifier lt(T value) {
        return ERXQ.lessThan(this._key, value);
    }

    public ERXKeyComparisonQualifier lt(ERXKey<T> value) {
        return ERXQ.lessThan(this, value);
    }

    public ERXKeyValueQualifier greaterThanOrEqualTo(T value) {
        return ERXQ.greaterThanOrEqualTo(this._key, value);
    }

    public ERXKeyComparisonQualifier greaterThanOrEqualTo(ERXKey<T> value) {
        return ERXQ.greaterThanOrEqualTo(this, value);
    }

    public ERXKeyValueQualifier gte(T value) {
        return ERXQ.greaterThanOrEqualTo(this._key, value);
    }

    public ERXKeyComparisonQualifier gte(ERXKey<T> value) {
        return ERXQ.greaterThanOrEqualTo(this, value);
    }

    public ERXKeyValueQualifier lessThanOrEqualTo(T value) {
        return ERXQ.lessThanOrEqualTo(this._key, value);
    }

    public ERXKeyComparisonQualifier lessThanOrEqualTo(ERXKey<T> value) {
        return ERXQ.lessThanOrEqualTo(this, value);
    }

    public ERXKeyValueQualifier lte(T value) {
        return ERXQ.lessThanOrEqualTo(this._key, value);
    }

    public ERXKeyComparisonQualifier lte(ERXKey<T> value) {
        return ERXQ.lessThanOrEqualTo(this, value);
    }

    public ERXKeyValueQualifier like(String value) {
        return ERXQ.like(this._key, value);
    }

    public ERXKeyValueQualifier likeInsensitive(String value) {
        return ERXQ.likeInsensitive(this._key, value);
    }

    public ERXKeyValueQualifier ilike(String value) {
        return ERXQ.likeInsensitive(this._key, value);
    }

    public ERXKeyValueQualifier isNull() {
        return ERXQ.isNull(this._key);
    }

    public ERXKeyValueQualifier isNotNull() {
        return ERXQ.isNotNull(this._key);
    }

    public ERXOrQualifier inObjects(T ... values) {
        return ERXQ.inObjects(this._key, values);
    }

    public ERXOrQualifier in(NSArray<T> values) {
        return ERXQ.in(this._key, values);
    }

    public ERXAndQualifier notIn(NSArray<T> values) {
        return ERXQ.notIn(this._key, values);
    }

    public ERXKeyValueQualifier before(NSTimestamp when) {
        return ERXQ.lessThan(this._key, when);
    }

    public ERXKeyComparisonQualifier before(ERXKey<? extends NSTimestamp> when) {
        return ERXQ.lessThan(this, when);
    }

    public ERXKeyValueQualifier after(NSTimestamp when) {
        return ERXQ.greaterThan(this._key, when);
    }

    public ERXKeyComparisonQualifier after(ERXKey<? extends NSTimestamp> when) {
        return ERXQ.greaterThan(this, when);
    }

    public EOQualifier between(T lowerBound, T upperBound) {
        return ERXQ.between(this._key, lowerBound, upperBound);
    }

    public EOQualifier between(T lowerBound, T upperBound, boolean inclusive) {
        return ERXQ.between(this._key, lowerBound, upperBound, inclusive);
    }

    public ERXKeyValueQualifier startsWith(String value) {
        return ERXQ.startsWith(this._key, value);
    }

    public ERXKeyValueQualifier startsWithInsensitive(String value) {
        return ERXQ.startsWithInsensitive(this._key, value);
    }

    public ERXKeyValueQualifier endsWith(String value) {
        return ERXQ.endsWith(this._key, value);
    }

    public ERXKeyValueQualifier endsWithInsensitive(String value) {
        return ERXQ.endsWithInsensitive(this._key, value);
    }

    public ERXKeyValueQualifier contains(String value) {
        return ERXQ.contains(this._key, value);
    }

    public ERXOrQualifier containsAny(String tokens) {
        return ERXQ.containsAny(this._key, tokens);
    }

    public ERXOrQualifier containsAny(String[] tokens) {
        return ERXQ.containsAny(this._key, tokens);
    }

    public ERXAndQualifier containsAll(String tokens) {
        return ERXQ.containsAll(this._key, tokens);
    }

    public ERXAndQualifier containsAll(String[] tokens) {
        return ERXQ.containsAll(this._key, tokens);
    }

    public ERXKeyValueQualifier containsObject(Object obj) {
        return ERXQ.containsObject(this._key, obj);
    }

    public ERXKeyValueQualifier hasValues(NSArray<T> values) {
        return ERXQ.hasValues(this._key, values);
    }

    public int hashCode() {
        return this._key.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof ERXKey && ((ERXKey)obj)._key.equals(this._key);
    }

    public <U> ERXKey<U> append(String key) {
        return new ERXKey<T>(this._key != null && this._key.length() != 0 ? this._key + "." + key : key);
    }

    public <U> ERXKey<U> dot(String key) {
        return this.append(key);
    }

    public <U> ERXKey<U> append(ERXKey<U> key) {
        return this.append(key.key());
    }

    public <U> ERXKey<U> dot(ERXKey<U> key) {
        return this.append(key);
    }

    public <U> ERXKey<NSArray<U>> appendAsArray(ERXKey<U> key) {
        return this.append(key.key());
    }

    public <U> ERXKey<NSArray<U>> dotArray(ERXKey<U> key) {
        return this.append(key.key());
    }

    public T valueInObject(Object obj) {
        return (T)this.rawValueInObject(obj);
    }

    public Object rawValueInObject(Object obj) {
        return NSKeyValueCodingAdditions.Utility.valueForKeyPath((Object)obj, (String)this._key);
    }

    public NSArray<T> arrayValueInObject(Object obj) {
        return (NSArray)this.rawValueInObject(obj);
    }

    public void takeValueInObject(T value, Object obj) {
        NSKeyValueCodingAdditions.Utility.takeValueForKeyPath((Object)obj, value, (String)this._key);
    }

    public EOQualifier prefix(EOQualifier qualifier) {
        return ERXPrefixQualifierTraversal.prefixQualifierWithKey((EOQualifierEvaluation)qualifier, this);
    }

    public String toString() {
        return this._key;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ValueCoding {
        public <T> T valueForKey(ERXKey<T> var1);

        public <T> void takeValueForKey(Object var1, ERXKey<T> var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        Attribute,
        ToOneRelationship,
        ToManyRelationship;

    }
}

