/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.eof;

import com.webobjects.eoaccess.EOAdaptor;
import com.webobjects.eoaccess.EOAttribute;
import com.webobjects.eoaccess.EOEntity;
import com.webobjects.eoaccess.EOJoin;
import com.webobjects.eoaccess.EOModel;
import com.webobjects.eoaccess.EOModelGroup;
import com.webobjects.eoaccess.EORelationship;
import com.webobjects.eoaccess.ERXModel;
import com.webobjects.eocontrol.EOKeyValueCodingAdditions;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSBundle;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSForwardException;
import com.webobjects.foundation.NSKeyValueCoding;
import com.webobjects.foundation.NSLog;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSMutableSet;
import com.webobjects.foundation.NSNotification;
import com.webobjects.foundation.NSNotificationCenter;
import com.webobjects.foundation.NSPathUtilities;
import com.webobjects.foundation.NSPropertyListSerialization;
import com.webobjects.foundation.NSSelector;
import com.webobjects.foundation.NSSet;
import com.webobjects.foundation._NSArrayUtilities;
import com.webobjects.jdbcadaptor.JDBCAdaptor;
import er.extensions.ERXExtensions;
import er.extensions.appserver.ERXApplication;
import er.extensions.eof.ERXConstant;
import er.extensions.eof.ERXEOAccessUtilities;
import er.extensions.eof.ERXEntityClassDescription;
import er.extensions.foundation.ERXConfigurationManager;
import er.extensions.foundation.ERXFileUtilities;
import er.extensions.foundation.ERXPatcher;
import er.extensions.foundation.ERXProperties;
import er.extensions.foundation.ERXStringUtilities;
import er.extensions.foundation.ERXSystem;
import er.extensions.foundation.ERXValueUtilities;
import er.extensions.jdbc.ERXJDBCAdaptor;
import er.extensions.jdbc.ERXSQLHelper;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import org.apache.log4j.Logger;

public class ERXModelGroup
extends EOModelGroup {
    public static final Logger log = Logger.getLogger(ERXModelGroup.class);
    private Hashtable cache;
    public static final String LANGUAGES_KEY = "ERXLanguages";
    protected static final boolean patchModelsOnLoad = ERXProperties.booleanForKeyWithDefault("er.extensions.ERXModelGroup.patchModelsOnLoad", false);
    protected static final boolean flattenPrototypes = ERXProperties.booleanForKeyWithDefault("er.extensions.ERXModelGroup.flattenPrototypes", true);
    protected NSArray<String> _prototypeModelNames = ERXProperties.componentsSeparatedByStringWithDefault("er.extensions.ERXModelGroup.prototypeModelNames", ",", new NSArray<String>(ERXProperties.stringForKeyWithDefault("er.extensions.ERXModelGroup.prototypeModelName", "erprototypes")));
    protected NSArray<String> _modelLoadOrder = ERXProperties.componentsSeparatedByStringWithDefault("er.extensions.ERXModelGroup.modelLoadOrder", ",", NSArray.EmptyArray);
    private boolean raiseOnUnmatchingConnectionDictionaries = ERXProperties.booleanForKeyWithDefault("er.extensions.ERXModelGroup.raiseOnUnmatchingConnectionDictionaries", true);
    public static final String ModelGroupAddedNotification = "ERXModelGroupAddedNotification";
    private static final NSArray _prototypeKeys;

    public ERXModelGroup() {
        this.cache = new Hashtable();
    }

    public void loadModelsFromLoadedBundles() {
        EOModelGroup.setDefaultGroup((EOModelGroup)this);
        NSArray frameworkBundles = NSBundle.frameworkBundles();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Loading bundles" + frameworkBundles.valueForKey("name")));
        }
        if (ERXEntityClassDescription.factory() != null) {
            log.warn((Object)"Clearing previous class descriptions");
            ERXEntityClassDescription.factory().reset();
        }
        NSMutableDictionary<String, URL> modelNameURLDictionary = new NSMutableDictionary<String, URL>();
        NSMutableArray<String> modelNames = new NSMutableArray<String>();
        NSMutableArray<NSBundle> bundles = new NSMutableArray<NSBundle>();
        bundles.addObject(NSBundle.mainBundle());
        bundles.addObjectsFromArray(frameworkBundles);
        Enumeration e = bundles.objectEnumerator();
        while (e.hasMoreElements()) {
            NSBundle nsbundle = (NSBundle)e.nextElement();
            NSArray paths = nsbundle.resourcePathsForResources("eomodeld", null);
            int pathCount = paths.count();
            for (int currentPath = 0; currentPath < pathCount; ++currentPath) {
                String indexPath = (String)paths.objectAtIndex(currentPath);
                if (indexPath.endsWith(".eomodeld~/index.eomodeld")) {
                    log.info((Object)("Not adding model, it's only a temp file: " + indexPath));
                    continue;
                }
                String modelPath = NSPathUtilities.stringByDeletingLastPathComponent((String)indexPath);
                String modelName = NSPathUtilities.stringByDeletingPathExtension((String)NSPathUtilities.lastPathComponent((String)modelPath));
                EOModel eomodel = this.modelNamed(modelName);
                if (eomodel == null) {
                    URL url = nsbundle.pathURLForResourcePath(modelPath);
                    modelNameURLDictionary.setObjectForKey(url, modelName);
                    modelNames.addObject(modelName);
                    continue;
                }
                if (!NSLog.debugLoggingAllowedForLevelAndGroups((int)1, (long)32768L)) continue;
                NSLog.debug.appendln((Object)("Ignoring model at path \"" + modelPath + "\" because the model group " + (Object)((Object)this) + " already contains the model from the path \"" + eomodel.pathURL() + "\""));
            }
        }
        NSMutableArray<URL> modelURLs = new NSMutableArray<URL>();
        Enumeration<String> prototypeModelNamesEnum = this._prototypeModelNames.objectEnumerator();
        while (prototypeModelNamesEnum.hasMoreElements()) {
            String prototypeModelName = prototypeModelNamesEnum.nextElement();
            URL prototypeModelURL = (URL)modelNameURLDictionary.removeObjectForKey(prototypeModelName);
            modelNames.removeObject(prototypeModelName);
            if (prototypeModelURL == null) {
                if ("erprototypes".equals(prototypeModelName)) continue;
                throw new IllegalArgumentException("You specified the prototype model '" + prototypeModelName + "' in your prototypeModelNames array, but it can not be found.");
            }
            modelURLs.addObject(prototypeModelURL);
        }
        Enumeration<String> modelLoadOrderEnum = this._modelLoadOrder.objectEnumerator();
        while (modelLoadOrderEnum.hasMoreElements()) {
            String modelName = modelLoadOrderEnum.nextElement();
            URL modelURL = (URL)modelNameURLDictionary.removeObjectForKey(modelName);
            modelNames.removeObject(modelName);
            if (modelURL == null) {
                throw new IllegalArgumentException("You specified the model '" + modelName + "' in your modelLoadOrder array, but it can not be found.");
            }
            modelURLs.addObject(modelURL);
        }
        Enumeration e2 = modelNames.objectEnumerator();
        while (e2.hasMoreElements()) {
            String name = (String)e2.nextElement();
            modelURLs.addObject((URL)modelNameURLDictionary.objectForKey(name));
        }
        Enumeration modelURLEnum = modelURLs.objectEnumerator();
        while (modelURLEnum.hasMoreElements()) {
            URL url = (URL)modelURLEnum.nextElement();
            this.addModelWithPathURL(url);
        }
        this.checkInheritanceRelationships();
        if (!patchModelsOnLoad) {
            this.modifyModelsFromProperties();
            this.flattenPrototypes();
            Enumeration modelsEnum = this.models().objectEnumerator();
            while (modelsEnum.hasMoreElements()) {
                EOModel model = (EOModel)modelsEnum.nextElement();
                this.preloadERXConstantClassesForModel(model);
            }
        }
        NSNotificationCenter.defaultCenter().postNotification(ModelGroupAddedNotification, (Object)this);
        if (!patchModelsOnLoad) {
            NSNotificationCenter.defaultCenter().addObserver((Object)this, new NSSelector("modelAddedHandler", ERXConstant.NotificationClassArray), "EOModelAddedNotification", null);
        }
        this.checkForMismatchedJoinTypes();
    }

    public void addModel(EOModel eomodel) {
        Enumeration enumeration = this._modelsByName.objectEnumerator();
        String name = eomodel.name();
        if (this._modelsByName.objectForKey(name) != null) {
            log.warn((Object)("The model '" + name + "' (path: " + eomodel.pathURL() + ") cannot be added to model group " + (Object)((Object)this) + " because it already contains a model with that name."));
            return;
        }
        NSMutableSet<int> nsmutableset = new NSMutableSet<int>(128);
        NSSet<NSArray> nsset = new NSSet<NSArray>(eomodel.entityNames());
        while (enumeration.hasMoreElements()) {
            EOModel eomodel1 = (EOModel)enumeration.nextElement();
            nsmutableset.addObjectsFromArray(eomodel1.entityNames());
        }
        NSSet intersection = nsmutableset.setByIntersectingSet(nsset);
        if (intersection.count() != 0) {
            log.warn((Object)("The model '" + name + "' (path: " + eomodel.pathURL() + ") has an entity name conflict with the entities " + intersection + " already in the model group " + (Object)((Object)this)));
            Enumeration e = intersection.objectEnumerator();
            while (e.hasMoreElements()) {
                String entityName = (String)e.nextElement();
                log.debug((Object)("Removing entity " + entityName + " from model " + name));
                eomodel.removeEntity(eomodel.entityNamed(entityName));
            }
        }
        if (eomodel.modelGroup() != this) {
            eomodel.setModelGroup((EOModelGroup)this);
        }
        this._modelsByName.setObjectForKey(eomodel, eomodel.name());
        this.resetConnectionDictionaryInModel(eomodel);
        NSNotificationCenter.defaultCenter().postNotification("EOModelAddedNotification", (Object)eomodel);
    }

    public static String sqlDumpDirectory() {
        return ERXSystem.getProperty("er.extensions.ERXModelGroup.sqlDumpDirectory");
    }

    private void dumpSchemaSQL(EOModel eomodel) {
        EOAdaptor adaptor;
        String dumpDir = ERXModelGroup.sqlDumpDirectory();
        if (dumpDir != null && (adaptor = EOAdaptor.adaptorWithModel((EOModel)eomodel)) instanceof JDBCAdaptor) {
            JDBCAdaptor jdbc = (JDBCAdaptor)adaptor;
            try {
                ERXSQLHelper helper = ERXSQLHelper.newSQLHelper(jdbc);
                String sql = helper.createSchemaSQLForEntitiesInModelAndOptions(eomodel.entities(), eomodel, helper.defaultOptionDictionary(true, true));
                File file = new File(dumpDir + File.separator + eomodel.name() + ".sql");
                ERXFileUtilities.writeInputStreamToFile(new ByteArrayInputStream(sql.getBytes()), file);
                log.info((Object)("Wrote Schema SQL to " + file));
            }
            catch (IOException e) {
                throw NSForwardException._runtimeExceptionForThrowable((Throwable)e);
            }
        }
    }

    public EOModel addModelWithPathURL(URL url) {
        ERXModel model = null;
        String customModelClass = null;
        if (patchModelsOnLoad) {
            customModelClass = ERXProperties.stringForKey("er.extensions.ERXModelGroup.patchedModelClassName");
            if (customModelClass != null) {
                try {
                    Class<Model> modelClass = Class.forName(customModelClass).asSubclass(Model.class);
                    Constructor<Model> modelConstructor = modelClass.getConstructor(URL.class);
                    model = modelConstructor.newInstance(url);
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to create custom patched Model subclass '" + customModelClass + "'.", e);
                }
            } else {
                model = new Model(url);
            }
        } else {
            customModelClass = ERXProperties.stringForKey("er.extensions.ERXModelGroup.modelClassName");
            if (customModelClass != null) {
                try {
                    Class<EOModel> modelClass = Class.forName(customModelClass).asSubclass(EOModel.class);
                    Constructor<EOModel> modelConstructor = modelClass.getConstructor(URL.class);
                    model = modelConstructor.newInstance(url);
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to create custom EOModel subclass '" + customModelClass + "'.", e);
                }
            } else {
                model = new ERXModel(url);
            }
        }
        this.addModel(model);
        return model;
    }

    public void checkForMismatchedJoinTypes() {
        if (ERXProperties.booleanForKey("er.extensions.ERXModelGroup.ignoreTypeMismatch")) {
            return;
        }
        for (EOModel model : this.models()) {
            for (EOEntity entity : model.entities()) {
                for (EORelationship relationship : entity.relationships()) {
                    for (EOJoin join : relationship.joins()) {
                        EOAttribute sourceAttribute = join.sourceAttribute();
                        EOAttribute destinationAttribute = join.destinationAttribute();
                        if (sourceAttribute == null || destinationAttribute == null || ERXExtensions.safeEquals(sourceAttribute.className(), destinationAttribute.className()) && ERXExtensions.safeEquals(sourceAttribute.valueType(), destinationAttribute.valueType()) || ERXProperties.booleanForKey("er.extensions.ERXModelGroup." + sourceAttribute.entity().name() + "." + sourceAttribute.name() + ".ignoreTypeMismatch")) continue;
                        throw new RuntimeException("The attribute " + sourceAttribute.name() + " in " + sourceAttribute.entity().name() + " (" + sourceAttribute.className() + ", " + sourceAttribute.valueType() + ") is a foreign key to " + destinationAttribute.name() + " in " + destinationAttribute.entity().name() + " (" + destinationAttribute.className() + ", " + destinationAttribute.valueType() + ") but their class names or value types do not match.  If this is actually OK, you can set er.extensions.ERXModelGroup." + sourceAttribute.entity().name() + "." + sourceAttribute.name() + ".ignoreTypeMismatch=true in your Properties file.");
                    }
                }
            }
        }
    }

    public void checkInheritanceRelationships() {
        if (this._subEntitiesCache != null && this._subEntitiesCache.count() > 0) {
            Enumeration parentNameEnumerator = this._subEntitiesCache.keyEnumerator();
            while (parentNameEnumerator.hasMoreElements()) {
                String parentName = (String)parentNameEnumerator.nextElement();
                NSArray children = (NSArray)this._subEntitiesCache.objectForKey(parentName);
                EOEntity parent = this.entityNamed(parentName);
                Enumeration childrenEnumerator = children.objectEnumerator();
                while (childrenEnumerator.hasMoreElements()) {
                    String childName = (String)childrenEnumerator.nextElement();
                    EOEntity child = this.entityNamed(childName);
                    if (child.parentEntity() == parent || parent.subEntities().containsObject(child)) continue;
                    log.debug((Object)("Found entity: " + child.name() + " which should have: " + parent.name() + " as it's parent."));
                    parent.addSubEntity(child);
                }
            }
        }
    }

    public int entityCode(String ename) {
        return this.entityCode(this.entityNamed(ename));
    }

    public int entityCode(EOEntity entity) {
        Integer cachedValue = (Integer)this.cache.get(entity);
        if (cachedValue == null) {
            Object o;
            NSDictionary d = entity.userInfo();
            if (d == null) {
                d = NSDictionary.EmptyDictionary;
            }
            Integer n = cachedValue = (o = d.objectForKey("entityCode")) == null ? null : new Integer(o.toString());
            if (cachedValue == null) {
                cachedValue = new Integer(0);
            }
            this.cache.put(entity, cachedValue);
        }
        return cachedValue;
    }

    public static boolean patchModelsOnLoad() {
        return patchModelsOnLoad;
    }

    public static boolean isPrototypeEntity(EOEntity entity) {
        return ERXModelGroup.isPrototypeEntityName(entity.name());
    }

    public static boolean isPrototypeEntityName(String entityName) {
        return entityName.startsWith("EO") && entityName.endsWith("Prototypes");
    }

    public void modelAddedHandler(NSNotification n) {
        EOModel model = (EOModel)n.object();
        this.resetConnectionDictionaryInModel(model);
    }

    private static String getProperty(String key, String alternateKey, String defaultValue) {
        String value = ERXProperties.stringForKey(key);
        if (value == null) {
            value = ERXProperties.stringForKey(alternateKey);
        }
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    private static String getProperty(String key, String alternateKey) {
        return ERXModelGroup.getProperty(key, alternateKey, null);
    }

    private static String decryptProperty(String key, String alternateKey) {
        String value = ERXProperties.decryptedStringForKey(key);
        if (value == null) {
            value = ERXProperties.decryptedStringForKey(alternateKey);
        }
        return value;
    }

    protected void fixOracleDictionary(EOModel model) {
        String modelName = model.name();
        String serverName = ERXModelGroup.getProperty(modelName + ".DBServer", "dbConnectServerGLOBAL");
        String userName = ERXModelGroup.getProperty(modelName + ".DBUser", "dbConnectUserGLOBAL");
        String passwd = ERXModelGroup.decryptProperty(modelName + ".DBPassword", "dbConnectPasswordGLOBAL");
        NSMutableDictionary<String, String> newConnectionDictionary = new NSMutableDictionary<String, String>(model.connectionDictionary());
        if (serverName != null) {
            newConnectionDictionary.setObjectForKey(serverName, "serverId");
        }
        if (userName != null) {
            newConnectionDictionary.setObjectForKey(userName, "userName");
        }
        if (passwd != null) {
            newConnectionDictionary.setObjectForKey(passwd, "password");
        }
        model.setConnectionDictionary(newConnectionDictionary);
    }

    protected void fixFlatDictionary(EOModel model) {
        String aModelName = model.name();
        String path = ERXModelGroup.getProperty(aModelName + ".DBPath", "dbConnectPathGLOBAL");
        if (path != null) {
            NSArray<String> a;
            if (path.indexOf(" ") != -1 && (a = NSArray.componentsSeparatedByString(path, " ")).count() == 2) {
                path = ERXFileUtilities.pathForResourceNamed(a.objectAtIndex(0), a.objectAtIndex(1), null);
            }
        } else {
            path = model.pathURL().getFile();
            path = NSPathUtilities.stringByDeletingLastPathComponent((String)path);
            path = NSPathUtilities.stringByAppendingPathComponent((String)path, (String)(model.name() + ".db"));
        }
        NSMutableDictionary<String, String> newConnectionDictionary = new NSMutableDictionary<String, String>(model.connectionDictionary());
        if (path != null) {
            newConnectionDictionary.setObjectForKey(path, "path");
        }
        if (ERXConfigurationManager.defaultManager().operatingSystem() == 1) {
            newConnectionDictionary.setObjectForKey("\r\n", "rowSeparator");
        }
        model.setConnectionDictionary(newConnectionDictionary);
    }

    protected void fixOpenBaseDictionary(EOModel model) {
        String aModelName = model.name();
        String db = ERXModelGroup.getProperty(aModelName + ".DBDatabase", "dbConnectDatabaseGLOBAL");
        String h = ERXModelGroup.getProperty(aModelName + ".DBHostName", "dbConnectHostNameGLOBAL");
        NSMutableDictionary<String, String> newConnectionDictionary = new NSMutableDictionary<String, String>(model.connectionDictionary());
        if (db != null) {
            newConnectionDictionary.setObjectForKey(db, "databaseName");
        }
        if (h != null) {
            newConnectionDictionary.setObjectForKey(h, "hostName");
        }
        model.setConnectionDictionary(newConnectionDictionary);
    }

    protected void fixJNDIDictionary(EOModel model) {
        String modelName = model.name();
        String serverUrl = ERXModelGroup.getProperty(modelName + ".serverUrl", "JNDI.global.serverUrl");
        String userName = ERXModelGroup.getProperty(modelName + ".username", "JNDI.global.username");
        String password = ERXModelGroup.decryptProperty(modelName + ".password", "JNDI.global.password");
        String authenticationMethod = ERXModelGroup.getProperty(modelName + ".authenticationMethod", "JNDI.global.authenticationMethod");
        String plugin = ERXModelGroup.getProperty(modelName + ".plugin", "JNDI.global.plugin");
        NSMutableDictionary connectionDictionary = model.connectionDictionary();
        if (connectionDictionary == null) {
            connectionDictionary = new NSMutableDictionary();
            log.warn((Object)("The EOModel '" + model.name() + "' does not have a connection dictionary, providing an empty one"));
            model.setConnectionDictionary(connectionDictionary);
        }
        NSMutableDictionary<String, String> newConnectionDictionary = new NSMutableDictionary<String, String>(connectionDictionary);
        if (serverUrl != null) {
            newConnectionDictionary.setObjectForKey(serverUrl, "serverUrl");
        }
        if (userName != null) {
            newConnectionDictionary.setObjectForKey(userName, "username");
        }
        if (password != null) {
            newConnectionDictionary.setObjectForKey(password, "password");
        }
        if (authenticationMethod != null) {
            newConnectionDictionary.setObjectForKey(authenticationMethod, "authenticationMethod");
        }
        if (plugin != null) {
            newConnectionDictionary.setObjectForKey(plugin, "plugInClassName");
        }
        model.setConnectionDictionary(newConnectionDictionary);
    }

    protected void fixJDBCDictionary(EOModel model) {
        String driverCheck;
        String pluginCheck;
        String removeJdbc2Info;
        NSMutableDictionary connectionDictionary;
        String plugin;
        String aModelName = model.name();
        boolean poolConnections = ERXJDBCAdaptor.useConnectionBroker();
        String adaptor = ERXModelGroup.getProperty(aModelName + ".adaptor", "dbConnectAdaptorGLOBAL");
        String url = ERXModelGroup.getProperty(aModelName + ".URL", "dbConnectURLGLOBAL");
        String userName = ERXModelGroup.getProperty(aModelName + ".DBUser", "dbConnectUserGLOBAL");
        String passwd = ERXModelGroup.decryptProperty(aModelName + ".DBPassword", "dbConnectPasswordGLOBAL");
        String driver = ERXModelGroup.getProperty(aModelName + ".DBDriver", "dbConnectDriverGLOBAL");
        String serverName = ERXModelGroup.getProperty(aModelName + ".DBServer", "dbConnectServerGLOBAL");
        String h = ERXModelGroup.getProperty(aModelName + ".DBHostName", "dbConnectHostNameGLOBAL");
        String jdbcInfo = ERXModelGroup.getProperty(aModelName + ".DBJDBCInfo", "dbConnectJDBCInfoGLOBAL");
        NSMutableDictionary<String, String> poolingDictionary = new NSMutableDictionary<String, String>();
        if (poolConnections) {
            poolingDictionary.setObjectForKey(ERXModelGroup.getProperty(aModelName + ".DBMinConnections", "dbMinConnectionsGLOBAL", "1"), "minConnections");
            poolingDictionary.setObjectForKey(ERXModelGroup.getProperty(aModelName + ".DBMaxConnections", "dbMaxConnectionsGLOBAL", "20"), "maxConnections");
            poolingDictionary.setObjectForKey(ERXModelGroup.getProperty(aModelName + ".DBLogPath", "dbLogPathGLOBAL", "/tmp/ERXJDBCConnectionBroker_@@name@@_@@WOPort@@.log"), "logPath");
            poolingDictionary.setObjectForKey(ERXModelGroup.getProperty(aModelName + ".DBConnectionRecycle", "dbConnectionRecycleGLOBAL", "1.0"), "connectionRecycle");
            poolingDictionary.setObjectForKey(ERXModelGroup.getProperty(aModelName + ".DBMaxCheckout", "dbMaxCheckoutGLOBAL", "86400"), "maxCheckout");
            poolingDictionary.setObjectForKey(ERXModelGroup.getProperty(aModelName + ".DBDebugLevel", "dbDebugLevelGLOBAL", "1"), "debugLevel");
        }
        NSDictionary jdbcInfoDictionary = null;
        if (jdbcInfo != null && jdbcInfo.length() > 0 && jdbcInfo.charAt(0) == '^') {
            String modelName = jdbcInfo.substring(1, jdbcInfo.length());
            EOModel modelForCopy = model.modelGroup().modelNamed(modelName);
            if (modelForCopy != null && modelForCopy != model) {
                jdbcInfoDictionary = (NSDictionary)modelForCopy.connectionDictionary().objectForKey("jdbc2Info");
            } else {
                log.warn((Object)("Unable to find model named \"" + modelName + "\""));
                jdbcInfo = null;
            }
        }
        if ("Postgresql".equals(plugin = ERXModelGroup.getProperty(aModelName + ".DBPlugin", "dbConnectPluginGLOBAL")) && ERXStringUtilities.stringIsNullOrEmpty(url) && !ERXStringUtilities.stringIsNullOrEmpty(serverName) && !ERXStringUtilities.stringIsNullOrEmpty(h)) {
            url = "jdbc:postgresql://" + h + "/" + serverName;
        }
        if ((connectionDictionary = model.connectionDictionary()) == null) {
            connectionDictionary = new NSMutableDictionary();
            model.setConnectionDictionary(connectionDictionary);
        }
        NSMutableDictionary<String, Object> newConnectionDictionary = new NSMutableDictionary<String, Object>(connectionDictionary);
        if (adaptor != null) {
            model.setAdaptorName(adaptor);
        }
        if (url != null) {
            newConnectionDictionary.setObjectForKey(url, "URL");
        }
        if (userName != null) {
            newConnectionDictionary.setObjectForKey(userName, "username");
        }
        if (passwd != null) {
            newConnectionDictionary.setObjectForKey(passwd, "password");
        }
        if (driver != null) {
            newConnectionDictionary.setObjectForKey(driver, "driver");
        }
        if (jdbcInfoDictionary != null) {
            newConnectionDictionary.setObjectForKey(jdbcInfoDictionary, "jdbc2Info");
        } else if (jdbcInfo != null) {
            NSDictionary d = (NSDictionary)NSPropertyListSerialization.propertyListFromString((String)jdbcInfo);
            if (d != null) {
                newConnectionDictionary.setObjectForKey(d, "jdbc2Info");
            } else {
                newConnectionDictionary.removeObjectForKey("jdbc2Info");
            }
        }
        if (plugin != null) {
            newConnectionDictionary.setObjectForKey(plugin, "plugin");
        }
        newConnectionDictionary.addEntriesFromDictionary(poolingDictionary);
        if (newConnectionDictionary.count() == 0) {
            log.warn((Object)("The EOModel '" + model.name() + "' has an empty connection dictionary."));
        }
        if (ERXValueUtilities.booleanValue(removeJdbc2Info = ERXModelGroup.getProperty(aModelName + ".removeJdbc2Info", "dbRemoveJdbc2InfoGLOBAL", "true"))) {
            newConnectionDictionary.removeObjectForKey("jdbc2Info");
        }
        if ((pluginCheck = (String)newConnectionDictionary.objectForKey("plugin")) != null && pluginCheck.length() == 0) {
            newConnectionDictionary.removeObjectForKey("plugin");
        }
        if ((driverCheck = (String)newConnectionDictionary.objectForKey("driver")) != null && driverCheck.length() == 0) {
            newConnectionDictionary.removeObjectForKey("driver");
        }
        model.setConnectionDictionary(newConnectionDictionary);
        String[] keysThatMatter = new String[]{"URL", "username"};
        Enumeration modelsEnum = model.modelGroup().models().objectEnumerator();
        while (modelsEnum.hasMoreElements()) {
            NSDictionary otherConnectionDictionary;
            EOModel otherModel = (EOModel)modelsEnum.nextElement();
            if (otherModel == model || (otherConnectionDictionary = otherModel.connectionDictionary()) == null || !ERXExtensions.safeEquals(newConnectionDictionary.objectForKey("adaptorName"), otherConnectionDictionary.objectForKey("adaptorName"))) continue;
            boolean valuesThatMatterMatch = true;
            for (int keyNum = 0; valuesThatMatterMatch && keyNum < keysThatMatter.length; ++keyNum) {
                String thisValue = (String)newConnectionDictionary.objectForKey(keysThatMatter[keyNum]);
                String otherValue = (String)otherConnectionDictionary.objectForKey(keysThatMatter[keyNum]);
                valuesThatMatterMatch = ERXStringUtilities.stringEqualsString(thisValue, otherValue);
            }
            if (!valuesThatMatterMatch || newConnectionDictionary.equals(otherConnectionDictionary)) continue;
            if (!this.isPrototypeModel(model) && !this.isPrototypeModel(otherModel)) {
                String message = "The connection dictionaries for " + model.name() + " and " + otherModel.name() + " have the same URL and username, but the connection dictionaries are not equal. Check your connection dictionaries carefully! This problem is often caused by jdbc2Info not matching between the two.  One fix for this is to set " + model.name() + ".removeJdbc2Info=true and " + otherModel.name() + ".removeJdbc2Info=true in your Properties file. (" + model.name() + "=" + newConnectionDictionary + "; and " + otherModel.name() + "=" + otherConnectionDictionary + ").";
                if (!this.raiseOnUnmatchingConnectionDictionaries) {
                    log.warn((Object)message);
                } else {
                    throw new IllegalArgumentException(message);
                }
            }
            log.info((Object)("The connection dictionaries for " + model.name() + " and " + otherModel.name() + " have the same URL and username, but at least one of them is a prototype model, so it shouldn't be a problem."));
        }
    }

    public boolean isPrototypeModel(EOModel model) {
        return this._prototypeModelNames != null && model != null && this._prototypeModelNames.containsObject(model.name());
    }

    public void resetConnectionDictionaryInModel(EOModel model) {
        NSMutableDictionary<String, String> dict;
        if (model == null) {
            throw new IllegalArgumentException("Model can't be null");
        }
        String modelName = model.name();
        log.debug((Object)("Adjusting " + modelName));
        NSDictionary old = model.connectionDictionary();
        if (model.adaptorName() == null) {
            log.info((Object)("Skipping model '" + modelName + "', it has no adaptor name set"));
            return;
        }
        NSDictionary databaseConfig = ERXModelGroup.databaseConfigForModel(model);
        if (databaseConfig != null) {
            NSDictionary connectionDictionary = (NSDictionary)databaseConfig.objectForKey("connectionDictionary");
            model.setConnectionDictionary(connectionDictionary);
        }
        if (model.adaptorName().indexOf("Oracle") != -1) {
            this.fixOracleDictionary(model);
        } else if (model.adaptorName().indexOf("Flat") != -1) {
            this.fixFlatDictionary(model);
        } else if (model.adaptorName().indexOf("OpenBase") != -1) {
            this.fixOpenBaseDictionary(model);
        } else if (model.adaptorName().indexOf("JDBC") != -1) {
            this.fixJDBCDictionary(model);
        } else if (model.adaptorName().indexOf("JNDI") != -1) {
            this.fixJNDIDictionary(model);
        }
        if (log.isDebugEnabled() && old != null && !old.equals(model.connectionDictionary()) && model.connectionDictionary() != null && (dict = model.connectionDictionary().mutableClone()).objectForKey("password") != null) {
            dict.setObjectForKey("<deleted for log>", "password");
            log.debug((Object)("New Connection Dictionary for " + modelName + ": " + dict));
        }
        this.fixPrototypesForModel(model);
    }

    public static String prototypeEntityNameForModel(EOModel model) {
        String pluginName;
        String modelName = model.name();
        String prototypeEntityName = ERXModelGroup.getProperty(modelName + ".EOPrototypesEntity", "dbEOPrototypesEntityGLOBAL");
        NSDictionary databaseConfig = ERXModelGroup.databaseConfigForModel(model);
        if (prototypeEntityName == null && databaseConfig != null) {
            prototypeEntityName = (String)databaseConfig.objectForKey("prototypeEntityName");
        }
        if (prototypeEntityName == null && !ERXModelGroup.patchModelsOnLoad() && (pluginName = ERXEOAccessUtilities.guessPluginName(model)) != null) {
            String pluginPrototypeEntityName = "EOJDBC" + pluginName + "Prototypes";
            if (model.modelGroup().entityNamed(pluginPrototypeEntityName) != null) {
                prototypeEntityName = pluginPrototypeEntityName;
            }
        }
        return prototypeEntityName;
    }

    protected static NSDictionary databaseConfigForModel(EOModel model) {
        NSDictionary entityModelerDictionary;
        String modelName = model.name();
        String databaseConfigName = ERXModelGroup.getProperty(modelName + ".DBConfigName", "dbConfigNameGLOBAL");
        NSDictionary databaseConfig = null;
        NSDictionary userInfo = model.userInfo();
        if (userInfo != null && (entityModelerDictionary = (NSDictionary)userInfo.objectForKey("_EntityModeler")) != null) {
            NSDictionary databaseConfigsDictionary;
            if (databaseConfigName == null) {
                databaseConfigName = (String)entityModelerDictionary.objectForKey("activeDatabaseConfigName");
            }
            if (databaseConfigName != null && (databaseConfigsDictionary = (NSDictionary)entityModelerDictionary.objectForKey("databaseConfigs")) != null) {
                databaseConfig = (NSDictionary)databaseConfigsDictionary.objectForKey(databaseConfigName);
            }
        }
        return databaseConfig;
    }

    private void fixPrototypesForModel(EOModel model) {
        NSDictionary dict;
        String modelName = model.name();
        String f = ERXModelGroup.getProperty(modelName + ".EOPrototypesFile", "EOPrototypesFileGLOBAL");
        if (f != null && (dict = (NSDictionary)NSPropertyListSerialization.propertyListFromString((String)ERXStringUtilities.stringFromResource(f, "", null))) != null) {
            EOEntity proto;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Adjusting prototypes from " + f));
            }
            if ((proto = model.entityNamed("EOPrototypes")) == null) {
                log.warn((Object)("No prototypes found in model named \"" + modelName + "\", although the EOPrototypesFile default was set!"));
            } else {
                model.removeEntity(proto);
                proto = new EOEntity(dict, (Object)model);
                proto.awakeWithPropertyList(dict);
                model.addEntity(proto);
            }
        }
        if (patchModelsOnLoad) {
            this.modifyModelsFromProperties();
            this.flattenPrototypes();
            this.preloadERXConstantClassesForModel(model);
        }
    }

    protected void preloadERXConstantClassesForModel(EOModel model) {
        Enumeration entitiesEnum = model.entities().objectEnumerator();
        while (entitiesEnum.hasMoreElements()) {
            EOEntity entity = (EOEntity)entitiesEnum.nextElement();
            Enumeration attributesEnum = entity.attributes().objectEnumerator();
            while (attributesEnum.hasMoreElements()) {
                String constantClassName;
                EOAttribute attribute = (EOAttribute)attributesEnum.nextElement();
                NSDictionary attributeUserInfo = attribute.userInfo();
                if (attributeUserInfo == null || (constantClassName = (String)attributeUserInfo.objectForKey("ERXConstantClassName")) == null) continue;
                boolean constantClassFound = true;
                try {
                    Class.forName(constantClassName);
                }
                catch (ClassNotFoundException e) {
                    int lastDotIndex = constantClassName.lastIndexOf(46);
                    if (lastDotIndex != -1) {
                        String innerClassName = constantClassName.substring(0, lastDotIndex) + "$" + constantClassName.substring(lastDotIndex + 1);
                        try {
                            Class.forName(innerClassName);
                        }
                        catch (ClassNotFoundException e2) {
                            constantClassFound = false;
                        }
                    }
                    constantClassFound = false;
                }
                if (constantClassFound) continue;
                throw new IllegalArgumentException(attribute.name() + " specified an ERXConstantClass of '" + constantClassName + "', which could not be found.");
            }
        }
    }

    protected void modifyModelsFromProperties() {
        Enumeration modelsEnum = this.models().objectEnumerator();
        while (modelsEnum.hasMoreElements()) {
            EOModel model = (EOModel)modelsEnum.nextElement();
            Enumeration entitiesEnum = model.entities().objectEnumerator();
            while (entitiesEnum.hasMoreElements()) {
                EOEntity entity = (EOEntity)entitiesEnum.nextElement();
                String externalName = ERXProperties.stringForKey("er.extensions.ERXModelGroup." + entity.name() + ".externalName");
                if (externalName != null) {
                    entity.setExternalName(externalName);
                }
                Enumeration attributesEnum = entity.attributes().objectEnumerator();
                while (attributesEnum.hasMoreElements()) {
                    EOAttribute attribute = (EOAttribute)attributesEnum.nextElement();
                    String attributeColumnName = ERXProperties.stringForKey("er.extensions.ERXModelGroup." + entity.name() + "." + attribute.name() + ".columnName");
                    if (attributeColumnName == null) continue;
                    attribute.setColumnName(attributeColumnName);
                }
            }
        }
    }

    private void flattenPrototypes() {
        if (!flattenPrototypes) {
            return;
        }
        if (ERXModel.isUseExtendedPrototypesEnabled()) {
            log.warn((Object)"Using er.extensions.ERXModel.useExtendedPrototypes=true may be incompatible with er.extensions.ERXModelGroup.flattenPrototypes=true (its default value).");
        }
        String prototypesFixedKey = "_EOPrototypesFixed";
        Enumeration modelsEnum = this.models().objectEnumerator();
        while (modelsEnum.hasMoreElements()) {
            EOModel model = (EOModel)modelsEnum.nextElement();
            if (this._prototypeModelNames.containsObject(model.name())) {
                log.debug((Object)("Skipping prototype model " + model.name()));
                continue;
            }
            NSDictionary userInfo = model.userInfo();
            Boolean prototypesFixedBoolean = (Boolean)userInfo.objectForKey(prototypesFixedKey);
            if (prototypesFixedBoolean != null && prototypesFixedBoolean.booleanValue()) continue;
            boolean prototypesFixed = false;
            String prototypeEntityName = ERXModelGroup.prototypeEntityNameForModel(model);
            if (prototypeEntityName == null) {
                prototypesFixed = true;
            } else {
                EOEntity prototypeEntity = this.entityNamed(prototypeEntityName);
                if (prototypeEntity == null) {
                    log.info((Object)(model.name() + " references a prototype entity named " + prototypeEntityName + " which is not yet loaded."));
                } else {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Flattening " + model.name() + " using the prototype " + prototypeEntity.name()));
                    }
                    Enumeration entitiesEnum = model.entities().objectEnumerator();
                    while (entitiesEnum.hasMoreElements()) {
                        EOEntity entity = (EOEntity)entitiesEnum.nextElement();
                        Enumeration attributesEnum = entity.attributes().objectEnumerator();
                        while (attributesEnum.hasMoreElements()) {
                            EOAttribute attribute = (EOAttribute)attributesEnum.nextElement();
                            if (!attribute.isFlattened()) {
                                String prototypeAttributeName = attribute.prototypeName();
                                if (prototypeAttributeName == null) {
                                    if (attribute.externalType() != null) continue;
                                    log.warn((Object)(model.name() + "/" + entity.name() + "/" + attribute.name() + " does not have a prototype attribute name.  This can occur if the model cannot resolve ANY prototypes when loaded.  There must be a stub prototype for the model to load with that can then be replaced with the appropriate database-specific model."));
                                    continue;
                                }
                                EOAttribute prototypeAttribute = prototypeEntity.attributeNamed(prototypeAttributeName);
                                if (prototypeAttribute == null) {
                                    log.warn((Object)(model.name() + "/" + entity.name() + "/" + attribute.name() + " references a prototype attribute named " + prototypeAttributeName + " that does not exist in " + prototypeEntity.name() + "."));
                                    continue;
                                }
                                if (attribute.prototype().entity() == prototypeEntity) {
                                    if (!log.isDebugEnabled()) continue;
                                    log.debug((Object)("Skipping " + model.name() + "/" + entity.name() + "/" + attribute.name() + " because it is already prototyped by the correct entity."));
                                    continue;
                                }
                                this.flattenPrototypeAttribute(prototypeAttribute, attribute);
                                if (!log.isDebugEnabled()) continue;
                                log.debug((Object)("Flattening " + model.name() + "/" + entity.name() + "/" + attribute.name() + " with the prototype attribute " + prototypeAttribute.entity().model().name() + "/" + prototypeAttribute.entity().name() + "/" + prototypeAttribute.name()));
                                continue;
                            }
                            log.debug((Object)("Skipping " + model.name() + "/" + entity.name() + "/" + attribute.name() + " because it's derived or flattened."));
                        }
                    }
                    prototypesFixed = true;
                }
            }
            NSMutableDictionary<String, Boolean> mutableUserInfo = userInfo.mutableClone();
            mutableUserInfo.setObjectForKey(prototypesFixed, prototypesFixedKey);
            model.setUserInfo(mutableUserInfo);
            this.dumpSchemaSQL(model);
        }
    }

    public static NSArray _prototypeKeys() {
        return _prototypeKeys;
    }

    public static Object _keyForEnum(int key) {
        return ERXModelGroup._prototypeKeys().objectAtIndex(key);
    }

    public static int _enumForKey(String key) {
        return ERXModelGroup._prototypeKeys().indexOfObject(key);
    }

    public static boolean _isKeyEnumOverriden(EOAttribute att, int key) {
        if (!ERXApplication.isWO54()) {
            try {
                Method isKeyEnumOverriddenMethod = att.getClass().getMethod("_isKeyEnumOverriden", Integer.TYPE);
                Boolean isKeyEnumOverridden = (Boolean)isKeyEnumOverriddenMethod.invoke((Object)att, new Integer(key));
                return isKeyEnumOverridden;
            }
            catch (Exception e) {
                throw new RuntimeException("_isKeyEnumOverridden failed.", e);
            }
        }
        boolean result = false;
        if (att.prototype() != null) {
            Map characteristics = (Map)NSKeyValueCoding.Utility.valueForKey((Object)att, (String)"overwrittenCharacteristics");
            for (Map.Entry element : characteristics.entrySet()) {
                String charateristic = element.getKey().toString();
                Boolean value = (Boolean)element.getValue();
                if (!charateristic.equalsIgnoreCase(ERXModelGroup._keyForEnum(key).toString())) continue;
                return value;
            }
        }
        return result;
    }

    private void flattenPrototypeAttribute(EOAttribute prototypeAttribute, EOAttribute attribute) {
        Class clazz;
        NSArray prototypeKeys = ERXModelGroup._prototypeKeys();
        NSMutableArray<String> overriddenKeys = new NSMutableArray<String>();
        Enumeration prototypeKeysEnum = prototypeKeys.objectEnumerator();
        while (prototypeKeysEnum.hasMoreElements()) {
            String prototypeKey = (String)prototypeKeysEnum.nextElement();
            if (!ERXModelGroup._isKeyEnumOverriden(attribute, ERXModelGroup._enumForKey(prototypeKey))) continue;
            overriddenKeys.addObject(prototypeKey);
        }
        String className = attribute.className();
        boolean hasCustomClass = false;
        if (overriddenKeys.containsObject("valueFactoryMethodName")) {
            overriddenKeys.addObject("factoryMethodArgumentType");
            hasCustomClass = true;
        }
        if (attribute.isDerived()) {
            overriddenKeys.addObject("columnName");
        }
        NSArray keysToReplace = _NSArrayUtilities.arrayExcludingObjectsFromArray((NSArray)prototypeKeys, overriddenKeys);
        NSDictionary valuesToReplace = EOKeyValueCodingAdditions.Utility.valuesForKeys((Object)prototypeAttribute, (NSArray)keysToReplace);
        attribute.setPrototype(null);
        NSMutableDictionary<String, String> userInfo = new NSMutableDictionary<String, String>(prototypeAttribute.name(), "prototypeName");
        if (attribute.userInfo() != null) {
            userInfo.addEntriesFromDictionary(attribute.userInfo());
        }
        attribute.setUserInfo(userInfo);
        EOKeyValueCodingAdditions.Utility.takeValuesFromDictionary((Object)attribute, (NSDictionary)valuesToReplace);
        if (hasCustomClass && ERXConstant.StringConstant.class.isAssignableFrom(clazz = ERXPatcher.classForName(className))) {
            attribute.setFactoryMethodArgumentType(1);
            attribute.setClassName(className);
            attribute.setValueFactoryMethodName(attribute.valueFactoryMethodName());
            log.info((Object)("Attribute : " + attribute + " changed " + attribute.adaptorValueType() + " " + attribute.factoryMethodArgumentType()));
        }
    }

    static {
        NSNotificationCenter.defaultCenter().addObserver(LocalizedAttributeProcessor.class, new NSSelector("modelGroupAdded", ERXConstant.NotificationClassArray), ModelGroupAddedNotification, null);
        _prototypeKeys = new NSArray<Object>(new Object[]{"externalType", "columnName", "readOnly", "valueClassName", "valueType", "width", "precision", "scale", "writeFormat", "readFormat", "userInfo", "serverTimeZone", "valueFactoryMethodName", "adaptorValueConversionMethodName", "factoryMethodArgumentType", "allowsNull", "parameterDirection", "_internalInfo"});
    }

    public static class Model
    extends ERXModel {
        public Model(URL url) {
            super(url);
        }

        protected boolean useExtendedPrototypes() {
            return true;
        }
    }

    public static class LocalizedAttributeProcessor {
        protected EOAttribute cloneAttribute(EOEntity entity, EOAttribute attribute, String newName) {
            EOAttribute copy = new EOAttribute();
            copy.setName(newName);
            entity.addAttribute(copy);
            copy.setPrototype(attribute.prototype());
            copy.setColumnName(attribute.columnName());
            copy.setExternalType(attribute.externalType());
            copy.setValueType(attribute.valueType());
            copy.setPrecision(attribute.precision());
            copy.setAllowsNull(attribute.allowsNull());
            copy.setClassName(attribute.className());
            copy.setWidth(attribute.width());
            copy.setScale(attribute.scale());
            copy.setExternalType(attribute.externalType());
            return copy;
        }

        protected void adjustLocalizedAttributes(EOModelGroup group) {
            Enumeration enumerator = group.models().objectEnumerator();
            while (enumerator.hasMoreElements()) {
                EOModel model = (EOModel)enumerator.nextElement();
                Enumeration e1 = model.entities().objectEnumerator();
                while (e1.hasMoreElements()) {
                    EOEntity entity = (EOEntity)e1.nextElement();
                    this.adjustLocalizedAttributes(entity);
                }
            }
        }

        protected void adjustLocalizedAttributes(EOEntity entity) {
            NSArray attributes = entity.attributes().immutableClone();
            NSArray classProperties = entity.classProperties().immutableClone();
            NSArray attributesUsedForLocking = entity.attributesUsedForLocking().immutableClone();
            if (attributes == null) {
                attributes = NSArray.EmptyArray;
            }
            if (classProperties == null) {
                classProperties = NSArray.EmptyArray;
            }
            if (attributesUsedForLocking == null) {
                attributesUsedForLocking = NSArray.EmptyArray;
            }
            NSMutableArray<EOAttribute> mutableClassProperties = classProperties.mutableClone();
            NSMutableArray<EOAttribute> mutableAttributesUsedForLocking = attributesUsedForLocking.mutableClone();
            if (attributes != null) {
                Enumeration e = attributes.objectEnumerator();
                while (e.hasMoreElements()) {
                    NSArray languages;
                    NSArray languagesObject;
                    EOAttribute attribute = (EOAttribute)e.nextElement();
                    boolean isClassProperty = classProperties.containsObject(attribute);
                    boolean isUsedForLocking = attributesUsedForLocking.containsObject(attribute);
                    NSArray nSArray = languagesObject = attribute.userInfo() != null ? (NSArray)attribute.userInfo().objectForKey(ERXModelGroup.LANGUAGES_KEY) : null;
                    if (languagesObject != null && !(languagesObject instanceof NSArray)) {
                        NSArray nSArray2 = languagesObject = entity.model().userInfo() != null ? (NSArray)entity.model().userInfo().objectForKey(ERXModelGroup.LANGUAGES_KEY) : null;
                        if (languagesObject == null) {
                            languagesObject = ERXProperties.arrayForKey(ERXModelGroup.LANGUAGES_KEY);
                        }
                    }
                    if ((languages = languagesObject != null ? (NSArray)languagesObject : NSArray.EmptyArray).count() <= 0) continue;
                    String name = attribute.name();
                    String columnName = attribute.columnName();
                    NSMutableDictionary<String, NSArray> attributeUserInfo = new NSMutableDictionary<String, NSArray>();
                    if (attribute.userInfo() != null) {
                        attributeUserInfo.addEntriesFromDictionary(attribute.userInfo());
                    }
                    attributeUserInfo.setObjectForKey(languages, ERXModelGroup.LANGUAGES_KEY);
                    for (int i = 0; i < languages.count(); ++i) {
                        String language = (String)languages.objectAtIndex(i);
                        String newName = name + "_" + language;
                        EOAttribute copy = this.cloneAttribute(entity, attribute, newName);
                        String newColumnName = columnName + "_" + language;
                        copy.setColumnName(newColumnName);
                        if (isClassProperty) {
                            mutableClassProperties.addObject(copy);
                        }
                        if (isUsedForLocking) {
                            mutableAttributesUsedForLocking.addObject(copy);
                        }
                        copy.setUserInfo(attributeUserInfo.mutableClone());
                    }
                    entity.removeAttribute(attribute);
                    mutableClassProperties.removeObject(attribute);
                    mutableAttributesUsedForLocking.removeObject(attribute);
                }
                entity.setAttributesUsedForLocking(mutableAttributesUsedForLocking);
                entity.setClassProperties(mutableClassProperties);
            }
        }

        public static void modelGroupAdded(NSNotification n) {
            EOModelGroup group = (EOModelGroup)n.object();
            new LocalizedAttributeProcessor().adjustLocalizedAttributes(group);
        }
    }
}

