/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.formatters;

import com.webobjects.foundation.NSNumberFormatter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.FieldPosition;

public class ERXDividingNumberFormatter
extends NSNumberFormatter {
    private float factor;

    public ERXDividingNumberFormatter() {
    }

    public ERXDividingNumberFormatter(String arg0) {
        super(arg0);
    }

    public String pattern() {
        String pattern = super.pattern();
        return pattern;
    }

    public void setPattern(String pattern) {
        try {
            if (pattern.indexOf("=)") == -1) {
                super.setPattern(pattern);
                return;
            }
            String realPattern = pattern.substring(pattern.indexOf("=)") + 2);
            String f = pattern.substring(1, pattern.indexOf("=)"));
            try {
                this.factor = Float.parseFloat(f);
            }
            catch (NumberFormatException e1) {
                throw new IllegalArgumentException("ERXDividingNumberFormatter must have a pattern like '(1024=)0.00', where 1024 is the factor.");
            }
            super.setPattern(realPattern);
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException("ERXDividingNumberFormatter must have a pattern like '(1024=)0.00', where 1024 is the factor.");
        }
    }

    public StringBuffer format(Object arg0, StringBuffer arg1, FieldPosition arg2) {
        if (!(arg0 instanceof Number)) {
            return super.format(arg0, arg1, arg2);
        }
        Number n = (Number)arg0;
        if (arg0 instanceof BigDecimal) {
            BigDecimal b = (BigDecimal)arg0;
            b = b.divide(new BigDecimal(this.factor), 4);
            return super.format((Object)b, arg1, arg2);
        }
        if (arg0 instanceof BigInteger) {
            BigInteger b = (BigInteger)arg0;
            b = b.divide(new BigInteger("" + this.factor));
            return super.format((Object)b, arg1, arg2);
        }
        double d = n.doubleValue();
        return super.format((Object)new Double(d /= (double)this.factor), arg1, arg2);
    }
}

