/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.foundation;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.Socket;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class ERXLinlyn {
    public static final Logger log = Logger.getLogger(ERXLinlyn.class);
    private boolean DEBUG = false;
    private boolean pauser = false;
    private static final int DEFAULT_CNTRL_PORT = 21;
    private Socket csock = null;
    private Socket dsock = null;
    private BufferedReader dcis;
    private PrintWriter pos;

    public ERXLinlyn(String server, String user, String pass) {
        this(server, 21, user, pass);
    }

    public ERXLinlyn(String server, int portNum, String user, String pass) {
        try {
            this.ftpConnect(server, portNum);
            this.ftpLogin(user, pass);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public String[] listFiles(String dir) throws IOException {
        this.ftpSetTransferType(false);
        this.dsock = this.ftpGetDataSock();
        InputStream is = this.dsock.getInputStream();
        this.ftpSendCmd("LIST " + dir);
        String contents = this.getAsString(is);
        if (log.isDebugEnabled()) {
            log.debug((Object)contents);
        }
        String[] files = contents.split("\n");
        return files;
    }

    public String download(String dir, String file) throws IOException {
        return this.download(dir, file, true);
    }

    public String download(String dir, String file, boolean asc) throws IOException {
        return this.download(dir, file, asc, true);
    }

    public String download(String dir, String file, boolean asc, boolean keepAlive) throws IOException {
        this.ftpSetDir(dir);
        this.ftpSetTransferType(asc);
        this.dsock = this.ftpGetDataSock();
        InputStream is = this.dsock.getInputStream();
        this.ftpSendCmd("RETR " + file);
        String contents = this.getAsString(is);
        if (!keepAlive) {
            this.ftpLogout();
        }
        return contents;
    }

    public void append(String dir, String file, String what, boolean asc) throws IOException {
        this.ftpSetDir(dir);
        this.ftpSetTransferType(asc);
        this.dsock = this.ftpGetDataSock();
        OutputStream os = this.dsock.getOutputStream();
        DataOutputStream dos = new DataOutputStream(os);
        this.ftpSendCmd("APPE " + file);
        dos.writeBytes(what);
        dos.flush();
        dos.close();
        this.ftpLogout();
    }

    public void upload(String dir, String file, String what) throws IOException {
        this.upload(dir, file, what, true);
    }

    public void upload(String dir, String file, byte[] bytes) throws IOException {
        this.upload(dir, file, bytes, true);
    }

    public void upload(String dir, String file, byte[] bytes, boolean keepAlive) throws IOException {
        this.ftpSetDir(dir);
        this.ftpSetTransferType(false);
        this.dsock = this.ftpGetDataSock();
        OutputStream os = this.dsock.getOutputStream();
        DataOutputStream dos = new DataOutputStream(os);
        this.ftpSendCmd("STOR " + file);
        dos.write(bytes);
        dos.flush();
        dos.close();
        if (!keepAlive) {
            this.ftpLogout();
        }
    }

    public void upload(String dir, String file, String what, boolean asc) throws IOException {
        this.upload(dir, file, what, asc, true);
    }

    public void upload(String dir, String file, String what, boolean asc, boolean keepAlive) throws IOException {
        this.ftpSetDir(dir);
        this.ftpSetTransferType(asc);
        this.dsock = this.ftpGetDataSock();
        OutputStream os = this.dsock.getOutputStream();
        DataOutputStream dos = new DataOutputStream(os);
        this.ftpSendCmd("STOR " + file);
        dos.writeBytes(what);
        dos.flush();
        dos.close();
        if (!keepAlive) {
            this.ftpLogout();
        }
    }

    public boolean deleteFile(String dir, String file) throws IOException {
        return this.deleteFile(dir, file, true);
    }

    public boolean deleteFile(String dir, String file, boolean keepAlive) throws IOException {
        this.ftpSetDir(dir);
        String response = this.ftpSendCmd("DELE " + file);
        if (!keepAlive) {
            this.ftpLogout();
        }
        return response.startsWith("250");
    }

    private String getAsString(InputStream is) {
        int offset;
        char[] buf;
        int c;
        block9: {
            char[] lineBuffer;
            c = 0;
            int doubler = 65536;
            buf = lineBuffer = new char[doubler];
            int room = buf.length;
            offset = 0;
            try {
                while (true) {
                    c = is.read();
                    switch (c) {
                        case -1: {
                            break block9;
                        }
                        default: {
                            if (--room < 0) {
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)("Growing array by: " + doubler));
                                }
                                buf = new char[offset + doubler];
                                doubler *= 2;
                                room = buf.length - offset - 1;
                                System.arraycopy(lineBuffer, 0, buf, 0, offset);
                                lineBuffer = buf;
                            }
                            buf[offset++] = (char)c;
                            break;
                        }
                    }
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
        if (c == -1 && offset == 0) {
            return null;
        }
        return String.copyValueOf(buf, 0, offset);
    }

    private void ftpConnect(String server, int portNum) throws IOException {
        this.csock = new Socket(server, portNum);
        InputStream cis = this.csock.getInputStream();
        this.dcis = new BufferedReader(new InputStreamReader(cis));
        OutputStream cos = this.csock.getOutputStream();
        this.pos = new PrintWriter(cos, true);
        String numerals = this.responseHandler(null);
        if (!numerals.substring(0, 3).equals("220")) {
            System.err.println("Error connecting to ftp server.");
        }
    }

    private void ftpLogin(String user, String pass) throws IOException {
        this.ftpSendCmd("USER " + user);
        this.ftpSendCmd("PASS " + pass);
    }

    private void ftpSetDir(String dir) throws IOException {
        this.ftpSendCmd("CWD " + dir);
    }

    private void ftpSetTransferType(boolean asc) throws IOException {
        String ftype = asc ? "A" : "I";
        this.ftpSendCmd("TYPE " + ftype);
    }

    private Socket ftpGetDataSock() throws IOException {
        String reply = this.ftpSendCmd("PASV");
        StringTokenizer st = new StringTokenizer(reply, ",");
        String[] parts = new String[6];
        int i = 0;
        while (st.hasMoreElements()) {
            try {
                parts[i] = st.nextToken();
                ++i;
            }
            catch (NoSuchElementException nope) {
                nope.printStackTrace();
            }
        }
        String[] possNum = new String[3];
        for (int j = 0; j < 3; ++j) {
            possNum[j] = parts[0].substring(parts[0].length() - (j + 1), parts[0].length() - j);
            if (Character.isDigit(possNum[j].charAt(0))) continue;
            possNum[j] = "";
        }
        parts[0] = possNum[2] + possNum[1] + possNum[0];
        String[] porties = new String[3];
        for (int k = 0; k < 3; ++k) {
            porties[k] = k + 1 <= parts[5].length() ? parts[5].substring(k, k + 1) : "FOOBAR";
            if (Character.isDigit(porties[k].charAt(0))) continue;
            porties[k] = "";
        }
        parts[5] = porties[0] + porties[1] + porties[2];
        String ip = parts[0] + "." + parts[1] + "." + parts[2] + "." + parts[3];
        int port = -1;
        try {
            int big = Integer.parseInt(parts[4]) << 8;
            int small = Integer.parseInt(parts[5]);
            port = big + small;
        }
        catch (NumberFormatException nfe) {
            nfe.printStackTrace();
        }
        if (ip == null || port == -1) {
            throw new IOException();
        }
        this.dsock = new Socket(ip, port);
        return this.dsock;
    }

    private String ftpSendCmd(String cmd) throws IOException {
        if (this.pauser && this.dcis != null) {
            String discard = this.dcis.readLine();
            if (this.DEBUG) {
                System.out.println("keeping handler in sync by discarding next response: ");
                System.out.println(discard);
            }
            this.pauser = false;
        }
        this.pos.print(cmd + "\r\n");
        this.pos.flush();
        String response = this.responseHandler(cmd);
        if (log.isDebugEnabled()) {
            log.debug((Object)("command = " + cmd));
            log.debug((Object)("response = " + response));
        }
        return response;
    }

    private String responseHandler(String cmd) throws IOException {
        String reply = this.responseParser(this.dcis.readLine());
        String numerals = reply.substring(0, 3);
        String hyph_test = reply.substring(3, 4);
        String next = null;
        if (hyph_test.equals("-")) {
            String tester = numerals + " ";
            boolean done = false;
            while (!done) {
                next = this.dcis.readLine();
                while (next.equals("") || next.equals("  ")) {
                    next = this.dcis.readLine();
                }
                if (!next.substring(0, 4).equals(tester)) continue;
                done = true;
            }
            if (this.DEBUG) {
                if (cmd != null) {
                    System.out.println("Response to: " + cmd + " was: " + next);
                } else {
                    System.out.println("Response was: " + next);
                }
            }
            return next;
        }
        if (this.DEBUG) {
            if (cmd != null) {
                System.out.println("Response to: " + cmd + " was: " + reply);
            } else {
                System.out.println("Response was: " + reply);
            }
        }
        return reply;
    }

    private String responseParser(String resp) throws IOException {
        String digit1 = resp.substring(0, 1);
        if (digit1.equals("1")) {
            if (this.DEBUG) {
                System.out.println("in 1 handler");
            }
            this.pauser = true;
            return resp;
        }
        if (digit1.equals("2")) {
            if (this.DEBUG) {
                System.out.println("in 2 handler");
            }
            this.pauser = false;
            return resp;
        }
        if (digit1.equals("3") || digit1.equals("4") || digit1.equals("5")) {
            if (this.DEBUG) {
                System.out.println("in 3-4-5 handler");
            }
            return resp;
        }
        return null;
    }

    private void ftpLogout() {
        try {
            if (this.DEBUG) {
                System.out.println("sending BYE");
            }
            this.pos.print("BYE\r\n");
            this.pos.flush();
            this.pos.close();
            this.dcis.close();
            this.csock.close();
            this.dsock.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }
}

