/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.jdbc;

import com.webobjects.eoaccess.EOAdaptor;
import com.webobjects.eoaccess.EODatabaseContext;
import com.webobjects.eoaccess.EOModel;
import com.webobjects.eoaccess.EOModelGroup;
import com.webobjects.eocontrol.EOCooperatingObjectStore;
import com.webobjects.eocontrol.EOEnterpriseObject;
import com.webobjects.eocontrol.EOObjectStore;
import com.webobjects.eocontrol.EOObjectStoreCoordinator;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSForwardException;
import com.webobjects.jdbcadaptor.JDBCAdaptor;
import com.webobjects.jdbcadaptor.JDBCPlugIn;
import er.extensions.foundation.ERXProperties;
import er.extensions.foundation.ERXValueUtilities;
import er.extensions.jdbc.ERXJDBCAdaptor;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Date;
import java.util.Hashtable;
import org.apache.log4j.Logger;

public class ERXJDBCConnectionBroker
implements ERXJDBCAdaptor.ConnectionBroker {
    public static final Logger log = Logger.getLogger(ERXJDBCConnectionBroker.class);
    private static Hashtable brokers = new Hashtable();
    private Thread reaper;
    private Thread pinger;
    private ConnectionWrapper[] wrappers;
    private String dbDriver;
    private String dbServer;
    private String dbLogin;
    private String dbPassword;
    private int activeConnections;
    private int lastRoundRobinIndex;
    private int minimumConnections;
    private int maximumConnections;
    private int maxCheckoutMillis;
    long maxConnectionMillis;
    private boolean active = true;
    private boolean supportsTransactions = false;
    private static final int DEFAULTMAXCHECKOUTSECONDS = 600;

    public static ERXJDBCConnectionBroker connectionBrokerForModelWithName(String modelName) {
        return ERXJDBCConnectionBroker.connectionBrokerForModel(EOModelGroup.defaultGroup().modelNamed(modelName));
    }

    public static ERXJDBCConnectionBroker connectionBrokerForModel(EOModel model) {
        return ERXJDBCConnectionBroker.connectionBrokerForConnectionDictionary(model.connectionDictionary());
    }

    public static ERXJDBCConnectionBroker connectionBrokerForEoInEditingContext(EOEnterpriseObject eo) {
        EOObjectStoreCoordinator osc;
        EOCooperatingObjectStore cos;
        EOObjectStore os = eo.editingContext().rootObjectStore();
        if (os instanceof EOObjectStoreCoordinator && (cos = (osc = (EOObjectStoreCoordinator)os).objectStoreForObject(eo)) instanceof EODatabaseContext) {
            EODatabaseContext dbctx = (EODatabaseContext)cos;
            EOAdaptor adaptor = dbctx.database().adaptor();
            return ERXJDBCConnectionBroker.connectionBrokerForAdaptor(adaptor);
        }
        throw new IllegalStateException("No connection broker found for EC");
    }

    public static ERXJDBCConnectionBroker connectionBrokerForEntityNamed(String ename) {
        return ERXJDBCConnectionBroker.connectionBrokerForModel(EOModelGroup.defaultGroup().entityNamed(ename).model());
    }

    public static ERXJDBCConnectionBroker connectionBrokerForAdaptor(EOAdaptor adaptor) {
        return ERXJDBCConnectionBroker.connectionBrokerForConnectionDictionary(adaptor.connectionDictionary());
    }

    private static synchronized ERXJDBCConnectionBroker connectionBrokerForConnectionDictionary(NSDictionary d) {
        String key = "";
        String[] keys = new String[]{"URL", "username", "password", "driver", "plugin"};
        for (int i = 0; i < keys.length; ++i) {
            key = key + d.objectForKey(keys[i]) + "\u0000";
        }
        ERXJDBCConnectionBroker broker = (ERXJDBCConnectionBroker)brokers.get(key);
        if (broker == null) {
            broker = ERXJDBCConnectionBroker.newConnectionBrokerWithConnectionDictionary(d);
            brokers.put(key, broker);
        }
        return broker;
    }

    private static ERXJDBCConnectionBroker newConnectionBrokerWithConnectionDictionary(NSDictionary dict) {
        ERXJDBCConnectionBroker broker = null;
        try {
            broker = new ERXJDBCConnectionBroker(dict);
        }
        catch (Exception ex) {
            log.error((Object)("Error while creating broker: " + broker), (Throwable)ex);
            throw new NSForwardException((Throwable)ex, "Error while creating broker: " + broker);
        }
        return broker;
    }

    private ERXJDBCConnectionBroker(NSDictionary dict) {
        this.setup(dict, 600);
    }

    public String toString() {
        return "<" + this.getClass().getName() + ": dbDriver = " + this.dbDriver + ", dbServer = " + this.dbServer + ", dbLogin = " + this.dbLogin + ", activeConnections = " + this.activeConnections + ", maximumConnections = " + this.maximumConnections + ", maxCheckoutMillis = " + this.maxCheckoutMillis + ", maxConnectionMillis = " + this.maxConnectionMillis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setup(NSDictionary dict, int maxCheckoutSecond) {
        this.dbDriver = (String)dict.objectForKey("driver");
        this.dbServer = (String)dict.objectForKey("URL");
        this.dbLogin = (String)dict.objectForKey("username");
        this.dbPassword = (String)dict.objectForKey("password");
        if (this.dbDriver == null || this.dbDriver.length() == 0) {
            JDBCAdaptor jdbcAdaptor = new JDBCAdaptor("JDBC");
            jdbcAdaptor.setConnectionDictionary(dict);
            JDBCPlugIn plugIn = jdbcAdaptor.plugIn();
            this.dbDriver = plugIn.defaultDriverName();
        }
        this.minimumConnections = ERXValueUtilities.intValueWithDefault((String)dict.objectForKey("minConnections"), ERXProperties.intForKeyWithDefault("er.extensions.ERXJDBCConnectionBroker.minConnections", 1));
        this.maximumConnections = ERXValueUtilities.intValueWithDefault((String)dict.objectForKey("maxConnections"), ERXProperties.intForKeyWithDefault("er.extensions.ERXJDBCConnectionBroker.maxConnections", 1));
        this.maxCheckoutMillis = ERXValueUtilities.intValueWithDefault((String)dict.objectForKey("maxCheckout"), ERXProperties.intForKeyWithDefault("er.extensions.ERXJDBCConnectionBroker.maxCheckout", maxCheckoutSecond)) * 1000;
        this.maxConnectionMillis = ERXValueUtilities.bigDecimalValueWithDefault((String)dict.objectForKey("connectionRecycle"), BigDecimal.valueOf(1L)).longValue() * 86400000L;
        if (this.maxConnectionMillis < 30000L) {
            this.maxConnectionMillis = 30000L;
        }
        boolean success = false;
        int maxTries = 20;
        this.wrappers = new ConnectionWrapper[this.maximumConnections];
        for (int tries = 1; tries < 20 && !success; ++tries) {
            try {
                for (int j = 0; j < this.minimumConnections; ++j) {
                    this.createWrapper();
                }
                success = true;
                continue;
            }
            catch (SQLException e) {
                log.error((Object)("Can't create connection " + tries + " of " + maxTries + ", will retry in 15 seconds: " + e), (Throwable)e);
                try {
                    Thread.sleep(15000L);
                    continue;
                }
                catch (InterruptedException e1) {
                    // empty catch block
                }
            }
        }
        if (!success) {
            throw new IllegalStateException("All attempts at connecting to Database exhausted: " + this);
        }
        Connection con = this.getConnection();
        try {
            block13: {
                try {
                    boolean bl = this.supportsTransactions = con.getTransactionIsolation() != 0;
                    if (!this.supportsTransactions) break block13;
                    con.setAutoCommit(false);
                }
                catch (SQLException ex) {
                    log.error((Object)ex, (Throwable)ex);
                    Object var9_14 = null;
                    this.freeConnection(con);
                }
            }
            Object var9_13 = null;
            this.freeConnection(con);
        }
        catch (Throwable throwable) {
            Object var9_15 = null;
            this.freeConnection(con);
            throw throwable;
        }
        this.reaper = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                while (true) {
                    ConnectionWrapper connection;
                    int i;
                    ConnectionWrapper[] connectionWrapperArray = ERXJDBCConnectionBroker.this.wrappers;
                    synchronized (connectionWrapperArray) {
                        for (i = 0; i < ERXJDBCConnectionBroker.this.activeConnections; ++i) {
                            connection = ERXJDBCConnectionBroker.this.wrappers[i];
                            connection.clearWarnings();
                        }
                    }
                    connectionWrapperArray = ERXJDBCConnectionBroker.this.wrappers;
                    synchronized (connectionWrapperArray) {
                        for (i = 0; i < ERXJDBCConnectionBroker.this.activeConnections; ++i) {
                            connection = ERXJDBCConnectionBroker.this.wrappers[i];
                            try {
                                connection.reap(ERXJDBCConnectionBroker.this.maxCheckoutMillis, ERXJDBCConnectionBroker.this.maxConnectionMillis);
                                continue;
                            }
                            catch (SQLException e) {
                                log.error((Object)("Error while reaping: " + connection));
                            }
                        }
                    }
                    try {
                        Thread.sleep(20000L);
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                }
            }

            public void destroy() {
                try {
                    ERXJDBCConnectionBroker.this.destroy(10000);
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
        };
        this.pinger = new Thread(new Runnable(){
            boolean b = ERXProperties.booleanForKeyWithDefault("er.extensions.ERXJDBCConnectionBroker.connectionPingEnabled", false);
            int wait = ERXProperties.intForKeyWithDefault("er.extensions.ERXJDBCConnectionBroker.connectionPingInterval", 300);

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                log.debug((Object)"Starting up ConnectionPing");
                while (this.b) {
                    ConnectionWrapper[] connectionWrapperArray = ERXJDBCConnectionBroker.this.wrappers;
                    synchronized (connectionWrapperArray) {
                        for (int i = 0; i < ERXJDBCConnectionBroker.this.wrappers.length; ++i) {
                            ConnectionWrapper connection = ERXJDBCConnectionBroker.this.wrappers[i];
                            connection.ping();
                        }
                    }
                    try {
                        Thread.sleep(this.wait * 1000);
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                }
            }
        });
        this.reaper.setName("ERXJDBCReaper");
        this.reaper.setDaemon(true);
        this.reaper.start();
        this.pinger.setName("ERXJDBCPinger");
        this.pinger.setDaemon(true);
        this.pinger.start();
        log.info((Object)("Started Broker : " + this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public Connection getConnection() {
        Connection result = null;
        if (!this.active) {
            throw new IllegalStateException("Unsuccessful getConnection() request during destroy()");
        }
        boolean gotOne = false;
        int tries = 0;
        while (tries <= 10) {
            Object object;
            int loop = 0;
            int roundRobin = this.lastRoundRobinIndex + 1;
            do {
                if (roundRobin >= this.activeConnections) {
                    roundRobin = 0;
                }
                object = this.wrappers;
                // MONITORENTER : this.wrappers
                ConnectionWrapper connection = this.wrappers[roundRobin];
                if (connection.isFree()) {
                    this.lastRoundRobinIndex = roundRobin + 1;
                    connection.lock();
                    result = connection.getConnection();
                    // MONITOREXIT : object
                    return result;
                }
                ++roundRobin;
                // MONITOREXIT : object
            } while (!gotOne && ++loop <= this.activeConnections);
            if (!gotOne) {
                object = this;
                // MONITORENTER : object
                if (this.activeConnections < this.maximumConnections) {
                    try {
                        this.createWrapper();
                    }
                    catch (SQLException e) {
                        throw new NSForwardException((Throwable)e, "Error: Unable to create new connection");
                    }
                }
                // MONITOREXIT : object
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                log.warn((Object)("Connections Exhausted! Will wait and try again in loop " + tries));
            }
            ++tries;
        }
        throw new IllegalStateException("No new connections found");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConnectionWrapper wrapperForConnection(Connection conn) {
        ConnectionWrapper[] connectionWrapperArray = this.wrappers;
        synchronized (this.wrappers) {
            for (int i = 0; i < this.activeConnections; ++i) {
                ConnectionWrapper connection = this.wrappers[i];
                if (connection.getConnection() != conn) continue;
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return connection;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return null;
        }
    }

    public void freeConnection(Connection conn) {
        ConnectionWrapper wrapper = this.wrapperForConnection(conn);
        if (wrapper != null) {
            wrapper.unlock();
        } else {
            log.error((Object)("Could not free connection: " + conn));
        }
    }

    private Connection createConnection() throws SQLException {
        try {
            Class.forName(this.dbDriver);
            Connection conn = DriverManager.getConnection(this.dbServer, this.dbLogin, this.dbPassword);
            return conn;
        }
        catch (ClassNotFoundException e2) {
            throw NSForwardException._runtimeExceptionForThrowable((Throwable)e2);
        }
    }

    private synchronized void createWrapper() throws SQLException {
        if (this.wrappers[this.activeConnections] == null) {
            if (this.activeConnections < this.maximumConnections) {
                this.wrappers[this.activeConnections] = new ConnectionWrapper(this);
                ++this.activeConnections;
            } else {
                throw new IllegalStateException("Trying to get more wrappers than available: " + this.activeConnections + " vs " + this.maximumConnections);
            }
        }
    }

    private void destroy(int millis) throws SQLException {
        int openChannelCount;
        this.active = false;
        this.pinger.interrupt();
        try {
            this.pinger.join(millis);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        this.reaper.interrupt();
        try {
            this.reaper.join(millis);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        long startTime = System.currentTimeMillis();
        long elapsed = System.currentTimeMillis() - startTime;
        while ((openChannelCount = this.getOpenChannelCount()) > 0 && elapsed <= (long)millis) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            elapsed = System.currentTimeMillis() - startTime;
        }
        for (int i = 0; i < this.activeConnections; ++i) {
            this.wrappers[i].close();
        }
        if (openChannelCount > 0) {
            String msg = "Unsafe shutdown: Had to close " + openChannelCount + " active DB connections after " + millis + "ms";
            throw new SQLException(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getOpenChannelCount() {
        int useCount = 0;
        ConnectionWrapper[] connectionWrapperArray = this.wrappers;
        synchronized (this.wrappers) {
            for (int i = 0; i < this.activeConnections; ++i) {
                if (this.wrappers[i].isFree()) continue;
                ++useCount;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return useCount;
        }
    }

    public boolean supportsTransaction() {
        return this.supportsTransactions;
    }

    private static class ConnectionWrapper {
        private String pingStatement = ERXProperties.stringForKeyWithDefault("er.extensions.ERXJDBCConnectionBroker.connectionPingSQL", "SELECT 1+1;");
        private static final int FREE = 0;
        private static final int BUSY = 1;
        private static final int OFFLINE = 2;
        private Connection connection;
        private ERXJDBCConnectionBroker broker;
        private int status;
        private long lockTime;
        private long creationDate;

        private ConnectionWrapper(ERXJDBCConnectionBroker broker) throws SQLException {
            this.broker = broker;
            this.connection = broker.createConnection();
            this.status = 0;
            this.lockTime = 0L;
        }

        public String toString() {
            return this.getClass().getName() + ": connection = " + this.connection + ": status = " + this.status + ": lockTime = " + this.lockTime + ": creationDate = " + this.creationDate;
        }

        public Connection getConnection() {
            return this.connection;
        }

        public void setConnection(Connection connection) {
            this.creationDate = new Date().getTime();
            this.connection = connection;
        }

        public long getCreationDate() {
            return this.creationDate;
        }

        public void setCreationDate(long creationDate) {
            this.creationDate = creationDate;
        }

        public long getLockTime() {
            return this.lockTime;
        }

        public void setLockTime(long lockTime) {
            this.lockTime = lockTime;
        }

        public int getStatus() {
            return this.status;
        }

        public void setStatus(int status) {
            this.status = status;
        }

        public boolean isFree() {
            return this.getStatus() == 0;
        }

        private void close() {
            try {
                if (this.getConnection() != null) {
                    this.getConnection().close();
                    this.setConnection(null);
                    this.setStatus(2);
                }
            }
            catch (SQLException ex) {
                log.warn((Object)("Cannot close connection: " + this), (Throwable)ex);
            }
        }

        public void unlock() {
            if (this.getStatus() != 1) {
                throw new IllegalStateException("Attempt to unlock non-busy channel: " + this);
            }
            this.setStatus(0);
            this.setLockTime(0L);
            try {
                if (this.getConnection().isReadOnly()) {
                    this.getConnection().setReadOnly(true);
                }
                if (!this.getConnection().getAutoCommit()) {
                    this.getConnection().setAutoCommit(true);
                }
            }
            catch (SQLException e) {
                log.error((Object)e, (Throwable)e);
            }
        }

        public void lock() {
            if (!this.isFree()) {
                throw new IllegalStateException("Attempt to lock busy channel: " + this);
            }
            this.setStatus(2);
            this.setLockTime(System.currentTimeMillis());
            try {
                block6: {
                    try {
                        if (this.getConnection().isReadOnly()) {
                            this.getConnection().setReadOnly(false);
                        }
                        if (!this.getConnection().getAutoCommit()) break block6;
                        this.getConnection().setAutoCommit(false);
                    }
                    catch (SQLException e) {
                        throw new NSForwardException((Throwable)e, "Could not set read only to false for connection: " + this);
                    }
                }
                Object var3_1 = null;
                this.setStatus(1);
            }
            catch (Throwable throwable) {
                Object var3_2 = null;
                this.setStatus(1);
                throw throwable;
            }
        }

        private void clearWarnings() {
            try {
                SQLWarning warning = this.getConnection().getWarnings();
                if (warning != null) {
                    log.warn((Object)("Warnings on connection " + this + ": " + warning));
                    this.getConnection().clearWarnings();
                }
            }
            catch (SQLException e) {
                log.warn((Object)("Cannot access Warnings: " + e));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void ping() {
            if (!this.isFree()) return;
            this.setStatus(2);
            Connection c = this.getConnection();
            log.debug((Object)("Pinging connection " + this.connection));
            try {
                try {
                    c.isClosed();
                    c.setReadOnly(false);
                    ResultSet rs = c.createStatement().executeQuery(this.pingStatement);
                    if (rs == null) {
                        // empty if block
                    }
                }
                catch (SQLException e) {
                    log.error((Object)("Could not ping connection " + c + ", reason: " + e.getMessage()), (Throwable)e);
                    Object var4_5 = null;
                    try {
                        c.rollback();
                    }
                    catch (SQLException e1) {
                        throw new NSForwardException((Throwable)e1, "could not rollback connection!");
                    }
                }
                Object var4_4 = null;
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                try {}
                catch (SQLException e1) {
                    throw new NSForwardException((Throwable)e1, "could not rollback connection!");
                }
                c.rollback();
                throw throwable;
            }
            try {}
            catch (SQLException e1) {
                throw new NSForwardException((Throwable)e1, "could not rollback connection!");
            }
            c.rollback();
            this.setStatus(0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        private void reap(long maxCheckoutMillis, long maxConnectionAgeMillis) throws SQLException {
            boolean restart = false;
            Connection reapingConnection = this.getConnection();
            try {
                block22: {
                    long connectionAgeMillis;
                    if (!this.isFree()) {
                        long checkoutMillis = System.currentTimeMillis() - this.getLockTime();
                        log.debug((Object)("Connection is in use for " + checkoutMillis + " ms: " + this));
                        if (maxCheckoutMillis != 0L && checkoutMillis > maxCheckoutMillis) {
                            restart = true;
                            log.info((Object)("Connection " + this + " failed to be returned in time, recycling"));
                        }
                        if (!restart) {
                            return;
                        }
                    }
                    this.setStatus(2);
                    if (!restart && (connectionAgeMillis = System.currentTimeMillis() - this.getCreationDate()) > maxConnectionAgeMillis) {
                        restart = true;
                    }
                    if (!restart) {
                        Statement stmt = null;
                        stmt = reapingConnection.createStatement();
                        Object var10_9 = null;
                        try {
                            if (stmt != null) {
                                stmt.close();
                            }
                            break block22;
                        }
                        catch (SQLException e1) {
                            restart = true;
                        }
                        break block22;
                        {
                            catch (SQLException e) {
                                restart = true;
                                Object var10_10 = null;
                                try {
                                    if (stmt != null) {
                                        stmt.close();
                                    }
                                    break block22;
                                }
                                catch (SQLException e1) {
                                    restart = true;
                                }
                            }
                        }
                        catch (Throwable throwable) {
                            Object var10_11 = null;
                            try {
                                if (stmt != null) {
                                    stmt.close();
                                }
                            }
                            catch (SQLException e1) {
                                restart = true;
                            }
                            throw throwable;
                        }
                    }
                }
                if (!restart && reapingConnection.isClosed()) {
                    restart = true;
                }
            }
            catch (SQLException e) {
                restart = true;
            }
            if (restart) {
                log.debug((Object)("Recycling connection: " + this));
                try {
                    this.getConnection().close();
                }
                catch (SQLException e0) {
                    log.error((Object)"Can't close connection, might have been closed already.  Trying to recycle anyway");
                }
                this.setConnection(this.broker.createConnection());
            }
            this.setStatus(0);
        }
    }
}

