/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.jdbc;

import com.sun.rowset.CachedRowSetImpl;
import com.webobjects.appserver.WOApplication;
import com.webobjects.eoaccess.EOAdaptor;
import com.webobjects.eoaccess.EOAdaptorChannel;
import com.webobjects.eoaccess.EOAdaptorContext;
import com.webobjects.eoaccess.EOAttribute;
import com.webobjects.eoaccess.EODatabaseContext;
import com.webobjects.eoaccess.EOEntity;
import com.webobjects.eoaccess.EOModel;
import com.webobjects.eoaccess.EOModelGroup;
import com.webobjects.eoaccess.EOQualifierSQLGeneration;
import com.webobjects.eoaccess.EOSQLExpression;
import com.webobjects.eoaccess.EOSQLExpressionFactory;
import com.webobjects.eocontrol.EOEditingContext;
import com.webobjects.eocontrol.EOQualifier;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSMutableSet;
import com.webobjects.foundation.NSTimestamp;
import com.webobjects.foundation.NSTimestampFormatter;
import com.webobjects.jdbcadaptor.JDBCAdaptor;
import com.webobjects.jdbcadaptor.JDBCContext;
import er.extensions.eof.ERXEC;
import er.extensions.foundation.ERXExceptionUtilities;
import er.extensions.foundation.ERXFileUtilities;
import er.extensions.foundation.ERXStringUtilities;
import er.extensions.jdbc.ERXSQLHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import javax.sql.rowset.CachedRowSet;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ERXJDBCUtilities {
    public static final Logger log = Logger.getLogger(ERXJDBCUtilities.class);
    public static final NSTimestampFormatter TIMESTAMP_FORMATTER = new NSTimestampFormatter("%Y-%m-%d %H:%M:%S.%F");

    public static String jdbcTimestamp(NSTimestamp t) {
        StringBuffer b = new StringBuffer();
        b.append("TIMESTAMP '").append(TIMESTAMP_FORMATTER.format((Object)t)).append("'");
        return b.toString();
    }

    public static void _copyDatabaseDefinedByEOModelAndConnectionDictionaryToDatabaseWithConnectionDictionary(EOModel m, NSDictionary sourceDict, NSDictionary destDict) {
        try {
            CopyTask task = new CopyTask(m);
            task.connect(sourceDict, destDict);
            task.run(false);
            log.info((Object)"committing...");
            task.commit();
            log.info((Object)"committing... done");
        }
        catch (SQLException e) {
            log.error((Object)"could not commit destCon", (Throwable)e);
        }
    }

    public static void _copyDatabaseDefinedByEOModelAndConnectionDictionaryToDatabaseWithConnectionDictionary(EOModelGroup modelGroup, NSDictionary sourceDict, NSDictionary destDict) {
        try {
            CopyTask task = new CopyTask(modelGroup);
            task.connect(sourceDict, destDict);
            task.run(false);
            log.info((Object)"committing...");
            task.commit();
            log.info((Object)"committing... done");
        }
        catch (SQLException e) {
            log.error((Object)"could not commit destCon", (Throwable)e);
        }
    }

    public static EOAdaptorChannel adaptorChannelWithUserAndPassword(EOModel model, String userName, String password) {
        String adaptorName = model.adaptorName();
        NSDictionary connectionDictionary = model.connectionDictionary();
        return ERXJDBCUtilities.adaptorChannelWithUserAndPassword(adaptorName, connectionDictionary, userName, password);
    }

    public static EOAdaptorChannel adaptorChannelWithUserAndPassword(String adaptorName, NSDictionary originalConnectionDictionary, String userName, String password) {
        EOAdaptor adaptor = EOAdaptor.adaptorWithName((String)adaptorName);
        NSMutableDictionary<String, String> newConnectionDictionary = originalConnectionDictionary.mutableClone();
        if (userName == null) {
            newConnectionDictionary.removeObjectForKey("username");
        } else {
            newConnectionDictionary.setObjectForKey(userName, "username");
        }
        if (password == null) {
            newConnectionDictionary.removeObjectForKey("password");
        } else {
            newConnectionDictionary.setObjectForKey(password, "password");
        }
        adaptor.setConnectionDictionary(newConnectionDictionary);
        return adaptor.createAdaptorContext().createAdaptorChannel();
    }

    public static int executeUpdate(EOAdaptorChannel channel, String sql) throws SQLException {
        return ERXJDBCUtilities.executeUpdate(channel, sql, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int executeUpdate(EOAdaptorChannel channel, String sql, boolean autoCommit) throws SQLException {
        int rowsUpdated;
        boolean wasOpen = channel.isOpen();
        if (!wasOpen) {
            channel.openChannel();
        }
        Connection conn = ((JDBCContext)channel.adaptorContext()).connection();
        try {
            Statement stmt = conn.createStatement();
            try {
                block7: {
                    try {
                        rowsUpdated = stmt.executeUpdate(sql);
                        if (!autoCommit) break block7;
                        conn.commit();
                    }
                    catch (SQLException ex) {
                        if (!autoCommit) throw new RuntimeException("Failed to execute the statement '" + sql + "'.", ex);
                        conn.rollback();
                        throw new RuntimeException("Failed to execute the statement '" + sql + "'.", ex);
                    }
                }
                Object var9_7 = null;
            }
            catch (Throwable throwable) {
                Object var9_8 = null;
                stmt.close();
                throw throwable;
            }
            stmt.close();
            Object var11_11 = null;
            if (wasOpen) return rowsUpdated;
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            if (wasOpen) throw throwable;
            channel.closeChannel();
            throw throwable;
        }
        channel.closeChannel();
        return rowsUpdated;
    }

    public static int executeUpdateScript(EOAdaptorChannel channel, String sqlScript) throws SQLException {
        return ERXJDBCUtilities.executeUpdateScript(channel, sqlScript, false);
    }

    public static int executeUpdateScript(EOAdaptorChannel channel, String sqlScript, boolean ignoreFailures) throws SQLException {
        NSArray<String> sqlStatements = ERXSQLHelper.newSQLHelper(channel).splitSQLStatements(sqlScript);
        return ERXJDBCUtilities.executeUpdateScript(channel, sqlStatements, ignoreFailures);
    }

    public static int executeUpdateScript(EOAdaptorChannel channel, NSArray<String> sqlStatements) throws SQLException {
        return ERXJDBCUtilities.executeUpdateScript(channel, sqlStatements, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int executeUpdateScript(EOAdaptorChannel channel, NSArray<String> sqlStatements, boolean ignoreFailures) throws SQLException {
        EOAdaptorContext adaptorContext = channel.adaptorContext();
        if (!(adaptorContext instanceof JDBCContext)) {
            return 0;
        }
        ERXSQLHelper sqlHelper = ERXSQLHelper.newSQLHelper(channel);
        int rowsUpdated = 0;
        boolean wasOpen = channel.isOpen();
        if (!wasOpen) {
            channel.openChannel();
        }
        Connection conn = ((JDBCContext)adaptorContext).connection();
        try {
            Statement stmt = conn.createStatement();
            try {
                Enumeration<String> sqlStatementsEnum = sqlStatements.objectEnumerator();
                while (sqlStatementsEnum.hasMoreElements()) {
                    String sql = sqlStatementsEnum.nextElement();
                    if (sqlHelper.shouldExecute(sql)) {
                        if (log.isInfoEnabled()) {
                            log.info((Object)("Executing " + sql));
                        }
                        try {
                            rowsUpdated += stmt.executeUpdate(sql);
                        }
                        catch (Throwable t) {
                            if (!ignoreFailures) {
                                throw new RuntimeException("Failed to execute '" + sql + "'.", t);
                            }
                            log.warn((Object)("Failed to execute '" + sql + "', but ignoring: " + ERXExceptionUtilities.toParagraph(t)));
                        }
                        continue;
                    }
                    if (!log.isInfoEnabled()) continue;
                    log.info((Object)("Skipping " + sql));
                }
                Object var13_12 = null;
            }
            catch (Throwable throwable) {
                Object var13_13 = null;
                stmt.close();
                throw throwable;
            }
            stmt.close();
            Object var15_15 = null;
            if (wasOpen) return rowsUpdated;
        }
        catch (Throwable throwable) {
            Object var15_16 = null;
            if (wasOpen) throw throwable;
            if (!conn.getAutoCommit()) {
                conn.commit();
            }
            channel.closeChannel();
            throw throwable;
        }
        if (!conn.getAutoCommit()) {
            conn.commit();
        }
        channel.closeChannel();
        return rowsUpdated;
    }

    public static int executeUpdateScriptIgnoringErrors(EOAdaptorChannel channel, String script) throws SQLException {
        return ERXJDBCUtilities.executeUpdateScript(channel, script, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int executeUpdateScriptFromResourceNamed(EOAdaptorChannel channel, String resourceName, String frameworkName) throws SQLException, IOException {
        NSArray<String> sqlStatements;
        log.info((Object)("Executing SQL script '" + resourceName + "' from " + frameworkName + " ..."));
        InputStream sqlScript = WOApplication.application().resourceManager().inputStreamForResourceNamed(resourceName, frameworkName, NSArray.EmptyArray);
        if (sqlScript == null) {
            throw new IllegalArgumentException("There is no resource named '" + resourceName + "'.");
        }
        try {
            sqlStatements = ERXSQLHelper.newSQLHelper(channel).splitSQLStatementsFromInputStream(sqlScript);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            sqlScript.close();
            throw throwable;
        }
        sqlScript.close();
        return ERXJDBCUtilities.executeUpdateScript(channel, sqlStatements);
    }

    public static void dropTablesForModel(EOAdaptorChannel channel, EOModel model, boolean ignoreFailures) throws SQLException {
        ERXJDBCUtilities.dropTablesForEntities(channel, model.entities(), ignoreFailures);
    }

    public static void dropTablesForEntities(EOAdaptorChannel channel, NSArray<EOEntity> entities, boolean ignoreFailures) throws SQLException {
        ERXSQLHelper sqlHelper = ERXSQLHelper.newSQLHelper(channel);
        String sqlScript = sqlHelper.createSchemaSQLForEntitiesWithOptions(entities, channel.adaptorContext().adaptor(), sqlHelper.defaultOptionDictionary(false, true));
        ERXJDBCUtilities.executeUpdateScript(channel, sqlScript, ignoreFailures);
    }

    public static void createTablesForModel(EOAdaptorChannel channel, EOModel model) throws SQLException {
        ERXJDBCUtilities.createTablesForEntities(channel, model.entities());
    }

    public static void createTablesForEntities(EOAdaptorChannel channel, NSArray<EOEntity> entities) throws SQLException {
        ERXSQLHelper sqlHelper = ERXSQLHelper.newSQLHelper(channel);
        String sqlScript = sqlHelper.createSchemaSQLForEntitiesWithOptions(entities, channel.adaptorContext().adaptor(), sqlHelper.defaultOptionDictionary(true, false));
        ERXJDBCUtilities.executeUpdateScript(channel, sqlScript);
    }

    public static String databaseProductName(EOAdaptorChannel channel) {
        return ((JDBCAdaptor)channel.adaptorContext().adaptor()).plugIn().databaseProductName();
    }

    public static String databaseProductName(EOModel model) {
        EODatabaseContext databaseContext = EODatabaseContext.registeredDatabaseContextForModel((EOModel)model, (EOEditingContext)ERXEC.newEditingContext());
        EOAdaptor adaptor = databaseContext.database().adaptor();
        String databaseProductName = adaptor instanceof JDBCAdaptor ? ((JDBCAdaptor)adaptor).plugIn().databaseProductName() : adaptor.name();
        return databaseProductName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void processConnection(EOAdaptorChannel adaptorChannel, IConnectionDelegate delegate) throws Exception {
        boolean wasOpen = adaptorChannel.isOpen();
        if (!wasOpen) {
            adaptorChannel.openChannel();
        }
        try {
            Connection conn = ((JDBCContext)adaptorChannel.adaptorContext()).connection();
            delegate.processConnection(adaptorChannel, conn);
            Object var5_4 = null;
            if (wasOpen) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (wasOpen) throw throwable;
            adaptorChannel.closeChannel();
            throw throwable;
        }
        adaptorChannel.closeChannel();
    }

    public static void executeQuery(EOAdaptorChannel adaptorChannel, final String query, final IResultSetDelegate delegate) throws Exception {
        ERXJDBCUtilities.processConnection(adaptorChannel, new IConnectionDelegate(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void processConnection(EOAdaptorChannel innerAdaptorChannel, Connection conn) throws Exception {
                Statement stmt = conn.createStatement();
                try {
                    ResultSet rs = stmt.executeQuery(query);
                    try {
                        delegate.processResultSet(innerAdaptorChannel, rs);
                        Object var6_5 = null;
                    }
                    catch (Throwable throwable) {
                        Object var6_6 = null;
                        rs.close();
                        throw throwable;
                    }
                    rs.close();
                    Object var8_8 = null;
                }
                catch (Throwable throwable) {
                    Object var8_9 = null;
                    stmt.close();
                    throw throwable;
                }
                stmt.close();
            }
        });
    }

    public static void processResultSetRows(EOAdaptorChannel adaptorChannel, String query, final IResultSetDelegate delegate) throws Exception {
        ERXJDBCUtilities.executeQuery(adaptorChannel, query, new IResultSetDelegate(){

            public void processResultSet(EOAdaptorChannel innerAdaptorChannel, ResultSet rs) throws Exception {
                while (rs.next()) {
                    delegate.processResultSet(innerAdaptorChannel, rs);
                }
            }
        });
    }

    public static CachedRowSet fetchRowSet(EOAdaptorChannel adaptorChannel, String query) throws Exception {
        final CachedRowSetImpl rowSet = new CachedRowSetImpl();
        ERXJDBCUtilities.executeQuery(adaptorChannel, query, new IResultSetDelegate(){

            public void processResultSet(EOAdaptorChannel innerAdaptorChannel, ResultSet rs) throws Exception {
                rowSet.populate(rs);
            }
        });
        return rowSet;
    }

    public static interface IResultSetDelegate {
        public void processResultSet(EOAdaptorChannel var1, ResultSet var2) throws Exception;
    }

    public static interface IConnectionDelegate {
        public void processConnection(EOAdaptorChannel var1, Connection var2) throws Exception;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CopyTask {
        protected NSDictionary _sourceDictionary;
        protected NSDictionary _destDictionary;
        protected Connection _source;
        protected Connection _dest;
        protected boolean _quoteSource;
        protected boolean _quoteDestination;
        protected NSMutableArray<EOEntity> _entities = new NSMutableArray();

        public CopyTask(EOModelGroup aModelGroup) {
            this.addEntitiesFromModelGroup(aModelGroup);
        }

        public CopyTask(EOModel aModel) {
            this.addEntitiesFromModel(aModel);
        }

        public CopyTask(EOEntity anEntity) {
            this.addEntity(anEntity);
        }

        public CopyTask() {
        }

        public void connect(NSDictionary aSourceConnectionDict, NSDictionary aDestConnectionDict) throws SQLException {
            this._sourceDictionary = aSourceConnectionDict;
            this._destDictionary = aDestConnectionDict;
            this._source = this.connectionWithDictionary(aSourceConnectionDict);
            this._dest = this.connectionWithDictionary(aDestConnectionDict);
            this._quoteSource = Boolean.valueOf((String)aSourceConnectionDict.objectForKey("quote"));
            this._quoteDestination = Boolean.valueOf((String)aDestConnectionDict.objectForKey("quote"));
        }

        public void connect(String sourcePrefix, String destPrefix) throws SQLException {
            this._sourceDictionary = this.dictionaryFromPrefix(sourcePrefix);
            this._destDictionary = this.dictionaryFromPrefix(destPrefix);
            this.connect(this._sourceDictionary, this._destDictionary);
        }

        private NSDictionary dictionaryFromPrefix(String prefix) {
            NSMutableDictionary dict = new NSMutableDictionary();
            return dict;
        }

        protected void addEntitiesFromModelGroup(EOModelGroup group) {
            Enumeration enumeration = group.models().objectEnumerator();
            while (enumeration.hasMoreElements()) {
                EOModel model = (EOModel)enumeration.nextElement();
                if (!"JDBC".equalsIgnoreCase(model.adaptorName())) continue;
                this.addEntitiesFromModel(model);
            }
        }

        protected void addEntitiesFromModel(EOModel model) {
            Enumeration enumeration = model.entities().objectEnumerator();
            while (enumeration.hasMoreElements()) {
                EOEntity entity = (EOEntity)enumeration.nextElement();
                this._entities.addObject(entity);
            }
        }

        public void addEntity(EOEntity entity) {
            this._entities.addObject(entity);
        }

        public void run() throws SQLException {
            this.run(true);
        }

        public void run(boolean commitAtEnd) throws SQLException {
            Enumeration models = this._entities.objectEnumerator();
            while (models.hasMoreElements()) {
                EOEntity entity = (EOEntity)models.nextElement();
                if (entity.isAbstractEntity()) continue;
                this.copyEntity(entity);
            }
            if (commitAtEnd) {
                this.commit();
            }
        }

        public void commit() throws SQLException {
            this._dest.commit();
        }

        protected Connection connectionWithDictionary(NSDictionary dict) throws SQLException {
            Object autoCommitObj;
            String username = (String)dict.objectForKey("username");
            String password = (String)dict.objectForKey("password");
            String driver = (String)dict.objectForKey("driver");
            String url = (String)dict.objectForKey("URL");
            if (url == null) {
                url = (String)dict.objectForKey("url");
            }
            Boolean autoCommit = (autoCommitObj = dict.objectForKey("autoCommit")) instanceof String ? Boolean.valueOf((String)autoCommitObj) : (Boolean)autoCommitObj;
            boolean ac = autoCommit == null ? true : autoCommit;
            try {
                Class.forName(driver);
            }
            catch (ClassNotFoundException e) {
                throw new SQLException("Could not find driver: " + driver);
            }
            Connection con = DriverManager.getConnection(url, username, password);
            DatabaseMetaData dbmd = con.getMetaData();
            log.info((Object)("Connection to " + dbmd.getDatabaseProductName() + " " + dbmd.getDatabaseProductVersion() + " successful."));
            con.setAutoCommit(ac);
            return con;
        }

        protected String[] columnsFromAttributes(EOAttribute[] attributes, boolean quoteNames) {
            NSArray<String> a = this.columnsFromAttributesAsArray(attributes, quoteNames);
            String[] result = new String[a.count()];
            for (int i = 0; i < a.count(); ++i) {
                String s;
                result[i] = s = a.objectAtIndex(i);
            }
            return result;
        }

        protected NSArray<String> columnsFromAttributesAsArray(EOAttribute[] attributes, boolean quoteNames) {
            if (attributes == null) {
                throw new NullPointerException("attributes cannot be null!");
            }
            NSMutableArray<String> columns = new NSMutableArray<String>();
            int i = attributes.length;
            while (i-- > 0) {
                EOAttribute att = attributes[i];
                String column = att.columnName();
                if (!ERXStringUtilities.stringIsNullOrEmpty(column)) {
                    if (quoteNames) {
                        columns.addObject("\"" + column + "\"");
                        continue;
                    }
                    columns.addObject(column);
                    continue;
                }
                log.warn((Object)("Attribute " + att.name() + " column was null or empty"));
            }
            return columns;
        }

        protected EOAttribute[] attributesArray(NSArray<EOAttribute> array) {
            NSMutableArray<EOAttribute> attributes = new NSMutableArray<EOAttribute>();
            for (int i = 0; i < array.count(); ++i) {
                EOAttribute att = array.objectAtIndex(i);
                if (ERXStringUtilities.stringIsNullOrEmpty(att.columnName())) continue;
                attributes.addObject(att);
            }
            EOAttribute[] result = new EOAttribute[attributes.count()];
            for (int i = 0; i < attributes.count(); ++i) {
                result[i] = (EOAttribute)attributes.objectAtIndex(i);
            }
            return result;
        }

        protected void copyEntity(EOEntity entity) throws SQLException {
            EOAttribute[] attributes = this.attributesArray(entity.attributes());
            String tableName = entity.externalName();
            String[] columnNames = this.columnsFromAttributes(attributes, true);
            String[] columnNamesWithoutQuotes = this.columnsFromAttributes(attributes, false);
            StringBuffer selectBuf = new StringBuffer();
            selectBuf.append("select ");
            selectBuf.append(this.columnsFromAttributesAsArray(attributes, this._quoteSource).componentsJoinedByString(", ")).append(" from ");
            if (this._quoteSource) {
                selectBuf.append("\"" + tableName + "\"");
            } else {
                selectBuf.append(tableName);
            }
            EOQualifier qualifier = entity.restrictingQualifier();
            if (qualifier != null) {
                EOAdaptor adaptor = EOAdaptor.adaptorWithName((String)"JDBC");
                adaptor.setConnectionDictionary(this._sourceDictionary);
                EOSQLExpressionFactory factory = adaptor.expressionFactory();
                EOSQLExpression sqlExpression = factory.createExpression(entity);
                String sqlString = EOQualifierSQLGeneration.Support._sqlStringForSQLExpression((EOQualifier)qualifier, (EOSQLExpression)sqlExpression);
                selectBuf.append(" where ").append(sqlString);
            }
            selectBuf.append(";");
            String sql = selectBuf.toString();
            Statement stmt = this._source.createStatement();
            StringBuffer insertBuf = new StringBuffer();
            insertBuf.append("insert into ");
            if (this._quoteDestination) {
                insertBuf.append("\"" + tableName + "\"");
            } else {
                insertBuf.append(tableName);
            }
            insertBuf.append(" (").append(this.columnsFromAttributesAsArray(attributes, this._quoteDestination).componentsJoinedByString(", ")).append(") values (");
            int i = columnNames.length;
            while (i-- > 0) {
                insertBuf.append("?");
                if (i <= 0) continue;
                insertBuf.append(", ");
            }
            insertBuf.append(");");
            String insertSql = insertBuf.toString();
            System.out.println("CopyTask.copyEntity: " + insertSql);
            PreparedStatement upps = this._dest.prepareStatement(insertSql);
            ResultSet rows = stmt.executeQuery(sql);
            int rowsCount = 0;
            while (rows.next()) {
                ++rowsCount;
                if (rows.getRow() % 1000 == 0) {
                    System.out.println("CopyTask.copyEntity: table " + tableName + ", inserted " + rows.getRow() + " rows");
                    log.info((Object)("table " + tableName + ", inserted " + rows.getRow() + " rows"));
                }
                NSMutableSet<File> tempfilesToDelete = new NSMutableSet<File>();
                for (int i2 = 0; i2 < columnNamesWithoutQuotes.length; ++i2) {
                    String columnName = columnNamesWithoutQuotes[i2];
                    int type = rows.getMetaData().getColumnType(i2 + 1);
                    Object o = rows.getObject(columnName);
                    if (log.isDebugEnabled()) {
                        if (o != null) {
                            log.info((Object)("column=" + columnName + ", value class=" + o.getClass().getName() + ", value=" + o));
                        } else {
                            log.info((Object)("column=" + columnName + ", value class unknown, value is null"));
                        }
                    }
                    if (o instanceof Blob) {
                        FileInputStream fis;
                        Blob b = (Blob)o;
                        InputStream bis = b.getBinaryStream();
                        File tempFile = null;
                        try {
                            tempFile = File.createTempFile("TempJDBC", ".blob");
                            ERXFileUtilities.writeInputStreamToFile(bis, tempFile);
                        }
                        catch (IOException e5) {
                            log.error((Object)("could not create tempFile for row " + rows.getRow() + " and column " + columnName + ", setting column value to null!"));
                            upps.setNull(i2 + 1, type);
                            if (tempFile == null || tempFile.delete()) continue;
                            tempFile.delete();
                            continue;
                        }
                        try {
                            fis = new FileInputStream(tempFile);
                        }
                        catch (FileNotFoundException e6) {
                            log.error((Object)("could not create FileInputStream from tempFile for row " + rows.getRow() + " and column " + columnName + ", setting column value to null!"));
                            upps.setNull(i2 + 1, type);
                            if (tempFile == null || tempFile.delete()) continue;
                            tempFile.delete();
                            continue;
                        }
                        upps.setBinaryStream(i2 + 1, (InputStream)fis, (int)tempFile.length());
                        tempfilesToDelete.addObject(tempFile);
                        continue;
                    }
                    if (o != null) {
                        upps.setObject(i2 + 1, o);
                        continue;
                    }
                    upps.setNull(i2 + 1, type);
                }
                upps.executeUpdate();
                upps.clearParameters();
                Enumeration e = tempfilesToDelete.objectEnumerator();
                while (e.hasMoreElements()) {
                    File f = (File)e.nextElement();
                    if (f.delete()) continue;
                    f.delete();
                }
            }
            log.info((Object)("table " + tableName + ", inserted " + rowsCount + " rows"));
            rows.close();
        }
    }
}

