/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.logging;

import com.webobjects.foundation.NSLog;
import er.extensions.foundation.ERXProperties;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class ERXNSLogLog4jBridge
extends NSLog.PrintStreamLogger {
    public static final Logger log = Logger.getLogger((String)"NSLog");
    public static final int OUT = 1;
    public static final int ERR = 2;
    public static final int DEBUG = 3;
    private final int type;

    public ERXNSLogLog4jBridge(int type) {
        this.type = type;
    }

    public void appendln(Object obj) {
        if (this.isEnabled()) {
            if (obj == null) {
                obj = "";
            }
            switch (this.type) {
                case 1: {
                    log.info((Object)obj.toString());
                    break;
                }
                case 2: {
                    log.warn((Object)obj.toString());
                    break;
                }
                case 3: {
                    log.debug((Object)obj.toString());
                }
            }
        } else if (this.type == 2) {
            log.warn((Object)(obj != null ? obj.toString() : ""));
        }
    }

    public void setIsEnabled(boolean enabled) {
        super.setIsEnabled(enabled);
        if (this.type == 3 && !ERXProperties.booleanForKeyWithDefault("er.extensions.ERXNSLogLog4jBridge.ignoreNSLogSettings", false)) {
            log.setLevel(enabled ? Level.DEBUG : Level.INFO);
        }
    }

    public void setAllowedDebugLevel(int debugLevel) {
        super.setAllowedDebugLevel(debugLevel);
        if (this.type == 3 && !ERXProperties.booleanForKeyWithDefault("er.extensions.ERXNSLogLog4jBridge.ignoreNSLogSettings", false)) {
            log.setLevel(debugLevel != 0 ? Level.DEBUG : Level.INFO);
        }
    }

    public void appendln() {
        this.appendln("");
    }

    public void flush() {
    }
}

