/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.logging;

import com.webobjects.foundation.NSLog;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;

public class ERXNSPrintWriterLogger
extends NSLog.Logger {
    private PrintWriter _printWriter;
    private NSLog.PrintStreamLogger _vervoseStreamLogger;
    private ByteArrayOutputStream _verboseHeaderStream;
    private static final String _lineEndingString = " " + System.getProperty("line.separator");

    public ERXNSPrintWriterLogger() {
        this._printWriter = new PrintWriter(System.out);
    }

    public ERXNSPrintWriterLogger(PrintWriter printWriter) {
        this._printWriter = printWriter;
    }

    public ERXNSPrintWriterLogger(PrintStream printStream) {
        this._printWriter = new PrintWriter(printStream);
    }

    public ERXNSPrintWriterLogger(String encodingName) throws UnsupportedEncodingException {
        this._printWriter = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)System.out, encodingName), true);
    }

    public void appendln() {
        if (this.isEnabled()) {
            this._printWriter.println();
        }
    }

    public void appendln(Object object) {
        if (this.isEnabled()) {
            if (this.isVerbose()) {
                this._printWriter.print(this._verboseHeader());
            }
            this._printWriter.println(object);
        }
    }

    public void flush() {
        this._printWriter.flush();
    }

    private String _verboseHeader() {
        this._verboseHeaderStream().reset();
        this._vervoseStreamLogger().appendln((Object)" ");
        String verboseHeader = this._verboseHeaderStream().toString();
        int lastIndex = verboseHeader.lastIndexOf(_lineEndingString);
        if (lastIndex > 0) {
            verboseHeader = verboseHeader.substring(0, lastIndex);
        }
        return verboseHeader;
    }

    private ByteArrayOutputStream _verboseHeaderStream() {
        if (this._verboseHeaderStream == null) {
            this._verboseHeaderStream = new ByteArrayOutputStream("[2002-08-31 09:01:00 EDT] <main> ".length() + 20);
        }
        return this._verboseHeaderStream;
    }

    private NSLog.PrintStreamLogger _vervoseStreamLogger() {
        if (this._vervoseStreamLogger == null) {
            this._vervoseStreamLogger = new NSLog.PrintStreamLogger(new PrintStream(this._verboseHeaderStream()));
        }
        return this._vervoseStreamLogger;
    }
}

