/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.migration;

import com.webobjects.eoaccess.EOAdaptor;
import com.webobjects.eoaccess.EOAttribute;
import com.webobjects.eoaccess.EOEntity;
import com.webobjects.eoaccess.EOSQLExpression;
import com.webobjects.eoaccess.EOSchemaSynchronization;
import com.webobjects.eoaccess.EOSynchronizationFactory;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.jdbcadaptor.JDBCAdaptor;
import er.extensions.jdbc.ERXJDBCUtilities;
import er.extensions.jdbc.ERXSQLHelper;
import er.extensions.migration.ERXMigrationDatabase;
import er.extensions.migration.ERXMigrationTable;
import java.sql.SQLException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ERXMigrationColumn {
    public static final String NULL_VALUE_TYPE = "___NULL_VALUE_TYPE___";
    public static final boolean AllowsNull = true;
    public static final boolean NotNull = false;
    private ERXMigrationTable _table;
    private String _name;
    private int _jdbcType;
    private int _width;
    private int _precision;
    private int _scale;
    private boolean _allowsNull;
    private Object _defaultValue;
    private boolean _new;
    private String _overrideValueType;
    private String _overrideExternalType;
    private boolean _primaryKey;
    private ERXMigrationColumn _foreignKeyDestination;

    protected ERXMigrationColumn(ERXMigrationTable table, String name, int jdbcType, int width, int precision, int scale, boolean allowsNull, String overrideValueType, Object defaultValue) {
        this._table = table;
        this._name = name;
        this._jdbcType = jdbcType;
        this._width = width;
        this._precision = precision;
        this._scale = scale;
        this._allowsNull = allowsNull;
        this._overrideValueType = overrideValueType;
        this._defaultValue = defaultValue;
        this._new = true;
    }

    public ERXMigrationTable table() {
        return this._table;
    }

    public void _setName(String name) {
        this._name = name;
    }

    public String name() {
        return this._name;
    }

    public void _setWidth(int width) {
        this._width = width;
    }

    public int width() {
        return this._width;
    }

    public void _setAllowsNull(boolean allowsNull) {
        this._allowsNull = allowsNull;
    }

    public boolean allowsNull() {
        return this._allowsNull;
    }

    public void _setPrecision(int precision) {
        this._precision = precision;
    }

    public int precision() {
        return this._precision;
    }

    public void _setScale(int scale) {
        this._scale = scale;
    }

    public int scale() {
        return this._scale;
    }

    public void _setOverrideExternalType(String overrideExternalType) {
        this._overrideExternalType = overrideExternalType;
    }

    public String overrideExternalType() {
        return this._overrideExternalType;
    }

    public void _setOverrideValueType(String overrideValueType) {
        this._overrideValueType = overrideValueType;
    }

    public String overrideValueType() {
        return this._overrideValueType;
    }

    public void setDefaultValue(Object defaultValue) {
        this._defaultValue = defaultValue;
    }

    public Object defaultValue() {
        return this._defaultValue;
    }

    public void _setPrimaryKey(boolean primaryKey) {
        this._primaryKey = primaryKey;
    }

    public boolean isPrimaryKey() {
        return this._primaryKey;
    }

    public void _setForeignKeyDestination(ERXMigrationColumn foreignKeyDestination) {
        this._foreignKeyDestination = foreignKeyDestination;
    }

    public ERXMigrationColumn foreignKeyDestination() {
        return this._foreignKeyDestination;
    }

    public boolean isNew() {
        return this._new;
    }

    public void _setNew(boolean isNew) {
        this._new = isNew;
    }

    public EOAttribute _newAttribute() {
        return this._newAttribute(this._table._blankEntity());
    }

    public EOAttribute _newAttribute(EOEntity entity) {
        EOAdaptor eoAdaptor = this._table.database().adaptor();
        if (!(eoAdaptor instanceof JDBCAdaptor)) {
            EOAttribute nonJdbcAttribute = new EOAttribute();
            nonJdbcAttribute.setName(this._name);
            nonJdbcAttribute.setColumnName(this._name);
            nonJdbcAttribute.setExternalType("nonJdbcAttribute");
            entity.addAttribute(nonJdbcAttribute);
            return nonJdbcAttribute;
        }
        JDBCAdaptor adaptor = (JDBCAdaptor)this._table.database().adaptor();
        ERXSQLHelper sqlHelper = ERXSQLHelper.newSQLHelper(adaptor);
        String externalType = sqlHelper.externalTypeForJDBCType(adaptor, this._jdbcType);
        if (externalType == null) {
            externalType = "IF_YOU_ARE_SEEING_THIS_SOMETHING_WENT_WRONG_WITH_EXTERNAL_TYPES";
        }
        EOAttribute attribute = adaptor.createAttribute(this._name, this._name, this._jdbcType, externalType, this._precision, this._scale, this._allowsNull ? 1 : 0);
        if (this._width > 0) {
            attribute.setWidth(this._width);
        }
        if (this._defaultValue != null) {
            NSDictionary userInfo = attribute.userInfo();
            NSMutableDictionary<String, Object> mutableUserInfo = userInfo == null ? new NSMutableDictionary() : userInfo.mutableClone();
            mutableUserInfo.setObjectForKey(this._defaultValue, "er.extensions.eoattribute.default");
            attribute.setUserInfo(mutableUserInfo);
        }
        if (this._overrideValueType != null) {
            if (NULL_VALUE_TYPE.equals(this._overrideValueType)) {
                attribute.setValueType(null);
            } else {
                attribute.setValueType(this._overrideValueType);
            }
            if (sqlHelper.reassignExternalTypeForValueTypeOverride(attribute)) {
                adaptor.assignExternalTypeForAttribute(attribute);
            }
        }
        if (this._overrideExternalType != null) {
            attribute.setExternalType(this._overrideExternalType);
        }
        entity.addAttribute(attribute);
        return attribute;
    }

    public NSArray<EOSQLExpression> _createExpressions() {
        EOSynchronizationFactory schemaSynchronization = this._table.database().synchronizationFactory();
        NSArray expressions = schemaSynchronization.statementsToInsertColumnForAttribute(this._newAttribute(), NSDictionary.EmptyDictionary);
        ERXMigrationDatabase._ensureNotEmpty(expressions, "add column", true);
        return expressions;
    }

    public void create() throws SQLException {
        if (this._new) {
            ERXJDBCUtilities.executeUpdateScript(this._table.database().adaptorChannel(), ERXMigrationDatabase._stringsForExpressions(this._createExpressions()));
            this._new = false;
        } else {
            ERXMigrationDatabase.log.warn((Object)("You called .create() on the column '" + this._name + "', but it was already created."));
        }
    }

    public NSArray<EOSQLExpression> _deleteExpressions() {
        EOSynchronizationFactory schemaSynchronization = this._table.database().synchronizationFactory();
        NSArray expressions = schemaSynchronization.statementsToDeleteColumnNamed(this.name(), this._table.name(), NSDictionary.EmptyDictionary);
        ERXMigrationDatabase._ensureNotEmpty(expressions, "delete column", true);
        return expressions;
    }

    public void delete() throws SQLException {
        ERXJDBCUtilities.executeUpdateScript(this._table.database().adaptorChannel(), ERXMigrationDatabase._stringsForExpressions(this._deleteExpressions()));
        this._table._columnDeleted(this);
    }

    public NSArray<EOSQLExpression> _renameToExpressions(String newName) {
        EOSynchronizationFactory schemaSynchronization = this._table.database().synchronizationFactory();
        NSArray expressions = schemaSynchronization.statementsToRenameColumnNamed(this.name(), this._table.name(), newName, NSDictionary.EmptyDictionary);
        ERXMigrationDatabase._ensureNotEmpty(expressions, "rename column", true);
        this._setName(newName);
        return expressions;
    }

    public void renameTo(String newName) throws SQLException {
        ERXJDBCUtilities.executeUpdateScript(this._table.database().adaptorChannel(), ERXMigrationDatabase._stringsForExpressions(this._renameToExpressions(newName)));
    }

    public void setAllowsNull(boolean allowsNull) throws SQLException {
        EOSynchronizationFactory schemaSynchronization = this._table.database().synchronizationFactory();
        NSArray expressions = schemaSynchronization.statementsToModifyColumnNullRule(this.name(), this._table.name(), allowsNull, NSDictionary.EmptyDictionary);
        ERXMigrationDatabase._ensureNotEmpty(expressions, "modify allows null", true);
        ERXJDBCUtilities.executeUpdateScript(this._table.database().adaptorChannel(), ERXMigrationDatabase._stringsForExpressions(expressions));
    }

    public void setDataType(int jdbcType, int scale, int precision, int width, NSDictionary options) throws SQLException {
        JDBCAdaptor adaptor = (JDBCAdaptor)this._table.database().adaptor();
        String externalType = ERXSQLHelper.newSQLHelper(adaptor).externalTypeForJDBCType(adaptor, jdbcType);
        EOSynchronizationFactory schemaSynchronization = this._table.database().synchronizationFactory();
        NSArray expressions = schemaSynchronization.statementsToConvertColumnType(this._name, this._table.name(), null, (EOSchemaSynchronization.ColumnTypes)new _ColumnType(externalType, scale, precision, width), options);
        ERXMigrationDatabase._ensureNotEmpty(expressions, "convert column type", true);
        ERXJDBCUtilities.executeUpdateScript(this._table.database().adaptorChannel(), ERXMigrationDatabase._stringsForExpressions(expressions));
        this._jdbcType = jdbcType;
        this._scale = scale;
        this._precision = precision;
        this._width = width;
    }

    public void setWidthType(int jdbcType, int width, NSDictionary options) throws SQLException {
        this.setDataType(jdbcType, 0, 0, width, options);
    }

    public void setNumericType(int jdbcType, int scale, int precision, NSDictionary options) throws SQLException {
        this.setDataType(jdbcType, scale, precision, 0, options);
    }

    public static class _ColumnType
    implements EOSchemaSynchronization.ColumnTypes {
        private String _name;
        private int _scale;
        private int _precision;
        private int _width;

        public _ColumnType(String name, int scale, int precision, int width) {
            this._name = name;
            this._scale = scale;
            this._precision = precision;
            this._width = width;
        }

        public String name() {
            return this._name;
        }

        public int precision() {
            return this._precision;
        }

        public int scale() {
            return this._scale;
        }

        public int width() {
            return this._width;
        }
    }
}

