/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.migration;

import com.webobjects.eoaccess.EOAttribute;
import com.webobjects.eoaccess.EOEntity;
import com.webobjects.eoaccess.EOJoin;
import com.webobjects.eoaccess.EOModel;
import com.webobjects.eoaccess.EORelationship;
import com.webobjects.eoaccess.EOSQLExpression;
import com.webobjects.eoaccess.EOSynchronizationFactory;
import com.webobjects.eocontrol.EOKeyValueQualifier;
import com.webobjects.eocontrol.EOQualifier;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSData;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSTimestamp;
import er.extensions.jdbc.ERXJDBCUtilities;
import er.extensions.jdbc.ERXSQLHelper;
import er.extensions.migration.ERXMigrationColumn;
import er.extensions.migration.ERXMigrationDatabase;
import er.extensions.migration.ERXMigrationIndex;
import java.math.BigDecimal;
import java.sql.SQLException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ERXMigrationTable {
    private ERXMigrationDatabase _database;
    private NSMutableArray<ERXMigrationColumn> _columns;
    private NSMutableArray<ERXMigrationIndex> _indexes;
    private String _name;
    private boolean _new;

    protected ERXMigrationTable(ERXMigrationDatabase database, String name) {
        this._database = database;
        this._columns = new NSMutableArray();
        this._indexes = new NSMutableArray();
        this._name = name;
        this._new = true;
    }

    public ERXMigrationDatabase database() {
        return this._database;
    }

    public NSArray<String> languages() {
        return this.database().languages();
    }

    public void _setName(String name) {
        this._name = name;
    }

    public String name() {
        return this._name;
    }

    public boolean isNew() {
        return this._new;
    }

    public void _setNew(boolean isNew) {
        this._new = isNew;
    }

    public EOEntity _blankEntity() {
        EOModel newModel = this._database._blankModel();
        EOEntity newEntity = new EOEntity();
        newEntity.setExternalName(this._name);
        newEntity.setName("ERXMigrationTable_" + this._name);
        newModel.addEntity(newEntity);
        return newEntity;
    }

    public EOEntity _newEntity() {
        EOEntity entity = this._blankEntity();
        NSMutableArray<EOAttribute> primaryKeyAttributes = new NSMutableArray<EOAttribute>();
        for (ERXMigrationColumn column : this._columns) {
            EOAttribute attribute = column._newAttribute(entity);
            if (!column.isPrimaryKey()) continue;
            primaryKeyAttributes.addObject(attribute);
        }
        entity.setPrimaryKeyAttributes(primaryKeyAttributes);
        return entity;
    }

    public ERXMigrationColumn existingColumnNamed(String name) {
        ERXMigrationColumn column;
        NSArray existingColumns = EOQualifier.filteredArrayWithQualifier(this._columns, (EOQualifier)new EOKeyValueQualifier("name", EOQualifier.QualifierOperatorCaseInsensitiveLike, (Object)name));
        if (existingColumns.count() == 0) {
            if (this._new) {
                throw new IllegalStateException("You requested the column named '" + name + "' in the table '" + this._name + "', but that column hasn't been created yet.");
            }
            try {
                column = this._newColumn(name, 1111, 0, 0, 0, false, null, null, false);
            }
            catch (SQLException e) {
                throw new IllegalStateException("This should never have executed a database operation.", e);
            }
            column._setNew(false);
        } else {
            column = (ERXMigrationColumn)existingColumns.objectAtIndex(0);
        }
        return column;
    }

    public EORelationship _newRelationship(ERXMigrationColumn sourceColumn, ERXMigrationColumn destinationColumn) {
        EOAttribute sourceAttribute = sourceColumn._newAttribute();
        EOEntity entity = sourceAttribute.entity();
        EOAttribute destinationAttribute = destinationColumn._newAttribute();
        EOEntity destinationEntity = destinationAttribute.entity();
        destinationEntity.setPrimaryKeyAttributes(new NSArray<EOAttribute>(destinationAttribute));
        EORelationship relationship = new EORelationship();
        relationship.setName(sourceAttribute.name() + "_" + destinationAttribute.name());
        relationship.setEntity(entity);
        EOJoin join = new EOJoin(sourceAttribute, destinationAttribute);
        relationship.addJoin(join);
        return relationship;
    }

    public ERXMigrationColumn _newColumn(String name, int jdbcType, int width, int precision, int scale, boolean allowsNull, String overrideValueType, Object defaultValue, boolean autocreate) throws SQLException {
        ERXMigrationColumn newColumn = new ERXMigrationColumn(this, name, jdbcType, width, precision, scale, allowsNull, overrideValueType, defaultValue);
        this._columns.addObject(newColumn);
        if (autocreate) {
            newColumn.create();
        }
        return newColumn;
    }

    public ERXMigrationColumn newColumn(String name, int jdbcType, int width, int precision, int scale, boolean allowsNull, String overrideValueType, Object defaultValue) throws SQLException {
        return this._newColumn(name, jdbcType, width, precision, scale, allowsNull, overrideValueType, defaultValue, !this._new);
    }

    public ERXMigrationColumn newColumn(String name, int jdbcType, int width, int precision, int scale, boolean allowsNull, String overrideValueType) throws SQLException {
        return this._newColumn(name, jdbcType, width, precision, scale, allowsNull, overrideValueType, null, !this._new);
    }

    public ERXMigrationColumn newStringColumn(String name, int width, boolean allowsNull) throws SQLException {
        return this.newColumn(name, 12, width, 0, 0, allowsNull, null);
    }

    public ERXMigrationColumn newStringColumn(String name, int width, boolean allowsNull, String defaultValue) throws SQLException {
        return this.newColumn(name, 12, width, 0, 0, allowsNull, null, defaultValue);
    }

    public ERXMigrationColumn newStringColumn(String name, boolean allowsNull) throws SQLException {
        return this.newLargeStringColumn(name, allowsNull);
    }

    public ERXMigrationColumn newLargeStringColumn(String name, boolean allowsNull) throws SQLException {
        ERXSQLHelper sqlHelper = ERXSQLHelper.newSQLHelper(this._database.adaptorChannel());
        return this.newColumn(name, sqlHelper.varcharLargeJDBCType(), sqlHelper.varcharLargeColumnWidth(), 0, 0, allowsNull, null);
    }

    public ERXMigrationColumn newStringColumn(String name, boolean allowsNull, String defaultValue) throws SQLException {
        ERXSQLHelper sqlHelper = ERXSQLHelper.newSQLHelper(this._database.adaptorChannel());
        return this.newColumn(name, sqlHelper.varcharLargeJDBCType(), sqlHelper.varcharLargeColumnWidth(), 0, 0, allowsNull, null, defaultValue);
    }

    public NSArray<ERXMigrationColumn> newLocalizedStringColumns(String name, int width, boolean allowsNull) throws SQLException {
        NSMutableArray<ERXMigrationColumn> result = new NSMutableArray<ERXMigrationColumn>();
        for (String language : this.languages()) {
            ERXMigrationColumn column = this.newColumn(this.localizedColumnName(name, language), 12, width, 0, 0, allowsNull, null);
            result.addObject(column);
        }
        return result;
    }

    private String localizedColumnName(String name, String language) {
        return name + "_" + language;
    }

    public NSArray<ERXMigrationColumn> newLocalizedStringColumns(String name, int width, boolean allowsNull, String defaultValue) throws SQLException {
        NSMutableArray<ERXMigrationColumn> result = new NSMutableArray<ERXMigrationColumn>();
        for (String language : this.languages()) {
            ERXMigrationColumn column = this.newColumn(this.localizedColumnName(name, language), 12, width, 0, 0, allowsNull, null, defaultValue);
            result.addObject(column);
        }
        return result;
    }

    public NSArray<ERXMigrationColumn> newLocalizedClobColumns(String name, boolean allowsNull) throws SQLException {
        NSMutableArray<ERXMigrationColumn> result = new NSMutableArray<ERXMigrationColumn>();
        for (String language : this.languages()) {
            ERXMigrationColumn column = this.newColumn(this.localizedColumnName(name, language), 2005, 0, 0, 0, allowsNull, null);
            result.addObject(column);
        }
        return result;
    }

    public ERXMigrationColumn newIntegerColumn(String name, boolean allowsNull) throws SQLException {
        return this.newColumn(name, 4, 0, 0, 0, allowsNull, null);
    }

    public ERXMigrationColumn newIntegerColumn(String name, boolean allowsNull, Integer defaultValue) throws SQLException {
        return this.newColumn(name, 4, 0, 0, 0, allowsNull, null, defaultValue);
    }

    public ERXMigrationColumn newIntegerColumn(String name, int scale, boolean allowsNull) throws SQLException {
        return this.newColumn(name, 4, 0, 0, scale, allowsNull, null);
    }

    public ERXMigrationColumn newIntegerColumn(String name, int scale, boolean allowsNull, Integer defaultValue) throws SQLException {
        return this.newColumn(name, 4, 0, 0, scale, allowsNull, null, defaultValue);
    }

    public ERXMigrationColumn newIntegerColumn(String name, int scale, int precision, boolean allowsNull) throws SQLException {
        return this.newColumn(name, 4, 0, scale, precision, allowsNull, null);
    }

    public ERXMigrationColumn newIntegerColumn(String name, int scale, int precision, boolean allowsNull, Object defaultValue) throws SQLException {
        return this.newColumn(name, 4, 0, scale, precision, allowsNull, null, defaultValue);
    }

    public ERXMigrationColumn newSmallIntegerColumn(String name, boolean allowsNull) throws SQLException {
        return this.newColumn(name, 5, 0, 0, 0, allowsNull, null);
    }

    public ERXMigrationColumn newSmallIntegerColumn(String name, boolean allowsNull, Short defaultValue) throws SQLException {
        return this.newColumn(name, 5, 0, 0, 0, allowsNull, null, defaultValue);
    }

    public ERXMigrationColumn newBigIntegerColumn(String name, boolean allowsNull) throws SQLException {
        return this.newColumn(name, -5, 0, 0, 0, allowsNull, null);
    }

    public ERXMigrationColumn newBigIntegerColumn(String name, boolean allowsNull, Long defaultValue) throws SQLException {
        return this.newColumn(name, -5, 0, 0, 0, allowsNull, null, defaultValue);
    }

    public ERXMigrationColumn newFloatColumn(String name, int precision, int scale, boolean allowsNull) throws SQLException {
        return this.newColumn(name, 6, 0, precision, scale, allowsNull, null);
    }

    public ERXMigrationColumn newFloatColumn(String name, int precision, int scale, boolean allowsNull, Float defaultValue) throws SQLException {
        return this.newColumn(name, 6, 0, precision, scale, allowsNull, null, defaultValue);
    }

    public ERXMigrationColumn newDoubleColumn(String name, int precision, int scale, boolean allowsNull) throws SQLException {
        return this.newColumn(name, 8, 0, precision, scale, allowsNull, null);
    }

    public ERXMigrationColumn newDoubleColumn(String name, int precision, int scale, boolean allowsNull, Double defaultValue) throws SQLException {
        return this.newColumn(name, 8, 0, precision, scale, allowsNull, null, defaultValue);
    }

    public ERXMigrationColumn newBigDecimalColumn(String name, int precision, int scale, boolean allowsNull) throws SQLException {
        return this.newColumn(name, 3, 0, precision, scale, allowsNull, null);
    }

    public ERXMigrationColumn newBigDecimalColumn(String name, int precision, int scale, boolean allowsNull, BigDecimal defaultValue) throws SQLException {
        return this.newColumn(name, 3, 0, precision, scale, allowsNull, null, defaultValue);
    }

    public ERXMigrationColumn newBooleanColumn(String name, boolean allowsNull) throws SQLException {
        return this.newColumn(name, 12, 5, 0, 0, allowsNull, null);
    }

    public ERXMigrationColumn newBooleanColumn(String name, boolean allowsNull, Boolean defaultValue) throws SQLException {
        return this.newColumn(name, 12, 5, 0, 0, allowsNull, null, defaultValue == null ? null : defaultValue.toString());
    }

    public ERXMigrationColumn newIntBooleanColumn(String name, boolean allowsNull) throws SQLException {
        return this.newColumn(name, 4, 0, 0, 0, allowsNull, null);
    }

    public ERXMigrationColumn newIntBooleanColumn(String name, boolean allowsNull, Boolean defaultValue) throws SQLException {
        return this.newColumn(name, 4, 0, 0, 0, allowsNull, null, defaultValue);
    }

    public ERXMigrationColumn newFlagBooleanColumn(String name, boolean allowsNull) throws SQLException {
        return this.newColumn(name, 16, 0, 0, 0, allowsNull, null);
    }

    public ERXMigrationColumn newFlagBooleanColumn(String name, boolean allowsNull, Boolean defaultValue) throws SQLException {
        return this.newColumn(name, 16, 0, 0, 0, allowsNull, null, defaultValue);
    }

    public ERXMigrationColumn newClobColumn(String name, boolean allowsNull) throws SQLException {
        return this.newColumn(name, 2005, 0, 0, 0, allowsNull, null);
    }

    public ERXMigrationColumn newBlobColumn(String name, boolean allowsNull) throws SQLException {
        return this.newColumn(name, 2004, 0, 0, 0, allowsNull, null);
    }

    public ERXMigrationColumn newBlobColumn(String name, int width, boolean allowsNull) throws SQLException {
        return this.newColumn(name, 2004, width, 0, 0, allowsNull, null);
    }

    public ERXMigrationColumn newBlobColumn(String name, int width, boolean allowsNull, NSData defaultValue) throws SQLException {
        return this.newColumn(name, 2004, width, 0, 0, allowsNull, null, defaultValue);
    }

    public ERXMigrationColumn newTimestampColumn(String name, boolean allowsNull) throws SQLException {
        return this.newColumn(name, 93, 0, 0, 0, allowsNull, "___NULL_VALUE_TYPE___");
    }

    public ERXMigrationColumn newTimestampColumn(String name, boolean allowsNull, NSTimestamp defaultValue) throws SQLException {
        return this.newColumn(name, 93, 0, 0, 0, allowsNull, "___NULL_VALUE_TYPE___", defaultValue);
    }

    public ERXMigrationColumn newDateColumn(String name, boolean allowsNull) throws SQLException {
        return this.newColumn(name, 91, 0, 0, 0, allowsNull, "___NULL_VALUE_TYPE___");
    }

    public ERXMigrationColumn newDateColumn(String name, boolean allowsNull, NSTimestamp defaultValue) throws SQLException {
        return this.newColumn(name, 91, 0, 0, 0, allowsNull, "___NULL_VALUE_TYPE___", defaultValue);
    }

    public ERXMigrationColumn newIpAddressColumn(String name, boolean allowsNull) throws SQLException {
        return this.newColumn(name, 9001, 39, 0, 0, allowsNull, null);
    }

    public ERXMigrationColumn newIpAddressColumn(String name, boolean allowsNull, String defaultValue) throws SQLException {
        return this.newColumn(name, 9001, 39, 0, 0, allowsNull, null, defaultValue);
    }

    public void _columnDeleted(ERXMigrationColumn column) {
        this._columns.removeObject(column);
    }

    public NSArray<EOSQLExpression> _createExpressions() {
        EOSynchronizationFactory schemaGeneration = this._database.synchronizationFactory();
        NSArray expressions = schemaGeneration.createTableStatementsForEntityGroup(new NSArray<EOEntity>(this._newEntity()));
        ERXMigrationDatabase._ensureNotEmpty(expressions, "create table", true);
        return expressions;
    }

    public void create() throws SQLException {
        if (this._new) {
            ERXJDBCUtilities.executeUpdateScript(this._database.adaptorChannel(), ERXMigrationDatabase._stringsForExpressions(this._createExpressions()));
            NSMutableArray<ERXMigrationColumn> primaryKeys = new NSMutableArray<ERXMigrationColumn>();
            for (ERXMigrationColumn column : this._columns) {
                if (column.isPrimaryKey()) {
                    primaryKeys.addObject(column);
                }
                column._setNew(false);
            }
            if (primaryKeys.count() > 0) {
                this.setPrimaryKey(true, primaryKeys.toArray(new ERXMigrationColumn[primaryKeys.count()]));
            }
            for (ERXMigrationColumn column : this._columns) {
                ERXMigrationColumn foreignKeyDestination = column.foreignKeyDestination();
                if (foreignKeyDestination == null) continue;
                this.addForeignKey(true, column, foreignKeyDestination);
            }
            for (ERXMigrationIndex index : this._indexes) {
                this.addIndex(true, index);
            }
            this._new = false;
        } else {
            ERXMigrationDatabase.log.warn((Object)("You called .create() on the table '" + this._name + "', but it was already created."));
        }
    }

    public NSArray<EOSQLExpression> _dropExpressions() {
        EOSynchronizationFactory schemaGeneration = this._database.synchronizationFactory();
        NSArray expressions = schemaGeneration.dropTableStatementsForEntityGroup(new NSArray<EOEntity>(this._blankEntity()));
        ERXMigrationDatabase._ensureNotEmpty(expressions, "drop table", true);
        return expressions;
    }

    public void drop() throws SQLException {
        ERXJDBCUtilities.executeUpdateScript(this._database.adaptorChannel(), ERXMigrationDatabase._stringsForExpressions(this._dropExpressions()));
        this._database._tableDropped(this);
    }

    public NSArray<EOSQLExpression> _renameToExpressions(String newName) {
        EOSynchronizationFactory schemaSynchronization = this._database.synchronizationFactory();
        NSArray expressions = schemaSynchronization.statementsToRenameTableNamed(this.name(), newName, NSDictionary.EmptyDictionary);
        ERXMigrationDatabase._ensureNotEmpty(expressions, "rename table", true);
        return expressions;
    }

    public void renameTo(String newName) throws SQLException {
        ERXJDBCUtilities.executeUpdateScript(this._database.adaptorChannel(), ERXMigrationDatabase._stringsForExpressions(this._renameToExpressions(newName)));
        this._setName(newName);
    }

    public NSArray<EOSQLExpression> _setPrimaryKeyExpressions(ERXMigrationColumn ... columns) {
        EOSynchronizationFactory schemaGeneration = this._database.synchronizationFactory();
        EOEntity entity = columns[0].table()._blankEntity();
        NSMutableArray<EOAttribute> attributes = new NSMutableArray<EOAttribute>();
        for (ERXMigrationColumn column : columns) {
            EOAttribute attribute = column._newAttribute(entity);
            attributes.addObject(attribute);
        }
        entity.setPrimaryKeyAttributes(attributes);
        NSArray expressions = schemaGeneration.primaryKeyConstraintStatementsForEntityGroup(new NSArray<EOEntity>(entity));
        ERXMigrationDatabase._ensureNotEmpty(expressions, "add primary key", true);
        NSArray supportExpressions = schemaGeneration.primaryKeySupportStatementsForEntityGroup(new NSArray<EOEntity>(entity));
        return expressions.arrayByAddingObjectsFromArray(supportExpressions);
    }

    public void addUniqueIndex(String columnName) throws SQLException {
        this.addUniqueIndex(null, columnName);
    }

    public void addUniqueIndex(String indexName, String columnName) throws SQLException {
        this.addUniqueIndex(indexName, this.existingColumnNamed(columnName));
    }

    public void addUniqueIndex(String indexName, String columnName, int width) throws SQLException {
        this.addUniqueIndex(indexName, new ERXSQLHelper.ColumnIndex(columnName, width));
    }

    public void addUniqueIndex(String indexName, ERXMigrationColumn ... columns) throws SQLException {
        ERXSQLHelper.ColumnIndex[] columnIndexes = this._columnIndexesForMigrationColumns(columns);
        this.addUniqueIndex(indexName, columnIndexes);
    }

    public void addUniqueIndex(String indexName, ERXSQLHelper.ColumnIndex ... columnIndexes) throws SQLException {
        this.addUniqueIndex(!this._new, indexName, columnIndexes);
    }

    public void addUniqueIndex(boolean create, String indexName, ERXSQLHelper.ColumnIndex ... columnIndexes) throws SQLException {
        if (create) {
            ERXSQLHelper helper = ERXSQLHelper.newSQLHelper(this._database.adaptorChannel());
            if (indexName == null) {
                indexName = this._defaultIndexName(true, this._name, helper.columnNamesFromColumnIndexes(columnIndexes).toArray(new String[0]));
            }
            String sql = helper.sqlForCreateUniqueIndex(indexName, this._name, columnIndexes);
            ERXJDBCUtilities.executeUpdateScript(this._database.adaptorChannel(), sql);
        } else {
            this._indexes.addObject(new ERXMigrationIndex(indexName, true, columnIndexes));
        }
    }

    public void addIndex(String columnName) throws SQLException {
        this.addIndex(null, columnName);
    }

    public void addIndex(String indexName, String columnName) throws SQLException {
        this.addIndex(indexName, this.existingColumnNamed(columnName));
    }

    public void addIndex(String indexName, String columnName, int width) throws SQLException {
        this.addIndex(indexName, new ERXSQLHelper.ColumnIndex(columnName, width));
    }

    public void addIndex(String indexName, ERXMigrationColumn ... columns) throws SQLException {
        ERXSQLHelper.ColumnIndex[] columnIndexes = this._columnIndexesForMigrationColumns(columns);
        this.addIndex(indexName, columnIndexes);
    }

    public void addIndex(String indexName, ERXSQLHelper.ColumnIndex ... columnIndexes) throws SQLException {
        this.addIndex(!this._new, indexName, columnIndexes);
    }

    public void addIndex(boolean create, String indexName, ERXSQLHelper.ColumnIndex ... columnIndexes) throws SQLException {
        if (create) {
            ERXSQLHelper helper = ERXSQLHelper.newSQLHelper(this._database.adaptorChannel());
            if (indexName == null) {
                indexName = this._defaultIndexName(false, this._name, helper.columnNamesFromColumnIndexes(columnIndexes).toArray(new String[0]));
            }
            String sql = helper.sqlForCreateIndex(indexName, this._name, columnIndexes);
            ERXJDBCUtilities.executeUpdateScript(this._database.adaptorChannel(), sql);
        } else {
            this._indexes.addObject(new ERXMigrationIndex(indexName, false, columnIndexes));
        }
    }

    public void addIndex(ERXMigrationIndex index) throws SQLException {
        this.addIndex(!this._new, index);
    }

    public void addIndex(boolean create, ERXMigrationIndex index) throws SQLException {
        if (index.isUnique()) {
            this.addUniqueIndex(create, index.name(), index.columns());
        } else {
            this.addIndex(create, index.name(), index.columns());
        }
    }

    private ERXSQLHelper.ColumnIndex[] _columnIndexesForMigrationColumns(ERXMigrationColumn ... columns) {
        ERXSQLHelper.ColumnIndex[] columnIndexes = new ERXSQLHelper.ColumnIndex[columns.length];
        for (int columnNum = 0; columnNum < columns.length; ++columnNum) {
            columnIndexes[columnNum] = new ERXSQLHelper.ColumnIndex(columns[columnNum].name(), columns[columnNum].width());
        }
        return columnIndexes;
    }

    private String _defaultIndexName(boolean unique, String tableName, String ... columnNames) {
        String indexName = unique ? "UNIQUE_" : "INDEX_";
        indexName = indexName + tableName;
        indexName = indexName + "__";
        indexName = indexName + new NSArray<String>(columnNames).componentsJoinedByString("_");
        return indexName;
    }

    public void setPrimaryKey(String columnName) throws SQLException {
        this.setPrimaryKey(this.existingColumnNamed(columnName));
    }

    public void setPrimaryKey(String ... columnNames) throws SQLException {
        ERXMigrationColumn[] columns = new ERXMigrationColumn[columnNames.length];
        for (int i = 0; i < columnNames.length; ++i) {
            columns[i] = this.existingColumnNamed(columnNames[i]);
        }
        this.setPrimaryKey(columns);
    }

    public void setPrimaryKey(ERXMigrationColumn ... columns) throws SQLException {
        this.setPrimaryKey(!this._new, columns);
    }

    public void setPrimaryKey(boolean create, ERXMigrationColumn ... columns) throws SQLException {
        for (ERXMigrationColumn column : this._columns) {
            column._setPrimaryKey(false);
        }
        for (ERXMigrationColumn column : columns) {
            column._setPrimaryKey(true);
        }
        if (create) {
            ERXJDBCUtilities.executeUpdateScript(this._database.adaptorChannel(), ERXMigrationDatabase._stringsForExpressions(this._setPrimaryKeyExpressions(columns)));
        }
    }

    public NSArray<EOSQLExpression> _addForeignKeyExpressions(ERXMigrationColumn sourceColumn, ERXMigrationColumn destinationColumn) {
        EOSynchronizationFactory schemaGeneration = this._database.synchronizationFactory();
        NSArray expressions = schemaGeneration.foreignKeyConstraintStatementsForRelationship(this._newRelationship(sourceColumn, destinationColumn));
        ERXMigrationDatabase._ensureNotEmpty(expressions, "add foreign key", false);
        return expressions;
    }

    public void addForeignKey(String sourceColumnName, String destinationTableName, String destinationColumnName) throws SQLException {
        this.addForeignKey(this.existingColumnNamed(sourceColumnName), this.database().existingColumnNamed(destinationTableName, destinationColumnName));
    }

    public void addForeignKey(String sourceColumnName, ERXMigrationColumn destinationColumn) throws SQLException {
        this.addForeignKey(this.existingColumnNamed(sourceColumnName), destinationColumn);
    }

    public void addForeignKey(ERXMigrationColumn sourceColumn, ERXMigrationColumn destinationColumn) throws SQLException {
        this.addForeignKey(!this._new, sourceColumn, destinationColumn);
    }

    public void addForeignKey(boolean create, ERXMigrationColumn sourceColumn, ERXMigrationColumn destinationColumn) throws SQLException {
        NSArray<EOSQLExpression> expressions;
        sourceColumn._setForeignKeyDestination(destinationColumn);
        if (create && (expressions = this._addForeignKeyExpressions(sourceColumn, destinationColumn)) != null) {
            ERXJDBCUtilities.executeUpdateScript(this._database.adaptorChannel(), ERXMigrationDatabase._stringsForExpressions(expressions));
        }
    }

    public NSArray<EOSQLExpression> _dropPrimaryKeyExpressions(ERXMigrationColumn ... columns) {
        EOSynchronizationFactory schemaGeneration = this._database.synchronizationFactory();
        EOEntity entity = columns[0].table()._blankEntity();
        NSMutableArray<EOAttribute> attributes = new NSMutableArray<EOAttribute>();
        for (ERXMigrationColumn column : columns) {
            EOAttribute attribute = column._newAttribute(entity);
            attributes.addObject(attribute);
        }
        entity.setPrimaryKeyAttributes(attributes);
        NSArray expressions = schemaGeneration.dropPrimaryKeySupportStatementsForEntityGroup(new NSArray<EOEntity>(entity));
        ERXMigrationDatabase._ensureNotEmpty(expressions, "drop primary key", true);
        return expressions;
    }

    public void dropPrimaryKey(ERXMigrationColumn ... columns) throws SQLException {
        ERXJDBCUtilities.executeUpdateScript(this._database.adaptorChannel(), ERXMigrationDatabase._stringsForExpressions(this._dropPrimaryKeyExpressions(columns)));
        for (ERXMigrationColumn column : columns) {
            column._setPrimaryKey(false);
        }
    }

    public NSDictionary<String, Object> newPrimaryKey() {
        return this.newPrimaryKeys(1).lastObject();
    }

    public NSArray<NSDictionary<String, Object>> newPrimaryKeys(int count) {
        NSArray primaryKeys = this.database().adaptorChannel().primaryKeysForNewRowsWithEntity(count, this._newEntity());
        return primaryKeys;
    }
}

