/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.remoteSynchronizer;

import com.webobjects.appserver.WOApplication;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSMutableDictionary;
import er.extensions.eof.ERXDatabase;
import er.extensions.eof.ERXObjectStoreCoordinatorSynchronizer;
import er.extensions.foundation.ERXProperties;
import er.extensions.foundation.ERXStringUtilities;
import er.extensions.remoteSynchronizer.ERXRemoteSynchronizer;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Arrays;
import java.util.Enumeration;

public class ERXSimpleMulticastSynchronizer
extends ERXRemoteSynchronizer {
    public static final int IDENTIFIER_LENGTH = 6;
    private static final int JOIN = 1;
    private static final int LEAVE = 2;
    private byte[] _identifier;
    private InetAddress _localBindAddress;
    private NetworkInterface _localNetworkInterface;
    private InetSocketAddress _multicastGroup;
    private int _multicastPort;
    private MulticastSocket _multicastSocket;
    private boolean _listening;
    private int _maxSendPacketSize;
    private int _maxReceivePacketSize;
    private NSArray _whitelist;
    private NSMutableDictionary _incomingCacheChanges = new NSMutableDictionary();

    public ERXSimpleMulticastSynchronizer(ERXObjectStoreCoordinatorSynchronizer.IChangeListener listener) throws IOException {
        super(listener);
        int maxPacketSize;
        String localBindAddressStr = ERXProperties.stringForKey("er.extensions.multicastSynchronizer.localBindAddress");
        this._localBindAddress = localBindAddressStr == null ? WOApplication.application().hostAddress() : InetAddress.getByName(localBindAddressStr);
        String multicastGroup = ERXProperties.stringForKeyWithDefault("er.extensions.multicastSynchronizer.group", "230.0.0.1");
        this._multicastPort = ERXProperties.intForKeyWithDefault("er.extensions.multicastSynchronizer.port", 9753);
        String whitelist = ERXProperties.stringForKey("er.extensions.multicastSynchronizer.whitelist");
        if (whitelist != null) {
            this._whitelist = NSArray.componentsSeparatedByString(whitelist, ",");
        }
        this._maxSendPacketSize = maxPacketSize = ERXProperties.intForKeyWithDefault("er.extensions.multicastSynchronizer.maxPacketSize", 1024);
        this._maxReceivePacketSize = 2 * maxPacketSize;
        String multicastIdentifierStr = ERXProperties.stringForKey("er.extensions.multicastSynchronizer.identifier");
        if (multicastIdentifierStr == null) {
            this._identifier = new byte[6];
            byte[] hostAddressBytes = this._localBindAddress.getAddress();
            System.arraycopy(hostAddressBytes, 0, this._identifier, 0, hostAddressBytes.length);
            short multicastInstance = WOApplication.application().port().shortValue();
            this._identifier[4] = (byte)(multicastInstance & 0xFF);
            this._identifier[5] = (byte)(multicastInstance >>> 8 & 0xFF);
        } else {
            this._identifier = ERXStringUtilities.hexStringToByteArray(multicastIdentifierStr);
        }
        this._localNetworkInterface = NetworkInterface.getByInetAddress(this._localBindAddress);
        this._multicastGroup = new InetSocketAddress(InetAddress.getByName(multicastGroup), this._multicastPort);
        this._multicastSocket = new MulticastSocket(null);
        this._multicastSocket.setInterface(this._localBindAddress);
        this._multicastSocket.setTimeToLive(4);
        this._multicastSocket.setReuseAddress(true);
        this._multicastSocket.bind(new InetSocketAddress(this._multicastPort));
    }

    public void join() throws IOException {
        if (ERXRemoteSynchronizer.log.isInfoEnabled()) {
            ERXRemoteSynchronizer.log.info((Object)("Multicast instance " + ERXStringUtilities.byteArrayToHexString(this._identifier) + " joining."));
        }
        this._multicastSocket.joinGroup(this._multicastGroup, this._localNetworkInterface);
        MulticastByteArrayOutputStream baos = new MulticastByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        dos.write(this._identifier);
        dos.writeInt(0);
        dos.writeShort(0);
        dos.writeShort(0);
        dos.writeByte(1);
        dos.flush();
        this._multicastSocket.send(baos.createDatagramPacket());
    }

    public void leave() throws IOException {
        if (ERXRemoteSynchronizer.log.isInfoEnabled()) {
            ERXRemoteSynchronizer.log.info((Object)("Multicast instance " + ERXStringUtilities.byteArrayToHexString(this._identifier) + " leaving."));
        }
        MulticastByteArrayOutputStream baos = new MulticastByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        dos.write(this._identifier);
        dos.writeInt(0);
        dos.writeShort(0);
        dos.writeShort(0);
        dos.writeByte(2);
        dos.flush();
        this._multicastSocket.send(baos.createDatagramPacket());
        this._multicastSocket.leaveGroup(this._multicastGroup, this._localNetworkInterface);
        this._listening = false;
    }

    protected boolean handleMessageType(int messageType, ERXObjectStoreCoordinatorSynchronizer.RemoteChange remoteChange, DataInputStream dis) {
        boolean handled = false;
        if (messageType == 1) {
            handled = true;
        } else if (messageType == 2) {
            handled = true;
        }
        return handled;
    }

    public void listen() throws IOException {
        Thread listenThread = new Thread(new Runnable(){

            public void run() {
                ERXSimpleMulticastSynchronizer.this._listening = true;
                byte[] buffer = new byte[ERXSimpleMulticastSynchronizer.this._maxReceivePacketSize];
                while (ERXSimpleMulticastSynchronizer.this._listening) {
                    DatagramPacket receivePacket = new DatagramPacket(buffer, 0, buffer.length);
                    try {
                        ERXSimpleMulticastSynchronizer.this._multicastSocket.receive(receivePacket);
                        ByteArrayInputStream bais = new ByteArrayInputStream(receivePacket.getData(), 0, receivePacket.getLength());
                        DataInputStream dis = new DataInputStream(bais);
                        boolean processPacket = true;
                        if (ERXSimpleMulticastSynchronizer.this._whitelist != null) {
                            InetAddress remoteAddress = receivePacket.getAddress();
                            String remoteHostAddress = remoteAddress.getHostAddress();
                            processPacket = ERXSimpleMulticastSynchronizer.this._whitelist.containsObject(remoteHostAddress);
                        }
                        byte[] identifier = new byte[6];
                        dis.readFully(identifier);
                        if (!processPacket || Arrays.equals(identifier, ERXSimpleMulticastSynchronizer.this._identifier)) continue;
                        int transactionID = dis.readInt();
                        short transactionNum = dis.readShort();
                        short transactionSize = dis.readShort();
                        String transactionIdentifierStr = identifier + "-" + transactionID;
                        ERXObjectStoreCoordinatorSynchronizer.RemoteChange remoteChange = (ERXObjectStoreCoordinatorSynchronizer.RemoteChange)ERXSimpleMulticastSynchronizer.this._incomingCacheChanges.objectForKey(transactionIdentifierStr);
                        if (remoteChange == null) {
                            remoteChange = new ERXObjectStoreCoordinatorSynchronizer.RemoteChange(ERXStringUtilities.byteArrayToHexString(identifier), transactionID, transactionSize);
                            ERXSimpleMulticastSynchronizer.this._incomingCacheChanges.setObjectForKey(remoteChange, transactionIdentifierStr);
                        }
                        ERXSimpleMulticastSynchronizer.this._readCacheChange(remoteChange, dis);
                        if (!remoteChange.isComplete()) continue;
                        ERXSimpleMulticastSynchronizer.this._incomingCacheChanges.removeObjectForKey(transactionIdentifierStr);
                        ERXSimpleMulticastSynchronizer.this.addChange(remoteChange);
                    }
                    catch (Throwable t) {
                        ERXRemoteSynchronizer.log.error((Object)"Failed to read multicast notification.", t);
                    }
                }
            }
        });
        listenThread.setName("ERXSimpleMultiCastListener");
        listenThread.setDaemon(true);
        listenThread.start();
    }

    protected void _writeCacheChanges(int transactionID, NSArray cacheChanges) throws IOException {
        short transactionSize = (short)cacheChanges.count();
        short transactionNum = 0;
        Enumeration cacheChangesEnum = cacheChanges.objectEnumerator();
        while (cacheChangesEnum.hasMoreElements()) {
            ERXDatabase.CacheChange cacheChange = (ERXDatabase.CacheChange)cacheChangesEnum.nextElement();
            this.writeCacheChange(cacheChange, transactionID, transactionNum, transactionSize);
            transactionNum = (short)(transactionNum + 1);
        }
    }

    public void writeCacheChange(ERXDatabase.CacheChange cacheChange, int transactionID, short transactionNum, short transactionSize) throws IOException {
        MulticastByteArrayOutputStream baos = new MulticastByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        dos.write(this._identifier);
        dos.writeInt(transactionID);
        dos.writeShort(transactionNum);
        dos.writeShort(transactionSize);
        this._writeCacheChange(dos, cacheChange);
        dos.flush();
        this._multicastSocket.send(baos.createDatagramPacket());
        if (ERXRemoteSynchronizer.log.isDebugEnabled()) {
            ERXRemoteSynchronizer.log.info((Object)("Multicast instance " + ERXStringUtilities.byteArrayToHexString(this._identifier) + ": Writing " + cacheChange));
        }
    }

    protected class MulticastByteArrayOutputStream
    extends ERXRemoteSynchronizer.RefByteArrayOutputStream {
        protected MulticastByteArrayOutputStream() {
        }

        public DatagramPacket createDatagramPacket() throws SocketException {
            return new DatagramPacket(this.buf, 0, this.count, ERXSimpleMulticastSynchronizer.this._multicastGroup);
        }
    }
}

