/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.statistics;

import com.webobjects.appserver.WOComponent;
import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WORequest;
import com.webobjects.appserver.WOSession;
import com.webobjects.appserver.WOStatisticsStore;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import er.extensions.appserver.ERXApplication;
import er.extensions.eof.ERXEC;
import er.extensions.eof.ERXObjectStoreCoordinator;
import er.extensions.foundation.ERXProperties;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.apache.log4j.Logger;

public class ERXStatisticsStore
extends WOStatisticsStore {
    private static final Logger log = Logger.getLogger(ERXStatisticsStore.class);
    private final StopWatchTimer _timer = new StopWatchTimer();
    protected NSMutableArray sessions = new NSMutableArray();

    private StopWatchTimer timer() {
        return this._timer;
    }

    public NSDictionary statistics() {
        NSMutableDictionary stats = super.statistics();
        if (ERXApplication.isWO54()) {
            NSMutableDictionary fixed = ((NSDictionary)stats).mutableClone();
            Enumeration enumerator = stats.keyEnumerator();
            while (enumerator.hasMoreElements()) {
                Object key = enumerator.nextElement();
                Object value = stats.objectForKey(key);
                fixed.setObjectForKey(this.fix(value), key);
            }
            stats = fixed;
        }
        return stats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _applicationCreatedSession(WOSession wosession) {
        ERXStatisticsStore eRXStatisticsStore = this;
        synchronized (eRXStatisticsStore) {
            this.sessions.addObject(wosession);
            super._applicationCreatedSession(wosession);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _sessionTerminating(WOSession wosession) {
        ERXStatisticsStore eRXStatisticsStore = this;
        synchronized (eRXStatisticsStore) {
            super._sessionTerminating(wosession);
            this.sessions.removeObject(wosession);
        }
    }

    public NSArray activeSession() {
        return this.sessions;
    }

    private void startTimer() {
        this.timer().startTimer();
    }

    private void endTimer(String aString) {
        this.timer().endTimer(null, aString);
    }

    public void applicationWillHandleComponentActionRequest() {
        this.startTimer();
        super.applicationWillHandleComponentActionRequest();
    }

    public void applicationDidHandleComponentActionRequestWithPageNamed(String aString) {
        this.endTimer(aString);
        super.applicationDidHandleComponentActionRequestWithPageNamed(aString);
    }

    public void applicationWillHandleDirectActionRequest() {
        this.startTimer();
        super.applicationWillHandleDirectActionRequest();
    }

    public void applicationDidHandleDirectActionRequestWithActionNamed(String aString) {
        this.endTimer(aString);
        super.applicationDidHandleDirectActionRequestWithActionNamed(aString);
    }

    public void applicationWillHandleWebServiceRequest() {
        this.startTimer();
        super.applicationWillHandleWebServiceRequest();
    }

    public void applicationDidHandleWebServiceRequestWithActionNamed(String aString) {
        this.endTimer(aString);
        super.applicationDidHandleWebServiceRequestWithActionNamed(aString);
    }

    private Object fix(Object value) {
        if (value instanceof ArrayList) {
            ArrayList converted = (ArrayList)value;
            return new NSArray(converted, false);
        }
        if (value instanceof HashMap) {
            HashMap converted = (HashMap)value;
            return new NSDictionary(converted, false);
        }
        return value;
    }

    public Object valueForKey(String s) {
        Object result = super.valueForKey(s);
        return this.fix(result);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class StopWatchTimer
    implements Runnable {
        long maximumRequestErrorTime;
        long maximumRequestWarnTime;
        long maximumRequestFatalTime;
        Map<Thread, Long> _requestThreads = new WeakHashMap<Thread, Long>();
        Map<Thread, Map<Thread, StackTraceElement[]>> _warnTraces = Collections.synchronizedMap(new WeakHashMap());
        Map<Thread, Map<Thread, StackTraceElement[]>> _errorTraces = Collections.synchronizedMap(new WeakHashMap());
        Map<Thread, Map<Thread, StackTraceElement[]>> _fatalTraces = Collections.synchronizedMap(new WeakHashMap());
        Map<Thread, Map<Thread, String>> _warnTracesNames = Collections.synchronizedMap(new WeakHashMap());
        Map<Thread, Map<Thread, String>> _errorTracesNames = Collections.synchronizedMap(new WeakHashMap());
        Map<Thread, Map<Thread, String>> _fatalTracesNames = Collections.synchronizedMap(new WeakHashMap());

        public StopWatchTimer() {
            Thread timerThread = new Thread(this);
            timerThread.setDaemon(true);
            timerThread.start();
            this.maximumRequestWarnTime = ERXProperties.longForKeyWithDefault("er.extensions.ERXStatisticsStore.milliSeconds.warn", 2000L);
            this.maximumRequestErrorTime = ERXProperties.longForKeyWithDefault("er.extensions.ERXStatisticsStore.milliSeconds.error", 10000L);
            this.maximumRequestFatalTime = ERXProperties.longForKeyWithDefault("er.extensions.ERXStatisticsStore.milliSeconds.fatal", 300000L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private long time() {
            Map<Thread, Long> map = this._requestThreads;
            synchronized (map) {
                Long time = this._requestThreads.get(Thread.currentThread());
                return time == null ? 0L : time;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void endTimer(WOContext aContext, String aString) {
            try {
                String requestDescription;
                long requestTime = 0L;
                if (this.hasTimerStarted()) {
                    requestTime = System.currentTimeMillis() - this.time();
                }
                Thread currentThread = Thread.currentThread();
                Map<Thread, StackTraceElement[]> traces = this._fatalTraces.remove(currentThread);
                Map<Thread, String> names = this._fatalTracesNames.remove(currentThread);
                if (traces == null) {
                    traces = this._errorTraces.remove(currentThread);
                    names = this._errorTracesNames.remove(currentThread);
                }
                if (traces == null) {
                    traces = this._warnTraces.remove(currentThread);
                    names = this._warnTracesNames.remove(currentThread);
                }
                String trace = this.stringFromTraces(traces, names);
                Map<Thread, Long> map = this._requestThreads;
                synchronized (map) {
                    this._requestThreads.remove(Thread.currentThread());
                }
                if (requestTime > this.maximumRequestFatalTime) {
                    requestDescription = aContext == null ? aString : this.descriptionForContext(aContext);
                    log.fatal((Object)("Request did take too long : " + requestTime + "ms request was: " + requestDescription + trace));
                } else if (requestTime > this.maximumRequestErrorTime) {
                    requestDescription = aContext == null ? aString : this.descriptionForContext(aContext);
                    log.error((Object)("Request did take too long : " + requestTime + "ms request was: " + requestDescription + trace));
                } else if (requestTime > this.maximumRequestWarnTime) {
                    requestDescription = aContext == null ? aString : this.descriptionForContext(aContext);
                    log.warn((Object)("Request did take too long : " + requestTime + "ms request was: " + requestDescription + trace));
                }
            }
            catch (Exception ex) {
                log.error((Object)ex, (Throwable)ex);
            }
        }

        private String stringFromTraces(Map<Thread, StackTraceElement[]> traces, Map<Thread, String> names) {
            String trace = null;
            if (traces != null) {
                String capturedThreadName = null;
                capturedThreadName = names == null ? Thread.currentThread().getName() : names.get(Thread.currentThread());
                StringBuffer sb = new StringBuffer();
                sb.append("\nRequest Thread Name: ").append(capturedThreadName).append("\n\n");
                for (Thread t : traces.keySet()) {
                    String customThreadName;
                    StackTraceElement func;
                    String groupName;
                    StackTraceElement[] stack = traces.get(t);
                    String name = t.getName() != null ? t.getName() : "No name";
                    String string = groupName = t.getThreadGroup() != null ? t.getThreadGroup().getName() : "No group";
                    if (stack == null || stack.length <= 2 || name.equals("main") || name.equals("ERXStopWatchTimer") || groupName.equals("system") || (func = stack[0]) == null || func.getClassName() == null || func.getClassName().equals("java.net.PlainSocketImpl")) continue;
                    if (names != null && (customThreadName = names.get(t)) != null) {
                        sb.append(customThreadName).append(":\n");
                    }
                    sb.append(t).append(":\n");
                    for (int i = 0; i < stack.length; ++i) {
                        StackTraceElement stackTraceElement = stack[i];
                        sb.append("\tat ").append(stackTraceElement).append("\n");
                    }
                }
                trace = "\n" + sb.toString();
            } else {
                trace = "";
            }
            return trace;
        }

        private boolean hasTimerStarted() {
            return this.time() != 0L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void startTimer() {
            if (!this.hasTimerStarted()) {
                Map<Thread, Long> map = this._requestThreads;
                synchronized (map) {
                    this._requestThreads.put(Thread.currentThread(), new Long(System.currentTimeMillis()));
                }
            }
        }

        public String descriptionForContext(WOContext aContext) {
            try {
                String requestHandler;
                WOComponent component = aContext.page();
                String componentName = component != null ? component.name() : "NoNameComponent";
                String additionalInfo = "(no additional Info)";
                WORequest request = aContext.request();
                String string = requestHandler = request != null ? request.requestHandlerKey() : "NoRequestHandler";
                if (!requestHandler.equals("wo")) {
                    additionalInfo = additionalInfo + aContext.request().uri();
                }
                return componentName + "-" + requestHandler + additionalInfo;
            }
            catch (RuntimeException e) {
                log.error((Object)("Cannot get context description since received exception " + e), (Throwable)e);
                return "Error-during-context-description";
            }
        }

        @Override
        public void run() {
            Thread.currentThread().setName("ERXStopWatchTimer");
            boolean done = false;
            while (!done) {
                this.checkThreads();
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    done = true;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void checkThreads() {
            HashMap<Thread, Long> requestThreads = new HashMap<Thread, Long>();
            Map<Thread, Long> map = this._requestThreads;
            synchronized (map) {
                requestThreads.putAll(this._requestThreads);
            }
            if (!requestThreads.isEmpty()) {
                for (Thread thread : requestThreads.keySet()) {
                    Map names;
                    Map<Thread, StackTraceElement[]> traces;
                    Long time = (Long)requestThreads.get(thread);
                    if (time == null) continue;
                    time = System.currentTimeMillis() - time;
                    if (time > this.maximumRequestWarnTime / 2L && this._warnTraces.get(thread) == null) {
                        traces = Thread.getAllStackTraces();
                        names = this.getCurrentThreadNames(traces.keySet());
                        this._warnTraces.put(thread, traces);
                    }
                    if (time > this.maximumRequestErrorTime / 2L && this._errorTraces.get(thread) == null) {
                        traces = Thread.getAllStackTraces();
                        names = this.getCurrentThreadNames(traces.keySet());
                        this._errorTraces.put(thread, traces);
                        this._errorTracesNames.put(thread, names);
                    }
                    if (time <= this.maximumRequestFatalTime || this._fatalTraces.get(thread) != null) continue;
                    traces = Thread.getAllStackTraces();
                    names = this.getCurrentThreadNames(traces.keySet());
                    this._fatalTraces.put(thread, traces);
                    this._fatalTracesNames.put(thread, names);
                    String message = "Request is taking too long, possible deadlock: " + time + " ms ";
                    message = message + this.stringFromTraces(traces, names);
                    message = message + "EC info:\n" + ERXEC.outstandingLockDescription();
                    message = message + "OSC info:\n" + ERXObjectStoreCoordinator.outstandingLockDescription();
                    log.fatal((Object)message);
                }
            }
        }

        private Map getCurrentThreadNames(Set<Thread> keySet) {
            HashMap<Thread, String> names = new HashMap<Thread, String>();
            for (Thread thread : keySet) {
                names.put(thread, thread.getName());
            }
            return names;
        }
    }
}

