/*
 * Decompiled with CFR 0.152.
 */
package er.pdf;

import com.webobjects.appserver.WOActionResults;
import com.webobjects.appserver.WOAssociation;
import com.webobjects.appserver.WOElement;
import com.webobjects.foundation.NSData;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSForwardException;
import com.webobjects.foundation.NSMutableDictionary;
import er.pdf.ERPDFWrapper;
import er.pdf.builder.PDFBuilder;
import er.pdf.builder.PDFBuilderFactory;
import java.io.ByteArrayOutputStream;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ERPDFUtilities {
    private ERPDFUtilities() {
    }

    public static WOActionResults pageAsPdf(WOElement element) {
        return ERPDFUtilities.pageAsPdf(element, null);
    }

    public static WOActionResults pageAsPdf(WOElement element, NSDictionary<String, Object> config) {
        NSMutableDictionary associations = new NSMutableDictionary();
        if (config != null) {
            for (Map.Entry entry : config.entrySet()) {
                associations.setObjectForKey((Object)WOAssociation.associationWithValue(entry.getValue()), entry.getKey());
            }
        }
        ERPDFWrapper wrapper = new ERPDFWrapper("PDFWrapper", (NSDictionary<String, WOAssociation>)associations, element);
        return wrapper;
    }

    public static NSData htmlAsPdf(String content) {
        return ERPDFUtilities.htmlAsPdf(content, "UTF-8", null, null);
    }

    public static NSData htmlAsPdf(String content, String encoding) {
        return ERPDFUtilities.htmlAsPdf(content, encoding, null, null);
    }

    public static NSData htmlAsPdf(String content, String encoding, String urlPrefix) {
        return ERPDFUtilities.htmlAsPdf(content, encoding, urlPrefix, null);
    }

    public static NSData htmlAsPdf(String html, String encoding, String urlPrefix, NSDictionary<String, Object> config) {
        NSMutableDictionary _config = config == null ? new NSMutableDictionary() : config.mutableClone();
        PDFBuilder builder = PDFBuilderFactory.newBuilder((String)_config.removeObjectForKey((Object)"engine"));
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            builder.setSource(html, encoding, urlPrefix, (NSDictionary<String, Object>)_config);
            builder.createDocument(os);
            os.close();
            return new NSData(os.toByteArray());
        }
        catch (Exception e) {
            throw NSForwardException._runtimeExceptionForThrowable((Throwable)e);
        }
    }
}

