/*
 * Decompiled with CFR 0.152.
 */
package er.pdf;

import com.webobjects.appserver.WOActionResults;
import com.webobjects.appserver.WOApplication;
import com.webobjects.appserver.WOAssociation;
import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WOElement;
import com.webobjects.appserver.WORequest;
import com.webobjects.appserver.WOResponse;
import com.webobjects.appserver._private.WODynamicGroup;
import com.webobjects.foundation.NSData;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSMutableDictionary;
import er.extensions.appserver.ERXRequest;
import er.extensions.appserver.ERXResourceManager;
import er.extensions.appserver.ERXResponse;
import er.extensions.appserver.ERXWOContext;
import er.pdf.ERPDFUtilities;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ERPDFWrapper
extends WODynamicGroup
implements WOActionResults {
    protected NSMutableDictionary<String, WOAssociation> _associations;
    protected WOAssociation _secure;
    protected WOAssociation _enabled;
    protected WOAssociation _filename;
    protected WOElement _component;

    public ERPDFWrapper(String name, NSDictionary<String, WOAssociation> someAssociations, WOElement component) {
        super(name, someAssociations, component);
        this._associations = someAssociations.mutableClone();
        this._secure = (WOAssociation)this._associations.removeObjectForKey((Object)"secure");
        this._enabled = (WOAssociation)this._associations.removeObjectForKey((Object)"enabled");
        this._filename = (WOAssociation)this._associations.removeObjectForKey((Object)"filename");
        this._component = component;
    }

    public void appendToResponse(WOResponse response, WOContext context) {
        ERXResponse.setXHTML((WOResponse)response, (boolean)true);
        boolean enabled = this._enabled != null ? this._enabled.booleanValueInComponent(context.component()) : true;
        super.appendToResponse(response, context);
        if (enabled) {
            this.responseAsPdf(response, context);
        }
    }

    protected void responseAsPdf(WOResponse response, WOContext context) {
        boolean secure = this._secure != null ? this._secure.booleanValueInComponent(context.component()) : ERXRequest.isRequestSecure((WORequest)context.request());
        String resourceUrlPrefix = ERXResourceManager._completeURLForResource((String)"", (Boolean)secure, (WOContext)context);
        NSMutableDictionary config = new NSMutableDictionary();
        for (Map.Entry entry : this._associations.entrySet()) {
            Object value = ((WOAssociation)entry.getValue()).valueInComponent(context.component());
            if (value == null) continue;
            config.setObjectForKey(value, entry.getKey());
        }
        NSData data = ERPDFUtilities.htmlAsPdf(response.contentString(), response.contentEncoding(), resourceUrlPrefix, (NSDictionary<String, Object>)config);
        String filename = this._filename != null ? (String)this._filename.valueInComponent(context.component()) : "result.pdf";
        response.setHeader("inline; filename=\"" + filename + "\"", "content-disposition");
        response.setHeader("application/pdf", "Content-Type");
        response.setHeader(String.valueOf(data.length()), "Content-Length");
        response.setContent(data);
    }

    public WOResponse generateResponse() {
        WOResponse response;
        if (this._component instanceof WOActionResults) {
            response = ((WOActionResults)this._component).generateResponse();
            this.responseAsPdf(response, ERXWOContext.currentContext());
        } else {
            WOContext context = ERXWOContext.currentContext();
            response = WOApplication.application().createResponseInContext(context);
            WOElement currentElement = context._pageElement();
            context._setPageElement(this._component);
            this.appendToResponse(response, context);
            context._setPageElement(currentElement);
        }
        return response;
    }
}

