/*
 * Decompiled with CFR 0.152.
 */
package ognl.helperfunction;

import com.webobjects.appserver.WOAssociation;
import com.webobjects.appserver.WOElement;
import com.webobjects.appserver._private.WOConstantValueAssociation;
import com.webobjects.appserver._private.WODeclaration;
import com.webobjects.appserver._private.WOHTMLCommentString;
import com.webobjects.appserver._private.WOKeyValueAssociation;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSMutableDictionary;
import java.util.Enumeration;
import ognl.helperfunction.WOHTMLWebObjectTag;
import ognl.helperfunction.WOHelperFunctionAssociation;
import ognl.helperfunction.WOHelperFunctionDeclarationFormatException;
import ognl.helperfunction.WOHelperFunctionDeclarationParser;
import ognl.helperfunction.WOHelperFunctionHTMLFormatException;
import ognl.helperfunction.WOHelperFunctionHTMLParser;
import ognl.helperfunction.WOHelperFunctionRegistry;
import ognl.helperfunction.WOHelperFunctionTagRegistry;
import ognl.helperfunction.WOTagProcessor;
import ognl.webobjects.WOOgnl;
import org.apache.log4j.Logger;

public class WOHelperFunctionParser {
    public static Logger log = Logger.getLogger(WOHelperFunctionParser.class);
    public static boolean _debugSupport;
    private static String WO_REPLACEMENT_MARKER;
    private WOHTMLWebObjectTag _currentWebObjectTag;
    private NSMutableDictionary _declarations;
    private int _inlineBindingCount;
    private String _declarationString;
    private String _HTMLString;
    private NSArray _languages;

    public WOHelperFunctionParser(String htmlString, String declarationString, NSArray languages) {
        this._HTMLString = htmlString;
        this._declarationString = declarationString;
        this._languages = languages;
        this._declarations = null;
        this._currentWebObjectTag = new WOHTMLWebObjectTag();
    }

    public WOElement parse() throws WOHelperFunctionDeclarationFormatException, WOHelperFunctionHTMLFormatException, ClassNotFoundException {
        this.parseDeclarations();
        Enumeration e = this.declarations().objectEnumerator();
        while (e.hasMoreElements()) {
            WODeclaration declaration = (WODeclaration)e.nextElement();
            this.processDeclaration(declaration);
        }
        WOElement woelement = this.parseHTML();
        return woelement;
    }

    public void didParseOpeningWebObjectTag(String s, WOHelperFunctionHTMLParser htmlParser) throws WOHelperFunctionHTMLFormatException {
        int spaceIndex;
        int colonIndex;
        if (WOHelperFunctionTagRegistry.allowInlineBindings() && (colonIndex = (spaceIndex = s.indexOf(32)) != -1 ? s.substring(0, spaceIndex).indexOf(58) : s.indexOf(58)) != -1) {
            WODeclaration declaration = this.parseInlineBindings(s, colonIndex);
            s = "<wo name = \"" + declaration.name() + "\"";
        }
        this._currentWebObjectTag = new WOHTMLWebObjectTag(s, this._currentWebObjectTag);
        if (log.isDebugEnabled()) {
            log.debug((Object)("inserted WebObject with Name '" + this._currentWebObjectTag.name() + "'."));
        }
    }

    public void didParseClosingWebObjectTag(String s, WOHelperFunctionHTMLParser htmlParser) throws WOHelperFunctionDeclarationFormatException, WOHelperFunctionHTMLFormatException, ClassNotFoundException {
        WOHTMLWebObjectTag webobjectTag = this._currentWebObjectTag.parentTag();
        if (this._currentWebObjectTag == null || webobjectTag == null) {
            throw new WOHelperFunctionHTMLFormatException("<" + this.getClass().getName() + "> Unbalanced WebObject tags. Either there is an extra closing </WEBOBJECT> tag in the html template, or one of the opening <WEBOBJECT ...> tag has a typo (extra spaces between a < sign and a WEBOBJECT tag ?).");
        }
        try {
            WOElement element = this._currentWebObjectTag.dynamicElement((NSDictionary)this._declarations, this._languages);
            this._currentWebObjectTag = webobjectTag;
            this._currentWebObjectTag.addChildElement(element);
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Unable to load the component named '" + this.componentName(this._currentWebObjectTag) + "' with the declaration " + this.prettyDeclaration((WODeclaration)this._declarations.objectForKey((Object)this._currentWebObjectTag.name())) + ". Make sure the .wo folder is where it's supposed to be and the name is spelled correctly.", e);
        }
    }

    public void didParseComment(String comment, WOHelperFunctionHTMLParser htmlParser) {
        WOHTMLCommentString wohtmlcommentstring = new WOHTMLCommentString(comment);
        this._currentWebObjectTag.addChildElement(wohtmlcommentstring);
    }

    public void didParseText(String text, WOHelperFunctionHTMLParser htmlParser) {
        this._currentWebObjectTag.addChildElement(text);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected WODeclaration parseInlineBindings(String tag, int colonIndex) throws WOHelperFunctionHTMLFormatException {
        String elementName;
        StringBuffer keyBuffer = new StringBuffer();
        StringBuffer valueBuffer = new StringBuffer();
        StringBuffer elementTypeBuffer = new StringBuffer();
        NSMutableDictionary associations = new NSMutableDictionary();
        StringBuffer currentBuffer = elementTypeBuffer;
        boolean changeBuffers = false;
        boolean inQuote = false;
        int length = tag.length();
        for (int index = colonIndex + 1; index < length; ++index) {
            char ch = tag.charAt(index);
            if (!(inQuote || ch != ' ' && ch != '\t' && ch != '\n' && ch != '\r')) {
                changeBuffers = true;
                continue;
            }
            if (!inQuote && ch == '=') {
                changeBuffers = true;
                continue;
            }
            if (inQuote && ch == '\\') {
                if (++index == length) {
                    throw new WOHelperFunctionHTMLFormatException("'" + tag + "' has a '\\' as the last character.");
                }
                if (tag.charAt(index) == '\"') {
                    currentBuffer.append("\"");
                    continue;
                }
                if (tag.charAt(index) == 'n') {
                    currentBuffer.append("\n");
                    continue;
                }
                if (tag.charAt(index) == 'r') {
                    currentBuffer.append("\r");
                    continue;
                }
                if (tag.charAt(index) == 't') {
                    currentBuffer.append("\t");
                    continue;
                }
                currentBuffer.append('\\');
                currentBuffer.append(tag.charAt(index));
                continue;
            }
            if (changeBuffers) {
                if (currentBuffer == elementTypeBuffer) {
                    currentBuffer = keyBuffer;
                } else if (currentBuffer == keyBuffer) {
                    currentBuffer = valueBuffer;
                } else if (currentBuffer == valueBuffer) {
                    this.parseInlineAssociation(keyBuffer, valueBuffer, associations);
                    currentBuffer = keyBuffer;
                }
                currentBuffer.setLength(0);
                changeBuffers = false;
            }
            if (ch == '\"') {
                inQuote = !inQuote;
            }
            currentBuffer.append(ch);
        }
        if (inQuote) {
            throw new WOHelperFunctionHTMLFormatException("'" + tag + "' has a quote left open.");
        }
        if (keyBuffer.length() > 0) {
            if (valueBuffer.length() > 0) {
                this.parseInlineAssociation(keyBuffer, valueBuffer, associations);
            } else {
                throw new WOHelperFunctionHTMLFormatException("'" + tag + "' defines a key but no value.");
            }
        }
        String elementType = elementTypeBuffer.toString();
        String shortcutType = (String)WOHelperFunctionTagRegistry.tagShortcutMap().objectForKey((Object)elementType);
        if (shortcutType != null) {
            elementType = shortcutType;
        } else if (elementType.startsWith(WO_REPLACEMENT_MARKER)) {
            elementType = elementType.replaceAll(WO_REPLACEMENT_MARKER, "");
            associations.setObjectForKey((Object)WOHelperFunctionAssociation.associationWithValue(elementType), (Object)"elementName");
            elementType = "WOGenericContainer";
        }
        WOHelperFunctionParser wOHelperFunctionParser = this;
        synchronized (wOHelperFunctionParser) {
            elementName = "_" + elementType + "_" + this._inlineBindingCount;
            ++this._inlineBindingCount;
        }
        WOTagProcessor tagProcessor = (WOTagProcessor)WOHelperFunctionTagRegistry.tagProcessorMap().objectForKey((Object)elementType);
        WODeclaration declaration = tagProcessor == null ? WOHelperFunctionParser.createDeclaration(elementName, elementType, associations) : tagProcessor.createDeclaration(elementName, elementType, associations);
        this._declarations.setObjectForKey((Object)declaration, (Object)elementName);
        this.processDeclaration(declaration);
        return declaration;
    }

    protected void parseInlineAssociation(StringBuffer keyBuffer, StringBuffer valueBuffer, NSMutableDictionary bindings) throws WOHelperFunctionHTMLFormatException {
        NSDictionary quotedStrings;
        String key = keyBuffer.toString().trim();
        String value = valueBuffer.toString().trim();
        if (value.startsWith("\"")) {
            if (!(value = value.substring(1)).endsWith("\"")) {
                throw new WOHelperFunctionHTMLFormatException(valueBuffer + " starts with quote but does not end with one.");
            }
            value = value.substring(0, value.length() - 1);
            if (value.startsWith("$")) {
                if ((value = value.substring(1)).endsWith("VALID")) {
                    value = value.replaceFirst("\\s*//\\s*VALID", "");
                }
                quotedStrings = new NSDictionary();
            } else {
                value = value.replaceAll("\\\\\\$", "\\$");
                value = value.replaceAll("\\\"", "\"");
                quotedStrings = new NSDictionary((Object)value, (Object)"_WODP_0");
                value = "_WODP_0";
            }
        } else {
            quotedStrings = new NSDictionary();
        }
        WOAssociation association = WOHelperFunctionDeclarationParser._associationWithKey(value, quotedStrings);
        bindings.setObjectForKey((Object)association, (Object)key);
    }

    protected void processDeclaration(WODeclaration declaration) {
        NSMutableDictionary associations = (NSMutableDictionary)declaration.associations();
        Enumeration bindingNameEnum = associations.keyEnumerator();
        while (bindingNameEnum.hasMoreElements()) {
            String bindingName = (String)bindingNameEnum.nextElement();
            WOAssociation association = (WOAssociation)associations.valueForKey(bindingName);
            WOAssociation helperAssociation = this.parserHelperAssociation(association);
            if (helperAssociation == association) continue;
            associations.setObjectForKey((Object)helperAssociation, (Object)bindingName);
        }
        WOOgnl.factory().convertOgnlConstantAssociations(associations);
    }

    protected WOAssociation parserHelperAssociation(WOAssociation originalAssociation) {
        int pipeIndex;
        WOAssociation association = originalAssociation;
        String originalKeyPath = null;
        if (association instanceof WOKeyValueAssociation) {
            WOKeyValueAssociation kvAssociation = (WOKeyValueAssociation)association;
            originalKeyPath = kvAssociation.keyPath();
        }
        if (originalKeyPath != null && (pipeIndex = originalKeyPath.indexOf(124)) != -1) {
            int helperFunctionDotIndex;
            String targetKeyPath = originalKeyPath.substring(0, pipeIndex).trim();
            String frameworkName = "app";
            String helperFunctionName = originalKeyPath.substring(pipeIndex + 1).trim();
            String otherParams = null;
            int openParenIndex = helperFunctionName.indexOf(40);
            if (openParenIndex != -1) {
                int closeParenIndex = helperFunctionName.indexOf(41, openParenIndex + 1);
                otherParams = helperFunctionName.substring(openParenIndex + 1, closeParenIndex);
                helperFunctionName = helperFunctionName.substring(0, openParenIndex);
            }
            if ((helperFunctionDotIndex = helperFunctionName.indexOf(46)) != -1) {
                frameworkName = helperFunctionName.substring(0, helperFunctionDotIndex);
                helperFunctionName = helperFunctionName.substring(helperFunctionDotIndex + 1);
            }
            StringBuffer ognlKeyPath = new StringBuffer();
            ognlKeyPath.append("~");
            ognlKeyPath.append("@" + WOHelperFunctionRegistry.class.getName() + "@registry()._helperInstanceForFrameworkNamed(#this, \"");
            ognlKeyPath.append(helperFunctionName);
            ognlKeyPath.append("\", \"");
            ognlKeyPath.append(targetKeyPath);
            ognlKeyPath.append("\", \"");
            ognlKeyPath.append(frameworkName);
            ognlKeyPath.append("\").");
            ognlKeyPath.append(helperFunctionName);
            ognlKeyPath.append("(");
            ognlKeyPath.append(targetKeyPath);
            if (otherParams != null) {
                ognlKeyPath.append(",");
                ognlKeyPath.append(otherParams);
            }
            ognlKeyPath.append(")");
            if (log.isDebugEnabled()) {
                log.debug((Object)("Converted " + originalKeyPath + " into " + ognlKeyPath));
            }
            association = new WOConstantValueAssociation((Object)ognlKeyPath.toString());
        }
        return association;
    }

    protected String prettyDeclaration(WODeclaration declaration) {
        StringBuffer declarationStr = new StringBuffer();
        if (declaration == null) {
            declarationStr.append("[none]");
        } else {
            declarationStr.append("Component Type = " + declaration.type());
            declarationStr.append(", Bindings = { ");
            Enumeration keyEnum = declaration.associations().keyEnumerator();
            while (keyEnum.hasMoreElements()) {
                String key = (String)keyEnum.nextElement();
                Object assoc = declaration.associations().objectForKey((Object)key);
                if (assoc instanceof WOKeyValueAssociation) {
                    declarationStr.append(key + "=" + ((WOKeyValueAssociation)assoc).keyPath());
                } else if (assoc instanceof WOConstantValueAssociation) {
                    declarationStr.append(key + "='" + ((WOConstantValueAssociation)assoc).valueInComponent(null) + "'");
                } else {
                    declarationStr.append(key + "=" + assoc);
                }
                if (!keyEnum.hasMoreElements()) continue;
                declarationStr.append(", ");
            }
            declarationStr.append(" }");
        }
        return declarationStr.toString();
    }

    private WOElement parseHTML() throws WOHelperFunctionHTMLFormatException, WOHelperFunctionDeclarationFormatException, ClassNotFoundException {
        WOElement currentWebObjectTemplate = null;
        if (this._HTMLString != null && this._declarations != null) {
            WOHelperFunctionHTMLParser htmlParser = new WOHelperFunctionHTMLParser(this, this._HTMLString);
            htmlParser.parseHTML();
            String webobjectTagName = this._currentWebObjectTag.name();
            if (webobjectTagName != null) {
                throw new WOHelperFunctionHTMLFormatException("There is an unbalanced WebObjects tag named '" + webobjectTagName + "'.");
            }
            currentWebObjectTemplate = this._currentWebObjectTag.template();
        }
        return currentWebObjectTemplate;
    }

    protected boolean isInline(WOHTMLWebObjectTag tag) {
        String name = tag.name();
        return name != null && name.startsWith("_") && name.length() > 1 && name.indexOf(95, 1) != -1;
    }

    protected String componentName(WOHTMLWebObjectTag tag) {
        int secondUnderscoreIndex;
        String name = tag.name();
        if (name == null) {
            name = "[none]";
        } else if (this.isInline(tag) && (secondUnderscoreIndex = name.indexOf(95, 1)) != -1) {
            name = name.substring(1, secondUnderscoreIndex);
        }
        return name;
    }

    public String declarationString() {
        return this._declarationString;
    }

    public void setDeclarationString(String value) {
        this._declarationString = value;
    }

    public NSMutableDictionary declarations() {
        return this._declarations;
    }

    public void setDeclarations(NSMutableDictionary value) {
        this._declarations = value;
    }

    private void parseDeclarations() throws WOHelperFunctionDeclarationFormatException {
        if (this._declarations == null && this._declarationString != null) {
            this._declarations = WOHelperFunctionDeclarationParser.declarationsWithString(this._declarationString);
        }
    }

    public static WODeclaration createDeclaration(String declarationName, String declarationType, NSMutableDictionary associations) {
        WODeclaration declaration = new WODeclaration(declarationName, declarationType, (NSDictionary)associations);
        if (_debugSupport && associations != null && associations.objectForKey((Object)"WODebug") == null) {
            Enumeration associationsEnum = associations.keyEnumerator();
            while (associationsEnum.hasMoreElements()) {
                String bindingName = (String)associationsEnum.nextElement();
                WOAssociation association = (WOAssociation)associations.objectForKey((Object)bindingName);
                association.setDebugEnabledForBinding(bindingName, declarationName, declarationType);
                association._setDebuggingEnabled(false);
            }
        }
        return declaration;
    }

    static {
        WO_REPLACEMENT_MARKER = "__REPL__";
    }
}

