/*
 * Decompiled with CFR 0.152.
 */
package er.excel;

import com.webobjects.appserver.WOComponent;
import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WOResponse;
import com.webobjects.foundation.NSData;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSForwardException;
import er.excel.EGSimpleTableParser;
import er.extensions.components.ERXComponentUtilities;
import er.extensions.components.ERXNonSynchronizingComponent;
import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import org.apache.log4j.Logger;

public class EGWrapper
extends ERXNonSynchronizingComponent {
    private static final Logger log = Logger.getLogger(EGWrapper.class);
    private String _fileName;
    private NSDictionary _styles;
    private NSDictionary _fonts;

    public EGWrapper(WOContext context) {
        super(context);
    }

    public boolean isEnabled() {
        return ERXComponentUtilities.booleanValueForBinding((WOComponent)this, (String)"enabled", (boolean)false);
    }

    public String fileName() {
        if (this._fileName == null) {
            this._fileName = (String)this.valueForBinding("fileName");
        }
        return this._fileName;
    }

    public void setFileName(String value) {
        this._fileName = value;
    }

    public NSDictionary styles() {
        if (this._styles == null) {
            this._styles = (NSDictionary)this.valueForBinding("styles");
        }
        return this._styles;
    }

    public void setStyles(NSDictionary value) {
        this._styles = value;
    }

    public NSDictionary fonts() {
        if (this._fonts == null) {
            this._fonts = (NSDictionary)this.valueForBinding("fonts");
        }
        return this._fonts;
    }

    public void setFonts(NSDictionary value) {
        this._fonts = value;
    }

    public void appendToResponse(WOResponse response, WOContext context) {
        if (this.isEnabled()) {
            byte[] bytes;
            WOResponse newResponse = new WOResponse();
            super.appendToResponse(newResponse, context);
            String contentString = newResponse.contentString();
            contentString = contentString.replaceAll("&nbsp;", "");
            if (log.isDebugEnabled()) {
                log.debug((Object)("Converting content string:\n" + contentString));
            }
            try {
                bytes = contentString.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new NSForwardException((Throwable)e, "Can't convert string to UTF-8...you should get a better VM");
            }
            ByteArrayInputStream stream = new ByteArrayInputStream(bytes);
            EGSimpleTableParser parser = new EGSimpleTableParser(stream, this.fonts(), this.styles());
            NSData data = parser.data();
            if (this.hasBinding("data") && this.canSetValueForBinding("data") || this.hasBinding("stream") && this.canSetValueForBinding("stream")) {
                if (this.hasBinding("data")) {
                    this.setValueForBinding(data, "data");
                }
                if (this.hasBinding("stream")) {
                    this.setValueForBinding(data.stream(), "stream");
                }
                response.appendContentString(contentString);
            } else {
                response.appendContentData(data);
                String fileName = this.fileName();
                if (fileName == null) {
                    fileName = "results.xls";
                }
                response.setHeader("inline; filename=\"" + fileName + "\"", "content-disposition");
                response.setHeader("application/vnd.ms-excel", "content-type");
            }
        } else {
            super.appendToResponse(response, context);
        }
    }
}

