/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.javarebel.integration.util;

import java.util.HashMap;
import java.util.Map;

public class MonitorUtil {
    private static final ThreadLocal monitor = new ThreadLocal(){

        protected Object initialValue() {
            return new MonitorHolder();
        }
    };

    private static MonitorHolder getHolder() {
        return (MonitorHolder)monitor.get();
    }

    public static boolean isActive(String id) {
        return MonitorUtil.getHolder().isActive(id);
    }

    public static void enter(String id) {
        MonitorUtil.getHolder().enter(id);
    }

    public static void exit(String id) {
        MonitorUtil.getHolder().exit(id);
    }

    private static class MonitorHolder {
        private Map counters = new HashMap();

        private MonitorHolder() {
        }

        public boolean isActive(String id) {
            Counter counter = (Counter)this.counters.get(id);
            return counter != null && counter.isActive();
        }

        private Counter getCounter(String id) {
            Counter counter = (Counter)this.counters.get(id);
            if (counter == null) {
                counter = new Counter();
                this.counters.put(id, counter);
            }
            return counter;
        }

        public void enter(String id) {
            this.getCounter(id).enter();
        }

        public void exit(String id) {
            this.getCounter(id).exit();
        }
    }

    private static class Counter {
        private int value = 0;

        private Counter() {
        }

        public boolean isActive() {
            return this.value > 0;
        }

        public void enter() {
            ++this.value;
        }

        public void exit() {
            --this.value;
        }
    }
}

