/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.javarebel.integration.util;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.util.Map;
import java.util.WeakHashMap;
import org.zeroturnaround.bundled.javassist.util.proxy.MethodHandler;
import org.zeroturnaround.bundled.javassist.util.proxy.ProxyFactory;
import org.zeroturnaround.bundled.javassist.util.proxy.ProxyObject;
import org.zeroturnaround.javarebel.Logger;
import org.zeroturnaround.javarebel.LoggerFactory;
import org.zeroturnaround.javarebel.integration.generic.Nop;
import org.zeroturnaround.javarebel.integration.generic.NopConstructorCBP;
import org.zeroturnaround.javarebel.integration.util.MiscUtil;

public class ProxyUtil {
    private static final Logger log = LoggerFactory.getInstance();
    private static final Map proxyClasses = new WeakHashMap();

    public static Object createProxy(Class klass, MethodHandler handler) throws Throwable {
        try {
            Class proxy = ProxyUtil._createProxyClass(klass);
            Constructor c = proxy.getConstructor(Nop.class);
            Object result = c.newInstance(new Object[]{null});
            ((ProxyObject)result).setHandler(handler);
            return result;
        }
        catch (Throwable t) {
            String msg = "Could not create proxy instnace of " + MiscUtil.identityToString(klass);
            if (t instanceof NoSuchMethodException) {
                msg = msg + ": The class must be processed by " + NopConstructorCBP.class.getName();
            }
            log.echoPrefix(msg);
            log.errorEcho(t);
            throw t;
        }
    }

    public static synchronized Class _createProxyClass(Class klass) {
        Class result;
        Reference ref = (Reference)proxyClasses.get(klass);
        if (ref != null && (result = (Class)ref.get()) != null) {
            if (log.isTraceEnabled()) {
                log.trace("ProxyUtil: Using existing proxy class " + MiscUtil.identityToString(result) + " for " + MiscUtil.identityToString(klass));
            }
            return result;
        }
        ProxyFactory factory = new ProxyFactory();
        factory.setSuperclass(klass);
        result = factory.createClass();
        if (log.isEnabled()) {
            log.log("ProxyUtil: Created proxy class " + MiscUtil.identityToString(result) + " for " + MiscUtil.identityToString(klass));
        }
        proxyClasses.put(klass, new WeakReference<Class>(result));
        return result;
    }
}

