/*
 * Decompiled with CFR 0.152.
 */
package er.imadaptor;

import er.imadaptor.IInstantMessenger;
import er.imadaptor.IMConnectionException;
import er.imadaptor.IMessageListener;
import er.imadaptor.MessageException;

public class IMConnectionTester
implements Runnable,
IMessageListener {
    private static final String PING_MESSAGE = "~Ping~";
    private static final String PONG_MESSAGE = "~Pong~";
    private IInstantMessenger _watcher;
    private IInstantMessenger _watched;
    private Object _pingPongMessageLock = new Object();
    private int _failureCount;
    private boolean _pinged;
    private boolean _ponged;
    private long _pingPongFrequencyMillis;
    private long _timeoutMillis;
    private long _lastConnectionAttempt;
    private boolean _running = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IMConnectionTester(IInstantMessenger watcher, IInstantMessenger watched, long pingPongFrequencyMillis, long timeoutMillis) {
        this._watcher = watcher;
        this._watched = watched;
        this._pingPongFrequencyMillis = pingPongFrequencyMillis;
        this._timeoutMillis = timeoutMillis;
        Object object = this._pingPongMessageLock;
        synchronized (object) {
            this._watched.addMessageListener(this);
            this._watcher.addMessageListener(this);
        }
    }

    public void stop() {
        this._running = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageReceived(IInstantMessenger instantMessenger, String buddyName, String message) {
        System.out.println("IMConnectionTester.messageReceived: " + buddyName + ", " + message);
        if (instantMessenger == this._watched && this._watcher.getScreenName().equals(buddyName) && PING_MESSAGE.equals(message)) {
            Object object = this._pingPongMessageLock;
            synchronized (object) {
                try {
                    System.out.println("IMConnectionTester.testConnection: Sending PONG to " + this._watcher.getScreenName());
                    this._watched.sendMessage(buddyName, PONG_MESSAGE, false);
                }
                catch (MessageException e) {
                    e.printStackTrace();
                }
            }
        }
        if (instantMessenger == this._watcher && this._watched.getScreenName().equals(buddyName) && PONG_MESSAGE.equals(message)) {
            Object object = this._pingPongMessageLock;
            synchronized (object) {
                this._ponged = true;
                System.out.println("IMConnectionTester.testConnection: Recevied PONG from " + this._watched.getScreenName());
                this._pingPongMessageLock.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void testConnection() throws IMConnectionException {
        if (this._running && !this._watched.isConnected()) {
            this._watched.connect();
            this._failureCount = 0;
        }
        if (this._running && !this._watcher.isConnected()) {
            this._watcher.connect();
            this._failureCount = 0;
        }
        Object object = this._pingPongMessageLock;
        synchronized (object) {
            try {
                System.out.println("IMConnectionTester.testConnection: Sending PING to " + this._watched.getScreenName());
                this._watcher.sendMessage(this._watched.getScreenName(), PING_MESSAGE, false);
                this._ponged = false;
                this._pingPongMessageLock.wait(this._timeoutMillis);
                if (!this._ponged) {
                    System.out.println("IMConnectionTester.testConnection: " + this._watcher.getScreenName() + " did not respond to PING");
                    ++this._failureCount;
                    if (this._running && this._failureCount > 5) {
                        System.out.println("IMConnectionTester.reconnect: Reconnecting " + this._watched.getScreenName());
                        this._watched.connect();
                        this._failureCount = 0;
                    }
                }
            }
            catch (MessageException e) {
                e.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                this._pinged = false;
                this._ponged = false;
            }
        }
    }

    public void run() {
        while (this._running) {
            try {
                Thread.sleep(this._pingPongFrequencyMillis);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            if (!this._running) continue;
            try {
                this.testConnection();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }
}

