/*
 * Decompiled with CFR 0.152.
 */
package er.imadaptor;

import er.imadaptor.AbstractInstantMessenger;
import er.imadaptor.BuddyOfflineException;
import er.imadaptor.ConnectedTooFastException;
import er.imadaptor.IInstantMessenger;
import er.imadaptor.IInstantMessengerFactory;
import er.imadaptor.IMConnectionException;
import er.imadaptor.MessageException;
import java.beans.PropertyChangeEvent;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.kano.joustsim.Screenname;
import net.kano.joustsim.oscar.AimConnection;
import net.kano.joustsim.oscar.AimConnectionProperties;
import net.kano.joustsim.oscar.AimSession;
import net.kano.joustsim.oscar.BuddyInfo;
import net.kano.joustsim.oscar.BuddyInfoManager;
import net.kano.joustsim.oscar.DefaultAimSession;
import net.kano.joustsim.oscar.GlobalBuddyInfoListener;
import net.kano.joustsim.oscar.State;
import net.kano.joustsim.oscar.StateEvent;
import net.kano.joustsim.oscar.StateListener;
import net.kano.joustsim.oscar.oscar.service.icbm.Conversation;
import net.kano.joustsim.oscar.oscar.service.icbm.ConversationEventInfo;
import net.kano.joustsim.oscar.oscar.service.icbm.ConversationListener;
import net.kano.joustsim.oscar.oscar.service.icbm.IcbmBuddyInfo;
import net.kano.joustsim.oscar.oscar.service.icbm.IcbmListener;
import net.kano.joustsim.oscar.oscar.service.icbm.IcbmService;
import net.kano.joustsim.oscar.oscar.service.icbm.ImConversation;
import net.kano.joustsim.oscar.oscar.service.icbm.Message;
import net.kano.joustsim.oscar.oscar.service.icbm.MessageInfo;
import net.kano.joustsim.oscar.oscar.service.icbm.SimpleMessage;
import net.kano.joustsim.oscar.oscar.service.ssi.Buddy;
import net.kano.joustsim.oscar.oscar.service.ssi.MutableBuddy;
import net.kano.joustsim.oscar.oscar.service.ssi.MutableBuddyList;
import net.kano.joustsim.oscar.oscar.service.ssi.MutableGroup;
import net.kano.joustsim.oscar.oscar.service.ssi.SsiService;

public class JOscarInstantMessenger
extends AbstractInstantMessenger {
    private AimSession _aimSession;
    private AimConnection _conn;
    private IcbmHandler _icbmHandler = new IcbmHandler();
    private ConversationHandler _conversationHandler = new ConversationHandler();
    private boolean _connected;
    private long _lastConnectionAttempt;
    private long _lastBuddyListChange;

    public JOscarInstantMessenger(String screenName, String password) {
        super(screenName, password);
    }

    public long buddyListLastModified() {
        return this._lastBuddyListChange;
    }

    protected void buddyListModified() {
        this._lastBuddyListChange = System.currentTimeMillis();
    }

    public synchronized boolean isBuddyOnline(String buddyName) {
        boolean buddyOnline = false;
        BuddyInfo buddyInfo = this._addBuddyIfNecessary(buddyName);
        if (buddyInfo != null) {
            buddyOnline = buddyInfo.isOnline();
        }
        return buddyOnline;
    }

    public synchronized boolean isBuddyAway(String buddyName) {
        boolean buddyAway = false;
        BuddyInfo buddyInfo = this._addBuddyIfNecessary(buddyName);
        if (buddyInfo != null) {
            buddyAway = buddyInfo.isAway();
        }
        return buddyAway;
    }

    public synchronized String getStatusMessage(String buddyName) {
        String statusMessage = null;
        BuddyInfo buddyInfo = this._addBuddyIfNecessary(buddyName);
        if (buddyInfo != null) {
            statusMessage = buddyInfo.getStatusMessage();
        }
        return statusMessage;
    }

    public synchronized String getAwayMessage(String buddyName) {
        String awayMessage = null;
        BuddyInfo buddyInfo = this._addBuddyIfNecessary(buddyName);
        if (buddyInfo != null) {
            awayMessage = buddyInfo.getAwayMessage();
        }
        return awayMessage;
    }

    public String[] getGroupNames() {
        String[] groupNames;
        if (this._connected && this._conn != null) {
            BuddyInfoManager buddyInfoManager = this._conn.getBuddyInfoManager();
            SsiService ssiService = this._conn.getSsiService();
            MutableBuddyList buddyList = ssiService.getBuddyList();
            List groupsList = buddyList.getGroups();
            groupNames = new String[groupsList.size()];
            int groupNum = 0;
            for (MutableGroup group : groupsList) {
                groupNames[groupNum++] = group.getName();
            }
        } else {
            groupNames = new String[]{};
        }
        return groupNames;
    }

    public String[] getBuddiesInGroupNamed(String groupName) {
        String[] buddyNames = null;
        if (this._connected && this._conn != null) {
            BuddyInfoManager buddyInfoManager = this._conn.getBuddyInfoManager();
            SsiService ssiService = this._conn.getSsiService();
            MutableBuddyList buddyList = ssiService.getBuddyList();
            List groupsList = buddyList.getGroups();
            for (MutableGroup group : groupsList) {
                if (!groupName.equals(group.getName())) continue;
                List buddies = group.getBuddiesCopy();
                buddyNames = new String[buddies.size()];
                int buddyNum = 0;
                for (MutableBuddy buddy : buddies) {
                    buddyNames[buddyNum++] = buddy.getScreenname().getNormal();
                }
            }
        }
        if (buddyNames == null) {
            buddyNames = new String[]{};
        }
        return buddyNames;
    }

    public void removeBuddy(String buddyName) {
        if (this._connected && this._conn != null) {
            Screenname buddyScreenName = new Screenname(buddyName);
            BuddyInfoManager buddyInfoManager = this._conn.getBuddyInfoManager();
            SsiService ssiService = this._conn.getSsiService();
            MutableBuddyList buddyList = ssiService.getBuddyList();
            List groups = buddyList.getGroups();
            for (MutableGroup group : groups) {
                Buddy matchingBuddy = null;
                Iterator buddiesIter = group.getBuddiesCopy().iterator();
                while (matchingBuddy == null && buddiesIter.hasNext()) {
                    Buddy buddy = (Buddy)buddiesIter.next();
                    if (!buddy.getScreenname().equals((Object)buddyScreenName)) continue;
                    matchingBuddy = buddy;
                }
                if (matchingBuddy == null) continue;
                group.deleteBuddy(matchingBuddy);
            }
        }
    }

    public void addBuddy(String buddyName) {
        this._addBuddyIfNecessary(buddyName);
    }

    public BuddyInfo _addBuddyIfNecessary(String buddyName) {
        BuddyInfo buddyInfo = null;
        if (this._connected && this._conn != null) {
            Screenname buddy = new Screenname(buddyName);
            BuddyInfoManager buddyInfoManager = this._conn.getBuddyInfoManager();
            buddyInfo = buddyInfoManager.getBuddyInfo(buddy);
            boolean isOnBuddyList = false;
            if (buddyInfo != null) {
                isOnBuddyList = buddyInfo.isOnBuddyList();
            }
            if (!isOnBuddyList) {
                SsiService ssiService = this._conn.getSsiService();
                MutableBuddyList buddyList = ssiService.getBuddyList();
                List groups = buddyList.getGroups();
                if (groups.size() == 0) {
                    buddyList.addGroup("Buddies");
                    groups = buddyList.getGroups();
                }
                MutableGroup group = (MutableGroup)groups.get(0);
                group.addBuddy(buddyName);
                for (int attempt = 0; attempt < 10 && !buddyInfo.isOnBuddyList(); ++attempt) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                    buddyInfo = buddyInfoManager.getBuddyInfo(buddy);
                }
            }
        }
        return buddyInfo;
    }

    public synchronized void connect() throws IMConnectionException {
        boolean wasConnected = this._connected;
        if (wasConnected || this._conn != null) {
            this.disconnect();
        }
        long now = System.currentTimeMillis();
        if (!wasConnected && now - this._lastConnectionAttempt <= 900000L) {
            throw new ConnectedTooFastException("You attempted to connect repeatedly too quickly.");
        }
        this._lastConnectionAttempt = now;
        Screenname sn = new Screenname(this.getScreenName());
        this._aimSession = new DefaultAimSession(sn);
        AimConnectionProperties props = new AimConnectionProperties(sn, this.getPassword());
        AimConnection conn = this._aimSession.openConnection(props);
        conn.addStateListener((StateListener)new AimStateHandler());
        conn.connect();
    }

    public synchronized void disconnect() {
        if (this._connected) {
            if (this._conn != null) {
                this._conn.disconnect();
                this._conn = null;
                this._aimSession = null;
            }
            this._connected = false;
        }
    }

    public synchronized boolean isConnected() {
        return this._connected;
    }

    public synchronized void sendMessage(String buddyName, String message, boolean ignoreIfOffline) throws MessageException {
        BuddyInfo buddyInfo;
        if (message != null && (buddyInfo = this._addBuddyIfNecessary(buddyName)) != null) {
            if (!buddyInfo.isOnline()) {
                if (!ignoreIfOffline) {
                    throw new BuddyOfflineException("The buddy '" + buddyName + "' is not online.");
                }
            } else {
                if (message.length() > 2048) {
                    message = message.substring(0, 2048);
                }
                ImConversation conv = this._conn.getIcbmService().getImConversation(buddyInfo.getScreenname());
                conv.open();
                conv.sendMessage((Message)new SimpleMessage(message));
            }
        }
    }

    public static class Factory
    implements IInstantMessengerFactory {
        public IInstantMessenger createInstantMessenger(String screenName, String password) {
            return new JOscarInstantMessenger(screenName, password);
        }
    }

    protected class ConversationHandler
    implements ConversationListener {
        protected ConversationHandler() {
        }

        public void canSendMessageChanged(Conversation c, boolean canSend) {
        }

        public void conversationClosed(Conversation c) {
        }

        public void conversationOpened(Conversation c) {
        }

        public void gotMessage(Conversation c, MessageInfo minfo) {
            JOscarInstantMessenger.this.fireMessageReceived(minfo.getFrom().getNormal(), minfo.getMessage().getMessageBody());
        }

        public void gotOtherEvent(Conversation conversation, ConversationEventInfo event) {
        }

        public void sentMessage(Conversation c, MessageInfo minfo) {
        }

        public void sentOtherEvent(Conversation conversation, ConversationEventInfo event) {
        }
    }

    protected class IcbmHandler
    implements IcbmListener {
        protected IcbmHandler() {
        }

        public void buddyInfoUpdated(IcbmService service, Screenname sn, IcbmBuddyInfo buddyInfo) {
            JOscarInstantMessenger.this.buddyListModified();
        }

        public void newConversation(IcbmService service, Conversation conv) {
            conv.addConversationListener((ConversationListener)JOscarInstantMessenger.this._conversationHandler);
        }

        public void sendAutomaticallyFailed(IcbmService service, Message message, Set conversations) {
        }
    }

    protected class BuddyChangeListener
    implements GlobalBuddyInfoListener {
        protected BuddyChangeListener() {
        }

        public void buddyInfoChanged(BuddyInfoManager buddyinfomanager, Screenname screenname, BuddyInfo buddyinfo, PropertyChangeEvent propertychangeevent) {
            JOscarInstantMessenger.this.buddyListModified();
        }

        public void newBuddyInfo(BuddyInfoManager buddyinfomanager, Screenname screenname, BuddyInfo buddyinfo) {
            JOscarInstantMessenger.this.buddyListModified();
        }

        public void receivedStatusUpdate(BuddyInfoManager buddyinfomanager, Screenname screenname, BuddyInfo buddyinfo) {
            JOscarInstantMessenger.this.buddyListModified();
        }
    }

    protected class AimStateHandler
    implements StateListener {
        protected AimStateHandler() {
        }

        public void handleStateChange(StateEvent event) {
            State state = event.getNewState();
            if (state == State.ONLINE) {
                JOscarInstantMessenger.this._conn = event.getAimConnection();
                JOscarInstantMessenger.this._conn.getBuddyInfoManager().addGlobalBuddyInfoListener((GlobalBuddyInfoListener)new BuddyChangeListener());
                IcbmService icbmService = JOscarInstantMessenger.this._conn.getIcbmService();
                icbmService.addIcbmListener((IcbmListener)JOscarInstantMessenger.this._icbmHandler);
                JOscarInstantMessenger.this._connected = true;
            } else {
                AimConnection conn = event.getAimConnection();
                IcbmService icbmService = conn.getIcbmService();
                if (icbmService != null) {
                    icbmService.removeIcbmListener((IcbmListener)JOscarInstantMessenger.this._icbmHandler);
                }
                JOscarInstantMessenger.this._connected = false;
            }
        }
    }
}

