/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.jdbcadaptor;

import com.webobjects.eoaccess.EOAttribute;
import com.webobjects.eoaccess.EOEntity;
import com.webobjects.eoaccess.EOSQLExpression;
import com.webobjects.eocontrol.EOFetchSpecification;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.jdbcadaptor.JDBCAdaptor;
import com.webobjects.jdbcadaptor.JDBCAdaptorException;

public class JDBCExpression
extends EOSQLExpression {
    protected boolean _inSelect = false;
    protected String _externalQuoteChar = "";
    protected String _rtrimFunctionName = "RTRIM";
    protected NSDictionary _jdbcInfo;

    public JDBCExpression(EOEntity eOEntity) {
        super(eOEntity);
    }

    public boolean useBindVariables() {
        return true;
    }

    public boolean shouldUseBindVariableForAttribute(EOAttribute eOAttribute) {
        return true;
    }

    public boolean mustUseBindVariableForAttribute(EOAttribute eOAttribute) {
        return true;
    }

    protected NSDictionary jdbcInfo() {
        return this._jdbcInfo == null ? NSDictionary.EmptyDictionary : this._jdbcInfo;
    }

    protected void setJDBCInfo(NSDictionary nSDictionary) {
        this._jdbcInfo = nSDictionary;
    }

    public String externalNameQuoteCharacter() {
        if (this._externalQuoteChar == null) {
            this._externalQuoteChar = (String)this.jdbcInfo().objectForKey((Object)"IDENTIFIER_QUOTE_STRING");
            if (this._externalQuoteChar == null) {
                this._externalQuoteChar = "";
            }
        }
        return this._externalQuoteChar;
    }

    public String lockClause() {
        return "FOR UPDATE";
    }

    public NSMutableDictionary bindVariableDictionaryForAttribute(EOAttribute eOAttribute, Object object) {
        Object[] objectArray = new Object[]{"BindVariableName", "BindVariablePlaceholder", "BindVariableAttribute", "BindVariableValue"};
        Object[] objectArray2 = new Object[]{eOAttribute.name(), "?", eOAttribute, object};
        NSMutableDictionary nSMutableDictionary = new NSMutableDictionary(objectArray2, objectArray);
        objectArray = null;
        objectArray2 = null;
        return nSMutableDictionary;
    }

    public String formatValueForAttribute(Object object, EOAttribute eOAttribute) {
        return "NULL";
    }

    public void prepareSelectExpressionWithAttributes(NSArray nSArray, boolean bl, EOFetchSpecification eOFetchSpecification) {
        this._inSelect = true;
        super.prepareSelectExpressionWithAttributes(nSArray, bl, eOFetchSpecification);
        this._inSelect = false;
    }

    public String columnTypeStringForAttribute(EOAttribute eOAttribute) {
        int n;
        NSDictionary nSDictionary;
        String string = eOAttribute.externalType();
        NSDictionary nSDictionary2 = (NSDictionary)this.jdbcInfo().objectForKey((Object)"typeInfo");
        if (nSDictionary2 == null) {
            nSDictionary2 = JDBCAdaptor.typeInfoForModel(((EOEntity)eOAttribute.parent()).model());
        }
        if ((nSDictionary = (NSDictionary)nSDictionary2.objectForKey((Object)string)) == null) {
            nSDictionary = (NSDictionary)nSDictionary2.objectForKey((Object)string.toUpperCase());
        }
        if (nSDictionary == null) {
            throw new JDBCAdaptorException("Unable to find type information for external type '" + string + "' in attribute '" + eOAttribute.name() + "' of entity '" + ((EOEntity)eOAttribute.parent()).name() + "'.  Check spelling and capitalization.", null);
        }
        try {
            n = Integer.parseInt((String)nSDictionary.objectForKey((Object)"createParams"));
        }
        catch (NumberFormatException numberFormatException) {
            n = 0;
        }
        switch (n) {
            case 2: {
                int n2 = eOAttribute.precision();
                if (n2 == 0) {
                    return eOAttribute.externalType();
                }
                int n3 = eOAttribute.scale();
                if (n3 == 0) {
                    return eOAttribute.externalType() + "(" + n2 + ")";
                }
                return eOAttribute.externalType() + "(" + n2 + "," + n3 + ")";
            }
            case 1: {
                int n4 = eOAttribute.width();
                if (n4 == 0) {
                    n4 = eOAttribute.precision();
                }
                if (n4 == 0) {
                    return eOAttribute.externalType();
                }
                return eOAttribute.externalType() + "(" + n4 + ")";
            }
        }
        return eOAttribute.externalType();
    }

    public String allowsNullClauseForConstraint(boolean bl) {
        if (bl) {
            return "";
        }
        Object object = this.jdbcInfo().objectForKey((Object)"NON_NULLABLE_COLUMNS");
        if (object != null && object.equals("T")) {
            return "NOT NULL";
        }
        return "";
    }

    protected void appendItemToListString(String string) {
        this.appendItemToListString(string, this._listString());
    }

    protected void appendItemToOrderByString(String string) {
        this.appendItemToListString(string, this._orderByString());
    }

    protected void appendItemToValueListString(String string) {
        this.appendItemToListString(string, this._valueList());
    }

    public void addSelectListAttribute(EOAttribute eOAttribute) {
        String string;
        String string2 = this.sqlStringForAttribute(eOAttribute);
        String string3 = this.formatSQLString(string2, eOAttribute.readFormat());
        if (string3 == string2 && this._rtrimFunctionName != null && (string = eOAttribute.valueType()) != null && string.length() == 1 && string.charAt(0) == 'c' && eOAttribute.adaptorValueType() == 1) {
            StringBuffer stringBuffer = new StringBuffer(string3.length() + this._rtrimFunctionName.length() + 2);
            stringBuffer.append(this._rtrimFunctionName);
            stringBuffer.append('(');
            stringBuffer.append(string3);
            stringBuffer.append(')');
            string3 = stringBuffer.toString();
        }
        this.appendItemToListString(string3);
    }
}

