/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.jdbcadaptor;

import com.webobjects.eoaccess.EOAdaptor;
import com.webobjects.eoaccess.EOAttribute;
import com.webobjects.eoaccess.EOEntity;
import com.webobjects.eoaccess.EORelationship;
import com.webobjects.eoaccess.EOSQLExpression;
import com.webobjects.eoaccess.EOSQLExpressionFactory;
import com.webobjects.eoaccess.EOStoredProcedure;
import com.webobjects.eoaccess.EOSynchronizationFactory;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSKeyValueCoding;
import com.webobjects.foundation.NSLog;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSProperties;
import com.webobjects.foundation._NSUtilities;
import com.webobjects.jdbcadaptor.JDBCAdaptor;
import com.webobjects.jdbcadaptor.JDBCAdaptorException;
import com.webobjects.jdbcadaptor.JDBCChannel;
import com.webobjects.jdbcadaptor.JDBCContext;
import com.webobjects.jdbcadaptor.JDBCExpression;
import com.webobjects.jdbcadaptor.JDBCExpressionFactory;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;

public class JDBCPlugIn {
    protected JDBCAdaptor _adaptor;
    protected Class _expressionClass;
    protected EOSQLExpressionFactory _expressionFactory;
    protected EOSynchronizationFactory _syncFactory;
    protected static NSMutableDictionary _subprotocolRegistry = new NSMutableDictionary();
    protected String _pkTableName = "EO_PK_TABLE";
    static final String DefaultPlugInPackagePrefix = "com.webobjects.jdbcadaptor.";
    protected static final String DefaultPlugInSuffix = "PlugIn";
    protected static final String DefaultPlugInClassName = "com.webobjects.jdbcadaptor.JDBCPlugIn";
    static final String[] _defaultTableTypes;

    public JDBCPlugIn(JDBCAdaptor jDBCAdaptor) {
        this._adaptor = jDBCAdaptor;
    }

    public JDBCAdaptor adaptor() {
        return this._adaptor;
    }

    public String connectionURL() {
        return this.adaptor().connectionDictionaryURL();
    }

    public Properties connectionPropertiesForConnectionDictionary(NSDictionary nSDictionary) {
        Properties properties = new Properties();
        properties.put("user", this.adaptor().username());
        properties.put("password", this.adaptor().password());
        return properties;
    }

    private static String _urlSubprotocol(String string) {
        int n = string.indexOf(58);
        if (n == -1) {
            return null;
        }
        int n2 = string.indexOf(58, n + 1);
        if (n2 == -1) {
            return null;
        }
        return string.substring(n + 1, n2).toLowerCase();
    }

    public static void setPlugInNameForSubprotocol(String string, String string2) {
        _subprotocolRegistry.setObjectForKey((Object)string, (Object)string2.toLowerCase());
    }

    public static void removePlugInNameForSubprotocol(String string) {
        _subprotocolRegistry.removeObjectForKey((Object)string.toLowerCase());
    }

    public static String plugInNameForURL(String string) {
        String string2 = JDBCPlugIn._urlSubprotocol(string);
        if (string2 == null) {
            return DefaultPlugInClassName;
        }
        String string3 = (String)_subprotocolRegistry.objectForKey((Object)string2);
        if (string3 == null) {
            string3 = DefaultPlugInPackagePrefix + string2.substring(0, 1).toUpperCase() + string2.substring(1) + DefaultPlugInSuffix;
        }
        return string3;
    }

    public String databaseProductName() {
        return null;
    }

    public String defaultDriverName() {
        return null;
    }

    public NSDictionary databaseInformation() {
        return null;
    }

    public Class defaultExpressionClass() {
        return JDBCExpression.class;
    }

    public EOSQLExpressionFactory createExpressionFactory() {
        return new JDBCExpressionFactory(this.adaptor());
    }

    public EOSQLExpressionFactory expressionFactory() {
        if (this._expressionFactory == null) {
            this._expressionFactory = this.createExpressionFactory();
        }
        return this._expressionFactory;
    }

    public EOSynchronizationFactory createSynchronizationFactory() {
        return new EOSynchronizationFactory((EOAdaptor)this._adaptor);
    }

    public EOSynchronizationFactory synchronizationFactory() {
        if (this._syncFactory == null) {
            this._syncFactory = this.createSynchronizationFactory();
        }
        return this._syncFactory;
    }

    public String primaryKeyTableName() {
        return this._pkTableName;
    }

    public String wildcardPatternForAttributes() {
        return "%";
    }

    public String wildcardPatternForTables() {
        return "%";
    }

    public String wildcardPatternForSchema() {
        return null;
    }

    public String schemaNameForEntity(EOEntity eOEntity) {
        String string = eOEntity.externalName();
        if (string == null) {
            return null;
        }
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return null;
        }
        return string.substring(0, n);
    }

    String _tableNameForEntity(EOEntity eOEntity) {
        String string = eOEntity.externalName();
        int n = string.indexOf(46);
        if (n >= 0) {
            string = string.substring(n + 1);
        }
        return string;
    }

    public String[] tableTypes() {
        return _defaultTableTypes;
    }

    public String sqlStatementForGettingTableNames() {
        return null;
    }

    public boolean canDescribeStoredProcedure(String string) {
        return false;
    }

    public EOStoredProcedure storedProcedureNamed(String string, JDBCChannel jDBCChannel, NSDictionary nSDictionary) {
        return null;
    }

    public String sqlStatementForGettingProcedureNames() {
        return null;
    }

    public String storedProcedureCatalogPattern() {
        return null;
    }

    public String storedProcedureSchemaPattern() {
        return null;
    }

    public String sqlStatementForTableNamed(String string) {
        return null;
    }

    public EOAttribute createAttributeForRow(NSDictionary nSDictionary) {
        return null;
    }

    EOEntity _rootParent(EOEntity eOEntity) {
        EOEntity eOEntity2;
        EOEntity eOEntity3 = eOEntity;
        while ((eOEntity2 = eOEntity3.parentEntity()) != null) {
            eOEntity3 = eOEntity2;
        }
        return eOEntity3;
    }

    public String newPrimaryKeySelectString(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append("SELECT PK FROM ");
        stringBuffer.append(string);
        stringBuffer.append(" WHERE NAME = '");
        stringBuffer.append(string2);
        stringBuffer.append("' FOR UPDATE");
        return new String(stringBuffer);
    }

    public String primaryKeyLockString(String string, String string2) {
        return null;
    }

    public NSArray newPrimaryKeys(int n, EOEntity eOEntity, JDBCChannel jDBCChannel) {
        NSMutableDictionary nSMutableDictionary;
        Number number;
        Object object;
        NSArray nSArray = eOEntity.primaryKeyAttributes();
        NSArray nSArray2 = null;
        Number number2 = null;
        boolean bl = false;
        String string = eOEntity.primaryKeyRootName();
        boolean bl2 = NSLog.debugLoggingAllowedForLevelAndGroups((int)2, (long)65536L);
        if (nSArray.count() != 1) {
            return null;
        }
        EOAttribute eOAttribute = (EOAttribute)nSArray.objectAtIndex(0);
        String string2 = eOAttribute.name();
        if (eOAttribute.adaptorValueType() != 0) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(128);
        String string3 = this.primaryKeyTableName();
        String string4 = this.primaryKeyLockString(string3, string);
        EOSQLExpression eOSQLExpression = null;
        if (string4 != null) {
            eOSQLExpression = this.expressionFactory().expressionForString(string4);
        }
        EOSQLExpression eOSQLExpression2 = this.expressionFactory().expressionForString(this.newPrimaryKeySelectString(string3, string));
        JDBCContext jDBCContext = (JDBCContext)jDBCChannel.adaptorContext();
        jDBCContext.beginTransaction();
        try {
            if (bl2) {
                NSLog.debug.appendln((Object)("finding primary key value for " + string));
            }
            if (eOSQLExpression != null) {
                jDBCChannel.evaluateExpression(eOSQLExpression);
            }
            jDBCChannel.evaluateExpression(eOSQLExpression2);
            nSArray2 = jDBCChannel._fetchOrderedRow(false);
            jDBCChannel.cancelFetch();
        }
        catch (JDBCAdaptorException jDBCAdaptorException) {
            if (bl2) {
                NSLog.err.appendln((Object)("unable to find primary key value for " + string));
                NSLog.err.appendln((Throwable)((Object)jDBCAdaptorException));
            }
            jDBCChannel.cancelFetch();
            jDBCContext.rollbackTransaction();
            bl = true;
            nSArray2 = null;
        }
        if (bl) {
            JDBCAdaptor jDBCAdaptor = (JDBCAdaptor)jDBCContext.adaptor();
            String string5 = jDBCAdaptor.externalTypeForJDBCType(1);
            if (string5 == null) {
                string5 = jDBCAdaptor.externalTypeForJDBCType(12);
            }
            if (string5 == null) {
                string5 = "CHAR";
            }
            stringBuffer.setLength(0);
            stringBuffer.append("CREATE TABLE ");
            stringBuffer.append(string3);
            stringBuffer.append(" (NAME ");
            stringBuffer.append(string5);
            stringBuffer.append("(40), PK ");
            stringBuffer.append(eOSQLExpression2.columnTypeStringForAttribute(eOAttribute));
            stringBuffer.append(')');
            object = this.expressionFactory().expressionForString(new String(stringBuffer));
            try {
                if (bl2) {
                    NSLog.debug.appendln((Object)"creating primary key value table");
                }
                jDBCChannel.evaluateExpression((EOSQLExpression)object);
                jDBCContext.beginTransaction();
                if (eOSQLExpression != null) {
                    jDBCChannel.evaluateExpression(eOSQLExpression);
                }
            }
            catch (JDBCAdaptorException jDBCAdaptorException) {
                if (bl2) {
                    NSLog.err.appendln((Object)"unable to create primary key value table");
                    NSLog.err.appendln((Throwable)((Object)jDBCAdaptorException));
                }
                jDBCContext.rollbackTransaction();
                return null;
            }
        }
        if (nSArray2 != null) {
            object = nSArray2.objectAtIndex(0);
            number = object == NSKeyValueCoding.NullValue ? (Number)new Integer(0) : (Number)((Number)object);
        } else {
            stringBuffer.setLength(0);
            stringBuffer.append("INSERT INTO ");
            stringBuffer.append(string3);
            stringBuffer.append("(NAME, PK) VALUES ( '");
            stringBuffer.append(string);
            stringBuffer.append("', 0 )");
            object = this.expressionFactory().expressionForString(new String(stringBuffer));
            try {
                if (bl2) {
                    NSLog.debug.appendln((Object)("setting initial primary key value for " + string));
                }
                jDBCChannel.evaluateExpression((EOSQLExpression)object);
            }
            catch (JDBCAdaptorException jDBCAdaptorException) {
                if (bl2) {
                    NSLog.err.appendln((Object)("unable to set initial primary key value for " + string));
                    NSLog.err.appendln((Throwable)((Object)jDBCAdaptorException));
                }
                jDBCContext.rollbackTransaction();
                return null;
            }
            number = new Integer(0);
        }
        if (number.intValue() == 0) {
            object = jDBCChannel._entityGroupForEntity(this._rootParent(eOEntity));
            number2 = new Integer(0);
            int n2 = object.count();
            for (int i = 0; i < n2; ++i) {
                Number number3;
                Object object2;
                EOEntity eOEntity2 = (EOEntity)object.objectAtIndex(i);
                EOAttribute eOAttribute2 = eOEntity2.attributeNamed(string2);
                stringBuffer.setLength(0);
                stringBuffer.append("SELECT MAX(");
                stringBuffer.append(eOAttribute2.columnName());
                stringBuffer.append(") FROM ");
                stringBuffer.append(eOEntity2.externalName());
                EOSQLExpression eOSQLExpression3 = this.expressionFactory().expressionForString(new String(stringBuffer));
                try {
                    if (bl2) {
                        NSLog.debug.appendln((Object)("finding maximum primary key value for " + string));
                    }
                    jDBCChannel.evaluateExpression(eOSQLExpression3);
                }
                catch (JDBCAdaptorException jDBCAdaptorException) {
                    jDBCContext.rollbackTransaction();
                    if (bl2) {
                        NSLog.err.appendln((Object)("unable to find maximum primary key value for " + string));
                        NSLog.err.appendln((Throwable)((Object)jDBCAdaptorException));
                    }
                    return null;
                }
                jDBCChannel.setAttributesToFetch(new NSArray((Object)eOAttribute2));
                NSArray nSArray3 = jDBCChannel._fetchOrderedRow(false);
                jDBCChannel.cancelFetch();
                if (nSArray3 == null || (object2 = nSArray3.objectAtIndex(0)) == null || object2 == NSKeyValueCoding.NullValue || (number3 = (Number)object2).intValue() <= number2.intValue()) continue;
                number2 = number3;
            }
        } else {
            number2 = number;
        }
        int n3 = number2.intValue() + 1;
        number2 = new Integer(n3 + n - 1);
        stringBuffer.setLength(0);
        stringBuffer.append("UPDATE ");
        stringBuffer.append(string3);
        stringBuffer.append(" SET PK = ");
        stringBuffer.append(number2);
        stringBuffer.append(" WHERE NAME = '");
        stringBuffer.append(string);
        stringBuffer.append("' AND PK = ");
        stringBuffer.append(number);
        EOSQLExpression eOSQLExpression4 = this.expressionFactory().expressionForString(new String(stringBuffer));
        try {
            if (bl2) {
                NSLog.debug.appendln((Object)("updating primary key value for " + string));
            }
            jDBCChannel.evaluateExpression(eOSQLExpression4);
        }
        catch (JDBCAdaptorException jDBCAdaptorException) {
            if (bl2) {
                NSLog.err.appendln((Object)("unable to update primary key value for " + string));
                NSLog.err.appendln((Throwable)((Object)jDBCAdaptorException));
            }
            jDBCContext.rollbackTransaction();
            return null;
        }
        while ((nSMutableDictionary = jDBCChannel.fetchRow()) != null) {
        }
        if (jDBCChannel.rowsProcessedCount() > 0) {
            if (bl2) {
                NSLog.err.appendln((Object)("unable to update primary key value for " + string + "!"));
            }
            jDBCContext.rollbackTransaction();
            return null;
        }
        jDBCContext.commitTransaction();
        NSMutableArray nSMutableArray = new NSMutableArray(n);
        int n4 = n + n3;
        for (int i = n3; i < n4; ++i) {
            nSMutableArray.addObject((Object)new NSDictionary((Object)_NSUtilities.IntegerForInt((int)i), (Object)string2));
        }
        return nSMutableArray;
    }

    public boolean _couldIgnoreException(SQLException sQLException) {
        return false;
    }

    public Object fetchBLOB(ResultSet resultSet, int n, EOAttribute eOAttribute, boolean bl) throws SQLException {
        return null;
    }

    public Object fetchCLOB(ResultSet resultSet, int n, EOAttribute eOAttribute, boolean bl) throws SQLException {
        return null;
    }

    public void updateLOBs(JDBCChannel jDBCChannel, JDBCExpression jDBCExpression, NSDictionary nSDictionary, EOEntity eOEntity) {
    }

    public NSDictionary jdbcInfo() {
        JDBCContext jDBCContext = this.adaptor()._cachedAdaptorContext();
        NSDictionary nSDictionary = jDBCContext._fetchJDBCInfo();
        return nSDictionary;
    }

    public int jdbcTypeForUnknownExternalType(String string, int n, int n2) {
        if (string == null) {
            return 1111;
        }
        if (string.equalsIgnoreCase("CLOB")) {
            return 2005;
        }
        if (string.equalsIgnoreCase("BLOB")) {
            return 2004;
        }
        return 1111;
    }

    public void assignTypeForAttribute(EOAttribute eOAttribute) {
    }

    public boolean isPseudoColumnName(String string) {
        return false;
    }

    public Object plugInValueForValue(Object object, EOAttribute eOAttribute) {
        if (object == null) {
            return NSKeyValueCoding.NullValue;
        }
        return object;
    }

    protected static EOAttribute _attributeForPath(EOEntity eOEntity, String string) {
        return eOEntity._attributeForPath(string);
    }

    protected static EORelationship _relationshipForPath(EOEntity eOEntity, String string) {
        return eOEntity._relationshipForPath(string);
    }

    protected static void _takeValueForKeyPath(NSMutableDictionary nSMutableDictionary, Object object, String string, String string2) {
        NSMutableDictionary nSMutableDictionary2;
        Object object2 = nSMutableDictionary.valueForKey(string);
        if (object2 == null) {
            return;
        }
        if (object2 instanceof NSMutableDictionary) {
            nSMutableDictionary2 = (NSMutableDictionary)object2;
        } else {
            nSMutableDictionary2 = new NSMutableDictionary((NSDictionary)object2);
            nSMutableDictionary.takeValueForKey((Object)nSMutableDictionary2, string);
        }
        nSMutableDictionary2.takeValueForKey(object, string2);
    }

    static {
        JDBCPlugIn.setPlugInNameForSubprotocol("com.webobjects.jdbcadaptor.OpenBasePlugIn", "openbase");
        JDBCPlugIn.setPlugInNameForSubprotocol("com.webobjects.jdbcadaptor.MySQLPlugIn", "mysql");
        JDBCPlugIn.setPlugInNameForSubprotocol("com.webobjects.jdbcadaptor.MicrosoftPlugIn", "sqlserver");
        String string = NSProperties.getProperty((String)"jdbcadaptor.plugin.subprotocols");
        if (string != null) {
            NSArray nSArray = NSArray.componentsSeparatedByString((String)string, (String)":");
            int n = nSArray.count();
            for (int i = 0; i < n; ++i) {
                String string2 = ((String)nSArray.objectAtIndex(i)).trim();
                String string3 = "jdbcadaptor." + string2 + ".plugin";
                String string4 = NSProperties.getProperty((String)string3);
                if (string4 == null) continue;
                JDBCPlugIn.setPlugInNameForSubprotocol(string4, string2);
            }
        }
        _defaultTableTypes = new String[]{"TABLE", "VIEW", "ALIAS", "SYNONYM"};
    }
}

