/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.jdbcadaptor;

import com.webobjects.eoaccess.EOAdaptor;
import com.webobjects.eoaccess.EOAttribute;
import com.webobjects.eoaccess.EOEntity;
import com.webobjects.eoaccess.EORelationship;
import com.webobjects.eoaccess.EOSQLExpression;
import com.webobjects.eoaccess.EOSchemaSynchronization;
import com.webobjects.eoaccess.EOSynchronizationFactory;
import com.webobjects.eocontrol.EOQualifier;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSLog;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.jdbcadaptor.JDBCAdaptor;
import com.webobjects.jdbcadaptor.JDBCAdaptorException;
import com.webobjects.jdbcadaptor.JDBCContext;
import com.webobjects.jdbcadaptor.JDBCExpression;
import com.webobjects.jdbcadaptor.JDBCPlugIn;
import java.sql.SQLException;

public class OpenBasePlugIn
extends JDBCPlugIn {
    private static final String DriverClassName = "com.openbase.jdbc.ObDriver";
    private static final String DriverProductName = "OpenBase";

    public OpenBasePlugIn(JDBCAdaptor jDBCAdaptor) {
        super(jDBCAdaptor);
    }

    public String connectionURL() {
        return super.connectionURL() + ":wo";
    }

    public String defaultDriverName() {
        return DriverClassName;
    }

    public String databaseProductName() {
        return DriverProductName;
    }

    public Class defaultExpressionClass() {
        return OpenBaseExpression.class;
    }

    public EOSynchronizationFactory createSynchronizationFactory() {
        return new OpenBaseSynchronizationFactory(this._adaptor);
    }

    public boolean isPseudoColumnName(String string) {
        if (string.equalsIgnoreCase("_timestamp") || string.equalsIgnoreCase("_version")) {
            return true;
        }
        return super.isPseudoColumnName(string);
    }

    public NSDictionary jdbcInfo() {
        NSDictionary nSDictionary;
        block2: {
            nSDictionary = super.jdbcInfo();
            JDBCContext jDBCContext = this.adaptor()._cachedAdaptorContext();
            try {
                jDBCContext.connection().commit();
            }
            catch (SQLException sQLException) {
                if (!NSLog.debugLoggingAllowedForLevelAndGroups((int)3, (long)65536L)) break block2;
                NSLog.debug.appendln((Throwable)sQLException);
            }
        }
        return nSDictionary;
    }

    public static class OpenBaseExpression
    extends JDBCExpression {
        public OpenBaseExpression(EOEntity eOEntity) {
            super(eOEntity);
            this._rtrimFunctionName = null;
        }

        public char sqlEscapeChar() {
            return '\u0000';
        }

        public String assembleSelectStatementWithAttributes(NSArray nSArray, boolean bl, EOQualifier eOQualifier, NSArray nSArray2, String string, String string2, String string3, String string4, String string5, String string6, String string7) {
            int n = string.length() + string2.length() + string3.length() + 7;
            if (string7 != null && string7.length() != 0) {
                n += string7.length() + 1;
            }
            if (string4 != null && string4.length() != 0) {
                n += string4.length() + 7;
            }
            if (string5 != null && string5.length() != 0) {
                n += string5.length() + 7;
            }
            if (string6 != null && string6.length() != 0) {
                n += string6.length() + 10;
            }
            StringBuffer stringBuffer = new StringBuffer(n);
            stringBuffer.append(string);
            stringBuffer.append(string2);
            stringBuffer.append(" FROM ");
            stringBuffer.append(string3);
            if (string7 != null && string7.length() != 0) {
                stringBuffer.append(" ");
                stringBuffer.append(string7);
            }
            if (string4 != null && string4.length() != 0) {
                stringBuffer.append(" WHERE ");
                stringBuffer.append(string4);
            }
            if (string5 != null && string5.length() != 0) {
                if (string4 != null && string4.length() != 0) {
                    stringBuffer.append(" AND ");
                } else {
                    stringBuffer.append(" WHERE ");
                }
                stringBuffer.append(string5);
            }
            if (string6 != null && string6.length() != 0) {
                stringBuffer.append(" ORDER BY ");
                stringBuffer.append(string6);
            }
            return new String(stringBuffer);
        }

        public String assembleJoinClause(String string, String string2, int n) {
            switch (n) {
                case 2: {
                    return string + " * " + string2;
                }
                case 3: {
                    throw new JDBCAdaptorException("OpenBase does not support right outer joins: unable to join " + string + " and " + string2, null);
                }
                case 1: {
                    throw new JDBCAdaptorException("OpenBase does not support full outer joins: unable to join " + string + " and " + string2, null);
                }
            }
            return super.assembleJoinClause(string, string2, n);
        }
    }

    public static class OpenBaseSynchronizationFactory
    extends EOSynchronizationFactory {
        public OpenBaseSynchronizationFactory(EOAdaptor eOAdaptor) {
            super(eOAdaptor);
        }

        public NSArray dropPrimaryKeySupportStatementsForEntityGroups(NSArray nSArray) {
            return new NSArray((Object)this._expressionForString("DROP TABLE " + ((JDBCAdaptor)this.adaptor()).plugIn().primaryKeyTableName() + " CASCADE"));
        }

        public NSArray foreignKeyConstraintStatementsForRelationship(EORelationship eORelationship) {
            return null;
        }

        public NSArray primaryKeySupportStatementsForEntityGroups(NSArray nSArray) {
            String string = ((JDBCAdaptor)this.adaptor()).plugIn().primaryKeyTableName();
            NSMutableArray nSMutableArray = new NSMutableArray();
            nSMutableArray.addObject((Object)this._expressionForString("CREATE TABLE " + string + " (NAME char(40), PK long)"));
            nSMutableArray.addObject((Object)this._expressionForString("ALTER TABLE " + string + " ADD PRIMARY KEY (NAME)"));
            nSMutableArray.addObject((Object)this._expressionForString("CREATE UNIQUE INDEX " + string + " NAME"));
            return nSMutableArray;
        }

        public String _alterPhraseCoercingColumnsWithNames(NSArray nSArray, NSDictionary nSDictionary, NSArray nSArray2, NSDictionary nSDictionary2) {
            return this._alterPhraseInsertingColumnsWithNames(nSArray, nSArray2, nSDictionary2);
        }

        public String _alterPhraseDeletingColumnsWithNames(NSArray nSArray, NSArray nSArray2, NSDictionary nSDictionary) {
            StringBuffer stringBuffer = new StringBuffer();
            int n = nSArray.count();
            for (int i = 0; i < n; ++i) {
                stringBuffer.append("" + (i != 0 ? this._alterPhraseJoinString() : "") + "remove column " + nSArray.objectAtIndex(i));
            }
            return stringBuffer.toString();
        }

        public String _alterPhraseInsertionClausePrefixAtIndex(int n) {
            return "add column";
        }

        public String _alterPhraseJoinString() {
            return " ";
        }

        public NSArray primaryKeyConstraintStatementsForEntityGroup(NSArray nSArray) {
            EOSQLExpression eOSQLExpression;
            int n;
            EOEntity eOEntity;
            int n2;
            if (nSArray == null) {
                return NSArray.EmptyArray;
            }
            NSMutableDictionary nSMutableDictionary = new NSMutableDictionary();
            NSMutableArray nSMutableArray = new NSMutableArray();
            int n3 = nSArray.count();
            for (n2 = 0; n2 < n3; ++n2) {
                eOEntity = (EOEntity)nSArray.objectAtIndex(n2);
                NSArray nSArray2 = eOEntity.primaryKeyAttributes();
                n = nSArray2.count();
                NSArray nSArray3 = super.primaryKeyConstraintStatementsForEntityGroup(nSArray);
                if (nSArray3 != null && nSArray3.count() > 0) {
                    nSMutableArray.addObjectsFromArray(nSArray3);
                }
                for (int i = 0; i < n; ++i) {
                    String string = ((EOAttribute)nSArray2.objectAtIndex(i)).columnName();
                    eOSQLExpression = n == 1 ? this._expressionForString("create unique index " + eOEntity.externalName() + " " + string) : this._expressionForString("create index " + eOEntity.externalName() + " " + string);
                    nSMutableDictionary.setObjectForKey((Object)string, (Object)("" + eOEntity.externalName() + "." + string));
                    if (eOSQLExpression == null) continue;
                    nSMutableArray.addObject((Object)eOSQLExpression);
                }
            }
            for (n2 = 0; n2 < n3; ++n2) {
                eOEntity = (EOEntity)nSArray.objectAtIndex(n2);
                NSArray nSArray4 = eOEntity.relationships();
                n = nSArray4.count();
                for (int i = 0; i < n; ++i) {
                    String string;
                    EOAttribute eOAttribute;
                    int n4;
                    EORelationship eORelationship = (EORelationship)nSArray4.objectAtIndex(i);
                    if (eORelationship.isFlattened()) continue;
                    NSArray nSArray5 = eORelationship.sourceAttributes();
                    NSArray nSArray6 = eORelationship.destinationAttributes();
                    NSArray nSArray7 = eORelationship.destinationEntity().primaryKeyAttributes();
                    int n5 = nSArray7.count();
                    for (n4 = 0; n4 < n5; ++n4) {
                        eOAttribute = (EOAttribute)nSArray7.objectAtIndex(n4);
                        nSMutableDictionary.setObjectForKey((Object)eOAttribute.columnName(), (Object)("" + eORelationship.destinationEntity().externalName() + "." + eOAttribute.columnName()));
                    }
                    int n6 = nSArray5.count();
                    for (n4 = 0; n4 < n6; ++n4) {
                        eOAttribute = (EOAttribute)nSArray5.objectAtIndex(n4);
                        if (nSMutableDictionary.objectForKey((Object)("" + eOEntity.externalName() + "." + eOAttribute.columnName())) == null) continue;
                        eOSQLExpression = this._expressionForString("create index " + eOEntity.externalName() + " " + eOAttribute.columnName());
                        if (eOSQLExpression != null) {
                            nSMutableArray.addObject((Object)eOSQLExpression);
                        }
                        nSMutableDictionary.setObjectForKey((Object)eOAttribute.columnName(), (Object)("" + eOEntity.externalName() + "." + eOAttribute.columnName()));
                    }
                    if (eOEntity.model() != eORelationship.destinationEntity().model()) continue;
                    int n7 = nSArray6.count();
                    for (n4 = 0; n4 < n7; ++n4) {
                        eOAttribute = (EOAttribute)nSArray6.objectAtIndex(n4);
                        if (nSMutableDictionary.objectForKey((Object)("" + eORelationship.destinationEntity().externalName() + "." + eOAttribute.columnName())) == null) continue;
                        eOSQLExpression = this._expressionForString("create index " + eORelationship.destinationEntity().externalName() + " " + eOAttribute.columnName());
                        if (eOSQLExpression != null) {
                            nSMutableArray.addObject((Object)eOSQLExpression);
                        }
                        nSMutableDictionary.setObjectForKey((Object)eOAttribute.columnName(), (Object)("" + eOEntity.externalName() + "." + eOAttribute.columnName()));
                    }
                    if (eORelationship.isCompound() || n6 != 1 || n7 != 1) continue;
                    switch (eORelationship.joinSemantic()) {
                        case 1: 
                        case 2: {
                            string = "*";
                            break;
                        }
                        default: {
                            string = "=";
                        }
                    }
                    eOSQLExpression = this._expressionForString("delete from _SYS_RELATIONSHIP where relationshipName = '" + eORelationship.name() + "' and source_table = '" + eOEntity.externalName() + "' ");
                    if (eOSQLExpression != null) {
                        nSMutableArray.addObject((Object)eOSQLExpression);
                    }
                    if ((eOSQLExpression = this._expressionForString("insert into _SYS_RELATIONSHIP (relationshipName, source_table, source_column, dest_table, dest_column, operator, one_to_many) values ('" + eORelationship.name() + "','" + eOEntity.externalName() + "','" + ((EOAttribute)nSArray5.objectAtIndex(0)).columnName() + "','" + eORelationship.destinationEntity().externalName() + "','" + ((EOAttribute)nSArray6.objectAtIndex(0)).columnName() + "','" + string + "'," + (eORelationship.isToMany() ? 1 : 0) + ")")) == null) continue;
                    nSMutableArray.addObject((Object)eOSQLExpression);
                }
            }
            return nSMutableArray;
        }

        public boolean isColumnTypeEquivalentToColumnType(EOSchemaSynchronization.ColumnTypes columnTypes, EOSchemaSynchronization.ColumnTypes columnTypes2, NSDictionary nSDictionary) {
            return columnTypes.name().equals(columnTypes2.name()) && columnTypes.width() == columnTypes2.width();
        }

        public NSArray statementsToDropForeignKeyConstraintsOnEntityGroups(NSArray nSArray, NSDictionary nSDictionary, NSDictionary nSDictionary2) {
            return NSArray.EmptyArray;
        }

        public NSArray statementsToDropPrimaryKeyConstraintsOnEntityGroups(NSArray nSArray, NSDictionary nSDictionary, NSDictionary nSDictionary2) {
            NSMutableArray nSMutableArray = new NSMutableArray();
            if (nSArray == null) {
                nSArray = NSArray.EmptyArray;
            }
            if (nSDictionary == null) {
                nSDictionary = NSDictionary.EmptyDictionary;
            }
            if (nSDictionary2 == null) {
                nSDictionary2 = NSDictionary.EmptyDictionary;
            }
            int n = nSArray.count();
            for (int i = 0; i < n; ++i) {
                NSArray nSArray2 = (NSArray)nSArray.objectAtIndex(i);
                String string = this._nameInObjectStoreForEntityGroupWithChangeDictionary(nSArray2, (NSDictionary)nSDictionary.objectForKey((Object)((EOEntity)nSArray2.lastObject()).externalName()));
                nSMutableArray.addObject((Object)this._expressionForString("delete from _SYS_RELATIONSHIP where source_table = '" + string + "' or dest_table = '" + string + "'"));
            }
            return nSMutableArray;
        }

        public NSArray statementsToImplementPrimaryKeyConstraintsOnEntityGroups(NSArray nSArray, NSDictionary nSDictionary, NSDictionary nSDictionary2) {
            NSArray nSArray2 = this.primaryKeyConstraintStatementsForEntityGroups(nSArray);
            NSMutableArray nSMutableArray = new NSMutableArray();
            NSMutableArray nSMutableArray2 = new NSMutableArray();
            int n = nSArray2.count();
            for (int i = 0; i < n; ++i) {
                EOSQLExpression eOSQLExpression = (EOSQLExpression)nSArray2.objectAtIndex(i);
                String string = eOSQLExpression.statement();
                if (string.startsWith("create")) {
                    nSMutableArray.addObject((Object)eOSQLExpression);
                    continue;
                }
                if (string.startsWith("delete from _SYS_RELATIONSHIP")) continue;
                nSMutableArray2.addObject((Object)eOSQLExpression);
            }
            nSMutableArray.addObjectsFromArray((NSArray)nSMutableArray2);
            return nSMutableArray;
        }

        public NSArray statementsToModifyColumnNullRule(String string, String string2, boolean bl, NSDictionary nSDictionary) {
            return new NSArray((Object)this._expressionForString("alter table " + string2 + " column " + string + " set " + (bl ? "null" : "not null")));
        }

        public NSArray statementsToRenameColumnNamed(String string, String string2, String string3, NSDictionary nSDictionary) {
            return new NSArray((Object)this._expressionForString("alter table " + string2 + " rename " + string + " to " + string3));
        }

        public NSArray statementsToRenameTableNamed(String string, String string2, NSDictionary nSDictionary) {
            return new NSArray((Object)this._expressionForString("rename " + string + " " + string2));
        }

        public boolean supportsDirectColumnCoercion() {
            return true;
        }

        public boolean supportsDirectColumnDeletion() {
            return true;
        }

        public boolean supportsDirectColumnInsertion() {
            return true;
        }

        public boolean supportsDirectColumnNullRuleModification() {
            return true;
        }

        public boolean supportsDirectColumnRenaming() {
            return true;
        }

        public boolean supportsSchemaSynchronization() {
            return true;
        }

        public NSArray primaryKeySupportStatementsForEntityGroup(NSArray nSArray) {
            return null;
        }

        public NSArray dropPrimaryKeySupportStatementsForEntityGroup(NSArray nSArray) {
            return null;
        }

        public NSDictionary objectStoreChangesFromAttributeToAttribute(EOAttribute eOAttribute, EOAttribute eOAttribute2) {
            NSMutableDictionary nSMutableDictionary = new NSMutableDictionary(super.objectStoreChangesFromAttributeToAttribute(eOAttribute, eOAttribute2));
            if (nSMutableDictionary.objectForKey((Object)"precision") != null || nSMutableDictionary.objectForKey((Object)"scale") != null) {
                nSMutableDictionary.removeObjectForKey((Object)"precision");
                nSMutableDictionary.removeObjectForKey((Object)"scale");
            }
            if (!eOAttribute2.externalType().equals(eOAttribute.externalType())) {
                if (eOAttribute2.externalType().equals("varchar") && eOAttribute.externalType().equals("char")) {
                    nSMutableDictionary.removeObjectForKey((Object)"externalType");
                }
            } else if (eOAttribute.externalType().equals("object") && nSMutableDictionary.objectForKey((Object)"width") != null) {
                nSMutableDictionary.removeObjectForKey((Object)"width");
            }
            if ((eOAttribute2.externalType().equals("char") || eOAttribute2.externalType().equals("varchar")) && eOAttribute2.width() == 1024 && eOAttribute.width() == 1023) {
                nSMutableDictionary.removeObjectForKey((Object)"width");
            }
            return nSMutableDictionary;
        }
    }
}

