/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.jdbcadaptor;

import com.webobjects.eoaccess.EOAdaptor;
import com.webobjects.eoaccess.EOAttribute;
import com.webobjects.eoaccess.EOEntity;
import com.webobjects.eoaccess.EOJoin;
import com.webobjects.eoaccess.EOModel;
import com.webobjects.eoaccess.EORelationship;
import com.webobjects.eoaccess.EOSQLExpression;
import com.webobjects.eoaccess.EOSynchronizationFactory;
import com.webobjects.eocontrol.EOAndQualifier;
import com.webobjects.eocontrol.EOFetchSpecification;
import com.webobjects.eocontrol.EOKeyValueQualifier;
import com.webobjects.eocontrol.EOQualifier;
import com.webobjects.eocontrol.EOQualifierVariable;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSData;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSKeyValueCoding;
import com.webobjects.foundation.NSLog;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSMutableRange;
import com.webobjects.foundation.NSProperties;
import com.webobjects.foundation.NSSelector;
import com.webobjects.foundation._NSStringUtilities;
import com.webobjects.jdbcadaptor.JDBCAdaptor;
import com.webobjects.jdbcadaptor.JDBCAdaptorException;
import com.webobjects.jdbcadaptor.JDBCChannel;
import com.webobjects.jdbcadaptor.JDBCExpression;
import com.webobjects.jdbcadaptor.JDBCPlugIn;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import oracle.sql.BLOB;
import oracle.sql.CLOB;

public class OraclePlugIn
extends JDBCPlugIn {
    static final int OracleRefCursor = -10;
    static final String OracleRefCursorName = "REF CURSOR";
    static final String _oracleIncludeSynonyms = NSProperties.getProperty((String)"jdbcadaptor.oracle.includeSynonyms", null);
    static final String _oracleWildcardPatternForAttributes = NSProperties.getProperty((String)"jdbcadaptor.oracle.wildcardPatternForAttributes", null);
    static final String _oracleWildcardPatternForTables = NSProperties.getProperty((String)"jdbcadaptor.oracle.wildcardPatternForTables", (String)"%");
    static final String _oracleWildcardPatternForSchema = NSProperties.getProperty((String)"jdbcadaptor.oracle.wildcardPatternForSchema", null);
    static final String _oracleSqlStatementForGettingProcedureNames = NSProperties.getProperty((String)"jdbcadaptor.oracle.sqlStatementForGettingProcedureNames", null);
    static final String _oracleStoredProcedureCatalogPattern = NSProperties.getProperty((String)"jdbcadaptor.oracle.storedProcedureCatalogPattern", null);
    static final String _oracleStoredProcedureSchemaPattern = NSProperties.getProperty((String)"jdbcadaptor.oracle.storedProcedureSchemaPattern", null);
    static final String _oracleSqlStatementForGettingTableNames = NSProperties.getProperty((String)"jdbcadaptor.oracle.sqlStatementForGettingTableNames", null);

    public OraclePlugIn(JDBCAdaptor jDBCAdaptor) {
        super(jDBCAdaptor);
    }

    public Class defaultExpressionClass() {
        return OracleExpression.class;
    }

    public EOSynchronizationFactory createSynchronizationFactory() {
        return new OracleSynchronizationFactory(this._adaptor);
    }

    public String defaultDriverName() {
        return "oracle.jdbc.driver.OracleDriver";
    }

    public String databaseProductName() {
        return "Oracle";
    }

    public NSDictionary jdbcInfo() {
        Object object;
        boolean bl = NSLog.debugLoggingAllowedForLevelAndGroups((int)2, (long)65536L);
        NSMutableDictionary nSMutableDictionary = new NSMutableDictionary(super.jdbcInfo());
        NSMutableDictionary nSMutableDictionary2 = new NSMutableDictionary((NSDictionary)nSMutableDictionary.objectForKey((Object)"typeInfo"));
        nSMutableDictionary2.removeObjectForKey((Object)"ARRAY");
        nSMutableDictionary2.removeObjectForKey((Object)"STRUCT");
        nSMutableDictionary2.removeObjectForKey((Object)"REF");
        nSMutableDictionary2.removeObjectForKey((Object)"TIMESTAMP WITH LOCAL TIME ZONE");
        nSMutableDictionary2.removeObjectForKey((Object)"TIMESTAMP WITH TIME ZONE");
        nSMutableDictionary2.removeObjectForKey((Object)"INTERVALDS");
        nSMutableDictionary2.removeObjectForKey((Object)"INTERVALYM");
        NSDictionary nSDictionary = (NSDictionary)nSMutableDictionary2.objectForKey((Object)"RAW");
        if (nSDictionary != null && !(object = nSDictionary.objectForKey((Object)"createParams")).equals("1")) {
            NSMutableDictionary nSMutableDictionary3 = new NSMutableDictionary(nSDictionary);
            nSMutableDictionary3.setObjectForKey((Object)"1", (Object)"createParams");
            nSMutableDictionary2.setObjectForKey((Object)nSMutableDictionary3, (Object)"RAW");
            if (bl) {
                NSLog.debug.appendln((Object)"set RAW createParams to one");
            }
        }
        nSMutableDictionary.setObjectForKey((Object)nSMutableDictionary2, (Object)"typeInfo");
        if (bl) {
            NSLog.debug.appendln((Object)("fetched Oracle JDBC Info = " + nSMutableDictionary));
        }
        return nSMutableDictionary;
    }

    public Properties connectionPropertiesForConnectionDictionary(NSDictionary nSDictionary) {
        Properties properties = super.connectionPropertiesForConnectionDictionary(nSDictionary);
        if (_oracleIncludeSynonyms != null) {
            properties.put("includeSynonyms", _oracleIncludeSynonyms);
        }
        return properties;
    }

    public int jdbcTypeForUnknownExternalType(String string, int n, int n2) {
        if (string == null) {
            return 1111;
        }
        if (string.equals("CLOB")) {
            return 2005;
        }
        if (string.equals("BLOB")) {
            return 2004;
        }
        if (string.equals("FLOAT")) {
            return 6;
        }
        if (string.equals("REAL")) {
            return 7;
        }
        if (string.equals("TIMESTAMP")) {
            return 93;
        }
        if (string.equals(OracleRefCursorName)) {
            return -10;
        }
        return 1111;
    }

    public void assignTypeForAttribute(EOAttribute eOAttribute) {
        int n;
        super.assignTypeForAttribute(eOAttribute);
        if (eOAttribute.scale() == 0 && ((n = eOAttribute.precision()) == 0 || n >= 22) && eOAttribute.externalType().equals("NUMBER")) {
            eOAttribute.setValueType(String.valueOf('d'));
            eOAttribute.setPrecision(0);
        }
    }

    public Object fetchBLOB(ResultSet resultSet, int n, EOAttribute eOAttribute, boolean bl) throws SQLException {
        NSData nSData = null;
        BLOB bLOB = (BLOB)resultSet.getObject(n);
        if (bLOB == null) {
            return null;
        }
        if (!bl) {
            return bLOB;
        }
        try {
            InputStream inputStream = bLOB.getBinaryStream();
            int n2 = (int)bLOB.length();
            nSData = n2 == 0 ? NSData.EmptyData : new NSData(inputStream, n2);
            inputStream.close();
        }
        catch (IOException iOException) {
            throw new JDBCAdaptorException(iOException.getMessage(), null);
        }
        return nSData;
    }

    public Object fetchCLOB(ResultSet resultSet, int n, EOAttribute eOAttribute, boolean bl) throws SQLException {
        CLOB cLOB = (CLOB)resultSet.getObject(n);
        if (cLOB == null) {
            return null;
        }
        if (!bl) {
            return cLOB;
        }
        return cLOB.getSubString(1L, (int)cLOB.length());
    }

    EOQualifier primaryKeyQualifier(EOQualifier eOQualifier, EOEntity eOEntity) {
        if (eOQualifier instanceof EOAndQualifier) {
            EOAndQualifier eOAndQualifier = (EOAndQualifier)eOQualifier;
            NSArray nSArray = eOAndQualifier.qualifiers();
            NSArray nSArray2 = eOEntity.primaryKeyAttributeNames();
            int n = nSArray.count();
            NSMutableArray nSMutableArray = new NSMutableArray(n);
            for (int i = 0; i < n; ++i) {
                EOKeyValueQualifier eOKeyValueQualifier;
                EOQualifier eOQualifier2 = (EOQualifier)nSArray.objectAtIndex(i);
                if (!(eOQualifier2 instanceof EOKeyValueQualifier) || !nSArray2.containsObject((Object)(eOKeyValueQualifier = (EOKeyValueQualifier)eOQualifier2).key())) continue;
                nSMutableArray.addObject((Object)eOKeyValueQualifier);
            }
            if (nSMutableArray.count() == 1) {
                return (EOQualifier)nSMutableArray.objectAtIndex(0);
            }
            return new EOAndQualifier(nSArray);
        }
        return eOQualifier;
    }

    public void updateLOBs(JDBCChannel jDBCChannel, JDBCExpression jDBCExpression, NSDictionary nSDictionary, EOEntity eOEntity) {
        BLOB bLOB;
        Object object;
        int n;
        int n2;
        NSArray nSArray;
        int n3;
        OracleExpression oracleExpression = (OracleExpression)jDBCExpression;
        if (!oracleExpression.hasLOBsToUpdate()) {
            return;
        }
        NSArray nSArray2 = oracleExpression.blobList();
        int n4 = nSArray2.count();
        int n5 = n4 + (n3 = (nSArray = oracleExpression.clobList()).count());
        if (n5 == 0) {
            return;
        }
        NSMutableArray nSMutableArray = new NSMutableArray();
        for (n2 = 0; n2 < n4; n2 += 2) {
            nSMutableArray.addObject(nSArray2.objectAtIndex(n2));
        }
        for (n = 0; n < n3; n += 2) {
            nSMutableArray.addObject(nSArray.objectAtIndex(n));
        }
        EOQualifier eOQualifier = oracleExpression.qualifier();
        eOQualifier = eOQualifier == null ? eOEntity.qualifierForPrimaryKey(nSDictionary) : this.primaryKeyQualifier(eOQualifier, eOEntity);
        EOFetchSpecification eOFetchSpecification = new EOFetchSpecification(eOEntity.name(), eOQualifier, null);
        jDBCChannel.selectAttributes((NSArray)nSMutableArray, eOFetchSpecification, true, eOEntity);
        NSArray nSArray3 = jDBCChannel._fetchOrderedRow(false);
        if (nSArray3 == null || nSArray3.count() < n5 / 2) {
            throw new JDBCAdaptorException("Expected a LOB count of " + n5 / 2 + " but could not fetch that many objects", null);
        }
        jDBCChannel.cancelFetch();
        int n6 = 0;
        for (n2 = 1; n2 < n4; n2 += 2) {
            object = (NSData)nSArray2.objectAtIndex(n2);
            bLOB = (BLOB)nSArray3.objectAtIndex(n6++);
            try {
                NSMutableRange nSMutableRange = new NSMutableRange();
                byte[] byArray = object.bytesNoCopy(nSMutableRange);
                OutputStream outputStream = bLOB.getBinaryOutputStream();
                int n7 = bLOB.getBufferSize();
                int n8 = nSMutableRange.maxRange();
                int n9 = nSMutableRange.location();
                try {
                    while (n9 + n7 <= n8) {
                        outputStream.write(byArray, n9, n7);
                        n9 += n7;
                    }
                    outputStream.write(byArray, n9, n8 - n9);
                    outputStream.close();
                    continue;
                }
                catch (IOException iOException) {
                    throw new JDBCAdaptorException(iOException.getMessage(), null);
                }
            }
            catch (SQLException sQLException) {
                throw new JDBCAdaptorException(sQLException);
            }
        }
        for (n = 1; n < n3; n += 2) {
            object = (String)nSArray.objectAtIndex(n);
            bLOB = (CLOB)nSArray3.objectAtIndex(n6++);
            try {
                bLOB.putString(1L, (String)object);
                continue;
            }
            catch (SQLException sQLException) {
                throw new JDBCAdaptorException(sQLException);
            }
        }
    }

    public String wildcardPatternForAttributes() {
        return _oracleWildcardPatternForAttributes;
    }

    public String wildcardPatternForTables() {
        return _oracleWildcardPatternForTables;
    }

    public String wildcardPatternForSchema() {
        if (_oracleWildcardPatternForSchema != null) {
            return _oracleWildcardPatternForSchema;
        }
        return this.adaptor().username().toUpperCase();
    }

    public String schemaNameForEntity(EOEntity eOEntity) {
        String string = super.schemaNameForEntity(eOEntity);
        if (string == null) {
            return this.adaptor().username().toUpperCase();
        }
        return string;
    }

    public String sqlStatementForGettingProcedureNames() {
        return _oracleSqlStatementForGettingProcedureNames;
    }

    public String storedProcedureCatalogPattern() {
        return _oracleStoredProcedureCatalogPattern;
    }

    public String storedProcedureSchemaPattern() {
        if (_oracleStoredProcedureSchemaPattern != null) {
            return _oracleStoredProcedureSchemaPattern;
        }
        return this.adaptor().username().toUpperCase();
    }

    public String sqlStatementForGettingTableNames() {
        return _oracleSqlStatementForGettingTableNames;
    }

    public NSArray newPrimaryKeys(int n, EOEntity eOEntity, JDBCChannel jDBCChannel) {
        NSMutableArray nSMutableArray = new NSMutableArray(n);
        for (int i = 0; i < n; ++i) {
            NSDictionary nSDictionary = this._newPrimaryKey(eOEntity, jDBCChannel);
            if (nSDictionary == null) {
                return null;
            }
            nSMutableArray.addObject((Object)nSDictionary);
        }
        return nSMutableArray;
    }

    private NSDictionary _newPrimaryKey(EOEntity eOEntity, JDBCChannel jDBCChannel) {
        NSArray nSArray = null;
        nSArray = eOEntity.primaryKeyAttributes();
        if (nSArray == null || nSArray.count() != 1) {
            return null;
        }
        String string = eOEntity.primaryKeyRootName();
        EOAttribute eOAttribute = (EOAttribute)nSArray.objectAtIndex(0);
        if (eOAttribute.adaptorValueType() != 0) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length() + 29);
        stringBuffer.append("SELECT ");
        stringBuffer.append(string);
        stringBuffer.append("_SEQ.NEXTVAL FROM DUAL");
        String string2 = new String(stringBuffer);
        EOSQLExpression eOSQLExpression = this.expressionFactory().expressionForString(string2);
        NSArray nSArray2 = jDBCChannel._fetchRowsForSQLExpressionAndAttributes(eOSQLExpression, nSArray);
        if (nSArray2 != null && nSArray2.count() > 0) {
            return (NSDictionary)nSArray2.lastObject();
        }
        return null;
    }

    public static class OracleSynchronizationFactory
    extends EOSynchronizationFactory {
        static String sequenceSetProc1 = "create procedure eo_set_sequence is\n    xxx number;\n    yyy number;\nbegin\n    select max(counter) into xxx from eo_temp_table;\n    if xxx is not NULL then\n        yyy := 0;\n        while (yyy < xxx) loop\n            select ";
        static String sequenceSetProc2 = ".nextval into yyy from dual;\n        end loop;\n    end if;\nend;\n";

        public OracleSynchronizationFactory(EOAdaptor eOAdaptor) {
            super(eOAdaptor);
        }

        public NSArray dropTableStatementsForEntityGroup(NSArray nSArray) {
            EOSQLExpression eOSQLExpression = this._expressionForString("drop table " + ((EOEntity)nSArray.objectAtIndex(0)).externalName() + " cascade constraints");
            NSArray nSArray2 = new NSArray((Object)eOSQLExpression);
            return nSArray2;
        }

        public NSArray _statementsToDeleteTableNamedOptions(String string, NSDictionary nSDictionary) {
            NSArray nSArray = new NSArray((Object)this._expressionForString("DROP TABLE " + string + " CASCADE CONSTRAINTS"));
            return nSArray;
        }

        public NSArray primaryKeySupportStatementsForEntityGroup(NSArray nSArray) {
            NSMutableArray nSMutableArray = new NSMutableArray();
            EOEntity eOEntity = null;
            boolean bl = true;
            for (int i = nSArray.count() - 1; i >= 0; --i) {
                eOEntity = (EOEntity)nSArray.objectAtIndex(i);
                EOAttribute eOAttribute = (EOAttribute)eOEntity.primaryKeyAttributes().objectAtIndex(0);
                if (bl) {
                    nSMutableArray.addObject((Object)this._expressionForString("create table eo_temp_table as select max(" + eOAttribute.columnName() + ") counter from " + eOEntity.externalName()));
                    bl = false;
                    continue;
                }
                nSMutableArray.addObject((Object)this._expressionForString("insert into eo_temp_table select max(" + eOAttribute.columnName() + ") counter from " + eOEntity.externalName()));
            }
            String string = eOEntity.primaryKeyRootName() + "_SEQ";
            nSMutableArray.addObject((Object)this._expressionForString("create sequence " + string));
            nSMutableArray.addObject((Object)this._expressionForString(sequenceSetProc1 + string + sequenceSetProc2));
            nSMutableArray.addObject((Object)this._expressionForString("begin eo_set_sequence; end;"));
            nSMutableArray.addObject((Object)this._expressionForString("drop procedure eo_set_sequence"));
            nSMutableArray.addObject((Object)this._expressionForString("drop table eo_temp_table"));
            return nSMutableArray;
        }

        public NSArray dropPrimaryKeySupportStatementsForEntityGroup(NSArray nSArray) {
            if (nSArray == null || nSArray.count() == 0) {
                return NSArray.EmptyArray;
            }
            EOEntity eOEntity = (EOEntity)nSArray.lastObject();
            NSArray nSArray2 = new NSArray((Object)this._expressionForString("drop sequence " + eOEntity.primaryKeyRootName() + "_SEQ"));
            return nSArray2;
        }

        public void appendExpressionToScript(EOSQLExpression eOSQLExpression, StringBuffer stringBuffer) {
            if (eOSQLExpression != null) {
                stringBuffer.append("" + eOSQLExpression.statement() + "\n/\n\n");
            }
        }

        public NSArray createDatabaseStatementsForConnectionDictionary(NSDictionary nSDictionary, NSDictionary nSDictionary2) {
            if (nSDictionary2 == null) {
                return null;
            }
            String string = (String)nSDictionary.objectForKey((Object)"username");
            if (string == null) {
                return null;
            }
            String string2 = (String)nSDictionary2.objectForKey((Object)"AdminInfoContainerNameKey");
            EOSQLExpression eOSQLExpression = this._expressionForString("CREATE USER " + string + " IDENTIFIED BY " + nSDictionary.objectForKey((Object)"password") + " " + (string2 != null ? "DEFAULT TABLESPACE " + string2 : ""));
            EOSQLExpression eOSQLExpression2 = this._expressionForString("GRANT CONNECT, RESOURCE TO " + string);
            NSArray nSArray = new NSArray((Object[])new EOSQLExpression[]{eOSQLExpression, eOSQLExpression2});
            return nSArray;
        }

        public NSArray dropDatabaseStatementsForConnectionDictionary(NSDictionary nSDictionary, NSDictionary nSDictionary2) {
            if (nSDictionary == null || nSDictionary2 == null) {
                return null;
            }
            String string = (String)nSDictionary.objectForKey((Object)"username");
            if (string == null) {
                return null;
            }
            NSArray nSArray = new NSArray((Object)this._expressionForString("DROP USER " + string + " CASCADE"));
            return nSArray;
        }

        public boolean supportsSchemaSynchronization() {
            return true;
        }

        public NSArray foreignKeyConstraintStatementsForRelationship(EORelationship eORelationship) {
            EOModel eOModel;
            EOEntity eOEntity = eORelationship.entity();
            EOEntity eOEntity2 = eORelationship.destinationEntity();
            NSMutableArray nSMutableArray = new NSMutableArray();
            NSMutableArray nSMutableArray2 = new NSMutableArray();
            NSArray nSArray = eOEntity2.primaryKeyAttributes();
            NSArray nSArray2 = eORelationship.joins();
            int n = nSArray.count();
            EOModel eOModel2 = eOEntity.model();
            if (eOModel2 != (eOModel = eOEntity2.model()) && !eOModel2.connectionDictionary().equals((Object)eOModel.connectionDictionary())) {
                return NSArray.EmptyArray;
            }
            if (eORelationship.isToMany()) {
                return NSArray.EmptyArray;
            }
            int n2 = n;
            for (int i = 0; i < n2; ++i) {
                EOAttribute eOAttribute = (EOAttribute)nSArray.objectAtIndex(i);
                nSMutableArray2.addObject((Object)eOAttribute.columnName());
                int n3 = nSArray2.count();
                while (n3-- != 0) {
                    EOJoin eOJoin = (EOJoin)nSArray2.objectAtIndex(n3);
                    if (eOJoin.destinationAttribute() != eOAttribute) continue;
                    nSMutableArray.addObject((Object)eOJoin.sourceAttribute().columnName());
                }
            }
            if (nSMutableArray.count() != nSArray2.count()) {
                return NSArray.EmptyArray;
            }
            EOSQLExpression eOSQLExpression = this._expressionForEntity(eOEntity);
            eOSQLExpression.prepareConstraintStatementForRelationship(eORelationship, (NSArray)nSMutableArray, (NSArray)nSMutableArray2);
            return new NSArray((Object)eOSQLExpression);
        }
    }

    public static class OracleExpression
    extends JDBCExpression {
        NSMutableArray _blobList;
        NSMutableArray _clobList;
        EOQualifier _qualifier;

        public OracleExpression(EOEntity eOEntity) {
            super(eOEntity);
        }

        boolean hasLOBsToUpdate() {
            return this._blobList != null || this._clobList != null;
        }

        NSArray blobList() {
            return this._blobList == null ? NSArray.EmptyArray : this._blobList;
        }

        NSArray clobList() {
            return this._clobList == null ? NSArray.EmptyArray : this._clobList;
        }

        EOQualifier qualifier() {
            return this._qualifier;
        }

        private boolean isLOBAttribute(EOAttribute eOAttribute) {
            String string = eOAttribute.externalType();
            return string.equals("BLOB") || string.equals("CLOB");
        }

        private boolean isBLOBAttribute(EOAttribute eOAttribute) {
            String string = eOAttribute.externalType();
            return string.equals("BLOB");
        }

        private boolean isCLOBAttribute(EOAttribute eOAttribute) {
            String string = eOAttribute.externalType();
            return string.equals("CLOB");
        }

        public boolean shouldUseBindVariableForAttribute(EOAttribute eOAttribute) {
            return !this.isLOBAttribute(eOAttribute);
        }

        public boolean mustUseBindVariableForAttribute(EOAttribute eOAttribute) {
            return !this.isLOBAttribute(eOAttribute);
        }

        public String formatValueForAttribute(Object object, EOAttribute eOAttribute) {
            if (object != null && object != NSKeyValueCoding.NullValue) {
                if (this.isBLOBAttribute(eOAttribute)) {
                    if (this._blobList == null) {
                        this._blobList = new NSMutableArray();
                    }
                    this._blobList.addObject((Object)eOAttribute);
                    this._blobList.addObject(object);
                    return "EMPTY_BLOB()";
                }
                if (this.isCLOBAttribute(eOAttribute)) {
                    if (this._clobList == null) {
                        this._clobList = new NSMutableArray();
                    }
                    this._clobList.addObject((Object)eOAttribute);
                    this._clobList.addObject(object);
                    return "EMPTY_CLOB()";
                }
            }
            return super.formatValueForAttribute(object, eOAttribute);
        }

        public String sqlStringForKeyValueQualifier(EOKeyValueQualifier eOKeyValueQualifier) {
            char c;
            String string;
            boolean bl;
            String string2 = eOKeyValueQualifier.key();
            String string3 = this.sqlStringForAttributeNamed(string2);
            if (string3 == null) {
                throw new IllegalStateException("sqlStringForKeyValueQualifier: attempt to generate SQL for " + eOKeyValueQualifier.getClass().getName() + " " + eOKeyValueQualifier + " failed because attribute identified by key '" + string2 + "' was not reachable from from entity '" + this.entity().name() + "'");
            }
            Object object = eOKeyValueQualifier.value();
            if (object instanceof EOQualifierVariable) {
                throw new IllegalStateException("sqlStringForKeyValueQualifier: attempt to generate SQL for " + eOKeyValueQualifier.getClass().getName() + " " + eOKeyValueQualifier + " failed because the qualifier variable '$" + ((EOQualifierVariable)object).key() + "' is unbound.");
            }
            EOAttribute eOAttribute = JDBCPlugIn._attributeForPath(this.entity(), string2);
            String string4 = eOAttribute.readFormat();
            NSSelector nSSelector = eOKeyValueQualifier.selector();
            boolean bl2 = nSSelector.equals((Object)EOQualifier.QualifierOperatorEqual);
            boolean bl3 = bl = eOAttribute.adaptorValueType() == 1 && JDBCAdaptor._valueTypeCharForAttribute(eOAttribute) == 'c';
            if (!bl2 && string4 == null && bl) {
                string4 = "RTRIM(%V)";
            }
            string3 = this.formatSQLString(string3, string4);
            boolean bl4 = nSSelector.equals((Object)EOQualifier.QualifierOperatorLike) || nSSelector.equals((Object)EOQualifier.QualifierOperatorCaseInsensitiveLike);
            Object object2 = bl4 ? this.sqlPatternFromShellPattern((String)object) : object;
            if (nSSelector.equals((Object)EOQualifier.QualifierOperatorCaseInsensitiveLike)) {
                String string5 = this.sqlStringForValue(object2, string2);
                String string6 = this.sqlStringForSelector(nSSelector, object2);
                string = this.sqlStringForCaseInsensitiveLike(string5, string3);
            } else {
                if (bl2 && "".equals(object2)) {
                    object2 = NSKeyValueCoding.NullValue;
                }
                String string7 = this.sqlStringForValue(object2, string2);
                if (bl2 && object2 != NSKeyValueCoding.NullValue && bl) {
                    string7 = "RPAD(" + string7 + ", " + eOAttribute.width() + ")";
                }
                String string8 = this.sqlStringForSelector(nSSelector, object2);
                string = string3 + " " + string8 + " " + string7;
            }
            if (bl4 && (c = this.sqlEscapeChar()) != '\u0000') {
                string = string + " ESCAPE '" + c + "'";
            }
            return string;
        }

        public String assembleUpdateStatementWithRow(NSDictionary nSDictionary, EOQualifier eOQualifier, String string, String string2, String string3) {
            this._qualifier = eOQualifier;
            return super.assembleUpdateStatementWithRow(nSDictionary, eOQualifier, string, string2, string3);
        }

        public String assembleJoinClause(String string, String string2, int n) {
            String string3 = null;
            if (string2.equals("NULL") || string2.equals("''")) {
                string2 = "NULL";
                string3 = "IS";
            } else {
                string3 = "=";
                switch (n) {
                    case 2: {
                        string2 = string2 + "(+)";
                        break;
                    }
                    case 3: {
                        string = string + "(+)";
                        break;
                    }
                    case 1: {
                        throw new JDBCAdaptorException("Oracle does not support the full outer join that was specified between '" + string + "' and '" + string2 + "' for the expression: " + (Object)((Object)this), null);
                    }
                }
            }
            String string4 = _NSStringUtilities.concat((String)string, (String)" ", (String)string3, (String)" ", (String)string2);
            return string4;
        }

        public void prepareConstraintStatementForRelationship(EORelationship eORelationship, NSArray nSArray, NSArray nSArray2) {
            EOModel eOModel;
            EOEntity eOEntity = eORelationship.entity();
            String string = eOEntity.externalName();
            int n = string.lastIndexOf(46);
            if (n >= 0) {
                string = string.substring(n + 1);
            }
            String string2 = string + "_" + eORelationship.name() + "_FK";
            String string3 = nSArray.componentsJoinedByString(", ");
            String string4 = nSArray2.componentsJoinedByString(", ");
            EOModel eOModel2 = eOEntity.model();
            if (eOModel2 != (eOModel = eORelationship.destinationEntity().model()) && !eOModel2.connectionDictionary().equals((Object)eOModel.connectionDictionary())) {
                throw new IllegalArgumentException("prepareConstraintStatementForRelationship unable to create a constraint for " + eORelationship.name() + " because the source and destination entities reside in different databases");
            }
            this.setStatement("ALTER TABLE " + eOEntity.externalName() + " ADD CONSTRAINT " + string2 + " FOREIGN KEY (" + string3 + ") REFERENCES " + eORelationship.destinationEntity().externalName() + " (" + string4 + ") DEFERRABLE INITIALLY DEFERRED");
        }
    }
}

