/*
 * Decompiled with CFR 0.152.
 */
package er.ajax;

import com.webobjects.appserver.WOActionResults;
import com.webobjects.appserver.WOComponent;
import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WORequest;
import com.webobjects.appserver.WOResponse;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSMutableArray;
import er.ajax.AjaxFileUpload;
import er.ajax.AjaxUploadProgress;
import er.ajax.AjaxUtils;
import er.extensions.appserver.ERXRequest;
import er.extensions.appserver.ERXWOContext;
import er.extensions.components.ERXComponentUtilities;
import er.extensions.foundation.ERXValueUtilities;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AjaxFlexibleFileUpload
extends AjaxFileUpload {
    protected final Logger log = Logger.getLogger(((Object)((Object)this)).getClass());
    private String _fileName;
    private String _refreshTime;
    private String _clearLabel;
    private String _cancelLabel;
    private String _uploadLabel;
    private String _selectFileLabel;
    private String _selectFileButtonClass;
    private String _uploadButtonClass;
    private String _cancelButtonClass;
    private String _clearButtonClass;
    private boolean _clearUpload;
    private boolean _fileChosen;
    private Boolean _autoSubmit;
    public boolean testFlag = false;
    public UploadState state = UploadState.DORMANT;

    public AjaxFlexibleFileUpload(WOContext context) {
        super(context);
    }

    @Override
    public void appendToResponse(WOResponse response, WOContext context) {
        super.appendToResponse(response, context);
        if (ERXComponentUtilities.booleanValueForBinding((WOComponent)this, (String)"injectDefaultCSS", (boolean)true)) {
            AjaxUtils.addStylesheetResourceInHead(context, response, "default_ajaxupload.css");
        }
        AjaxUtils.addScriptResourceInHead(context, response, "prototype.js");
        AjaxUtils.addScriptResourceInHead(context, response, "effects.js");
        AjaxUtils.addScriptResourceInHead(context, response, "wonder.js");
        AjaxUtils.addScriptResourceInHead(context, response, "ajaxupload.js");
    }

    public String ajaxUploadScript() {
        String result = "AFU.create('" + this.id() + "', '" + this.uploadButtonId() + "', {" + this.ajaxUploadOptions() + "});";
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("AFU Create Script: " + result));
        }
        return result;
    }

    protected NSArray<String> _ajaxUploadData() {
        NSMutableArray _data = new NSMutableArray((Object)("wosid:'" + this.session().sessionID() + "'"));
        _data.addObject((Object)("id:'" + this.id() + "'"));
        return _data.immutableClone();
    }

    public String ajaxUploadData() {
        return this._ajaxUploadData().componentsJoinedByString(", ");
    }

    protected NSArray<String> _ajaxUploadOptions() {
        NSMutableArray _options = new NSMutableArray((Object)("action:'" + this.uploadUrl() + "'"));
        _options.addObject((Object)("data:{" + this.ajaxUploadData() + "}"));
        _options.addObject((Object)("name:'" + this.uploadName() + "'"));
        _options.add((Object)("iframeId:'" + this.iframeId() + "'"));
        if (!this.autoSubmit().booleanValue()) {
            _options.add((Object)("onChange:" + this.onChangeFunction()));
            _options.add((Object)"autoSubmit:false");
        }
        _options.add((Object)("onSubmit:" + this.onSubmitFunction()));
        _options.add((Object)("onComplete:" + this.onCompleteFunction()));
        return _options.immutableClone();
    }

    public String ajaxUploadOptions() {
        return this._ajaxUploadOptions().componentsJoinedByString(", ");
    }

    public String startFunction() {
        return this.innerUpdateContainerId() + "PeriodicalUpdater.start();";
    }

    public String stopFunction() {
        return this.innerUpdateContainerId() + "Stop();";
    }

    public String onChangeFunction() {
        String result = "function(file, extension) { " + this.innerUpdateContainerId() + "Update(); }";
        return result;
    }

    public String onCompleteFunction() {
        String result = "function(file, extension){ " + this.innerUpdateContainerId() + "Stop(); " + this.innerUpdateContainerId() + "Update(); }";
        return result;
    }

    public String onSubmitFunction() {
        String result = "function(file, extension){ " + this.startFunction() + " }";
        return result;
    }

    public String innerContainerRefreshFunction() {
        String additionalFunction = null;
        String finalFunction = null;
        switch (this.state) {
            case DORMANT: {
                break;
            }
            case STARTED: {
                additionalFunction = (String)this.valueForBinding("startedFunction");
                break;
            }
            case INPROGRESS: {
                break;
            }
            case CANCELED: {
                additionalFunction = (String)this.valueForBinding("canceledFunction");
                finalFunction = (String)this.valueForBinding("finishedFunction");
                this.state = UploadState.DORMANT;
                break;
            }
            case FAILED: {
                additionalFunction = (String)this.valueForBinding("failedFunction");
                finalFunction = (String)this.valueForBinding("finishedFunction");
                this.state = UploadState.DORMANT;
                break;
            }
            case SUCCEEDED: {
                additionalFunction = (String)this.valueForBinding("succeededFunction");
                finalFunction = (String)this.valueForBinding("finishedFunction");
                this.state = UploadState.DORMANT;
                break;
            }
        }
        String result = "AFU.progressUpdate( '" + this.id() + "', '" + this.fileNameId() + "', " + additionalFunction + ", " + finalFunction + ")";
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Function: " + result));
        }
        return result;
    }

    public String outerContainerRefreshCompleteFunction() {
        String additionalFunction = null;
        String finalFunction = null;
        switch (this.state) {
            case CANCELED: {
                additionalFunction = (String)this.valueForBinding("canceledFunction");
                finalFunction = (String)this.valueForBinding("finishedFunction");
                this.state = UploadState.DORMANT;
            }
        }
        String result = "AFU.executeCallbacks( '" + this.id() + "', " + additionalFunction + ", " + finalFunction + ")";
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Function: " + result));
        }
        return result;
    }

    public String submitUploadFunction() {
        String result = "AFU.submit( '" + this.id() + "', '" + this.innerUpdateContainerId() + "')";
        return result;
    }

    public String cancelFunction() {
        String script = "AFU.cancelIFrame('" + this.iframeId() + "', '" + this.cancelUrl() + "')";
        return script;
    }

    public String innerUpdateContainerId() {
        return "AFUIC" + this.id();
    }

    public String outerUpdateContainerId() {
        return "AFUOC" + this.id();
    }

    public String uploadButtonId() {
        return "AFUUB" + this.id();
    }

    public String iframeId() {
        return "AFUIF" + this.id();
    }

    public String fileNameId() {
        return "AFUFN" + this.id();
    }

    public String uploadName() {
        return "AFUUN" + this.id();
    }

    public String cancelUrl() {
        NSDictionary queryParams = new NSDictionary((Object)Boolean.FALSE, (Object)"wosid");
        String url = ERXWOContext._directActionURL((WOContext)this.context(), (String)"ERXDirectAction/closeHTTPSession", (NSDictionary)queryParams, (boolean)ERXRequest.isRequestSecure((WORequest)this.context().request()));
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("URL: " + url));
        }
        return url;
    }

    public WOActionResults containerRefreshed() {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"** START ***");
        }
        WOActionResults result = null;
        AjaxUploadProgress progress = this.uploadProgress();
        if (this._fileName == null && progress != null) {
            this._fileName = progress.fileName();
        }
        if (progress == null) {
            if (!this._clearUpload && (this.autoSubmit().booleanValue() || this._fileChosen)) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Progress is null: " + this.autoSubmit()));
                }
                this._uploadStarted = true;
                this._triggerUploadStart = true;
                this.state = UploadState.STARTED;
            }
            if (!this._clearUpload && !this.autoSubmit().booleanValue()) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Setting file chosen flag - autoSubmit: " + this.autoSubmit()));
                }
                this._fileChosen = true;
            }
        }
        if (this._clearUpload) {
            this._clearUpload = false;
        }
        if (progress != null) {
            this._triggerUploadStart = false;
            this._fileChosen = false;
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"***HAS PROGRESS***");
                this.log.debug((Object)("Percentage: " + progress.percentage()));
                this.log.debug((Object)("isDone: " + progress.isDone()));
                this.log.debug((Object)("isStarted: " + progress.isStarted()));
                this.log.debug((Object)("isCanceled: " + progress.isCanceled()));
                this.log.debug((Object)("isFailed: " + progress.isFailed()));
                this.log.debug((Object)("isSucceeded: " + progress.isSucceeded()));
            }
            if (progress.isStarted()) {
                this.state = UploadState.INPROGRESS;
            }
            if (progress.isSucceeded()) {
                this.state = UploadState.SUCCEEDED;
                result = this.uploadSucceeded();
            }
            if (progress.isFailed()) {
                this.state = UploadState.FAILED;
                result = this.uploadFailed();
            }
            if (progress.isCanceled()) {
                this.state = UploadState.CANCELED;
                this._fileName = null;
                result = this.uploadCanceled();
            }
        }
        return result;
    }

    public WOActionResults cancelUpload() {
        if (this.uploadProgress() != null) {
            this.uploadProgress().cancel();
        }
        this.state = UploadState.CANCELED;
        return null;
    }

    public WOActionResults clearFileResults() {
        this.clearUploadProgress();
        this._fileName = null;
        this._clearUpload = true;
        this._fileChosen = false;
        return null;
    }

    @Override
    public WOActionResults uploadCanceled() {
        this.clearUploadProgress();
        return super.uploadCanceled();
    }

    @Override
    public WOActionResults uploadFailed() {
        this.clearUploadProgress();
        return super.uploadFailed();
    }

    @Override
    public WOActionResults uploadSucceeded() {
        WOActionResults result = super.uploadSucceeded();
        if (ERXComponentUtilities.booleanValueForBinding((WOComponent)this, (String)"clearUploadProgressOnSuccess", (boolean)false)) {
            this.clearUploadProgress();
        }
        return result;
    }

    public void clearUploadProgress() {
        if (this._progress != null) {
            AjaxUploadProgress.unregisterProgress(this.session(), this._progress);
        }
        this._progress = null;
        this._uploadStarted = false;
    }

    public boolean showProgressBar() {
        boolean result = this._triggerUploadStart || this._progress != null && this._progress.isStarted() && !this._progress.isCanceled() && !this._progress.isDone();
        return result;
    }

    public boolean showFileSelect() {
        boolean result = (this._progress == null || this._progress.isCanceled()) && !this._triggerUploadStart && !this._fileChosen;
        return result;
    }

    public boolean showClearButton() {
        boolean result;
        boolean bl = result = this._progress != null && this._progress.isSucceeded();
        if (!this.autoSubmit().booleanValue()) {
            result = this.showUploadButton() || result;
        }
        return result;
    }

    public boolean showUploadStarting() {
        boolean result = this._progress == null && this._triggerUploadStart;
        return result;
    }

    public boolean fileChosen() {
        return this._fileChosen;
    }

    public boolean showUploadButton() {
        return this._progress == null && this.fileChosen() && this.autoSubmit() == false && !this.showProgressBar();
    }

    @Override
    public AjaxUploadProgress uploadProgress() {
        if (this._progress == null) {
            this._progress = (AjaxUploadProgress)AjaxUploadProgress.progress(this.session(), this.id());
        }
        return this._progress;
    }

    public Boolean autoSubmit() {
        if (this._autoSubmit == null) {
            this._autoSubmit = ERXValueUtilities.BooleanValueWithDefault((Object)this.valueForBinding("autoSubmit"), (Boolean)Boolean.TRUE);
        }
        return this._autoSubmit;
    }

    public String progressStyle() {
        String style = null;
        AjaxUploadProgress progress = this.uploadProgress();
        if (progress != null) {
            if (!progress.isSucceeded()) {
                int width = (int)(progress.percentage() * 100.0);
                style = "width:" + width + "%;";
            } else {
                style = "width:100%;";
            }
        }
        return style;
    }

    public String progressClass() {
        String result = "AFUProgressAmount";
        return this.showUploadStarting() ? result + " AFUProgressAmountIndeterminate" : result;
    }

    public String refreshTime() {
        if (this._refreshTime == null) {
            double tempValue = ERXValueUtilities.doubleValueWithDefault((Object)this.valueForBinding("refreshTime"), (double)2000.0);
            this._refreshTime = String.valueOf(tempValue / 1000.0);
        }
        return this._refreshTime;
    }

    public String fileName() {
        return this._fileName;
    }

    public void setFileName(String fn) {
        this._fileName = fn;
    }

    @Override
    public String uploadLabel() {
        if (this._uploadLabel == null) {
            this._uploadLabel = (String)this.valueForBinding("uploadLabel");
            if (this._uploadLabel == null) {
                this._uploadLabel = "Upload";
            }
        }
        return this._uploadLabel;
    }

    public String clearLabel() {
        if (this._clearLabel == null) {
            this._clearLabel = (String)this.valueForBinding("clearLabel");
            if (this._clearLabel == null) {
                this._clearLabel = "Clear";
            }
        }
        return this._clearLabel;
    }

    public String cancelLabel() {
        if (this._cancelLabel == null) {
            this._cancelLabel = (String)this.valueForBinding("cancelLabel");
            if (this._cancelLabel == null) {
                this._cancelLabel = "Cancel";
            }
        }
        return this._cancelLabel;
    }

    public String selectFileLabel() {
        if (this._selectFileLabel == null) {
            this._selectFileLabel = (String)this.valueForBinding("selectFileLabel");
            if (this._selectFileLabel == null) {
                this._selectFileLabel = "Select File...";
            }
        }
        return this._selectFileLabel;
    }

    public String selectFileButtonClass() {
        if (this._selectFileButtonClass == null) {
            this._selectFileButtonClass = (String)this.valueForBinding("selectFileButtonClass");
            if (this._selectFileButtonClass == null) {
                this._selectFileButtonClass = "Button ObjButton SelectFileObjButton";
            }
        }
        return this._selectFileButtonClass;
    }

    public String uploadButtonClass() {
        if (this._uploadButtonClass == null) {
            this._uploadButtonClass = (String)this.valueForBinding("uploadButtonClass");
            if (this._uploadButtonClass == null) {
                this._uploadButtonClass = "Button ObjButton UploadFileObjButton";
            }
        }
        return this._uploadButtonClass;
    }

    public String cancelButtonClass() {
        if (this._cancelButtonClass == null) {
            this._cancelButtonClass = (String)this.valueForBinding("cancelButtonClass");
            if (this._cancelButtonClass == null) {
                this._cancelButtonClass = "Button ObjButton CancelUploadObjButton";
            }
        }
        return this._cancelButtonClass;
    }

    public String clearButtonClass() {
        if (this._clearButtonClass == null) {
            this._clearButtonClass = (String)this.valueForBinding("clearButtonClass");
            if (this._clearButtonClass == null) {
                this._clearButtonClass = "Button ObjButton ClearUploadObjButton";
            }
        }
        return this._clearButtonClass;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum UploadState {
        DORMANT,
        STARTED,
        INPROGRESS,
        CANCELED,
        FAILED,
        SUCCEEDED,
        FINISHED;

    }

    public static interface Keys {
        public static final String name = "name";
        public static final String wosid = "wosid";
        public static final String selectFileLabel = "selectFileLabel";
        public static final String cancelLabel = "cancelLabel";
        public static final String clearLabel = "clearLabel";
        public static final String uploadLabel = "uploadLabel";
        public static final String refreshTime = "refreshTime";
        public static final String autoSubmit = "autoSubmit";
        public static final String startedFunction = "startedFunction";
        public static final String canceledFunction = "canceledFunction";
        public static final String finishedFunction = "finishedFunction";
        public static final String failedFunction = "failedFunction";
        public static final String succeededFunction = "succeededFunction";
        public static final String selectFileButtonClass = "selectFileButtonClass";
        public static final String uploadButtonClass = "uploadButtonClass";
        public static final String cancelButtonClass = "cancelButtonClass";
        public static final String clearButtonClass = "clearButtonClass";
        public static final String injectDefaultCSS = "injectDefaultCSS";
        public static final String clearUploadProgressOnSuccess = "clearUploadProgressOnSuccess";
    }
}

