/*
 * Decompiled with CFR 0.152.
 */
package er.ajax;

import com.webobjects.appserver.WOActionResults;
import com.webobjects.appserver.WOComponent;
import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WORequest;
import com.webobjects.appserver.WOResponse;
import com.webobjects.appserver._private.WOForm;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSPathUtilities;
import er.ajax.AjaxComponent;
import er.ajax.AjaxConstantOption;
import er.ajax.AjaxOption;
import er.ajax.AjaxOptions;
import er.ajax.AjaxResponse;
import er.ajax.AjaxUpdateContainer;
import er.ajax.AjaxUtils;
import er.ajax.AjaxValue;
import er.extensions.appserver.ERXResponseRewriter;
import er.extensions.appserver.ERXWOContext;
import er.extensions.appserver.ajax.ERXAjaxApplication;
import er.extensions.components.ERXComponentUtilities;
import er.extensions.components._private.ERXWOForm;
import org.apache.log4j.Logger;

public class AjaxModalDialog
extends AjaxComponent {
    public static final String Close = "AMD.close();";
    public static final String Open_ElementID_Suffix = ".open";
    public static final String Close_ElementID_Suffix = ".close";
    private boolean _open;
    private WOComponent _actionResults;
    private AjaxModalDialog outerDialog;
    private boolean hasWarnedOnNesting = false;
    private WOComponent previousComponent;
    private String ajaxComponentActionUrl;
    public static final Logger logger = Logger.getLogger(AjaxModalDialog.class);

    public AjaxModalDialog(WOContext context) {
        super(context);
    }

    public boolean synchronizesVariablesWithBindings() {
        return false;
    }

    public boolean isOpen() {
        return this._open;
    }

    public void setOpen(boolean open) {
        this._open = open;
    }

    public static void open(WOContext context, String id) {
        AjaxUtils.javascriptResponse(AjaxModalDialog.openDialogFunctionName(id) + "();", context);
    }

    public static void open(WOContext context, String id, String title) {
        AjaxUtils.javascriptResponse(AjaxModalDialog.openDialogFunctionName(id) + "(" + AjaxValue.javaScriptEscaped(title) + ");", context);
    }

    public static String openDialogFunctionName(String id) {
        return "openAMD_" + id;
    }

    public static void close(WOContext context) {
        AjaxModalDialog.currentDialog(context).closeDialog();
        AjaxUtils.javascriptResponse(Close, context);
    }

    public static void update(WOContext context, String title) {
        AjaxModalDialog currentDialog = AjaxModalDialog.currentDialog(context);
        StringBuffer js = new StringBuffer(300);
        js.append("Modalbox.show('");
        js.append(currentDialog.openDialogURL(context));
        js.append("', ");
        NSMutableDictionary options = currentDialog.createModalBoxOptions();
        if (title != null) {
            options.setObjectForKey((Object)AjaxUtils.quote(title), (Object)"title");
        }
        AjaxOptions.appendToBuffer((NSDictionary)options, js, context);
        js.append(");\n");
        AjaxUtils.javascriptResponse(js.toString(), context);
        AjaxUtils.setPageReplacementCacheKey(context, currentDialog._containerID(context));
    }

    public static void update(WOContext context) {
        AjaxModalDialog.update(context, null);
    }

    public static void setTitle(WOContext context, String title) {
        AjaxUtils.javascriptResponse("$wi('MB_caption').innerHTML=" + AjaxValue.javaScriptEscaped(title) + ";", context);
    }

    public void setCurrentDialogInPageIfNecessary(WOActionResults results, WORequest request, WOContext context) {
        if (AjaxUtils.isAjaxRequest(request) && results instanceof WOComponent && results != context.page()) {
            ERXResponseRewriter.pageUserInfo((WOComponent)((WOComponent)results)).setObjectForKey((Object)this, (Object)AjaxModalDialog.class.getName());
        }
    }

    public static AjaxModalDialog _currentDialog(WOContext context) {
        AjaxModalDialog currentDialog = (AjaxModalDialog)ERXWOContext.contextDictionary().objectForKey((Object)AjaxModalDialog.class.getName());
        if (currentDialog == null) {
            currentDialog = (AjaxModalDialog)ERXResponseRewriter.pageUserInfo((WOContext)context).objectForKey((Object)AjaxModalDialog.class.getName());
        }
        return currentDialog;
    }

    public static AjaxModalDialog currentDialog(WOContext context) {
        AjaxModalDialog currentDialog = AjaxModalDialog._currentDialog(context);
        if (currentDialog == null) {
            throw new RuntimeException("Attempted to get current AjaxModalDialog when none active.  Check your page structure.");
        }
        return currentDialog;
    }

    public static boolean isInDialog(WOContext context) {
        return AjaxModalDialog._currentDialog(context) != null;
    }

    public void awake() {
        super.awake();
        if (this._actionResults != null) {
            this._actionResults._awakeInContext(this.context());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void takeValuesFromRequest(WORequest request, WOContext context) {
        block8: {
            this.ajaxComponentActionUrl = AjaxUtils.ajaxComponentActionUrl(this.context());
            if (this.isOpen()) {
                try {
                    this.pushDialog();
                    if (this._actionResults != null) {
                        this.pushActionResultsIntoContext(context);
                        try {
                            this._actionResults.takeValuesFromRequest(request, context);
                            break block8;
                        }
                        finally {
                            this.popActionResultsFromContext(context);
                        }
                    }
                    super.takeValuesFromRequest(request, context);
                }
                finally {
                    this.popDialog();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WOActionResults invokeAction(WORequest request, WOContext context) {
        this.ajaxComponentActionUrl = AjaxUtils.ajaxComponentActionUrl(this.context());
        this.pushDialog();
        try {
            WOActionResults result = null;
            if (this.shouldHandleRequest(request, context)) {
                result = super.invokeAction(request, context);
            } else if (this.isOpen()) {
                if (this._actionResults != null) {
                    this.pushActionResultsIntoContext(context);
                    try {
                        result = this._actionResults.invokeAction(request, context);
                    }
                    finally {
                        this.popActionResultsFromContext(context);
                    }
                } else {
                    result = super.invokeAction(request, context);
                }
            }
            this.setCurrentDialogInPageIfNecessary(result, request, context);
            WOActionResults wOActionResults = result;
            return wOActionResults;
        }
        finally {
            this.popDialog();
        }
    }

    protected boolean shouldHandleRequest(WORequest request, WOContext context) {
        String elementID = context.elementID();
        String senderID = context.senderID();
        if (senderID != null && (senderID.endsWith(Open_ElementID_Suffix) || senderID.endsWith(Close_ElementID_Suffix))) {
            senderID = NSPathUtilities.stringByDeletingPathExtension((String)senderID);
        }
        boolean shouldHandleRequest = elementID != null && (elementID.equals(senderID) || elementID.equals(ERXAjaxApplication.ajaxSubmitButtonName((WORequest)request)));
        return shouldHandleRequest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WOActionResults handleRequest(WORequest request, WOContext context) {
        AjaxResponse response = null;
        String modalBoxAction = NSPathUtilities.pathExtension((String)context.senderID());
        if ("close".equals(modalBoxAction)) {
            String closeUpdateContainerID = AjaxUpdateContainer.updateContainerID((String)this.valueForBinding("closeUpdateContainerID"));
            if (closeUpdateContainerID != null) {
                AjaxUpdateContainer.setUpdateContainerID(request, closeUpdateContainerID);
            }
            this.closeDialog();
        } else if ("open".equals(modalBoxAction) && !this.isOpen()) {
            this.openDialog();
            if (this.hasBinding("action")) {
                this._actionResults = (WOComponent)this.valueForBinding("action");
                this._actionResults._awakeInContext(context);
            } else if (this.hasBinding("pageName")) {
                this._actionResults = this.pageWithName((String)this.valueForBinding("pageName"));
                this._actionResults._awakeInContext(context);
            }
            if (this._actionResults != null && (this._actionResults.template() instanceof WOForm || this._actionResults.template() instanceof ERXWOForm)) {
                throw new RuntimeException(this._actionResults.name() + " is used as contents of AjaxModalDialog, but starts with WOForm tag.  " + "Action elements inside the dialog will not function.  Add a space at the start or end of " + this._actionResults.name() + ".html");
            }
        }
        if (this.isOpen()) {
            response = AjaxUtils.createResponse(request, context);
            AjaxUtils.setPageReplacementCacheKey(context, this._containerID(context));
            if (this._actionResults != null) {
                this.pushActionResultsIntoContext(context);
                try {
                    this._actionResults.appendToResponse((WOResponse)response, context);
                }
                finally {
                    this.popActionResultsFromContext(context);
                }
            } else {
                super.appendToResponse((WOResponse)response, context);
            }
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendToResponse(WOResponse response, WOContext context) {
        this.ajaxComponentActionUrl = AjaxUtils.ajaxComponentActionUrl(this.context());
        if (context.isInForm()) {
            logger.warn((Object)("The AjaxModalDialog should not be used inside of a WOForm (" + ERXWOForm.formName((WOContext)context, (String)"- not specified -") + ") if it contains any form inputs or buttons.  Remove this AMD from this form, add a form of its own. Replace it with " + "an AjaxModalDialogOpener with a dialogID that matches the ID of this dialog."));
            logger.warn((Object)("    page: " + context.page()));
            logger.warn((Object)("    component: " + context.component()));
        }
        if (!this.booleanValueForBinding("enabled", true)) {
            return;
        }
        if (this.isOpen() && !"ajax".equals(this.context().request().requestHandlerKey())) {
            this.closeDialog();
        }
        if (this.isOpen() && this.shouldHandleRequest(context.request(), context)) {
            if (this._actionResults != null) {
                throw new RuntimeException("Unexpected call to appendToResponse");
            }
            try {
                this.pushDialog();
                super.appendToResponse(response, context);
            }
            finally {
                this.popDialog();
            }
        } else {
            boolean showOpener = this.booleanValueForBinding("showOpener", true);
            if (showOpener) {
                response.appendContentString("<a href=\"javascript:void(0)\"");
                this.appendTagAttributeToResponse(response, "id", this.id());
                this.appendTagAttributeToResponse(response, "class", this.valueForBinding("class", null));
                this.appendTagAttributeToResponse(response, "style", this.valueForBinding("style", null));
                if (this.hasBinding("linkTitle")) {
                    this.appendTagAttributeToResponse(response, "title", this.valueForBinding("linkTitle", null));
                } else {
                    this.appendTagAttributeToResponse(response, "title", this.valueForBinding("title", null));
                }
                response.appendContentString(" onclick=\"");
                response.appendContentString(AjaxModalDialog.openDialogFunctionName(this.id()));
                response.appendContentString("(); return false;\" >");
                if (this.hasBinding("label")) {
                    response.appendContentString((String)this.valueForBinding("label"));
                } else {
                    super.appendToResponse(response, context);
                }
                response.appendContentString("</a>");
            }
            AjaxUtils.appendScriptHeader(response);
            response.appendContentString(AjaxModalDialog.openDialogFunctionName(this.id()));
            response.appendContentString(" = function(titleBarText) {\n");
            this.appendOpenModalDialogFunction(response, context);
            response.appendContentString("}\n");
            if (this.booleanValueForBinding("open", false)) {
                response.appendContentString(AjaxModalDialog.openDialogFunctionName(this.id()));
                response.appendContentString("();\n");
            }
            AjaxUtils.appendScriptFooter(response);
            this.addRequiredWebResources(response);
        }
    }

    protected void appendOpenModalDialogFunction(WOResponse response, WOContext context) {
        response.appendContentString("    options = ");
        AjaxOptions.appendToResponse((NSDictionary)this.createModalBoxOptions(), response, context);
        response.appendContentString(";\n");
        response.appendContentString("    if (titleBarText) options.title = titleBarText;\n");
        response.appendContentString("    Modalbox.show('");
        response.appendContentString(this.openDialogURL(context));
        response.appendContentString("', options);\n");
    }

    public void sleep() {
        if (this._actionResults != null) {
            this._actionResults._sleepInContext(this.context());
        }
        this.ajaxComponentActionUrl = null;
        super.sleep();
    }

    public void openDialog() {
        if (this.hasBinding("onOpen")) {
            this.valueForBinding("onOpen");
        }
        this.setOpen(true);
    }

    public void closeDialog() {
        if (this.isOpen()) {
            if (this.hasBinding("onClose")) {
                this.valueForBinding("onClose");
            }
            this.setOpen(false);
            this._actionResults = null;
        }
    }

    protected String _containerID(WOContext context) {
        return this.id();
    }

    public String id() {
        return this.hasBinding("id") ? (String)this.valueForBinding("id") : ERXWOContext.safeIdentifierName((WOContext)this.context(), (boolean)false);
    }

    public String templateName() {
        return !this.isOpen() && !this.hasBinding("label") ? "link" : null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected NSMutableDictionary createModalBoxOptions() {
        String serverUpdate;
        NSMutableArray ajaxOptionsArray = new NSMutableArray();
        ajaxOptionsArray.addObject((Object)new AjaxOption("title", AjaxOption.STRING));
        ajaxOptionsArray.addObject((Object)new AjaxOption("width", AjaxOption.NUMBER));
        ajaxOptionsArray.addObject((Object)new AjaxOption("centerVertically", AjaxOption.BOOLEAN));
        ajaxOptionsArray.addObject((Object)new AjaxOption("overlayClose", AjaxOption.BOOLEAN));
        ajaxOptionsArray.addObject((Object)new AjaxOption("height", AjaxOption.NUMBER));
        ajaxOptionsArray.addObject((Object)new AjaxOption("method", AjaxOption.STRING));
        ajaxOptionsArray.addObject((Object)new AjaxOption("params", AjaxOption.DICTIONARY));
        ajaxOptionsArray.addObject((Object)new AjaxOption("loadingString", AjaxOption.STRING));
        ajaxOptionsArray.addObject((Object)new AjaxOption("closeString", AjaxOption.STRING));
        ajaxOptionsArray.addObject((Object)new AjaxOption("closeValue", AjaxOption.STRING));
        ajaxOptionsArray.addObject((Object)new AjaxOption("locked", AjaxOption.BOOLEAN));
        ajaxOptionsArray.addObject((Object)new AjaxOption("overlayOpacity", AjaxOption.NUMBER));
        ajaxOptionsArray.addObject((Object)new AjaxOption("overlayDuration", AjaxOption.NUMBER));
        ajaxOptionsArray.addObject((Object)new AjaxOption("slideDownDuration", AjaxOption.NUMBER));
        ajaxOptionsArray.addObject((Object)new AjaxOption("slideUpDuration", AjaxOption.NUMBER));
        ajaxOptionsArray.addObject((Object)new AjaxOption("resizeDuration", AjaxOption.NUMBER));
        ajaxOptionsArray.addObject((Object)new AjaxOption("inactiveFade", AjaxOption.BOOLEAN));
        ajaxOptionsArray.addObject((Object)new AjaxOption("transitions", AjaxOption.BOOLEAN));
        ajaxOptionsArray.addObject((Object)new AjaxOption("autoFocusing", AjaxOption.BOOLEAN));
        ajaxOptionsArray.addObject((Object)new AjaxOption("clickOnReturnId", AjaxOption.STRING));
        ajaxOptionsArray.addObject((Object)new AjaxOption("clickOnEscId", AjaxOption.STRING));
        ajaxOptionsArray.addObject((Object)new AjaxOption("beforeLoad", AjaxOption.SCRIPT));
        ajaxOptionsArray.addObject((Object)new AjaxOption("afterLoad", AjaxOption.SCRIPT));
        ajaxOptionsArray.addObject((Object)new AjaxOption("beforeHide", AjaxOption.SCRIPT));
        ajaxOptionsArray.addObject((Object)new AjaxOption("afterResize", AjaxOption.SCRIPT));
        ajaxOptionsArray.addObject((Object)new AjaxOption("onShow", AjaxOption.SCRIPT));
        ajaxOptionsArray.addObject((Object)new AjaxOption("onUpdate", AjaxOption.SCRIPT));
        String closeUpdateContainerID = AjaxUpdateContainer.updateContainerID((String)this.valueForBinding("closeUpdateContainerID"));
        if (closeUpdateContainerID == null) {
            serverUpdate = " AUL.request('" + this.closeDialogURL(this.context()) + "', null, null, null);";
        } else {
            String onCloseBeforeUpdate = (String)this.valueForBinding("onCloseBeforeUpdate", "AMD.shouldRefreshCloseUpdateContainer");
            String verifyUpdateContainerRefreshScript = " if (" + onCloseBeforeUpdate + ") { ";
            serverUpdate = verifyUpdateContainerRefreshScript + "AUL._update('" + closeUpdateContainerID + "', '" + this.closeDialogURL(this.context()) + "', null, null, null); } else { new Ajax.Request('" + this.closeDialogURL(this.context()) + "'); }";
        }
        if (this.hasBinding("afterHide")) {
            String afterHide = (String)this.valueForBinding("afterHide");
            int openingBraceIndex = afterHide.indexOf(123);
            if (openingBraceIndex <= -1) throw new RuntimeException("Don't know how to handle afterHide value '" + afterHide + "', did you forget to wrap it in function() { ...}?");
            serverUpdate = "function() {" + serverUpdate + " " + afterHide.substring(openingBraceIndex + 1);
        } else {
            serverUpdate = "function(v) { " + serverUpdate + '}';
        }
        ajaxOptionsArray.addObject((Object)new AjaxConstantOption("afterHide", serverUpdate, AjaxOption.SCRIPT));
        return AjaxOption.createAjaxOptionsDictionary((NSArray<AjaxOption>)ajaxOptionsArray, this);
    }

    protected void addRequiredWebResources(WOResponse response) {
        this.addScriptResourceInHead(response, "prototype.js");
        this.addScriptResourceInHead(response, "wonder.js");
        this.addScriptResourceInHead(response, "effects.js");
        this.addScriptResourceInHead(response, "modalbox.js");
        ERXResponseRewriter.addStylesheetResourceInHead((WOResponse)response, (WOContext)this.context(), (String)this.cssFileFrameworkName(), (String)this.cssFileName());
    }

    protected String cssFileName() {
        return (String)this.valueForBinding("modalboxCSS", "modalbox.css");
    }

    protected String cssFileFrameworkName() {
        return (String)this.valueForBinding("modalboxCSSFramework", "Ajax");
    }

    protected void pushDialog() {
        this.outerDialog = (AjaxModalDialog)ERXWOContext.contextDictionary().objectForKey((Object)AjaxModalDialog.class.getName());
        ERXWOContext.contextDictionary().setObjectForKey((Object)this, (Object)AjaxModalDialog.class.getName());
        if (!this.hasWarnedOnNesting && this.outerDialog != null) {
            this.hasWarnedOnNesting = true;
            if (!ERXComponentUtilities.booleanValueForBinding((WOComponent)this, (String)"ignoreNesting", (boolean)false)) {
                logger.warn((Object)("AjaxModalDialog " + this.id() + " is nested inside of " + this.outerDialog.id() + ". Are you sure you want to do this?"));
            }
        }
    }

    protected void popDialog() {
        if (this.outerDialog != null) {
            ERXWOContext.contextDictionary().setObjectForKey((Object)this.outerDialog, (Object)AjaxModalDialog.class.getName());
        } else {
            ERXWOContext.contextDictionary().removeObjectForKey((Object)AjaxModalDialog.class.getName());
        }
    }

    protected void pushActionResultsIntoContext(WOContext context) {
        this.previousComponent = context.component();
        context._setCurrentComponent(this._actionResults);
    }

    protected void popActionResultsFromContext(WOContext context) {
        context._setCurrentComponent(this.previousComponent);
    }

    protected String openDialogURL(WOContext context) {
        return new StringBuffer(this.ajaxComponentActionUrl).append(Open_ElementID_Suffix).toString();
    }

    protected String closeDialogURL(WOContext context) {
        return new StringBuffer(this.ajaxComponentActionUrl).append(Close_ElementID_Suffix).toString();
    }
}

