/*
 * Decompiled with CFR 0.152.
 */
package er.ajax;

import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSMutableDictionary;
import er.extensions.foundation.ERXMutableURL;
import er.extensions.foundation.ERXStringUtilities;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AjaxSocialNetwork {
    private static NSMutableDictionary<String, AjaxSocialNetwork> _socialNetworks = new NSMutableDictionary();

    public static AjaxSocialNetwork socialNetworkNamed(String name) {
        AjaxSocialNetwork socialNetwork = (AjaxSocialNetwork)_socialNetworks.objectForKey((Object)name);
        if (socialNetwork == null) {
            throw new NoSuchElementException("There is no AjaxSocialNetwork named '" + name + "'.");
        }
        return socialNetwork;
    }

    public static void registerSocialNetworkNamed(AjaxSocialNetwork socialNetwork, String name) {
        _socialNetworks.setObjectForKey((Object)socialNetwork, (Object)name);
    }

    protected String _submissionUrl(String baseUrl, String urlKey, String targetUrl, String titleKey, String title, NSDictionary<String, String> additionalParams) {
        try {
            ERXMutableURL url = new ERXMutableURL(baseUrl);
            url.setQueryParameter(urlKey, targetUrl);
            if (titleKey != null && title != null) {
                url.setQueryParameter(titleKey, title);
            }
            if (additionalParams != null) {
                url.addQueryParameters(additionalParams);
            }
            return url.toString();
        }
        catch (Throwable t) {
            throw new RuntimeException("Failed to create a URL for '" + baseUrl + "' with the targetUrl '" + targetUrl + "'");
        }
    }

    public String name() {
        return ERXStringUtilities.displayNameForKey((String)this.getClass().getSimpleName());
    }

    public String iconFramework() {
        return "Ajax";
    }

    public String iconName() {
        return "SocialNetwork/" + this.getClass().getSimpleName() + ".png";
    }

    public abstract String submissionUrl(String var1, String var2);

    static {
        _socialNetworks.setObjectForKey((Object)new Delicious(), (Object)"delicious");
        _socialNetworks.setObjectForKey((Object)new Digg(), (Object)"digg");
        _socialNetworks.setObjectForKey((Object)new Facebook(), (Object)"facebook");
        _socialNetworks.setObjectForKey((Object)new Furl(), (Object)"furl");
        _socialNetworks.setObjectForKey((Object)new Newsvine(), (Object)"newsvine");
        _socialNetworks.setObjectForKey((Object)new Netscape(), (Object)"netscape");
        _socialNetworks.setObjectForKey((Object)new Reddit(), (Object)"reddit");
        _socialNetworks.setObjectForKey((Object)new StumbleUpon(), (Object)"stumble");
        _socialNetworks.setObjectForKey((Object)new Technorati(), (Object)"technorati");
        _socialNetworks.setObjectForKey((Object)new Squidoo(), (Object)"squidoo");
        _socialNetworks.setObjectForKey((Object)new WindowsLive(), (Object)"live");
        _socialNetworks.setObjectForKey((Object)new YahooMyWeb(), (Object)"yahoo");
        _socialNetworks.setObjectForKey((Object)new Ask(), (Object)"ask");
        _socialNetworks.setObjectForKey((Object)new Google(), (Object)"google");
        _socialNetworks.setObjectForKey((Object)new Magnolia(), (Object)"magnolia");
        _socialNetworks.setObjectForKey((Object)new Ning(), (Object)"ning");
        _socialNetworks.setObjectForKey((Object)new Rawsugar(), (Object)"rawsugar");
        _socialNetworks.setObjectForKey((Object)new Spurl(), (Object)"spurl");
        _socialNetworks.setObjectForKey((Object)new Tagtooga(), (Object)"tagtooga");
    }

    public static class Tagtooga
    extends AjaxSocialNetwork {
        public String submissionUrl(String url, String title) {
            return this._submissionUrl("http://www.tagtooga.com/tapp/db.exe", "url", url, "title", title, (NSDictionary<String, String>)new NSDictionary((Object[])new String[]{"jsEntryForm", "fx"}, (Object[])new String[]{"c", "b"}));
        }
    }

    public static class Spurl
    extends AjaxSocialNetwork {
        public String submissionUrl(String url, String title) {
            return this._submissionUrl("http://www.spurl.net/spurl.php", "url", url, "title", title, null);
        }
    }

    public static class Rawsugar
    extends AjaxSocialNetwork {
        public String submissionUrl(String url, String title) {
            return this._submissionUrl("http://www.rawsugar.com/pages/tagger.faces", "url", url, "tttl", title, null);
        }
    }

    public static class Ning
    extends AjaxSocialNetwork {
        public String submissionUrl(String url, String title) {
            return this._submissionUrl("http://bookmarks.ning.com/addItem.php", "url", url, "T", title, null);
        }
    }

    public static class Magnolia
    extends AjaxSocialNetwork {
        public String submissionUrl(String url, String title) {
            return this._submissionUrl("http://ma.gnolia.com/bookmarklet/snap/add", "url", url, "title", title, null);
        }
    }

    public static class Google
    extends AjaxSocialNetwork {
        public String submissionUrl(String url, String title) {
            return this._submissionUrl("http://www.google.com/bookmarks/mark", "bkmk", url, "title", title, (NSDictionary<String, String>)new NSDictionary((Object[])new String[]{"edit", "popup"}, (Object[])new String[]{"op", "output"}));
        }
    }

    public static class Ask
    extends AjaxSocialNetwork {
        public String submissionUrl(String url, String title) {
            return this._submissionUrl("http://myjeeves.ask.com/mysearch/BookmarkIt", "url", url, "title", title, (NSDictionary<String, String>)new NSDictionary((Object[])new String[]{"1.2", "webpages"}, (Object[])new String[]{"v", "t"}));
        }
    }

    public static class YahooMyWeb
    extends AjaxSocialNetwork {
        public String name() {
            return "Yahoo MyWeb";
        }

        public String submissionUrl(String url, String title) {
            return this._submissionUrl("http://myweb.yahoo.com/myresults/bookmarklet", "u", url, "t", title, (NSDictionary<String, String>)new NSDictionary((Object)"UTF", (Object)"ei"));
        }
    }

    public static class WindowsLive
    extends AjaxSocialNetwork {
        public String submissionUrl(String url, String title) {
            return this._submissionUrl("https://favorites.live.com/quickadd.aspx", "url", url, "title", title, (NSDictionary<String, String>)new NSDictionary((Object[])new String[]{"1", "en-us", "1"}, (Object[])new String[]{"marklet", "mkt", "top"}));
        }
    }

    public static class Squidoo
    extends AjaxSocialNetwork {
        public String submissionUrl(String url, String title) {
            return this._submissionUrl("http://www.squidoo.com/lensmaster/bookmark", null, url, "title", title, null);
        }
    }

    public static class Technorati
    extends AjaxSocialNetwork {
        public String submissionUrl(String url, String title) {
            return this._submissionUrl("ttp://technorati.com/faves", "add", url, null, null, null);
        }
    }

    public static class StumbleUpon
    extends AjaxSocialNetwork {
        public String submissionUrl(String url, String title) {
            return this._submissionUrl("http://www.stumbleupon.com/submit", "url", url, "title", title, null);
        }

        public String iconName() {
            return "SocialNetwork/StumbleUpon.gif";
        }
    }

    public static class Reddit
    extends AjaxSocialNetwork {
        public String submissionUrl(String url, String title) {
            return this._submissionUrl("http://reddit.com/submit", "url", url, "title", title, null);
        }

        public String iconName() {
            return "SocialNetwork/Reddit.gif";
        }
    }

    public static class Facebook
    extends AjaxSocialNetwork {
        public String submissionUrl(String url, String title) {
            return this._submissionUrl("http://www.facebook.com/sharer.php", "u", url, "t", title, null);
        }

        public String iconName() {
            return "SocialNetwork/Facebook.gif";
        }
    }

    public static class Netscape
    extends AjaxSocialNetwork {
        public String submissionUrl(String url, String title) {
            return this._submissionUrl("http://www.netscape.com/submit/", "U", url, "T", title, null);
        }
    }

    public static class Newsvine
    extends AjaxSocialNetwork {
        public String submissionUrl(String url, String title) {
            return this._submissionUrl("http://www.newsvine.com/_tools/seed&save", "u", url, "T", title, null);
        }
    }

    public static class Furl
    extends AjaxSocialNetwork {
        public String iconName() {
            return "SocialNetwork/Furl.gif";
        }

        public String submissionUrl(String url, String title) {
            return this._submissionUrl("http://www.furl.net/store", "u", url, "ti", title, (NSDictionary<String, String>)new NSDictionary((Object[])new String[]{"f", "0"}, (Object[])new String[]{"s", "to"}));
        }
    }

    public static class Digg
    extends AjaxSocialNetwork {
        public String submissionUrl(String url, String title) {
            return this._submissionUrl("http://digg.com/submit", "url", url, "title", title, (NSDictionary<String, String>)new NSDictionary((Object)"2", (Object)"phase"));
        }
    }

    public static class Delicious
    extends AjaxSocialNetwork {
        public String submissionUrl(String url, String title) {
            return this._submissionUrl("http://del.icio.us/post", "url", url, "title", title, null);
        }
    }
}

