/*
 * Decompiled with CFR 0.152.
 */
package er.ajax;

import com.webobjects.appserver.WOActionResults;
import com.webobjects.appserver.WOAssociation;
import com.webobjects.appserver.WOComponent;
import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WOElement;
import com.webobjects.appserver.WORequest;
import com.webobjects.appserver.WOResponse;
import com.webobjects.appserver._private.WOConstantValueAssociation;
import com.webobjects.appserver._private.WODynamicGroup;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSMutableArray;
import er.ajax.AjaxDynamicElement;
import er.ajax.AjaxTabbedPanelTab;
import er.ajax.AjaxUtils;

public class AjaxTabbedPanel
extends AjaxDynamicElement {
    private WOElement content;
    private NSMutableArray tabs = new NSMutableArray();
    private WOAssociation id;
    private WOAssociation busyDiv;
    private WOAssociation onLoad;
    private WOAssociation onSelect;

    public AjaxTabbedPanel(String name, NSDictionary associations, WOElement template) {
        super(name, associations, template);
        this.content = template;
        this.id = (WOAssociation)associations.objectForKey((Object)"id");
        this.busyDiv = (WOAssociation)associations.objectForKey((Object)"busyDiv");
        this.onLoad = (WOAssociation)associations.objectForKey((Object)"onLoad");
        this.onSelect = (WOAssociation)associations.objectForKey((Object)"onSelect");
        this.findTabs((WODynamicGroup)template);
        if (this.id == null) {
            throw new RuntimeException("id binding is required");
        }
    }

    private void findTabs(WODynamicGroup template) {
        if (template == null || template.childrenElements() == null) {
            return;
        }
        NSMutableArray children = template.childrenElements();
        for (int i = 0; i < children.count(); ++i) {
            WOElement child = (WOElement)children.objectAtIndex(i);
            if (child instanceof AjaxTabbedPanelTab) {
                AjaxTabbedPanelTab childTab = (AjaxTabbedPanelTab)child;
                if (childTab.id() == null) {
                    childTab.setId((WOAssociation)new WOConstantValueAssociation((Object)(this.id.valueInComponent(null) + "_pane_" + this.tabs.count())));
                }
                this.tabs.addObject((Object)childTab);
                continue;
            }
            if (!(child instanceof WODynamicGroup)) continue;
            this.findTabs((WODynamicGroup)child);
        }
    }

    public void appendToResponse(WOResponse response, WOContext context) {
        WOComponent component = context.component();
        String idString = (String)this.id.valueInComponent(component);
        if (idString == null) {
            throw new RuntimeException("id binding evaluated to null");
        }
        response.appendContentString("<ul class=\"ajaxTabbedPanel\"");
        this.appendTagAttributeToResponse(response, "id", idString);
        if (this.onLoad != null) {
            this.appendTagAttributeToResponse(response, "onLoad", this.onLoad.valueInComponent(component));
        }
        if (this.onSelect != null) {
            this.appendTagAttributeToResponse(response, "onSelect", this.onSelect.valueInComponent(component));
        }
        response.appendContentString(">\n");
        String paneControlID = idString + "_panecontrol";
        for (int i = 0; i < this.tabs.count(); ++i) {
            String index = new Integer(i).toString();
            String tabID = idString + "_tab_" + index;
            AjaxTabbedPanelTab tab = (AjaxTabbedPanelTab)this.tabs.objectAtIndex(i);
            if (!tab.isVisble(component)) continue;
            boolean isSelectedTab = tab.isSelected(context.component());
            String panelTabID = (String)tab.id().valueInComponent(component);
            String panelID = panelTabID + "_panel";
            response.appendContentString("  <li class=\"ajaxTabbedPanelTab-");
            response.appendContentString(isSelectedTab ? "selected" : "unselected");
            response.appendContentString("\" ");
            this.appendTagAttributeToResponse(response, "id", tabID);
            response.appendContentString(">\n");
            response.appendContentString("<a ");
            if (tab.accesskey() != null) {
                String accessKeyStr = tab.accesskey().valueInComponent(component).toString();
                this.appendTagAttributeToResponse(response, "accesskey", accessKeyStr);
            }
            this.appendTagAttributeToResponse(response, "id", panelTabID);
            response.appendContentString(" href=\"javascript:void(0)\" onclick=\"");
            response.appendContentString("AjaxTabbedPanel.loadPanel('");
            response.appendContentString(idString);
            response.appendContentString("', '");
            response.appendContentString(panelID);
            response.appendContentString("', '");
            response.appendContentString(this.busyDiv != null ? (String)this.busyDiv.valueInComponent(component) : "");
            response.appendContentString("', ");
            response.appendContentString(tab.refreshesOnSelect(context.component()).toString());
            response.appendContentString("); ");
            response.appendContentString("AjaxTabbedPanel.selectPanel('");
            response.appendContentString(paneControlID);
            response.appendContentString("', '");
            response.appendContentString(panelID);
            response.appendContentString("'); ");
            response.appendContentString("AjaxTabbedPanel.selectTab('");
            response.appendContentString(idString);
            response.appendContentString("', '");
            response.appendContentString(tabID);
            response.appendContentString("', '");
            response.appendContentString(panelID);
            response.appendContentString("', '");
            response.appendContentString(this.busyDiv != null ? (String)this.busyDiv.valueInComponent(component) : "");
            response.appendContentString("'); ");
            response.appendContentString("\">");
            response.appendContentString((String)tab.name().valueInComponent(component));
            response.appendContentString("</a>\n");
            response.appendContentString("</li>\n");
        }
        response.appendContentString("</ul>\n");
        response.appendContentString("<ul class=\"ajaxTabbedPanelPanes\" ");
        this.appendTagAttributeToResponse(response, "id", paneControlID);
        response.appendContentString(">\n");
        if (this.content != null) {
            this.content.appendToResponse(response, context);
        }
        response.appendContentString("</ul>\n");
        super.appendToResponse(response, context);
        response.appendContentString("<script>AjaxTabbedPanel.onLoad('");
        response.appendContentString(idString);
        response.appendContentString("');</script>\n");
    }

    protected void addRequiredWebResources(WOResponse response, WOContext context) {
        AjaxUtils.addScriptResourceInHead(context, response, "prototype.js");
        AjaxUtils.addScriptResourceInHead(context, response, "wonder.js");
        AjaxUtils.addScriptResourceInHead(context, response, "switchtabs.js");
    }

    public WOActionResults handleRequest(WORequest request, WOContext context) {
        return null;
    }
}

