/*
 * Decompiled with CFR 0.152.
 */
package er.ajax;

import com.webobjects.appserver.WOActionResults;
import com.webobjects.appserver.WOAssociation;
import com.webobjects.appserver.WOComponent;
import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WOElement;
import com.webobjects.appserver.WORequest;
import com.webobjects.appserver.WOResponse;
import com.webobjects.foundation.NSDictionary;
import er.ajax.AjaxDynamicElement;
import er.ajax.AjaxResponse;
import er.ajax.AjaxUtils;

public class AjaxTabbedPanelTab
extends AjaxDynamicElement {
    private WOElement content;
    private WOAssociation name;
    private WOAssociation id;
    private WOAssociation isSelected;
    private WOAssociation refreshOnSelect;
    private WOAssociation onLoad;
    private WOAssociation isVisible;
    private WOAssociation accesskey;

    public AjaxTabbedPanelTab(String aName, NSDictionary associations, WOElement template) {
        super(aName, associations, template);
        this.content = template;
        this.name = (WOAssociation)associations.objectForKey((Object)"name");
        this.id = (WOAssociation)associations.objectForKey((Object)"id");
        this.isSelected = (WOAssociation)associations.objectForKey((Object)"isSelected");
        this.refreshOnSelect = (WOAssociation)associations.objectForKey((Object)"refreshOnSelect");
        this.onLoad = (WOAssociation)associations.objectForKey((Object)"onLoad");
        this.isVisible = (WOAssociation)associations.objectForKey((Object)"isVisible");
        this.accesskey = (WOAssociation)associations.objectForKey((Object)"accesskey");
        if (this.name == null) {
            throw new RuntimeException("name binding is required");
        }
    }

    public void appendToResponse(WOResponse aResponse, WOContext aContext) {
        WOComponent component = aContext.component();
        if (this.isVisble(component)) {
            aResponse.appendContentString("<li id=\"");
            aResponse.appendContentString((String)this.id().valueInComponent(component) + "_panel");
            aResponse.appendContentString("\" updateUrl=\"");
            aResponse.appendContentString(AjaxUtils.ajaxComponentActionUrl(aContext));
            aResponse.appendContentString("\" class=\"");
            aResponse.appendContentString(this.isSelected(component) ? "ajaxTabbedPanelPane-selected" : "ajaxTabbedPanelPane-unselected");
            aResponse.appendContentString("\"");
            if (this.onLoad != null) {
                this.appendTagAttributeToResponse(aResponse, "onLoad", this.onLoad.valueInComponent(component));
            }
            aResponse.appendContentString(">");
            if (this.isSelected(component) && this.content != null) {
                this.content.appendToResponse(aResponse, aContext);
            }
            aResponse.appendContentString("</li>\n");
            if (this.isSelected(component) && this.content != null) {
                aResponse.appendContentString("<script>AjaxTabbedPanel.onLoad('");
                aResponse.appendContentString((String)this.id().valueInComponent(component) + "_panel");
                aResponse.appendContentString("');</script>\n");
            }
        }
    }

    public void takeValuesFromRequest(WORequest request, WOContext context) {
        if (this.isVisble(context.component()) && (this.isSelected == null || this.isSelected(context.component()))) {
            super.takeChildrenValuesFromRequest(request, context);
        }
    }

    public WOActionResults invokeAction(WORequest request, WOContext context) {
        if (this.isVisble(context.component())) {
            return super.invokeAction(request, context);
        }
        return null;
    }

    public boolean isSelected(WOComponent component) {
        return this.isSelected != null ? this.isSelected.booleanValueInComponent(component) : false;
    }

    public void setIsSelected(WOComponent component, boolean isTabSelected) {
        if (this.isSelected != null && this.isSelected.isValueSettableInComponent(component)) {
            this.isSelected.setValue((Object)new Boolean(isTabSelected), component);
        }
    }

    protected void addRequiredWebResources(WOResponse response, WOContext context) {
    }

    public WOActionResults handleRequest(WORequest request, WOContext context) {
        AjaxResponse response = null;
        String didSelect = request.stringFormValueForKey("didSelect");
        if (didSelect == null) {
            response = AjaxUtils.createResponse(request, context);
            AjaxUtils.setPageReplacementCacheKey(context, this._containerID(context));
            if (this.content != null) {
                this.content.appendToResponse((WOResponse)response, context);
            }
        } else {
            this.setIsSelected(context.component(), didSelect.equals("true"));
        }
        return response;
    }

    protected String _containerID(WOContext context) {
        return (String)this.id().valueInComponent(context.component()) + "_panel";
    }

    public WOAssociation id() {
        return this.id;
    }

    public void setId(WOAssociation newID) {
        this.id = newID;
    }

    public WOAssociation name() {
        return this.name;
    }

    public Boolean refreshesOnSelect(WOComponent component) {
        return this.refreshOnSelect != null ? (Boolean)this.refreshOnSelect.valueInComponent(component) : Boolean.FALSE;
    }

    public boolean isVisble(WOComponent component) {
        return this.isVisible != null ? (Boolean)this.isVisible.valueInComponent(component) : true;
    }

    public WOAssociation accesskey() {
        return this.accesskey;
    }
}

