/*
 * Decompiled with CFR 0.152.
 */
package er.ajax;

import com.webobjects.appserver.WOApplication;
import com.webobjects.appserver.WOAssociation;
import com.webobjects.appserver.WOComponent;
import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WOMessage;
import com.webobjects.appserver.WORequest;
import com.webobjects.appserver.WOResponse;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSMutableDictionary;
import er.ajax.AjaxRequestHandler;
import er.ajax.AjaxResponse;
import er.ajax.AjaxUpdateContainer;
import er.ajax.AjaxValue;
import er.extensions.appserver.ERXRedirect;
import er.extensions.appserver.ERXResourceManager;
import er.extensions.appserver.ERXResponseRewriter;
import er.extensions.appserver.ERXWOContext;
import er.extensions.appserver.ajax.ERXAjaxApplication;
import er.extensions.formatters.ERXNumberFormatter;
import er.extensions.formatters.ERXTimestampFormatter;
import er.extensions.foundation.ERXProperties;
import er.extensions.foundation.ERXStringUtilities;
import java.util.Collection;
import org.apache.log4j.Logger;
import org.jabsorb.JSONSerializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AjaxUtils {
    private static final Logger log = Logger.getLogger(AjaxUtils.class);
    private static final String SECURE_RESOURCES_KEY = "er.ajax.secureResources";

    public static String quote(String value) {
        return value == null ? "null" : "'" + value + "'";
    }

    public static boolean isAjaxRequest(WORequest request) {
        return ERXAjaxApplication.isAjaxRequest((WORequest)request);
    }

    public static void setPageReplacementCacheKey(WOContext _context, String _key) {
        _context.request().setHeader(_key, "page_cache_key");
    }

    public static AjaxResponse createResponse(WORequest request, WOContext context) {
        AjaxResponse response = null;
        if (context != null && context.response() != null) {
            WOResponse existingResponse = context.response();
            if (existingResponse instanceof AjaxResponse) {
                response = (AjaxResponse)existingResponse;
            } else {
                response = new AjaxResponse(request, context);
                response.setHeaders(existingResponse.headers());
                response.setUserInfo(existingResponse.userInfo());
                response.appendContentString(existingResponse.contentString());
            }
        }
        if (response == null) {
            response = new AjaxResponse(request, context);
            response.setHeader("text/plain; charset=utf-8", "content-type");
        }
        if (context != null) {
            context._setResponse(response);
        }
        response.setHeader("Connection", "keep-alive");
        response.setHeader("erxsession.dont_store_page", "erxsession.dont_store_page");
        return response;
    }

    public static NSMutableDictionary mutableUserInfo(WOMessage message) {
        return ERXWOContext.contextDictionary();
    }

    public static void addScriptResourceInHead(WOContext context, WOResponse response, String framework, String fileName) {
        String processedFileName = fileName;
        if (ERXProperties.booleanForKey((String)"er.ajax.compressed") && ("prototype.js".equals(fileName) || "scriptaculous.js".equals(fileName))) {
            processedFileName = "sc-17-proto-15-compressed.js";
        }
        ERXResponseRewriter.addScriptResourceInHead((WOResponse)response, (WOContext)context, (String)framework, (String)processedFileName);
    }

    public static void addScriptResourceInHead(WOContext context, WOResponse response, String fileName) {
        AjaxUtils.addScriptResourceInHead(context, response, "Ajax", fileName);
    }

    public static void addStylesheetResourceInHead(WOContext context, WOResponse response, String framework, String fileName) {
        ERXResponseRewriter.addStylesheetResourceInHead((WOResponse)response, (WOContext)context, (String)framework, (String)fileName);
    }

    public static void addStylesheetResourceInHead(WOContext context, WOResponse response, String fileName) {
        AjaxUtils.addStylesheetResourceInHead(context, response, "Ajax", fileName);
    }

    public static void addResourceInHead(WOContext context, WOResponse response, String framework, String fileName, String startTag, String endTag) {
        ERXResponseRewriter.addResourceInHead((WOResponse)response, (WOContext)context, (String)framework, (String)fileName, (String)startTag, (String)endTag, (ERXResponseRewriter.TagMissingBehavior)ERXResponseRewriter.TagMissingBehavior.Top);
        if (!(WOApplication.application().resourceManager() instanceof ERXResourceManager) && "Ajax".equals(framework) && "scriptaculous.js".equals(fileName) && context.request() != null && (context.request() == null || !context.request().isUsingWebServer() || WOApplication.application()._rapidTurnaroundActiveForAnyProject())) {
            boolean enqueueIfTagMissing = !AjaxUtils.isAjaxRequest(context.request());
            ERXResponseRewriter.addResourceInHead((WOResponse)response, (WOContext)context, (String)framework, (String)"builder.js", (String)startTag, (String)endTag, (ERXResponseRewriter.TagMissingBehavior)ERXResponseRewriter.TagMissingBehavior.Top);
            ERXResponseRewriter.addResourceInHead((WOResponse)response, (WOContext)context, (String)framework, (String)"effects.js", (String)startTag, (String)endTag, (ERXResponseRewriter.TagMissingBehavior)ERXResponseRewriter.TagMissingBehavior.Top);
            ERXResponseRewriter.addResourceInHead((WOResponse)response, (WOContext)context, (String)framework, (String)"dragdrop.js", (String)startTag, (String)endTag, (ERXResponseRewriter.TagMissingBehavior)ERXResponseRewriter.TagMissingBehavior.Top);
            ERXResponseRewriter.addResourceInHead((WOResponse)response, (WOContext)context, (String)framework, (String)"controls.js", (String)startTag, (String)endTag, (ERXResponseRewriter.TagMissingBehavior)ERXResponseRewriter.TagMissingBehavior.Top);
            ERXResponseRewriter.addResourceInHead((WOResponse)response, (WOContext)context, (String)framework, (String)"slider.js", (String)startTag, (String)endTag, (ERXResponseRewriter.TagMissingBehavior)ERXResponseRewriter.TagMissingBehavior.Top);
        }
    }

    public static void addScriptCodeInHead(WOResponse response, WOContext context, String script) {
        ERXResponseRewriter.addScriptCodeInHead((WOResponse)response, (WOContext)context, (String)script);
    }

    public static String toSafeElementID(String elementID) {
        return ERXStringUtilities.safeIdentifierName((String)elementID);
    }

    public static boolean shouldHandleRequest(WORequest request, WOContext context, String containerID) {
        String elementID = context.elementID();
        String senderID = context.senderID();
        String updateContainerID = null;
        if (containerID != null && AjaxResponse.isAjaxUpdatePass(request)) {
            updateContainerID = AjaxUpdateContainer.updateContainerID(request);
        }
        boolean shouldHandleRequest = elementID != null && (elementID.equals(senderID) || containerID != null && containerID.equals(updateContainerID) || elementID.equals(ERXAjaxApplication.ajaxSubmitButtonName((WORequest)request)));
        return shouldHandleRequest;
    }

    public static void updateMutableUserInfoWithAjaxInfo(WOContext context) {
        AjaxUtils.updateMutableUserInfoWithAjaxInfo((WOMessage)context.response());
    }

    public static void updateMutableUserInfoWithAjaxInfo(WOMessage message) {
        NSMutableDictionary dict = AjaxUtils.mutableUserInfo(message);
        dict.takeValueForKey((Object)"erxsession.dont_store_page", "erxsession.dont_store_page");
    }

    public static WOResponse javascriptResponse(String javascript, WOContext context) {
        WORequest request = context.request();
        AjaxResponse response = AjaxUtils.createResponse(request, context);
        AjaxUtils.appendScriptHeaderIfNecessary(request, (WOResponse)response);
        response.appendContentString(javascript);
        AjaxUtils.appendScriptFooterIfNecessary(request, (WOResponse)response);
        return response;
    }

    public static void appendScript(WOContext context, String script) {
        AjaxUtils.appendScript(context.request(), context.response(), script);
    }

    public static void appendScript(WORequest request, WOResponse response, String script) {
        AjaxUtils.appendScriptHeaderIfNecessary(request, response);
        response.appendContentString(script);
        AjaxUtils.appendScriptFooterIfNecessary(request, response);
    }

    public static void appendScriptHeaderIfNecessary(WORequest request, WOResponse response) {
        if (AjaxUpdateContainer.hasUpdateContainerID(request)) {
            AjaxUtils.appendScriptHeader(response);
        } else {
            response.setHeader("text/javascript", "Content-Type");
        }
    }

    public static void appendScriptHeader(WOResponse response) {
        boolean appendTypeAttribute = ERXProperties.booleanForKeyWithDefault((String)"er.extensions.ERXResponseRewriter.javascriptTypeAttribute", (boolean)false);
        if (appendTypeAttribute) {
            response.appendContentString("<script type=\"text/javascript\">");
        } else {
            response.appendContentString("<script>");
        }
    }

    public static void appendScriptFooterIfNecessary(WORequest request, WOResponse response) {
        if (AjaxUpdateContainer.hasUpdateContainerID(request)) {
            AjaxUtils.appendScriptFooter(response);
        }
    }

    public static void appendScriptFooter(WOResponse response) {
        response.appendContentString("</script>");
    }

    public static boolean hasBinding(String name, NSDictionary associations) {
        return associations.objectForKey((Object)name) != null;
    }

    public static WOAssociation bindingNamed(String name, NSDictionary associations) {
        return (WOAssociation)associations.objectForKey((Object)name);
    }

    public static Object valueForBinding(String name, Object defaultValue, NSDictionary associations, WOComponent component) {
        Object value = AjaxUtils.valueForBinding(name, associations, component);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    public static String stringValueForBinding(String name, NSDictionary associations, WOComponent component) {
        WOAssociation association = (WOAssociation)associations.objectForKey((Object)name);
        if (association != null) {
            return (String)association.valueInComponent(component);
        }
        return null;
    }

    public static Object valueForBinding(String name, NSDictionary associations, WOComponent component) {
        WOAssociation association = (WOAssociation)associations.objectForKey((Object)name);
        if (association != null) {
            return association.valueInComponent(component);
        }
        return null;
    }

    public static boolean booleanValueForBinding(String name, boolean defaultValue, NSDictionary associations, WOComponent component) {
        WOAssociation association = (WOAssociation)associations.objectForKey((Object)name);
        if (association != null) {
            return association.booleanValueInComponent(component);
        }
        return defaultValue;
    }

    public static void setValueForBinding(Object value, String name, NSDictionary associations, WOComponent component) {
        WOAssociation association = (WOAssociation)associations.objectForKey((Object)name);
        if (association != null) {
            association.setValue(value, component);
        }
    }

    public static <T> NSArray<T> arrayValueForAssociation(WOComponent component, WOAssociation association) {
        NSArray<T> array = null;
        if (association != null) {
            array = AjaxUtils.arrayValueForObject(association.valueInComponent(component));
        }
        return array;
    }

    public static <T> NSArray<T> arrayValueForBinding(WOComponent component, String bindingName) {
        return AjaxUtils.arrayValueForObject(component.valueForBinding(bindingName));
    }

    public static <T> NSArray<T> arrayValueForObject(Object value) {
        NSArray arrayValue;
        if (value == null) {
            arrayValue = null;
        } else if (value instanceof NSArray) {
            arrayValue = (NSArray)value;
        } else if (value instanceof String) {
            try {
                String strValue = ((String)value).trim();
                if (!strValue.startsWith("[")) {
                    strValue = "[" + strValue + "]";
                }
                JSONSerializer serializer = new JSONSerializer();
                serializer.registerDefaultSerializers();
                Object objValue = serializer.fromJSON(strValue);
                if (objValue.getClass().isArray()) {
                    arrayValue = new NSArray((Object[])objValue);
                }
                if (objValue instanceof Collection) {
                    arrayValue = new NSArray((Collection)objValue);
                }
                arrayValue = new NSArray(objValue);
            }
            catch (Throwable e) {
                throw new IllegalArgumentException("Failed to convert String to array.", e);
            }
        } else {
            throw new IllegalArgumentException("Unable to convert '" + value + "' to an array.");
        }
        return arrayValue;
    }

    public static String ajaxComponentActionUrl(WOContext context) {
        String actionUrl = context.componentActionURL();
        if (AjaxRequestHandler.useAjaxRequestHandler()) {
            actionUrl = actionUrl.replaceFirst("/" + WOApplication.application().componentRequestHandlerKey() + "/", "/ajax/");
        }
        return actionUrl;
    }

    public static void appendTagAttributeAndValue(WOResponse response, WOContext context, WOComponent component, NSDictionary associations, String name) {
        AjaxUtils.appendTagAttributeAndValue(response, context, component, associations, name, null);
    }

    public static void appendTagAttributeAndValue(WOResponse response, WOContext context, WOComponent component, NSDictionary associations, String name, String appendValue) {
        AjaxUtils.appendTagAttributeAndValue(response, context, component, name, (WOAssociation)associations.objectForKey((Object)name), appendValue);
    }

    public static void appendTagAttributeAndValue(WOResponse response, WOContext context, WOComponent component, String name, WOAssociation association) {
        AjaxUtils.appendTagAttributeAndValue(response, context, component, name, association, null);
    }

    public static void appendTagAttributeAndValue(WOResponse response, WOContext context, WOComponent component, String name, WOAssociation association, String appendValue) {
        if (association != null || appendValue != null) {
            String value = null;
            if (association != null) {
                value = (String)association.valueInComponent(component);
            }
            if (value == null || value.length() == 0) {
                value = appendValue;
            } else if (appendValue != null && appendValue.length() > 0) {
                if (!value.endsWith(";")) {
                    value = value + ";";
                }
                value = value + appendValue;
            }
            if (value != null) {
                response._appendTagAttributeAndValue(name, value, true);
            }
        }
    }

    public static void redirectTo(WOComponent component) {
        WOContext context = component.context();
        ERXRedirect redirect = (ERXRedirect)component.pageWithName(ERXRedirect.class.getName());
        redirect.setComponent(component);
        redirect.appendToResponse((WOResponse)AjaxUtils.createResponse(context.request(), context), context);
    }

    public static void updateDomElement(WOResponse response, String id, Object value, String numberFormat, String dateFormat, String valueWhenEmpty) {
        if (numberFormat != null && dateFormat != null) {
            throw new IllegalArgumentException("You can only specify a numberFormat or a dateFormat, not both.");
        }
        if (value == null && valueWhenEmpty != null) {
            value = valueWhenEmpty;
        } else {
            try {
                if (numberFormat != null) {
                    value = ERXNumberFormatter.numberFormatterForPattern((String)numberFormat).format(value);
                }
                if (dateFormat != null) {
                    value = ERXTimestampFormatter.dateFormatterForPattern((String)dateFormat).format(value);
                }
            }
            catch (Exception e) {
                log.error((Object)e);
                value = null;
            }
        }
        response.appendContentString("Element.update('" + id + "'," + AjaxValue.javaScriptEscaped(value) + ");");
    }
}

