/*
 * Decompiled with CFR 0.152.
 */
package er.ajax;

import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSKeyValueCoding;
import er.ajax.AjaxOption;
import java.util.Enumeration;

public class AjaxValue {
    private AjaxOption.Type _type;
    private Object _value;

    public static String javaScriptEscaped(Object obj) {
        String escapedValue = String.valueOf(obj);
        escapedValue = escapedValue.replaceAll("\\\\", "\\\\\\\\");
        escapedValue = escapedValue.replaceAll("'", "\\\\'");
        escapedValue = "'" + escapedValue + "'";
        return escapedValue;
    }

    public AjaxValue(Object value) {
        this(AjaxOption.DEFAULT, value);
    }

    public AjaxValue(AjaxOption.Type type, Object value) {
        if (type == AjaxOption.DEFAULT) {
            if (value instanceof String) {
                this._type = AjaxOption.STRING;
            } else if (value instanceof Number) {
                this._type = AjaxOption.NUMBER;
            } else if (value instanceof Boolean) {
                this._type = AjaxOption.BOOLEAN;
            } else if (value instanceof NSArray) {
                this._type = AjaxOption.ARRAY;
            } else if (value instanceof NSDictionary) {
                this._type = AjaxOption.DICTIONARY;
            } else if (value instanceof AjaxValue) {
                this._type = ((AjaxValue)value)._type;
                this._value = ((AjaxValue)value)._value;
            } else {
                this._type = type;
            }
            this._value = value;
        } else {
            this._type = type;
            this._value = value;
        }
    }

    public String javascriptValue() {
        String strValue;
        AjaxOption.Type type = this._type;
        if (type == AjaxOption.STRING_OR_ARRAY) {
            if (this._value == null) {
                type = AjaxOption.STRING;
            } else if (this._value instanceof NSArray) {
                type = AjaxOption.ARRAY;
            } else if (this._value instanceof String) {
                strValue = (String)this._value;
                type = strValue.startsWith("[") ? AjaxOption.ARRAY : AjaxOption.STRING;
            }
        }
        if (this._value == null || this._value == NSKeyValueCoding.NullValue) {
            strValue = null;
        } else if (type == AjaxOption.STRING) {
            strValue = AjaxValue.javaScriptEscaped(this._value);
        } else if (type == AjaxOption.NUMBER) {
            strValue = this._value.toString();
        } else if (type == AjaxOption.ARRAY) {
            if (this._value instanceof NSArray) {
                NSArray arrayValue = (NSArray)this._value;
                StringBuffer sb = new StringBuffer();
                sb.append("[");
                Enumeration objEnum = arrayValue.objectEnumerator();
                while (objEnum.hasMoreElements()) {
                    Object o = objEnum.nextElement();
                    sb.append(new AjaxValue(o).javascriptValue());
                    if (!objEnum.hasMoreElements()) continue;
                    sb.append(",");
                }
                sb.append("]");
                strValue = sb.toString();
            } else {
                strValue = this._value.toString();
            }
        } else if (type == AjaxOption.DICTIONARY) {
            if (this._value instanceof NSDictionary) {
                NSDictionary dictValue = (NSDictionary)this._value;
                StringBuffer sb = new StringBuffer();
                sb.append("{");
                Enumeration keyEnum = dictValue.keyEnumerator();
                while (keyEnum.hasMoreElements()) {
                    Object key = keyEnum.nextElement();
                    Object value = dictValue.objectForKey(key);
                    sb.append(new AjaxValue(key).javascriptValue());
                    sb.append(":");
                    sb.append(new AjaxValue(value).javascriptValue());
                    if (!keyEnum.hasMoreElements()) continue;
                    sb.append(",");
                }
                sb.append("}");
                strValue = sb.toString();
            } else {
                strValue = this._value.toString();
            }
        } else if (type == AjaxOption.STRING_ARRAY) {
            if (this._value instanceof NSArray) {
                NSArray arrayValue = (NSArray)this._value;
                int count = arrayValue.count();
                if (count == 1) {
                    strValue = "'" + arrayValue.objectAtIndex(0).toString() + "'";
                } else if (count > 0) {
                    StringBuffer sb = new StringBuffer();
                    sb.append("[");
                    Enumeration objEnum = arrayValue.objectEnumerator();
                    while (objEnum.hasMoreElements()) {
                        Object o = objEnum.nextElement();
                        sb.append(new AjaxValue(AjaxOption.STRING, o).javascriptValue());
                        if (!objEnum.hasMoreElements()) continue;
                        sb.append(",");
                    }
                    sb.append("]");
                    strValue = sb.toString();
                } else {
                    strValue = "[]";
                }
            } else {
                strValue = this._value.toString();
            }
        } else {
            strValue = type == AjaxOption.SCRIPT ? this._value.toString() : (type == AjaxOption.FUNCTION ? "function() {" + this._value.toString() + "}" : (type == AjaxOption.FUNCTION_1 ? "function(v) {" + this._value.toString() + "}" : (type == AjaxOption.FUNCTION_2 ? "function(v1, v2) {" + this._value.toString() + "}" : this._value.toString())));
        }
        return strValue;
    }
}

