/*
 * Decompiled with CFR 0.152.
 */
package er.ajax.json.serializer;

import er.extensions.foundation.ERXStringUtilities;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.MethodDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jabsorb.serializer.AbstractSerializer;
import org.jabsorb.serializer.MarshallException;
import org.jabsorb.serializer.ObjectMatch;
import org.jabsorb.serializer.SerializerState;
import org.jabsorb.serializer.UnmarshallException;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ERXBeanSerializer
extends AbstractSerializer {
    private static final long serialVersionUID = 2L;
    private static final Logger log = LoggerFactory.getLogger(ERXBeanSerializer.class);
    private static Map<Class<?>, BeanData> beanCache = new HashMap();
    private static Class<?>[] _JSONClasses = new Class[0];
    private static Set<String> _ignoreMethodNames = new HashSet<String>();
    private Class _clazz;

    public static BeanData analyzeBean(Class<?> clazz) throws IntrospectionException {
        log.info("analyzing " + clazz.getName());
        BeanData bd = new BeanData();
        bd.beanInfo = Introspector.getBeanInfo(clazz, Object.class);
        bd.readableProps = new HashMap<String, Method>();
        bd.writableProps = new HashMap<String, Method>();
        for (MethodDescriptor md : bd.beanInfo.getMethodDescriptors()) {
            String name;
            Method method = md.getMethod();
            if (Modifier.isStatic(method.getModifiers()) || _ignoreMethodNames.contains(name = method.getName())) continue;
            Class<?> returnType = method.getReturnType();
            String propertyName = name;
            if (propertyName.startsWith("get") || propertyName.startsWith("set")) {
                propertyName = ERXStringUtilities.uncapitalize((String)propertyName.substring("set".length()));
            }
            if (returnType == Void.TYPE && name.startsWith("set") && method.getParameterTypes().length == 1) {
                bd.writableProps.put(propertyName, method);
                continue;
            }
            if (returnType == null || method.getParameterTypes().length != 0 || name.startsWith("_")) continue;
            bd.readableProps.put(propertyName, method);
        }
        return bd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BeanData getBeanData(Class<?> clazz) throws IntrospectionException {
        BeanData bd;
        Map<Class<?>, BeanData> map = beanCache;
        synchronized (map) {
            bd = beanCache.get(clazz);
            if (bd == null) {
                bd = ERXBeanSerializer.analyzeBean(clazz);
                beanCache.put(clazz, bd);
            }
        }
        return bd;
    }

    public ERXBeanSerializer(Class clazz) {
        this._clazz = clazz;
    }

    public boolean canSerialize(Class clazz, Class jsonClazz) {
        return this._clazz.isAssignableFrom(clazz) && (jsonClazz == null || jsonClazz == JSONObject.class);
    }

    public Class<?>[] getJSONClasses() {
        return _JSONClasses;
    }

    public Class<?>[] getSerializableClasses() {
        return new Class[]{this._clazz};
    }

    public Object marshall(SerializerState state, Object p, Object o) throws MarshallException {
        BeanData bd;
        try {
            bd = ERXBeanSerializer.getBeanData(o.getClass());
        }
        catch (IntrospectionException e) {
            throw new MarshallException(o.getClass().getName() + " is not a bean", (Throwable)e);
        }
        JSONObject val = new JSONObject();
        if (this.ser.getMarshallClassHints()) {
            try {
                val.put("javaClass", (Object)o.getClass().getName());
            }
            catch (JSONException e) {
                throw new MarshallException("JSONException: " + e.getMessage(), (Throwable)e);
            }
        }
        Object[] args = new Object[]{};
        for (Map.Entry<String, Method> ent : bd.readableProps.entrySet()) {
            Object result;
            String prop = ent.getKey();
            Method getMethod = ent.getValue();
            if (log.isDebugEnabled()) {
                log.debug("invoking " + getMethod.getName() + "()");
            }
            try {
                result = getMethod.invoke(o, args);
            }
            catch (Throwable e) {
                if (e instanceof InvocationTargetException) {
                    e = ((InvocationTargetException)e).getTargetException();
                }
                throw new MarshallException("bean " + o.getClass().getName() + " can't invoke " + getMethod.getName() + ": " + e.getMessage(), e);
            }
            try {
                if (result == null && !this.ser.getMarshallNullAttributes()) continue;
                try {
                    Object json = this.ser.marshall(state, o, result, (Object)prop);
                    val.put(prop, json);
                }
                catch (JSONException e) {
                    throw new MarshallException("JSONException: " + e.getMessage(), (Throwable)e);
                }
            }
            catch (MarshallException e) {
                throw new MarshallException("bean " + o.getClass().getName() + " " + e.getMessage(), (Throwable)e);
            }
        }
        return val;
    }

    public ObjectMatch tryUnmarshall(SerializerState state, Class clazz, Object o) throws UnmarshallException {
        BeanData bd;
        JSONObject jso = (JSONObject)o;
        try {
            bd = ERXBeanSerializer.getBeanData(clazz);
        }
        catch (IntrospectionException e) {
            throw new UnmarshallException(clazz.getName() + " is not a bean", (Throwable)e);
        }
        int match = 0;
        int mismatch = 0;
        for (Map.Entry<String, Method> ent : bd.writableProps.entrySet()) {
            String prop = ent.getKey();
            if (jso.has(prop)) {
                ++match;
                continue;
            }
            ++mismatch;
        }
        if (match == 0) {
            throw new UnmarshallException("bean has no matches");
        }
        ObjectMatch returnValue = new ObjectMatch(-1);
        state.setSerialized(o, (Object)returnValue);
        ObjectMatch m = null;
        Iterator i = jso.keys();
        while (i.hasNext()) {
            String field = (String)i.next();
            Method setMethod = bd.writableProps.get(field);
            if (setMethod != null) {
                try {
                    Class<?>[] param = setMethod.getParameterTypes();
                    if (param.length != 1) {
                        throw new UnmarshallException("bean " + clazz.getName() + " method " + setMethod.getName() + " does not have one arg");
                    }
                    ObjectMatch tmp = this.ser.tryUnmarshall(state, param[0], jso.get(field));
                    if (tmp == null) continue;
                    if (m == null) {
                        m = tmp;
                        continue;
                    }
                    m = m.max(tmp);
                    continue;
                }
                catch (UnmarshallException e) {
                    throw new UnmarshallException("bean " + clazz.getName() + " " + e.getMessage(), (Throwable)e);
                }
                catch (JSONException e) {
                    throw new UnmarshallException("bean " + clazz.getName() + " " + e.getMessage(), (Throwable)e);
                }
            }
            ++mismatch;
        }
        if (m != null) {
            returnValue.setMismatch(m.max(new ObjectMatch(mismatch)).getMismatch());
        } else {
            returnValue.setMismatch(mismatch);
        }
        return returnValue;
    }

    public Object unmarshall(SerializerState state, Class clazz, Object o) throws UnmarshallException {
        Object instance;
        BeanData bd;
        JSONObject jso = (JSONObject)o;
        try {
            bd = ERXBeanSerializer.getBeanData(clazz);
        }
        catch (IntrospectionException e) {
            throw new UnmarshallException(clazz.getName() + " is not a bean", (Throwable)e);
        }
        if (log.isDebugEnabled()) {
            log.debug("instantiating " + clazz.getName());
        }
        try {
            instance = clazz.newInstance();
        }
        catch (InstantiationException e) {
            throw new UnmarshallException("could not instantiate bean of type " + clazz.getName() + ", make sure it has a no argument " + "constructor and that it is not an interface or " + "abstract class", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new UnmarshallException("could not instantiate bean of type " + clazz.getName(), (Throwable)e);
        }
        catch (RuntimeException e) {
            throw new UnmarshallException("could not instantiate bean of type " + clazz.getName(), (Throwable)e);
        }
        state.setSerialized(o, instance);
        Object[] invokeArgs = new Object[1];
        Iterator i = jso.keys();
        while (i.hasNext()) {
            Object fieldVal;
            String field = (String)i.next();
            Method setMethod = bd.writableProps.get(field);
            if (setMethod == null) continue;
            try {
                Class<?>[] param = setMethod.getParameterTypes();
                fieldVal = this.ser.unmarshall(state, param[0], jso.get(field));
            }
            catch (UnmarshallException e) {
                throw new UnmarshallException("could not unmarshall field \"" + field + "\" of bean " + clazz.getName(), (Throwable)e);
            }
            catch (JSONException e) {
                throw new UnmarshallException("could not unmarshall field \"" + field + "\" of bean " + clazz.getName(), (Throwable)e);
            }
            if (log.isDebugEnabled()) {
                log.debug("invoking " + setMethod.getName() + "(" + fieldVal + ")");
            }
            invokeArgs[0] = fieldVal;
            try {
                setMethod.invoke(instance, invokeArgs);
            }
            catch (Throwable e) {
                if (e instanceof InvocationTargetException) {
                    e = ((InvocationTargetException)e).getTargetException();
                }
                throw new UnmarshallException("bean " + clazz.getName() + "can't invoke " + setMethod.getName() + ": " + e.getMessage(), e);
            }
        }
        return instance;
    }

    static {
        _ignoreMethodNames = new HashSet<String>();
        _ignoreMethodNames.add("equals");
        _ignoreMethodNames.add("hashCode");
        _ignoreMethodNames.add("main");
        _ignoreMethodNames.add("declaringClass");
    }

    protected static class BeanData {
        public BeanInfo beanInfo;
        public Map<String, Method> readableProps;
        public Map<String, Method> writableProps;

        protected BeanData() {
        }
    }
}

