/*
 * Decompiled with CFR 0.152.
 */
package er.ajax.json.serializer;

import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSKeyValueCoding;
import com.webobjects.foundation.NSMutableDictionary;
import java.util.Enumeration;
import java.util.Iterator;
import org.jabsorb.JSONSerializer;
import org.jabsorb.serializer.AbstractSerializer;
import org.jabsorb.serializer.MarshallException;
import org.jabsorb.serializer.ObjectMatch;
import org.jabsorb.serializer.SerializerState;
import org.jabsorb.serializer.UnmarshallException;
import org.json.JSONException;
import org.json.JSONObject;

public class NSDictionarySerializer
extends AbstractSerializer {
    private static final long serialVersionUID = 2L;
    private static Class[] _serializableClasses = new Class[]{NSDictionary.class, NSMutableDictionary.class};
    private static Class[] _JSONClasses = new Class[]{JSONObject.class};

    public boolean canSerialize(Class clazz, Class jsonClazz) {
        return super.canSerialize(clazz, jsonClazz) || (jsonClazz == null || jsonClazz == JSONObject.class) && NSDictionary.class.isAssignableFrom(clazz);
    }

    public Class[] getJSONClasses() {
        return _JSONClasses;
    }

    public Class[] getSerializableClasses() {
        return _serializableClasses;
    }

    public Object marshall(SerializerState state, Object p, Object o) throws MarshallException {
        NSDictionary dictionary = (NSDictionary)o;
        JSONObject obj = new JSONObject();
        JSONObject dictionarydata = new JSONObject();
        if (this.ser.getMarshallClassHints()) {
            try {
                obj.put("javaClass", (Object)o.getClass().getName());
            }
            catch (JSONException e) {
                throw new MarshallException("javaClass not found!");
            }
        }
        try {
            obj.put("nsdictionary", (Object)dictionarydata);
            state.push(o, (Object)dictionarydata, (Object)"nsdictionary");
        }
        catch (JSONException e) {
            throw new MarshallException("Could not add nsdictionary to object: " + e.getMessage());
        }
        Object key = null;
        try {
            Enumeration keyEnum = dictionary.allKeys().objectEnumerator();
            while (keyEnum.hasMoreElements()) {
                String keyString;
                key = keyEnum.nextElement();
                Object value = dictionary.objectForKey(key);
                Object json = this.ser.marshall(state, (Object)dictionarydata, value, (Object)(keyString = key.toString()));
                if (JSONSerializer.CIRC_REF_OR_DUPLICATE == json) continue;
                dictionarydata.put(keyString, json);
            }
        }
        catch (MarshallException e) {
            throw (MarshallException)new MarshallException("nsdictionary key " + key + " " + e.getMessage()).initCause((Throwable)e);
        }
        catch (JSONException e) {
            throw (MarshallException)new MarshallException("nsdictionary key " + key + " " + e.getMessage()).initCause((Throwable)e);
        }
        finally {
            state.pop();
        }
        return obj;
    }

    public ObjectMatch tryUnmarshall(SerializerState state, Class clazz, Object o) throws UnmarshallException {
        JSONObject jsondictionary;
        String java_class;
        JSONObject jso = (JSONObject)o;
        try {
            java_class = jso.getString("javaClass");
        }
        catch (JSONException e) {
            throw new UnmarshallException("Could not read javaClass", (Throwable)e);
        }
        if (java_class == null) {
            throw new UnmarshallException("no type hint");
        }
        if (!java_class.equals("com.webobjects.foundation.NSDictionary") && !java_class.equals("com.webobjects.foundation.NSMutableDictionary")) {
            throw new UnmarshallException("not an NSDictionary");
        }
        try {
            jsondictionary = jso.getJSONObject("nsdictionary");
        }
        catch (JSONException e) {
            throw new UnmarshallException("Could not read dictionary: " + e.getMessage(), (Throwable)e);
        }
        if (jsondictionary == null) {
            throw new UnmarshallException("nsdictionary missing");
        }
        ObjectMatch m = new ObjectMatch(-1);
        Iterator i = jsondictionary.keys();
        String key = null;
        state.setSerialized(o, (Object)m);
        try {
            while (i.hasNext()) {
                key = (String)i.next();
                m.setMismatch(this.ser.tryUnmarshall(state, null, jsondictionary.get(key)).max(m).getMismatch());
            }
        }
        catch (UnmarshallException e) {
            throw new UnmarshallException("key " + key + " " + e.getMessage(), (Throwable)e);
        }
        catch (JSONException e) {
            throw new UnmarshallException("key " + key + " " + e.getMessage(), (Throwable)e);
        }
        return m;
    }

    public Object unmarshall(SerializerState state, Class clazz, Object o) throws UnmarshallException {
        JSONObject jsondictionary;
        NSMutableDictionary abdictionary;
        String java_class;
        JSONObject jso = (JSONObject)o;
        try {
            java_class = jso.getString("javaClass");
        }
        catch (JSONException e) {
            throw new UnmarshallException("Could not read javaClass", (Throwable)e);
        }
        if (java_class == null) {
            throw new UnmarshallException("no type hint");
        }
        boolean immutableClone = false;
        if (java_class.equals("com.webobjects.foundation.NSDictionary")) {
            abdictionary = new NSMutableDictionary();
            immutableClone = true;
        } else if (java_class.equals("com.webobjects.foundation.NSMutableDictionary")) {
            abdictionary = new NSMutableDictionary();
        } else {
            throw new UnmarshallException("not an NSDictionary");
        }
        try {
            jsondictionary = jso.getJSONObject("nsdictionary");
        }
        catch (JSONException e) {
            throw new UnmarshallException("Could not read dictionary: " + e.getMessage(), (Throwable)e);
        }
        if (jsondictionary == null) {
            throw new UnmarshallException("nsdictionary missing");
        }
        Iterator i = jsondictionary.keys();
        String key = null;
        try {
            while (i.hasNext()) {
                key = (String)i.next();
                Object value = this.ser.unmarshall(state, null, jsondictionary.get(key));
                if (value != null) {
                    abdictionary.setObjectForKey(value, (Object)key);
                    continue;
                }
                abdictionary.setObjectForKey((Object)NSKeyValueCoding.NullValue, (Object)key);
            }
            NSMutableDictionary finalDictionary = abdictionary;
            if (immutableClone) {
                finalDictionary = abdictionary.immutableClone();
            }
            state.setSerialized(o, (Object)finalDictionary);
            return finalDictionary;
        }
        catch (UnmarshallException e) {
            throw new UnmarshallException("key " + key + " " + e.getMessage(), (Throwable)e);
        }
        catch (JSONException e) {
            throw new UnmarshallException("key " + key + " " + e.getMessage(), (Throwable)e);
        }
    }
}

