/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.client;

import java.util.Enumeration;
import java.util.Vector;
import javax.jms.Connection;
import javax.jms.ConnectionMetaData;
import javax.jms.ExceptionListener;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.core.service.ServiceException;
import org.exolab.jms.client.JmsConnectionFactory;
import org.exolab.jms.client.JmsConnectionMetaData;
import org.exolab.jms.client.JmsConnectionStubIfc;
import org.exolab.jms.client.JmsDestination;
import org.exolab.jms.client.JmsSession;
import org.exolab.jms.client.JmsTemporaryDestination;
import org.exolab.jms.events.BasicEventManager;

abstract class JmsConnection
implements Connection {
    private boolean _closed = false;
    private boolean _stopped = true;
    private boolean _modified = false;
    private String _clientId = null;
    private boolean _clientIdSet = false;
    private ExceptionListener _exceptionListener = null;
    private Vector _sessions = new Vector();
    private JmsConnectionFactory _factory = null;
    private JmsConnectionStubIfc _stub = null;
    private String _connectionId = null;
    private static volatile int _activeConnections = 0;
    private static final JmsConnectionMetaData _metaData = new JmsConnectionMetaData();
    private static final Log _log = LogFactory.getLog((Class)(class$org$exolab$jms$client$JmsConnection == null ? (class$org$exolab$jms$client$JmsConnection = JmsConnection.class$("org.exolab.jms.client.JmsConnection")) : class$org$exolab$jms$client$JmsConnection));
    static /* synthetic */ Class class$org$exolab$jms$client$JmsConnection;

    protected JmsConnection(JmsConnectionFactory factory, String id, String username, String password) throws JMSException {
        if (factory == null) {
            throw new IllegalArgumentException("Argument 'factory' is null");
        }
        if (id == null) {
            throw new IllegalArgumentException("Argument 'id' is null");
        }
        if (id.trim().length() == 0) {
            throw new IllegalArgumentException("Argument 'id' is invalid: '" + id + "'");
        }
        this._factory = factory;
        this._clientId = id;
        this._stopped = true;
        this._stub = factory.getProxy().createConnection(this._clientId, username, password);
        this._connectionId = this._stub.getConnectionId();
        JmsConnection.startEventManager();
    }

    public String getClientID() throws JMSException {
        this.ensureOpen();
        this.setModified();
        return this._clientId;
    }

    public void setClientID(String id) throws JMSException {
        this.ensureOpen();
        if (this._clientIdSet) {
            throw new IllegalStateException("The client id has already been set");
        }
        if (this._modified) {
            throw new IllegalStateException("The client identifier must be set before any other operation is performed");
        }
        this._clientId = id;
        this._clientIdSet = true;
    }

    public ConnectionMetaData getMetaData() throws JMSException {
        this.ensureOpen();
        this.setModified();
        return _metaData;
    }

    public ExceptionListener getExceptionListener() throws JMSException {
        this.ensureOpen();
        this.setModified();
        return this._exceptionListener;
    }

    public void setExceptionListener(ExceptionListener listener) throws JMSException {
        this.ensureOpen();
        this.setModified();
        this._exceptionListener = listener;
    }

    public void notifyExceptionListener(JMSException message) {
        if (message.getErrorCode() != null && message.getErrorCode().equals("connection_to_server_dropped")) {
            try {
                this.destroy();
            }
            catch (JMSException exception) {
                _log.error((Object)exception.getMessage(), (Throwable)exception);
            }
        }
        if (this._exceptionListener != null) {
            this._exceptionListener.onException(message);
        }
    }

    public synchronized void start() throws JMSException {
        this.ensureOpen();
        this.setModified();
        if (this._stopped) {
            Enumeration sessions = this._sessions.elements();
            while (sessions.hasMoreElements()) {
                JmsSession session = (JmsSession)sessions.nextElement();
                session.start();
            }
            this._stopped = false;
        }
    }

    public synchronized void stop() throws JMSException {
        this.ensureOpen();
        this.setModified();
        if (!this._stopped) {
            Enumeration sessions = this._sessions.elements();
            while (sessions.hasMoreElements()) {
                JmsSession session = (JmsSession)sessions.nextElement();
                session.stop();
            }
            this._stopped = true;
        }
    }

    public synchronized void close() throws JMSException {
        if (!this._closed) {
            try {
                this.stop();
                Object[] sessions = this._sessions.toArray();
                int i = 0;
                while (i < sessions.length) {
                    JmsSession session = (JmsSession)sessions[i];
                    session.close();
                    ++i;
                }
                this.getJmsConnectionStub().close();
                this._stub = null;
                this._factory.removeConnection(this);
                this._factory = null;
                this._closed = true;
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                JmsConnection.stopEventManager();
                throw throwable;
            }
            JmsConnection.stopEventManager();
            {
            }
        }
    }

    public synchronized void destroy() throws JMSException {
        if (!this._closed) {
            try {
                Object[] sessions = this._sessions.toArray();
                int i = 0;
                while (i < sessions.length) {
                    JmsSession session = (JmsSession)sessions[i];
                    session.destroy();
                    ++i;
                }
                this.getJmsConnectionStub().destroy();
                this._stub = null;
                this._factory.removeConnection(this);
                this._factory = null;
                this._closed = true;
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                JmsConnection.stopEventManager();
                throw throwable;
            }
            JmsConnection.stopEventManager();
            {
            }
        }
    }

    public String getConnectionId() {
        return this._connectionId;
    }

    JmsConnectionStubIfc getJmsConnectionStub() throws JMSException {
        if (this._stub == null) {
            throw new JMSException("The connectionstub is set to null");
        }
        return this._stub;
    }

    protected void addSession(JmsSession session) {
        this._sessions.addElement(session);
    }

    protected void removeSession(JmsSession session) {
        this._sessions.removeElement(session);
    }

    protected boolean isManaged(JmsSession session) {
        return this._sessions.contains(session);
    }

    protected Enumeration getSessions() {
        return this._sessions.elements();
    }

    protected boolean isStopped() {
        return this._stopped;
    }

    protected void setModified() {
        this._modified = true;
    }

    synchronized void deleteTemporaryDestination(JmsDestination destination) throws JMSException {
        if (destination != null && destination instanceof JmsTemporaryDestination) {
            JmsTemporaryDestination temp_dest = (JmsTemporaryDestination)((Object)destination);
            if (temp_dest.getOwningConnection() != this) {
                throw new JMSException("The temp destination cannot be used outside the scope of the connection creating it");
            }
        } else {
            throw new JMSException("The destination is not temporary");
        }
    }

    protected void ensureOpen() throws IllegalStateException {
        if (this._closed) {
            throw new IllegalStateException("Cannot perform operation - session has been closed");
        }
    }

    private static void startEventManager() {
        try {
            if (_activeConnections++ == 0) {
                try {
                    BasicEventManager.instance().start();
                }
                catch (ServiceException exception) {}
            }
        }
        catch (Exception exception) {
            _log.error((Object)exception.getMessage(), (Throwable)exception);
        }
    }

    private static void stopEventManager() {
        try {
            if (--_activeConnections == 0) {
                BasicEventManager.instance().stop();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

