/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.client;

import javax.jms.ConnectionConsumer;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ServerSession;
import javax.jms.ServerSessionPool;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.jms.client.JmsSession;

abstract class JmsConnectionConsumer
implements ConnectionConsumer,
MessageListener {
    private ServerSessionPool _pool;
    private final int _maxMessages;
    private static final Log _log = LogFactory.getLog((Class)(class$org$exolab$jms$client$JmsConnectionConsumer == null ? (class$org$exolab$jms$client$JmsConnectionConsumer = JmsConnectionConsumer.class$("org.exolab.jms.client.JmsConnectionConsumer")) : class$org$exolab$jms$client$JmsConnectionConsumer));
    static /* synthetic */ Class class$org$exolab$jms$client$JmsConnectionConsumer;

    public JmsConnectionConsumer(ServerSessionPool pool, int maxMessages) {
        if (pool == null) {
            throw new IllegalArgumentException("Argument 'pool' is null");
        }
        if (maxMessages <= 0) {
            throw new IllegalArgumentException("Argument 'maxMessages' must be > 0");
        }
        this._pool = pool;
        this._maxMessages = maxMessages;
    }

    public ServerSessionPool getServerSessionPool() {
        return this._pool;
    }

    public void close() throws JMSException {
        this._pool = null;
    }

    public void onMessage(Message message) {
        try {
            ServerSession serverSession = this._pool.getServerSession();
            JmsSession session = (JmsSession)serverSession.getSession();
            message.acknowledge();
            session.addMessage(message);
            serverSession.start();
        }
        catch (Exception exception) {
            _log.error((Object)exception, (Throwable)exception);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

