/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.client;

import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Topic;
import javax.jms.TopicPublisher;
import org.exolab.jms.client.JmsMessageProducer;
import org.exolab.jms.client.JmsSession;
import org.exolab.jms.client.JmsTopic;
import org.exolab.jms.client.JmsTopicSession;

class JmsTopicPublisher
extends JmsMessageProducer
implements TopicPublisher {
    private JmsTopic _topic = null;

    public JmsTopicPublisher(JmsSession session, JmsTopic topic) {
        super(session);
        this._topic = topic;
    }

    public Topic getTopic() {
        return this._topic;
    }

    public void publish(Message message) throws JMSException {
        this.publish(this.getTopic(), message, this.getDeliveryMode(), this.getPriority(), this.getTimeToLive());
    }

    public void publish(Topic topic, Message message) throws JMSException {
        this.publish(topic, message, this.getDeliveryMode(), this.getPriority(), this.getTimeToLive());
    }

    public void publish(Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.publish(this.getTopic(), message, deliveryMode, priority, timeToLive);
    }

    public void publish(Topic topic, Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.sendMessage((Destination)topic, message, deliveryMode, priority, timeToLive);
    }

    public synchronized void close() throws JMSException {
        if (!this.isClosed()) {
            JmsTopicSession session = (JmsTopicSession)this.getSession();
            session.removePublisher(this);
            super.close();
        }
    }

    public void destroy() {
        super.destroy();
        this._topic = null;
    }
}

