/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.message;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.MessageFormatException;
import javax.jms.MessageNotWriteableException;
import org.exolab.jms.message.FormatConverter;
import org.exolab.jms.message.MessageImpl;

public class MapMessageImpl
extends MessageImpl
implements MapMessage {
    static final long serialVersionUID = 2L;
    private static final int INITIAL_SIZE = 20;
    private HashMap _map = new HashMap(20);

    public MapMessageImpl() throws JMSException {
        this.setJMSType("MapMessage");
    }

    public final Object clone() throws CloneNotSupportedException {
        MapMessageImpl result = (MapMessageImpl)super.clone();
        result._map = (HashMap)this._map.clone();
        return result;
    }

    public final void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeLong(2L);
        out.writeObject(this._map);
    }

    public final void readExternal(ObjectInput in) throws ClassNotFoundException, IOException {
        super.readExternal(in);
        long version = in.readLong();
        if (version != 2L) {
            throw new IOException("Incorrect version enountered: " + version + ". This version = " + 2L);
        }
        this._map = (HashMap)in.readObject();
    }

    public final boolean getBoolean(String name) throws JMSException, MessageFormatException {
        return FormatConverter.getBoolean(this._map.get(name));
    }

    public final byte getByte(String name) throws JMSException, MessageFormatException {
        return FormatConverter.getByte(this._map.get(name));
    }

    public final short getShort(String name) throws JMSException, MessageFormatException {
        return FormatConverter.getShort(this._map.get(name));
    }

    public final char getChar(String name) throws JMSException, MessageFormatException {
        return FormatConverter.getChar(this._map.get(name));
    }

    public final int getInt(String name) throws JMSException, MessageFormatException {
        return FormatConverter.getInt(this._map.get(name));
    }

    public final long getLong(String name) throws JMSException, MessageFormatException {
        return FormatConverter.getLong(this._map.get(name));
    }

    public final float getFloat(String name) throws JMSException, MessageFormatException {
        return FormatConverter.getFloat(this._map.get(name));
    }

    public final double getDouble(String name) throws JMSException, MessageFormatException {
        return FormatConverter.getDouble(this._map.get(name));
    }

    public final String getString(String name) throws JMSException, MessageFormatException {
        return FormatConverter.getString(this._map.get(name));
    }

    public final byte[] getBytes(String name) throws JMSException, MessageFormatException {
        return FormatConverter.getBytes(this._map.get(name));
    }

    public final Object getObject(String name) throws JMSException {
        Object result = null;
        Object value = this._map.get(name);
        if (value != null) {
            if (value instanceof Boolean) {
                result = new Boolean((Boolean)value);
            } else if (value instanceof Byte) {
                result = new Byte((Byte)value);
            } else if (value instanceof Short) {
                result = new Short((Short)value);
            } else if (value instanceof Character) {
                result = new Character(((Character)value).charValue());
            } else if (value instanceof Integer) {
                result = new Integer((Integer)value);
            } else if (value instanceof Long) {
                result = new Long((Long)value);
            } else if (value instanceof Float) {
                result = new Float(((Float)value).floatValue());
            } else if (value instanceof Double) {
                result = new Double((Double)value);
            } else if (value instanceof String) {
                result = (String)value;
            } else if (value instanceof byte[]) {
                result = this.getBytes(name);
            } else {
                throw new MessageFormatException("MapMessage contains an unsupported object of type=" + value.getClass().getName());
            }
        }
        return result;
    }

    public final Enumeration getMapNames() {
        return Collections.enumeration(this._map.keySet());
    }

    public final void setBoolean(String name, boolean value) throws MessageNotWriteableException {
        this.checkWrite();
        this._map.put(name, new Boolean(value));
    }

    public final void setByte(String name, byte value) throws MessageNotWriteableException {
        this.checkWrite();
        this._map.put(name, new Byte(value));
    }

    public final void setShort(String name, short value) throws MessageNotWriteableException {
        this.checkWrite();
        this._map.put(name, new Short(value));
    }

    public final void setChar(String name, char value) throws MessageNotWriteableException {
        this.checkWrite();
        this._map.put(name, new Character(value));
    }

    public final void setInt(String name, int value) throws MessageNotWriteableException {
        this.checkWrite();
        this._map.put(name, new Integer(value));
    }

    public final void setLong(String name, long value) throws MessageNotWriteableException {
        this.checkWrite();
        this._map.put(name, new Long(value));
    }

    public final void setFloat(String name, float value) throws MessageNotWriteableException {
        this.checkWrite();
        this._map.put(name, new Float(value));
    }

    public final void setDouble(String name, double value) throws MessageNotWriteableException {
        this.checkWrite();
        this._map.put(name, new Double(value));
    }

    public final void setString(String name, String value) throws MessageNotWriteableException {
        this.checkWrite();
        this._map.put(name, value);
    }

    public final void setBytes(String name, byte[] value) throws MessageNotWriteableException {
        this.checkWrite();
        byte[] bytes = null;
        if (value != null) {
            bytes = new byte[value.length];
            System.arraycopy(value, 0, bytes, 0, bytes.length);
        }
        this._map.put(name, bytes);
    }

    public final void setBytes(String name, byte[] value, int offset, int length) throws MessageNotWriteableException {
        this.checkWrite();
        byte[] bytes = null;
        if (value != null) {
            bytes = new byte[length];
            System.arraycopy(value, offset, bytes, 0, length);
        }
        this._map.put(name, bytes);
    }

    public final void setObject(String name, Object value) throws MessageFormatException, MessageNotWriteableException {
        this.checkWrite();
        if (value == null) {
            this._map.put(name, null);
        } else if (value instanceof Boolean) {
            this.setBoolean(name, (Boolean)value);
        } else if (value instanceof Byte) {
            this.setByte(name, (Byte)value);
        } else if (value instanceof Short) {
            this.setShort(name, (Short)value);
        } else if (value instanceof Character) {
            this.setChar(name, ((Character)value).charValue());
        } else if (value instanceof Integer) {
            this.setInt(name, (Integer)value);
        } else if (value instanceof Long) {
            this.setLong(name, (Long)value);
        } else if (value instanceof Float) {
            this.setFloat(name, ((Float)value).floatValue());
        } else if (value instanceof Double) {
            this.setDouble(name, (Double)value);
        } else if (value instanceof String) {
            this.setString(name, (String)value);
        } else if (value instanceof byte[]) {
            this.setBytes(name, (byte[])value);
        } else {
            throw new MessageFormatException("MapMessage does not support objects of type=" + value.getClass().getName());
        }
    }

    public final boolean itemExists(String name) {
        return this._map.containsKey(name);
    }

    public final void clearBody() throws JMSException {
        super.clearBody();
        this._map = new HashMap(20);
    }
}

