/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.message;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.jms.JMSException;
import javax.jms.MessageEOFException;
import javax.jms.MessageFormatException;
import javax.jms.StreamMessage;
import org.exolab.jms.message.FormatConverter;
import org.exolab.jms.message.MessageImpl;

public final class StreamMessageImpl
extends MessageImpl
implements StreamMessage {
    static final long serialVersionUID = 2L;
    private static final byte NULL = 0;
    private static final byte BOOLEAN = 1;
    private static final byte BYTE = 2;
    private static final byte BYTE_ARRAY = 3;
    private static final byte SHORT = 4;
    private static final byte CHAR = 5;
    private static final byte INT = 6;
    private static final byte LONG = 7;
    private static final byte FLOAT = 8;
    private static final byte DOUBLE = 9;
    private static final byte STRING = 10;
    private static final String[] TYPE_NAMES = new String[]{"null", "boolean", "byte", "byte[]", "short", "char", "int", "long", "float", "double", "String"};
    private static final byte[] EMPTY = new byte[0];
    private byte[] _bytes = EMPTY;
    private DataOutputStream _out = null;
    private ByteArrayOutputStream _byteOut = null;
    private DataInputStream _in = null;
    private ByteArrayInputStream _byteIn = null;
    int _readBytes = 0;
    int _byteArrayLength = 0;
    private int _offset = 0;

    public StreamMessageImpl() throws JMSException {
        this.setJMSType("StreamMessage");
    }

    public final Object clone() throws CloneNotSupportedException {
        StreamMessageImpl result = (StreamMessageImpl)super.clone();
        if (this._bodyReadOnly) {
            result._bytes = new byte[this._bytes.length];
            System.arraycopy(this._bytes, 0, result._bytes, 0, this._bytes.length);
            if (this._byteIn != null) {
                this._offset = this._bytes.length - this._byteIn.available();
            }
            result._byteIn = null;
            result._in = null;
        } else if (this._out != null) {
            try {
                this._out.flush();
            }
            catch (IOException exception) {
                throw new CloneNotSupportedException(exception.getMessage());
            }
            result._bytes = this._byteOut.toByteArray();
            result._byteOut = null;
            result._out = null;
        } else {
            result._bytes = new byte[this._bytes.length];
            System.arraycopy(this._bytes, 0, result._bytes, 0, this._bytes.length);
        }
        return result;
    }

    public final void writeExternal(ObjectOutput out) throws IOException {
        if (!this._bodyReadOnly && this._out != null) {
            this._out.flush();
            this._bytes = this._byteOut.toByteArray();
        }
        super.writeExternal(out);
        out.writeLong(2L);
        out.writeInt(this._bytes.length);
        out.write(this._bytes);
        out.flush();
    }

    public final void readExternal(ObjectInput in) throws ClassNotFoundException, IOException {
        super.readExternal(in);
        long version = in.readLong();
        if (version != 2L) {
            throw new IOException("Incorrect version enountered: " + version + ". This version = " + 2L);
        }
        int length = in.readInt();
        this._bytes = new byte[length];
        in.readFully(this._bytes);
    }

    public final boolean readBoolean() throws JMSException {
        boolean result = false;
        this.prepare();
        try {
            result = FormatConverter.getBoolean(this.readNext());
        }
        catch (MessageFormatException exception) {
            this.revert(exception);
        }
        return result;
    }

    public final byte readByte() throws JMSException {
        byte result = 0;
        this.prepare();
        try {
            result = FormatConverter.getByte(this.readNext());
        }
        catch (MessageFormatException exception) {
            this.revert(exception);
        }
        catch (NumberFormatException exception) {
            this.revert(exception);
        }
        return result;
    }

    public final short readShort() throws JMSException {
        short result = 0;
        this.prepare();
        try {
            result = FormatConverter.getShort(this.readNext());
        }
        catch (MessageFormatException exception) {
            this.revert(exception);
        }
        catch (NumberFormatException exception) {
            this.revert(exception);
        }
        return result;
    }

    public final char readChar() throws JMSException {
        char result = '\u0000';
        this.prepare();
        try {
            result = FormatConverter.getChar(this.readNext());
        }
        catch (MessageFormatException exception) {
            this.revert(exception);
        }
        catch (NullPointerException exception) {
            this.revert(exception);
        }
        return result;
    }

    public final int readInt() throws JMSException {
        int result = 0;
        this.prepare();
        try {
            result = FormatConverter.getInt(this.readNext());
        }
        catch (MessageFormatException exception) {
            this.revert(exception);
        }
        catch (NumberFormatException exception) {
            this.revert(exception);
        }
        return result;
    }

    public final long readLong() throws JMSException {
        long result = 0L;
        this.prepare();
        try {
            result = FormatConverter.getLong(this.readNext());
        }
        catch (MessageFormatException exception) {
            this.revert(exception);
        }
        catch (NumberFormatException exception) {
            this.revert(exception);
        }
        return result;
    }

    public final float readFloat() throws JMSException {
        float result = 0.0f;
        this.prepare();
        try {
            result = FormatConverter.getFloat(this.readNext());
        }
        catch (MessageFormatException exception) {
            this.revert(exception);
        }
        catch (NullPointerException exception) {
            this.revert(exception);
        }
        catch (NumberFormatException exception) {
            this.revert(exception);
        }
        return result;
    }

    public final double readDouble() throws JMSException {
        double result = 0.0;
        this.prepare();
        try {
            result = FormatConverter.getDouble(this.readNext());
        }
        catch (MessageFormatException exception) {
            this.revert(exception);
        }
        catch (NullPointerException exception) {
            this.revert(exception);
        }
        catch (NumberFormatException exception) {
            this.revert(exception);
        }
        return result;
    }

    public final String readString() throws JMSException {
        String result = null;
        this.prepare();
        try {
            result = FormatConverter.getString(this.readNext());
        }
        catch (MessageFormatException exception) {
            this.revert(exception);
        }
        return result;
    }

    public final int readBytes(byte[] value) throws JMSException {
        this.checkRead();
        this.getInputStream();
        int read = 0;
        if (this._readBytes == 0) {
            try {
                this._in.mark(this._bytes.length - this._in.available());
                byte type = (byte)(this._in.readByte() & 0xF);
                if (type == 0) {
                    return -1;
                }
                if (type != 3) {
                    this._in.reset();
                    if (type < TYPE_NAMES.length) {
                        throw new MessageFormatException("Expected type=" + TYPE_NAMES[3] + ", but got type=" + TYPE_NAMES[type]);
                    }
                    throw new MessageFormatException("StreamMessage corrupted");
                }
            }
            catch (IOException exception) {
                this.raise(exception);
            }
            try {
                this._byteArrayLength = this._in.readInt();
            }
            catch (IOException exception) {
                this.raise(exception);
            }
        }
        if (this._byteArrayLength == 0) {
            if (this._readBytes != 0) {
                read = -1;
            }
            this._readBytes = 0;
        } else {
            ++this._readBytes;
            try {
                if (value.length <= this._byteArrayLength) {
                    read = value.length;
                    this._in.readFully(value);
                    this._byteArrayLength -= value.length;
                } else {
                    read = this._byteArrayLength;
                    this._in.readFully(value, 0, this._byteArrayLength);
                    this._byteArrayLength = 0;
                }
            }
            catch (IOException exception) {
                this.raise(exception);
            }
        }
        return read;
    }

    public final Object readObject() throws JMSException {
        Object result = null;
        this.prepare();
        try {
            result = this.readNext();
        }
        catch (MessageFormatException exception) {
            this.revert(exception);
        }
        return result;
    }

    public final void writeBoolean(boolean value) throws JMSException {
        this.checkWrite();
        try {
            this.getOutputStream();
            this._out.writeByte(1 | (value ? 16 : 0));
        }
        catch (IOException exception) {
            this.raise(exception);
        }
    }

    public final void writeByte(byte value) throws JMSException {
        this.checkWrite();
        try {
            this.getOutputStream();
            this._out.writeByte(2);
            this._out.writeByte(value);
        }
        catch (IOException exception) {
            this.raise(exception);
        }
    }

    public final void writeShort(short value) throws JMSException {
        this.checkWrite();
        try {
            this.getOutputStream();
            this._out.writeByte(4);
            this._out.writeShort(value);
        }
        catch (IOException exception) {
            this.raise(exception);
        }
    }

    public final void writeChar(char value) throws JMSException {
        this.checkWrite();
        try {
            this.getOutputStream();
            this._out.writeByte(5);
            this._out.writeChar(value);
        }
        catch (IOException exception) {
            this.raise(exception);
        }
    }

    public final void writeInt(int value) throws JMSException {
        this.checkWrite();
        try {
            this.getOutputStream();
            this._out.writeByte(6);
            this._out.writeInt(value);
        }
        catch (IOException exception) {
            this.raise(exception);
        }
    }

    public final void writeLong(long value) throws JMSException {
        this.checkWrite();
        try {
            this.getOutputStream();
            this._out.writeByte(7);
            this._out.writeLong(value);
        }
        catch (IOException exception) {
            this.raise(exception);
        }
    }

    public final void writeFloat(float value) throws JMSException {
        this.checkWrite();
        try {
            this.getOutputStream();
            this._out.writeByte(8);
            this._out.writeFloat(value);
        }
        catch (IOException exception) {
            this.raise(exception);
        }
    }

    public final void writeDouble(double value) throws JMSException {
        this.checkWrite();
        try {
            this.getOutputStream();
            this._out.writeByte(9);
            this._out.writeDouble(value);
        }
        catch (IOException exception) {
            this.raise(exception);
        }
    }

    public final void writeString(String value) throws JMSException {
        this.checkWrite();
        if (value == null) {
            throw new NullPointerException("Argument value is null");
        }
        try {
            this.getOutputStream();
            this._out.writeByte(10);
            this._out.writeUTF(value);
        }
        catch (IOException exception) {
            this.raise(exception);
        }
    }

    public final void writeBytes(byte[] value) throws JMSException {
        this.checkWrite();
        if (value == null) {
            throw new NullPointerException("Argument value is null");
        }
        try {
            this.getOutputStream();
            this._out.writeByte(3);
            this._out.writeInt(value.length);
            this._out.write(value);
        }
        catch (IOException exception) {
            this.raise(exception);
        }
    }

    public void writeBytes(byte[] value, int offset, int length) throws JMSException {
        this.checkWrite();
        if (value == null) {
            throw new NullPointerException("Argument value is null");
        }
        try {
            this.getOutputStream();
            this._out.writeByte(3);
            this._out.writeInt(length);
            this._out.write(value, offset, length);
        }
        catch (IOException exception) {
            this.raise(exception);
        }
    }

    public void writeObject(Object value) throws JMSException {
        if (value == null) {
            try {
                this.checkWrite();
                this.getOutputStream();
                this._out.writeByte(0);
            }
            catch (IOException exception) {
                this.raise(exception);
            }
        } else if (value instanceof Boolean) {
            this.writeBoolean((Boolean)value);
        } else if (value instanceof Byte) {
            this.writeByte((Byte)value);
        } else if (value instanceof byte[]) {
            this.writeBytes((byte[])value);
        } else if (value instanceof Short) {
            this.writeShort((Short)value);
        } else if (value instanceof Character) {
            this.writeChar(((Character)value).charValue());
        } else if (value instanceof Integer) {
            this.writeInt((Integer)value);
        } else if (value instanceof Long) {
            this.writeLong((Long)value);
        } else if (value instanceof Float) {
            this.writeFloat(((Float)value).floatValue());
        } else if (value instanceof Double) {
            this.writeDouble((Double)value);
        } else if (value instanceof String) {
            this.writeString((String)value);
        } else {
            throw new MessageFormatException("Objects of type " + value.getClass().getName() + " are not supported by StreamMessage");
        }
    }

    public void reset() throws JMSException {
        try {
            if (!this._bodyReadOnly) {
                this._bodyReadOnly = true;
                if (this._out != null) {
                    this._out.flush();
                    this._bytes = this._byteOut.toByteArray();
                    this._byteOut = null;
                    this._out.close();
                    this._out = null;
                }
            } else if (this._in != null) {
                this._byteIn = null;
                this._in.close();
                this._in = null;
            }
            this._readBytes = 0;
        }
        catch (IOException exception) {
            this.raise(exception);
        }
    }

    public void clearBody() throws JMSException {
        try {
            if (this._bodyReadOnly) {
                this._bodyReadOnly = false;
                if (this._in != null) {
                    this._byteIn = null;
                    this._in.close();
                    this._in = null;
                    this._offset = 0;
                }
            } else if (this._out != null) {
                this._byteOut = null;
                this._out.close();
                this._out = null;
            }
            this._bytes = EMPTY;
            this._readBytes = 0;
        }
        catch (IOException exception) {
            this.raise(exception);
        }
    }

    public final void setReadOnly(boolean readOnly) throws JMSException {
        if (readOnly) {
            this.reset();
        }
        super.setReadOnly(readOnly);
    }

    private final void prepare() throws JMSException {
        this.checkRead();
        this.getInputStream();
        try {
            this._in.mark(this._bytes.length - this._in.available());
        }
        catch (IOException exception) {
            this.raise(exception);
        }
    }

    private void revert(MessageFormatException exception) throws MessageFormatException {
        try {
            this._in.reset();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        throw exception;
    }

    private void revert(RuntimeException exception) {
        try {
            this._in.reset();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        throw exception;
    }

    private Object readNext() throws JMSException {
        if (this._readBytes != 0) {
            throw new MessageFormatException("Cannot read the next field until the byte array is read");
        }
        byte type = 0;
        try {
            type = this._in.readByte();
        }
        catch (IOException exception) {
            this.raise(exception);
        }
        if ((type & 0xF) > TYPE_NAMES.length) {
            throw new JMSException("StreamMessage corrupted");
        }
        Object result = null;
        try {
            switch (type & 0xF) {
                case 1: {
                    boolean value = (type & 0xF0) != 0;
                    result = new Boolean(value);
                    break;
                }
                case 2: {
                    result = new Byte(this._in.readByte());
                    break;
                }
                case 3: {
                    int length = this._in.readInt();
                    byte[] bytes = new byte[length];
                    this._in.readFully(bytes);
                    result = bytes;
                    break;
                }
                case 4: {
                    result = new Short(this._in.readShort());
                    break;
                }
                case 5: {
                    result = new Character(this._in.readChar());
                    break;
                }
                case 6: {
                    result = new Integer(this._in.readInt());
                    break;
                }
                case 7: {
                    result = new Long(this._in.readLong());
                    break;
                }
                case 8: {
                    result = new Float(this._in.readFloat());
                    break;
                }
                case 9: {
                    result = new Double(this._in.readDouble());
                    break;
                }
                case 10: {
                    result = this._in.readUTF();
                }
            }
        }
        catch (IOException exception) {
            this.raise(exception);
        }
        return result;
    }

    private DataInputStream getInputStream() {
        if (this._in == null) {
            this._byteIn = new ByteArrayInputStream(this._bytes, this._offset, this._bytes.length - this._offset);
            this._in = new DataInputStream(this._byteIn);
        }
        return this._in;
    }

    private final DataOutputStream getOutputStream() throws IOException {
        if (this._out == null) {
            this._byteOut = new ByteArrayOutputStream();
            this._out = new DataOutputStream(this._byteOut);
            this._out.write(this._bytes);
        }
        return this._out;
    }

    private final void raise(IOException exception) throws JMSException {
        Throwable error = null;
        error = exception instanceof EOFException ? new MessageEOFException(exception.getMessage()) : new JMSException(exception.getMessage());
        error.setLinkedException((Exception)exception);
        throw error;
    }
}

