/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.server.rmi;

import java.rmi.Naming;
import java.rmi.server.RemoteStub;
import java.rmi.server.UnicastRemoteObject;
import javax.naming.Context;
import javax.naming.NamingException;
import org.apache.avalon.excalibur.naming.rmi.RMINamingProvider;
import org.apache.avalon.excalibur.naming.rmi.server.RMINamingProviderImpl;
import org.exolab.jms.config.ConfigHelper;
import org.exolab.jms.config.Configuration;
import org.exolab.jms.config.ConfigurationManager;
import org.exolab.jms.config.types.SchemeType;
import org.exolab.jms.jndi.JndiServerIfc;

public class RmiJndiServer
implements JndiServerIfc {
    private Context _context;
    private RMINamingProvider _provider;

    public RmiJndiServer(Context context) {
        this._context = context;
    }

    public void init() throws NamingException {
        Configuration config = ConfigurationManager.getConfig();
        this._provider = new RMINamingProviderImpl(this._context);
        try {
            RemoteStub proxy = UnicastRemoteObject.exportObject(this._provider);
            String url = ConfigHelper.getJndiURL(SchemeType.RMI, config);
            Naming.rebind(url, proxy);
        }
        catch (Exception exception) {
            NamingException error = new NamingException("Failed to bind the RMI JNDI interface in the registry");
            error.setRootCause(exception);
            throw error;
        }
    }
}

