/*
 * Decompiled with CFR 0.152.
 */
package com.levelonelabs.aim;

import com.levelonelabs.aim.XMLizable;
import java.util.ArrayList;
import java.util.ListIterator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class AIMGroup
implements XMLizable {
    private ArrayList buddies = new ArrayList();
    private String name;

    public AIMGroup(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public ArrayList getList() {
        return this.buddies;
    }

    public boolean add(String buddy) {
        if (!this.buddies.contains(buddy)) {
            return this.buddies.add(buddy);
        }
        return false;
    }

    public boolean remove(String buddy) {
        if (this.buddies.contains(buddy)) {
            this.buddies.remove(this.buddies.indexOf(buddy));
            return true;
        }
        return false;
    }

    public int size() {
        return this.buddies.size();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        ListIterator it = this.buddies.listIterator();
        while (it.hasNext()) {
            sb.append(it.next() + " ");
        }
        return sb.toString();
    }

    public void readState(Element fullStateElement) {
        this.buddies = new ArrayList();
        NodeList list = fullStateElement.getElementsByTagName("buddy");
        for (int i = 0; i < list.getLength(); ++i) {
            Element buddyElem = (Element)list.item(i);
            String name = buddyElem.getAttribute("name");
            this.add(name);
        }
    }

    public void writeState(Element emptyStateElement) {
        Document doc = emptyStateElement.getOwnerDocument();
        emptyStateElement.setAttribute("name", this.getName());
        ListIterator buds = this.buddies.listIterator();
        while (buds.hasNext()) {
            String bud = (String)buds.next();
            Element budElem = doc.createElement("buddy");
            budElem.setAttribute("name", bud);
            emptyStateElement.appendChild(budElem);
        }
    }
}

