/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.foundation;

import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSKeyValueCoding;
import com.webobjects.foundation.NSMutableDictionary;
import er.erxtest.ERXTestCase;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;

public class NSDictionaryTest
extends ERXTestCase {
    public void testNSDictionary() {
        NSDictionary dict = new NSDictionary();
        NSDictionaryTest.assertTrue((boolean)dict.isEmpty());
    }

    public void testNSDictionaryIsImmutable() {
        NSDictionary dict = new NSDictionary();
        try {
            dict.put((Object)"abc", (Object)"def");
            NSDictionaryTest.fail((String)"NSDictionary is not immutable");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testNSDictionaryMapOfKV() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("key", "value");
        NSDictionary dict = new NSDictionary(map);
        NSDictionaryTest.assertEquals((String)"value", (String)((String)dict.get((Object)"key")));
    }

    public void testNSDictionaryMapOfKVNull() {
        try {
            new NSDictionary((Map)null);
            NSDictionaryTest.fail((String)"NullPointerException expected");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testNSDictionaryMapOfKVInvalid() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("key", null);
        try {
            new NSDictionary(map);
            NSDictionaryTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testNSDictionaryMapOfKVBoolean() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("key", "value");
        NSDictionary dict = new NSDictionary(map, true);
        NSDictionaryTest.assertEquals((String)"value", (String)((String)dict.get((Object)"key")));
        dict = new NSDictionary(map, false);
        NSDictionaryTest.assertEquals((String)"value", (String)((String)dict.get((Object)"key")));
    }

    public void testNSDictionaryMapOfKVBooleanNull() {
        try {
            new NSDictionary((Map)null, true);
            NSDictionaryTest.fail((String)"NullPointerException expected");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            new NSDictionary((Map)null, false);
            NSDictionaryTest.fail((String)"NullPointerException expected");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testNSDictionaryMapOfKVBooleanInvalid() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("key", null);
        try {
            new NSDictionary(map, false);
            NSDictionaryTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        new NSDictionary(map, true);
    }

    public void testNSDictionaryNSArrayOfVNSArrayOfK() {
        NSArray keys = new NSArray((Object[])new String[]{"key1", "key2"});
        NSArray values = new NSArray((Object[])new String[]{"value1", "value2"});
        NSDictionary dict = new NSDictionary(values, keys);
        NSDictionaryTest.assertEquals((String)"value1", (String)((String)dict.get((Object)"key1")));
        NSDictionaryTest.assertEquals((String)"value2", (String)((String)dict.get((Object)"key2")));
    }

    public void testNSDictionaryNSArrayOfVNSArrayOfKNull() {
        NSArray array = new NSArray((Object[])new String[]{"value1", "value2"});
        try {
            new NSDictionary((NSArray)null, array);
            NSDictionaryTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            new NSDictionary(array, (NSArray)null);
            NSDictionaryTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        new NSDictionary((NSArray)null, (NSArray)null);
    }

    public void testNSDictionaryNSDictionaryOfKV() {
        NSMutableDictionary mutableDict = new NSMutableDictionary((Object)"value", (Object)"key");
        NSDictionary dict = new NSDictionary((NSDictionary)mutableDict);
        NSDictionary dict2 = new NSDictionary(dict);
        NSDictionaryTest.assertEquals((Object)mutableDict, (Object)dict);
        NSDictionaryTest.assertEquals((Object)mutableDict, (Object)dict2);
        mutableDict.put((Object)"key", (Object)"newValue");
        NSDictionaryTest.assertEquals((String)"value", (String)((String)dict.get((Object)"key")));
        NSDictionaryTest.assertEquals((String)"value", (String)((String)dict2.get((Object)"key")));
    }

    public void testNSDictionaryNSDictionaryOfKVNull() {
        try {
            new NSDictionary((NSDictionary)null);
            NSDictionaryTest.fail((String)"NullPointerException expected");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testNSDictionaryVArrayKArray() {
        Object[] keys = new String[]{"key1", "key2"};
        Object[] values = new String[]{"value1", "value2"};
        NSDictionary dict = new NSDictionary(values, keys);
        NSDictionaryTest.assertEquals((int)2, (int)dict.size());
        NSDictionaryTest.assertEquals((String)"value1", (String)((String)dict.get((Object)"key1")));
        NSDictionaryTest.assertEquals((String)"value2", (String)((String)dict.get((Object)"key2")));
    }

    public void testNSDictionaryVArrayKArrayNull() {
        Object[] values = new String[]{"value1", "value2"};
        try {
            new NSDictionary((Object[])null, values);
            NSDictionaryTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            new NSDictionary(values, (Object[])null);
            NSDictionaryTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        NSDictionary dict = new NSDictionary((Object[])null, (Object[])null);
        NSDictionaryTest.assertTrue((boolean)dict.isEmpty());
    }

    public void testNSDictionaryVK() {
        NSDictionary dict = new NSDictionary((Object)"value", (Object)"key");
        NSDictionaryTest.assertEquals((String)"value", (String)((String)dict.get((Object)"key")));
    }

    public void testNSDictionaryVKNull() {
        try {
            new NSDictionary((Object)null, (Object)"key");
            NSDictionaryTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            new NSDictionary((Object)"value", (Object)null);
            NSDictionaryTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            new NSDictionary((Object)null, (Object)null);
            NSDictionaryTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testAllKeys() {
        Object[] keys = new String[]{"key1", "key2"};
        Object[] values = new String[]{"value1", "value2"};
        NSDictionary dict = new NSDictionary(values, keys);
        NSArray keyArray = dict.allKeys();
        NSDictionaryTest.assertEquals((int)2, (int)keyArray.size());
        NSDictionaryTest.assertTrue((boolean)keyArray.contains((Object)"key1"));
        NSDictionaryTest.assertTrue((boolean)keyArray.contains((Object)"key2"));
    }

    public void testAllKeysForObject() {
        Object[] keys = new String[]{"key1", "key2"};
        Object[] values = new String[]{"value", "value"};
        NSDictionary dict = new NSDictionary(values, keys);
        NSArray keyArray = dict.allKeysForObject((Object)"value");
        NSDictionaryTest.assertEquals((int)2, (int)keyArray.size());
        NSDictionaryTest.assertTrue((boolean)keyArray.contains((Object)"key1"));
        NSDictionaryTest.assertTrue((boolean)keyArray.contains((Object)"key2"));
    }

    public void testObjectsForKeys() {
        Object[] keys = new String[]{"key1", "key2"};
        Object[] values = new String[]{"value1", "value2"};
        NSDictionary dict = new NSDictionary(values, keys);
        NSArray objectArray = dict.objectsForKeys(new NSArray((Object[])new String[]{"key1", "key2", "key3"}), (Object)"null");
        NSDictionaryTest.assertEquals((int)3, (int)objectArray.size());
        NSDictionaryTest.assertTrue((boolean)objectArray.contains((Object)"value1"));
        NSDictionaryTest.assertTrue((boolean)objectArray.contains((Object)"value2"));
        NSDictionaryTest.assertTrue((boolean)objectArray.contains((Object)"null"));
    }

    public void testAllValues() {
        Object[] keys = new String[]{"key1", "key2"};
        Object[] values = new String[]{"value1", "value2"};
        NSDictionary dict = new NSDictionary(values, keys);
        NSArray keyArray = dict.allValues();
        NSDictionaryTest.assertEquals((int)2, (int)keyArray.size());
        NSDictionaryTest.assertTrue((boolean)keyArray.contains((Object)"value1"));
        NSDictionaryTest.assertTrue((boolean)keyArray.contains((Object)"value2"));
    }

    public void testCount() {
        Object[] keys = new String[]{"key1", "key2"};
        Object[] values = new String[]{"value1", "value2"};
        NSDictionary dict = new NSDictionary(values, keys);
        NSDictionaryTest.assertEquals((int)2, (int)dict.count());
    }

    public void testEmptyDictionary() {
        NSDictionaryTest.assertTrue((boolean)NSDictionary.EmptyDictionary.isEmpty());
        NSDictionaryTest.assertTrue((boolean)NSDictionary.emptyDictionary().isEmpty());
    }

    public void testHashMap() {
        Object[] keys = new String[]{"key1", "key2"};
        Object[] values = new String[]{"value1", "value2"};
        NSDictionary dict = new NSDictionary(values, keys);
        HashMap hashMap = dict.hashMap();
        NSDictionaryTest.assertEquals((int)2, (int)hashMap.size());
        NSDictionaryTest.assertEquals((String)"value1", (String)((String)hashMap.get("key1")));
        NSDictionaryTest.assertEquals((String)"value2", (String)((String)dict.get((Object)"key2")));
    }

    public void testIsEqualToDictionary() {
        Object[] keys = new String[]{"key1", "key2"};
        Object[] values = new String[]{"value1", "value2"};
        NSDictionary dict = new NSDictionary(values, keys);
        NSDictionary dict2 = new NSDictionary(values, keys);
        NSDictionaryTest.assertTrue((boolean)dict.isEqualToDictionary(dict2));
    }

    public void testImmutableClone() {
        Object[] keys = new String[]{"key1", "key2"};
        Object[] values = new String[]{"value1", "value2"};
        NSDictionary dict = new NSDictionary(values, keys);
        NSDictionary clone = dict.immutableClone();
        NSDictionaryTest.assertEquals(NSDictionary.class, clone.getClass());
        NSDictionaryTest.assertEquals((Object)clone, (Object)dict);
    }

    public void testMutableClone() {
        Object[] keys = new String[]{"key1", "key2"};
        Object[] values = new String[]{"value1", "value2"};
        NSDictionary dict = new NSDictionary(values, keys);
        NSMutableDictionary clone = dict.mutableClone();
        NSDictionaryTest.assertEquals(NSMutableDictionary.class, clone.getClass());
        NSDictionaryTest.assertEquals((Object)clone, (Object)dict);
    }

    public void testKeyEnumerator() {
        NSDictionary dict = new NSDictionary((Object)"value", (Object)"key");
        Enumeration e = dict.keyEnumerator();
        NSDictionaryTest.assertTrue((boolean)e.hasMoreElements());
        NSDictionaryTest.assertEquals((String)"key", (String)((String)e.nextElement()));
        NSDictionaryTest.assertFalse((boolean)e.hasMoreElements());
        try {
            e.nextElement();
            NSDictionaryTest.fail((String)"Expected NoSuchElementException");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public void testObjectEnumerator() {
        NSDictionary dict = new NSDictionary((Object)"value", (Object)"key");
        Enumeration e = dict.objectEnumerator();
        NSDictionaryTest.assertTrue((boolean)e.hasMoreElements());
        NSDictionaryTest.assertEquals((String)"value", (String)((String)e.nextElement()));
        NSDictionaryTest.assertFalse((boolean)e.hasMoreElements());
        try {
            e.nextElement();
            NSDictionaryTest.fail((String)"Expected NoSuchElementException");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public void testObjectForKey() {
        NSDictionary dict = new NSDictionary((Object)"value", (Object)"key");
        NSDictionaryTest.assertEquals((String)"value", (String)((String)dict.objectForKey((Object)"key")));
    }

    public void testValueForKey() {
        NSDictionary dict = new NSDictionary((Object)"value", (Object)"key");
        NSDictionaryTest.assertEquals((Object)"value", (Object)dict.valueForKey("key"));
    }

    public void testValueForKeyPath() {
        NSDictionary dict = new NSDictionary((Object)"value", (Object)"key");
        NSDictionaryTest.assertEquals((Object)"value", (Object)dict.valueForKeyPath("key"));
        dict = new NSDictionary((Object)"value", (Object)"key.path");
        NSDictionaryTest.assertEquals((Object)"value", (Object)dict.valueForKeyPath("key.path"));
        NSDictionary subDict = new NSDictionary((Object)"value", (Object)"path");
        NSDictionary dict2 = new NSDictionary((Object)subDict, (Object)"key");
        NSDictionaryTest.assertEquals((Object)"value", (Object)dict2.valueForKeyPath("key.path"));
    }

    public void testClone() {
        Object[] keys = new String[]{"key1", "key2"};
        Object[] values = new String[]{"value1", "value2"};
        NSDictionary dict = new NSDictionary(values, keys);
        NSDictionary clone = (NSDictionary)dict.clone();
        NSDictionaryTest.assertEquals(NSDictionary.class, clone.getClass());
        NSDictionaryTest.assertEquals((Object)clone, (Object)dict);
    }

    public void testPutObjectObject() {
        try {
            NSDictionary.emptyDictionary().put((Object)"key", (Object)"value");
            NSDictionaryTest.fail((String)"Put should throw UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testPutAllMap() {
        try {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("key", "value");
            NSDictionary.emptyDictionary().putAll(map);
            NSDictionaryTest.fail((String)"PutAll should throw UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testRemoveObject() {
        try {
            NSDictionary.emptyDictionary().remove((Object)"abc");
            NSDictionaryTest.fail((String)"RemoveObject should throw UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testClear() {
        try {
            NSDictionary.EmptyDictionary.clear();
            NSDictionaryTest.fail((String)"Clear should throw UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testUnknownKeyException() {
        NSDictionary dict = new NSDictionary((Object)"John", (Object)"name");
        try {
            throw new NSKeyValueCoding.UnknownKeyException("error", (Object)dict, "name");
        }
        catch (NSKeyValueCoding.UnknownKeyException e) {
            return;
        }
        catch (Exception e) {
            NSDictionaryTest.fail((String)"Unable to throw unknown key exception");
            return;
        }
    }
}

