/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.foundation;

import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSPropertyListSerialization;
import com.webobjects.foundation.NSTimeZone;
import com.webobjects.foundation.NSTimestamp;
import com.webobjects.foundation.NSTimestampFormatter;
import er.erxtest.ERXTestCase;
import er.extensions.foundation.ERXFileUtilities;
import er.extensions.foundation.ERXValueUtilities;
import java.net.URL;
import java.text.FieldPosition;
import java.util.Enumeration;
import java.util.TimeZone;
import junit.framework.Assert;

public class NSTimestampTest
extends ERXTestCase {
    static NSTimestamp refDate = new NSTimestamp(1970, 1, 1, 0, 0, 0, (TimeZone)NSTimeZone.getGMT());
    static final int SUN = 0;
    static final int MON = 1;
    static final int TUE = 2;
    static final int WED = 3;
    static final int THU = 4;
    static final int FRI = 5;
    static final int SAT = 6;
    static final int JAN = 1;
    static final int FEB = 2;
    static final int MAR = 3;
    static final int APR = 4;
    static final int MAY = 5;
    static final int JUN = 6;
    static final int JUL = 7;
    static final int AUG = 8;
    static final int SEP = 9;
    static final int OCT = 10;
    static final int NOV = 11;
    static final int DEC = 12;

    private static int day(String name) {
        if (name.equals("MON")) {
            return 1;
        }
        if (name.equals("TUE")) {
            return 2;
        }
        if (name.equals("WED")) {
            return 3;
        }
        if (name.equals("THU")) {
            return 4;
        }
        if (name.equals("FRI")) {
            return 5;
        }
        if (name.equals("SAT")) {
            return 6;
        }
        if (name.equals("SUN")) {
            return 0;
        }
        return -1;
    }

    public void testConstructors() {
    }

    public void testCurrentTimeIntervalSinceReferenceDate() {
    }

    public void testDistantFuture() {
        Assert.assertEquals((Object)NSTimestamp.DistantFuture, (Object)NSTimestamp.distantFuture());
    }

    public void testDistantPast() {
        Assert.assertEquals((Object)NSTimestamp.DistantPast, (Object)NSTimestamp.distantPast());
    }

    public void testMillisecondsToTimeInterval() {
    }

    public void testTimeIntervalToMilliseconds() {
    }

    public void testClassForCoder() {
    }

    public void testDecodeObject() {
    }

    public void testEncodeWithCoder() {
    }

    public void testIncrementAcrossDST() {
        NSTimeZone tz = null;
        NSTimestampFormatter formatter = null;
        StringBuffer dt = null;
        FieldPosition fp = new FieldPosition(0);
        NSDictionary data = (NSDictionary)NSPropertyListSerialization.propertyListWithPathURL((URL)ERXFileUtilities.pathURLForResourceNamed((String)"dates.plist", null, null));
        Enumeration dsts = ((NSArray)data.objectForKey((Object)"daylightSavingTimeTransitions")).objectEnumerator();
        while (dsts.hasMoreElements()) {
            NSDictionary dst = (NSDictionary)dsts.nextElement();
            int year = ERXValueUtilities.intValue((Object)dst.objectForKey((Object)"year"));
            int month = ERXValueUtilities.intValue((Object)dst.objectForKey((Object)"month"));
            int day = ERXValueUtilities.intValue((Object)dst.objectForKey((Object)"day"));
            tz = NSTimeZone.timeZoneWithName((String)((String)dst.objectForKey((Object)"tz")), (boolean)false);
            formatter = new NSTimestampFormatter("%Y %b %d %H:%M:%S %z");
            formatter.setDefaultFormatTimeZone(tz);
            String before = (String)dst.objectForKey((Object)"before");
            String after = (String)dst.objectForKey((Object)"after");
            NSTimestamp ts1 = new NSTimestamp(year, month, day, 1, 59, 59, (TimeZone)tz);
            dt = new StringBuffer();
            formatter.format((Object)ts1, dt, fp);
            Assert.assertEquals((String)before, (String)dt.toString());
            NSTimestamp ts2 = ts1.timestampByAddingGregorianUnits(0, 0, 0, 0, 0, 2);
            dt = new StringBuffer();
            formatter.format((Object)ts2, dt, fp);
            Assert.assertEquals((String)after, (String)dt.toString());
        }
    }

    public void testTimestampByAddingGregorianUnits() {
        NSTimestamp ts1 = new NSTimestamp(1970, 1, 1, 12, 0, 0, (TimeZone)NSTimeZone.getGMT());
        NSTimestamp ts2 = new NSTimestamp(1970, 1, 1, 12, 0, 0, (TimeZone)NSTimeZone.getGMT());
        Assert.assertEquals((Object)ts2, (Object)ts1.timestampByAddingGregorianUnits(0, 0, 0, 0, 0, 0));
        ts2 = new NSTimestamp(1971, 1, 1, 12, 0, 0, (TimeZone)NSTimeZone.getGMT());
        Assert.assertEquals((Object)ts2, (Object)ts1.timestampByAddingGregorianUnits(1, 0, 0, 0, 0, 0));
        ts2 = new NSTimestamp(1969, 1, 1, 12, 0, 0, (TimeZone)NSTimeZone.getGMT());
        Assert.assertEquals((Object)ts2, (Object)ts1.timestampByAddingGregorianUnits(-1, 0, 0, 0, 0, 0));
        ts2 = new NSTimestamp(1970, 2, 1, 12, 0, 0, (TimeZone)NSTimeZone.getGMT());
        Assert.assertEquals((Object)ts2, (Object)ts1.timestampByAddingGregorianUnits(0, 1, 0, 0, 0, 0));
        ts2 = new NSTimestamp(1969, 12, 1, 12, 0, 0, (TimeZone)NSTimeZone.getGMT());
        Assert.assertEquals((Object)ts2, (Object)ts1.timestampByAddingGregorianUnits(0, -1, 0, 0, 0, 0));
        ts2 = new NSTimestamp(1970, 1, 2, 12, 0, 0, (TimeZone)NSTimeZone.getGMT());
        Assert.assertEquals((Object)ts2, (Object)ts1.timestampByAddingGregorianUnits(0, 0, 1, 0, 0, 0));
        ts2 = new NSTimestamp(1969, 12, 31, 12, 0, 0, (TimeZone)NSTimeZone.getGMT());
        Assert.assertEquals((Object)ts2, (Object)ts1.timestampByAddingGregorianUnits(0, 0, -1, 0, 0, 0));
        ts2 = new NSTimestamp(1970, 1, 1, 13, 0, 0, (TimeZone)NSTimeZone.getGMT());
        Assert.assertEquals((Object)ts2, (Object)ts1.timestampByAddingGregorianUnits(0, 0, 0, 1, 0, 0));
        ts2 = new NSTimestamp(1970, 1, 1, 11, 0, 0, (TimeZone)NSTimeZone.getGMT());
        Assert.assertEquals((Object)ts2, (Object)ts1.timestampByAddingGregorianUnits(0, 0, 0, -1, 0, 0));
        ts2 = new NSTimestamp(1970, 1, 1, 12, 1, 0, (TimeZone)NSTimeZone.getGMT());
        Assert.assertEquals((Object)ts2, (Object)ts1.timestampByAddingGregorianUnits(0, 0, 0, 0, 1, 0));
        ts2 = new NSTimestamp(1970, 1, 1, 11, 59, 0, (TimeZone)NSTimeZone.getGMT());
        Assert.assertEquals((Object)ts2, (Object)ts1.timestampByAddingGregorianUnits(0, 0, 0, 0, -1, 0));
        ts2 = new NSTimestamp(1970, 1, 1, 12, 0, 1, (TimeZone)NSTimeZone.getGMT());
        Assert.assertEquals((Object)ts2, (Object)ts1.timestampByAddingGregorianUnits(0, 0, 0, 0, 0, 1));
        ts2 = new NSTimestamp(1970, 1, 1, 11, 59, 59, (TimeZone)NSTimeZone.getGMT());
        Assert.assertEquals((Object)ts2, (Object)ts1.timestampByAddingGregorianUnits(0, 0, 0, 0, 0, -1));
    }

    public void testTimestampByAddingTimeInterval() {
    }

    public void testDayOfCommonEra() {
    }

    public void testDayOfMonth() {
        Assert.assertEquals((int)1, (int)refDate.dayOfMonth());
    }

    public void testDayOfWeek() {
        Assert.assertEquals((int)4, (int)refDate.dayOfWeek());
        Assert.assertEquals((int)3, (int)new NSTimestamp(2009, 5, 6, 0, 0, 0, (TimeZone)NSTimeZone.getGMT()).dayOfWeek());
        Assert.assertEquals((int)5, (int)new NSTimestamp(2079, 12, 1, 0, 0, 0, (TimeZone)NSTimeZone.getGMT()).dayOfWeek());
    }

    public void testFirstDaysOfYears() {
        NSDictionary data = (NSDictionary)NSPropertyListSerialization.propertyListWithPathURL((URL)ERXFileUtilities.pathURLForResourceNamed((String)"dates.plist", null, null));
        NSDictionary daysDict = (NSDictionary)data.objectForKey((Object)"firstDayForYears");
        Enumeration days = daysDict.allKeys().objectEnumerator();
        while (days.hasMoreElements()) {
            String key = (String)days.nextElement();
            int year = -1;
            try {
                year = new Integer(key);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            String dayName = (String)daysDict.objectForKey((Object)key);
            Assert.assertEquals((int)NSTimestampTest.day(dayName), (int)new NSTimestamp(year, 1, 1, 0, 0, 0, (TimeZone)NSTimeZone.getGMT()).dayOfWeek());
        }
    }

    public void testDayOfYear() {
    }

    public void testHourOfDay() {
    }

    public void testMicrosecondOfSecond() {
    }

    public void testMinuteOfHour() {
    }

    public void testMonthOfYear() {
    }

    public void testSecondOfMinute() {
    }

    public void testYearOfCommonEra() {
    }

    public void testGregorianUnitsSinceTimestamp() {
    }

    public void testTimeIntervalSinceTimestamp() {
    }

    public void testTimeIntervalSinceNow() {
    }

    public void testTimeIntervalSinceReferenceDate() {
    }

    public void testCompare() {
    }

    public void testEarlierTimestamp() {
    }

    public void testLaterTimestamp() {
    }

    public void testToString() {
    }

    public void testTimeZone() {
    }

    public void testSetNanos() {
    }

    public void testSetDate() {
    }

    public void testSetHours() {
    }

    public void testSetMinutes() {
    }

    public void testSetMonth() {
    }

    public void testSetSeconds() {
    }

    public void testSetTime() {
    }

    public void testGetTime() {
    }

    public void testgetNanos() {
    }

    public void testSetYear() {
    }
}

