/*
 * Decompiled with CFR 0.152.
 */
package er.erxtest;

import com.webobjects.eoaccess.EODatabaseContext;
import com.webobjects.eoaccess.EOModel;
import com.webobjects.eoaccess.EOModelGroup;
import com.webobjects.eoaccess.EOUtilities;
import com.webobjects.eocontrol.EOEditingContext;
import com.webobjects.eocontrol.EOEnterpriseObject;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import er.erxtest.Application;
import er.extensions.eof.ERXEC;
import java.util.Arrays;
import java.util.List;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ERXTestUtilities {
    public static void fixModelsForAdaptorNamed(String adaptorName) {
        if (adaptorName.equals("Memory")) {
            for (EOModel model : EOModelGroup.defaultGroup().models()) {
                model.setAdaptorName("Memory");
                model.setConnectionDictionary(NSDictionary.EmptyDictionary);
            }
            return;
        }
        if (adaptorName.equals("MySQL")) {
            NSDictionary conn = new NSDictionary(Arrays.asList(Application.wobuild.getProperty("wo.test.dbAccess.MySQL.URL"), Application.wobuild.getProperty("wo.test.dbAccess.MySQL.name"), Application.wobuild.getProperty("wo.test.dbAccess.MySQL.password")).toArray(), Arrays.asList("URL", "username", "password").toArray());
            EOEditingContext ec = ERXEC.newEditingContext();
            for (EOModel model : EOModelGroup.defaultGroup().models()) {
                model.setAdaptorName("JDBC");
                model.setConnectionDictionary(conn);
                EODatabaseContext.forceConnectionWithModel((EOModel)model, (NSDictionary)conn, (EOEditingContext)ec);
            }
            return;
        }
    }

    public static String randomName(String prefix) {
        return prefix + "_" + System.currentTimeMillis() + "_" + new Random().nextDouble();
    }

    public static void deleteObjectsWithPrefix(EOEditingContext ec, String entityName, String prefix) {
        for (Object obj : EOUtilities.objectsWithQualifierFormat((EOEditingContext)ec, (String)entityName, (String)("name like '" + prefix + "_*'"), null)) {
            ec.deleteObject((EOEnterpriseObject)obj);
        }
        ec.saveChanges();
    }

    public static void deleteObjectsWithPrefix(String entityName, String prefix) {
        EOEditingContext ec = ERXEC.newEditingContext();
        for (Object obj : EOUtilities.objectsWithQualifierFormat((EOEditingContext)ec, (String)entityName, (String)("name = '" + prefix + "_*'"), null)) {
            ec.deleteObject((EOEnterpriseObject)obj);
        }
        ec.saveChanges();
    }

    public static void deleteObjectsWithPrefix(EOEditingContext ec, NSArray<Object> eos) {
        for (Object obj : eos) {
            ec.deleteObject((EOEnterpriseObject)obj);
        }
        ec.saveChanges();
    }

    public static int pkOne(EOEditingContext ec, EOEnterpriseObject eo) {
        return (Integer)((List)EOUtilities.primaryKeyForObject((EOEditingContext)ec, (EOEnterpriseObject)eo).values()).get(0);
    }
}

