/*
 * Decompiled with CFR 0.152.
 */
package er.erxtest.tests;

import com.webobjects.foundation.NSForwardException;
import er.erxtest.ERXTestCase;
import er.extensions.appserver.ERXApplication;
import er.extensions.eof.ERXEC;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import junit.framework.Assert;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ERXECLockingTestCase
extends ERXTestCase {
    static ExecutorService executor = Executors.newCachedThreadPool();
    public static final Logger log = Logger.getLogger(ERXECLockingTestCase.class);
    private static final long JOIN_TIME = 2000L;

    protected static Object call(Callable<? extends Object> aCallable, long timeout) throws TimeoutException {
        Future<? extends Object> future = executor.submit(aCallable);
        try {
            return future.get(timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e1) {
            throw new TimeoutException();
        }
        catch (ExecutionException e1) {
            throw NSForwardException._runtimeExceptionForThrowable((Throwable)e1.getCause());
        }
    }

    private EC createEC() {
        return new EC();
    }

    private void assertLockable(EC ec) {
        ERXECLockingTestCase.assertTrue((boolean)this.isLockable(ec));
    }

    private boolean isLockable(final EC ec) {
        try {
            return (Boolean)ERXECLockingTestCase.call((Callable<? extends Object>)new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    Boolean r = ec.tryLock();
                    if (r.booleanValue()) {
                        ec.unlock();
                    }
                    return r;
                }
            }, 1L);
        }
        catch (TimeoutException e) {
            ERXECLockingTestCase.fail((String)e.getMessage());
            return false;
        }
    }

    private void assertNotLockable(EC ec) {
        ERXECLockingTestCase.assertFalse((boolean)this.isLockable(ec));
    }

    public void test() {
        EC ec = this.createEC();
        ERXECLockingTestCase.assertFalse((boolean)ec.beforeLock);
        ERXECLockingTestCase.assertFalse((boolean)ec.beforeAutoLock);
        ERXECLockingTestCase.assertFalse((boolean)ec.beforeAutoUnlock);
        ERXECLockingTestCase.assertFalse((boolean)ec.beforeUnlock);
        ERXECLockingTestCase.assertFalse((boolean)ec.isAutoLocked());
        ERXECLockingTestCase.assertFalse((boolean)ec.wasAutolocked);
        this.assertLockable(ec);
    }

    public void testPlainOneThreadLocking() {
        EC ec = this.createEC();
        ec.lock();
        ERXECLockingTestCase.assertTrue((boolean)ec.beforeLock);
        ERXECLockingTestCase.assertTrue((boolean)ec.afterLock);
        ERXECLockingTestCase.assertFalse((boolean)ec.beforeAutoLock);
        ERXECLockingTestCase.assertFalse((boolean)ec.beforeAutoUnlock);
        ERXECLockingTestCase.assertFalse((boolean)ec.beforeUnlock);
        ec.unlock();
        ERXECLockingTestCase.assertTrue((boolean)ec.beforeLock);
        ERXECLockingTestCase.assertTrue((boolean)ec.afterLock);
        ERXECLockingTestCase.assertTrue((boolean)ec.beforeUnlock);
        ERXECLockingTestCase.assertTrue((boolean)ec.afterUnlock);
        ERXECLockingTestCase.assertFalse((boolean)ec.beforeAutoLock);
        ERXECLockingTestCase.assertFalse((boolean)ec.beforeAutoUnlock);
        ERXECLockingTestCase.assertFalse((boolean)ec.isAutoLocked());
        ERXECLockingTestCase.assertFalse((boolean)ec.wasAutolocked);
        ERXECLockingTestCase.assertEquals((int)ec.autoLocks, (int)0);
        this.assertLockable(ec);
    }

    public void testPlainOneThreadAutoLocking() {
        EC ec = this.createEC();
        ec.saveChanges();
        ERXECLockingTestCase.assertTrue((boolean)ec.beforeLock);
        ERXECLockingTestCase.assertTrue((boolean)ec.afterLock);
        ERXECLockingTestCase.assertTrue((boolean)ec.beforeAutoLock);
        ERXECLockingTestCase.assertTrue((boolean)ec.afterAutoLock);
        ERXECLockingTestCase.assertTrue((boolean)ec.beforeAutoUnlock);
        ERXECLockingTestCase.assertTrue((boolean)ec.afterAutoUnlock);
        ERXECLockingTestCase.assertTrue((boolean)ec.beforeUnlock);
        ERXECLockingTestCase.assertTrue((boolean)ec.afterUnlock);
        ERXECLockingTestCase.assertFalse((boolean)ec.isAutoLocked());
        ERXECLockingTestCase.assertTrue((boolean)ec.wasAutolocked);
        ERXECLockingTestCase.assertTrue((String)("autoLocks: " + ec.autoLocks), (ec.autoLocks >= 1 ? 1 : 0) != 0);
        this.assertLockable(ec);
    }

    public void testPlainOneThreadAutoLockingCoalesceNotInRequest() {
        EC ec = this.createEC();
        ec.setCoalesceAutoLocks(true);
        ec.saveChanges();
        ec.saveChanges();
        ERXECLockingTestCase.assertTrue((boolean)ec.beforeLock);
        ERXECLockingTestCase.assertTrue((boolean)ec.afterLock);
        ERXECLockingTestCase.assertTrue((boolean)ec.beforeAutoLock);
        ERXECLockingTestCase.assertTrue((boolean)ec.afterAutoLock);
        ERXECLockingTestCase.assertTrue((boolean)ec.beforeAutoUnlock);
        ERXECLockingTestCase.assertTrue((boolean)ec.afterAutoUnlock);
        ERXECLockingTestCase.assertTrue((boolean)ec.beforeUnlock);
        ERXECLockingTestCase.assertTrue((boolean)ec.afterUnlock);
        ERXECLockingTestCase.assertFalse((boolean)ec.isAutoLocked());
        ERXECLockingTestCase.assertTrue((boolean)ec.wasAutolocked);
        ERXECLockingTestCase.assertEquals((int)2, (int)ec.autoLocks);
        this.assertLockable(ec);
    }

    public void testPlainOneThreadAutoLockingCoalesceInRequest() {
        EC ec = this.createEC();
        ERXApplication._startRequest();
        ec.setCoalesceAutoLocks(true);
        ec.saveChanges();
        ec.saveChanges();
        this.assertNotLockable(ec);
        ERXECLockingTestCase.assertTrue((boolean)ec.isAutoLocked());
        ERXApplication._endRequest();
        ERXECLockingTestCase.assertTrue((boolean)ec.beforeLock);
        ERXECLockingTestCase.assertTrue((boolean)ec.afterLock);
        ERXECLockingTestCase.assertTrue((boolean)ec.beforeAutoLock);
        ERXECLockingTestCase.assertTrue((boolean)ec.afterAutoLock);
        ERXECLockingTestCase.assertTrue((boolean)ec.beforeAutoUnlock);
        ERXECLockingTestCase.assertTrue((boolean)ec.afterAutoUnlock);
        ERXECLockingTestCase.assertTrue((boolean)ec.beforeUnlock);
        ERXECLockingTestCase.assertTrue((boolean)ec.afterUnlock);
        ERXECLockingTestCase.assertEquals((int)1, (int)ec.autoLocks);
        ERXECLockingTestCase.assertFalse((boolean)ec.isAutoLocked());
        ERXECLockingTestCase.assertTrue((boolean)ec.wasAutolocked);
        this.assertLockable(ec);
    }

    public void testPlainOneThreadAutoLockingWithLock() {
        EC ec = this.createEC();
        ec.lock();
        ec.saveChanges();
        ec.unlock();
        ERXECLockingTestCase.assertFalse((boolean)ec.wasAutolocked);
        ec.saveChanges();
        ERXECLockingTestCase.assertTrue((boolean)ec.beforeLock);
        ERXECLockingTestCase.assertTrue((boolean)ec.afterLock);
        ERXECLockingTestCase.assertTrue((boolean)ec.beforeAutoLock);
        ERXECLockingTestCase.assertTrue((boolean)ec.afterAutoLock);
        ERXECLockingTestCase.assertTrue((boolean)ec.beforeAutoUnlock);
        ERXECLockingTestCase.assertTrue((boolean)ec.afterAutoUnlock);
        ERXECLockingTestCase.assertTrue((boolean)ec.beforeUnlock);
        ERXECLockingTestCase.assertTrue((boolean)ec.afterUnlock);
        ERXECLockingTestCase.assertFalse((boolean)ec.isAutoLocked());
        ERXECLockingTestCase.assertTrue((boolean)ec.wasAutolocked);
    }

    public void testTwoThreadWithAutoLock() {
        final EC ec = this.createEC();
        Runnable r = new Runnable(){

            public void run() {
                log.info((Object)("Saving: " + Thread.currentThread().getName()));
                ec.saveChangesWithWait();
                log.info((Object)("Saved: " + Thread.currentThread().getName()));
            }
        };
        Thread t1 = new Thread(r);
        Thread t2 = new Thread(r);
        t1.start();
        t2.start();
        try {
            t1.join(2000L);
            t2.join(2000L);
            ERXECLockingTestCase.assertFalse((boolean)t1.isAlive());
            ERXECLockingTestCase.assertFalse((boolean)t2.isAlive());
        }
        catch (InterruptedException e) {
            ERXECLockingTestCase.assertTrue((boolean)false);
        }
        ERXECLockingTestCase.assertTrue((boolean)ec.beforeLock);
        ERXECLockingTestCase.assertTrue((boolean)ec.afterLock);
        ERXECLockingTestCase.assertTrue((boolean)ec.beforeAutoLock);
        ERXECLockingTestCase.assertTrue((boolean)ec.afterAutoLock);
        ERXECLockingTestCase.assertTrue((boolean)ec.beforeAutoUnlock);
        ERXECLockingTestCase.assertTrue((boolean)ec.afterAutoUnlock);
        ERXECLockingTestCase.assertTrue((boolean)ec.beforeUnlock);
        ERXECLockingTestCase.assertTrue((boolean)ec.afterUnlock);
        ERXECLockingTestCase.assertFalse((boolean)ec.isAutoLocked());
        ERXECLockingTestCase.assertTrue((boolean)ec.wasAutolocked);
    }

    public void testTwoThreadWithLock() {
        final EC ec = this.createEC();
        Runnable r = new Runnable(){

            public void run() {
                log.info((Object)("Before lock: " + Thread.currentThread().getName()));
                ec.lock();
                log.info((Object)("After lock: " + Thread.currentThread().getName()));
                ec.saveChangesWithWait();
                log.info((Object)("Saved: " + Thread.currentThread().getName()));
                ec.unlock();
            }
        };
        Thread t1 = new Thread(r);
        Thread t2 = new Thread(r);
        t1.start();
        t2.start();
        try {
            t1.join(2000L);
            t2.join(2000L);
            ERXECLockingTestCase.assertFalse((boolean)t1.isAlive());
            ERXECLockingTestCase.assertFalse((boolean)t2.isAlive());
        }
        catch (InterruptedException e) {
            ERXECLockingTestCase.assertTrue((boolean)false);
        }
        ERXECLockingTestCase.assertTrue((boolean)ec.beforeLock);
        ERXECLockingTestCase.assertTrue((boolean)ec.afterLock);
        ERXECLockingTestCase.assertTrue((boolean)ec.beforeAutoLock);
        ERXECLockingTestCase.assertTrue((boolean)ec.afterAutoLock);
        ERXECLockingTestCase.assertTrue((boolean)ec.beforeAutoUnlock);
        ERXECLockingTestCase.assertTrue((boolean)ec.afterAutoUnlock);
        ERXECLockingTestCase.assertTrue((boolean)ec.beforeUnlock);
        ERXECLockingTestCase.assertTrue((boolean)ec.afterUnlock);
        ERXECLockingTestCase.assertFalse((boolean)ec.isAutoLocked());
        ERXECLockingTestCase.assertFalse((boolean)ec.wasAutolocked);
    }

    public void testTwoThreadWithLockAutoLock() {
        final EC ec = this.createEC();
        Runnable r1 = new Runnable(){

            public void run() {
                log.info((Object)("Before save: " + Thread.currentThread().getName()));
                ec.saveChangesWithWait();
                log.info((Object)("Saved: " + Thread.currentThread().getName()));
                Assert.assertFalse((boolean)ec.isAutoLocked());
            }
        };
        Runnable r2 = new Runnable(){

            public void run() {
                log.info((Object)("Before lock: " + Thread.currentThread().getName()));
                ec.lock();
                log.info((Object)("After lock: " + Thread.currentThread().getName()));
                ec.saveChangesWithWait();
                log.info((Object)("Saved: " + Thread.currentThread().getName()));
                ec.unlock();
                Assert.assertFalse((boolean)ec.isAutoLocked());
            }
        };
        Thread t1 = new Thread(r1);
        Thread t2 = new Thread(r2);
        t1.start();
        t2.start();
        try {
            t1.join(2000L);
            t2.join(2000L);
            ERXECLockingTestCase.assertFalse((boolean)t1.isAlive());
            ERXECLockingTestCase.assertFalse((boolean)t2.isAlive());
        }
        catch (InterruptedException e) {
            ERXECLockingTestCase.assertTrue((boolean)false);
        }
        ERXECLockingTestCase.assertTrue((boolean)ec.beforeLock);
        ERXECLockingTestCase.assertTrue((boolean)ec.afterLock);
        ERXECLockingTestCase.assertTrue((boolean)ec.beforeAutoLock);
        ERXECLockingTestCase.assertTrue((boolean)ec.afterAutoLock);
        ERXECLockingTestCase.assertTrue((boolean)ec.beforeAutoUnlock);
        ERXECLockingTestCase.assertTrue((boolean)ec.afterAutoUnlock);
        ERXECLockingTestCase.assertTrue((boolean)ec.beforeUnlock);
        ERXECLockingTestCase.assertTrue((boolean)ec.afterUnlock);
        ERXECLockingTestCase.assertFalse((boolean)ec.isAutoLocked());
        ERXECLockingTestCase.assertTrue((boolean)ec.wasAutolocked);
    }

    public void testTwoThreadWithAutoLockLock() {
        final EC ec = this.createEC();
        Runnable r2 = new Runnable(){

            public void run() {
                log.info((Object)("Before save: " + Thread.currentThread().getName()));
                ec.saveChangesWithWait();
                log.info((Object)("Saved: " + Thread.currentThread().getName()));
                Assert.assertFalse((boolean)ec.isAutoLocked());
            }
        };
        Runnable r1 = new Runnable(){

            public void run() {
                log.info((Object)("Before lock: " + Thread.currentThread().getName()));
                ec.lock();
                log.info((Object)("After lock: " + Thread.currentThread().getName()));
                ec.saveChangesWithWait();
                log.info((Object)("Saved: " + Thread.currentThread().getName()));
                ec.unlock();
                Assert.assertFalse((boolean)ec.isAutoLocked());
            }
        };
        Thread t1 = new Thread(r1);
        Thread t2 = new Thread(r2);
        t1.start();
        t2.start();
        try {
            t1.join(2000L);
            t2.join(2000L);
            ERXECLockingTestCase.assertFalse((boolean)t1.isAlive());
            ERXECLockingTestCase.assertFalse((boolean)t2.isAlive());
        }
        catch (InterruptedException e) {
            ERXECLockingTestCase.assertTrue((boolean)false);
        }
        ERXECLockingTestCase.assertTrue((boolean)ec.beforeLock);
        ERXECLockingTestCase.assertTrue((boolean)ec.afterLock);
        ERXECLockingTestCase.assertTrue((boolean)ec.beforeAutoLock);
        ERXECLockingTestCase.assertTrue((boolean)ec.afterAutoLock);
        ERXECLockingTestCase.assertTrue((boolean)ec.beforeAutoUnlock);
        ERXECLockingTestCase.assertTrue((boolean)ec.afterAutoUnlock);
        ERXECLockingTestCase.assertTrue((boolean)ec.beforeUnlock);
        ERXECLockingTestCase.assertTrue((boolean)ec.afterUnlock);
        ERXECLockingTestCase.assertFalse((boolean)ec.isAutoLocked());
        ERXECLockingTestCase.assertTrue((boolean)ec.wasAutolocked);
    }

    public static class EC
    extends ERXEC {
        public boolean beforeLock;
        public boolean afterLock;
        public boolean beforeUnlock;
        public boolean afterUnlock;
        public boolean beforeAutoLock;
        public boolean afterAutoLock;
        public boolean beforeAutoUnlock;
        public boolean afterAutoUnlock;
        public boolean wasAutolocked;
        public int autoLocks;
        public long waitTime;

        public void lock() {
            this.beforeLock = true;
            super.lock();
            this.afterLock = true;
        }

        public void unlock() {
            this.beforeUnlock = true;
            super.unlock();
            this.afterUnlock = true;
        }

        protected boolean autoLock(String method) {
            this.beforeAutoLock = true;
            boolean result = super.autoLock(method);
            if (result) {
                this.wasAutolocked = true;
                ++this.autoLocks;
            }
            this.afterAutoLock = true;
            return result;
        }

        protected void autoUnlock(boolean wasLocked) {
            this.beforeAutoUnlock = true;
            super.autoUnlock(wasLocked);
            this.afterAutoUnlock = true;
        }

        public void saveChangesWithWait() {
            this.waitTime = 400L;
            this.saveChanges();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void _saveChanges() {
            if (this.waitTime > 0L) {
                EC eC = this;
                synchronized (eC) {
                    try {
                        ((Object)((Object)this)).wait(this.waitTime);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
            super._saveChanges();
        }
    }
}

