/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.eof;

import com.webobjects.eocontrol.EOEditingContext;
import com.webobjects.eocontrol.EOQualifier;
import com.webobjects.eocontrol.EORelationshipManipulation;
import com.webobjects.eocontrol.EOSortOrdering;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSRange;
import com.webobjects.foundation.NSTimestamp;
import er.erxtest.ERXTestCase;
import er.erxtest.model.Company;
import er.erxtest.model.Employee;
import er.erxtest.model.Paycheck;
import er.erxtest.model.Role;
import er.extensions.eof.ERXEC;
import er.extensions.eof.ERXKey;
import er.extensions.foundation.ERXArrayUtilities;
import java.math.BigDecimal;
import java.sql.Timestamp;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class ERXKeyTest
extends ERXTestCase {
    private EOEditingContext ec;
    private Company acme;
    private Company shinraInc;
    private Company tyrellCorp;
    private Company sortCo;
    private Employee moe;
    private Employee larry;
    private Employee curly;
    private Employee tyrell;
    private Employee deckard;
    private Employee rachael;
    private Employee rufus;
    private Employee rude;
    private Employee elena;
    private Employee sephiroth;
    private Employee aaBb;
    private Employee Abba;
    private Paycheck paycheck5000;
    private Paycheck paycheck10000;
    private Paycheck paycheck15000;
    private Role headHunter;
    private Role bigBoss;
    private Role accountant;
    private Role doctor;
    private Role barber;
    private NSArray<Role> roles;
    private NSArray<Employee> shinraEmployees;
    private NSArray<Employee> shinraNonManager;
    private NSArray<String> shinraNonManagerNames;
    private NSArray<Employee> tyrellEmployees;
    private NSArray<Paycheck> paychecks;
    private static final String numKey = "num";
    private static final ERXKey<Integer> num = new ERXKey("num");
    private static final NSDictionary<String, Integer> uno = new NSDictionary((Object)1, (Object)"num");
    private static final NSDictionary<String, Integer> dos = new NSDictionary((Object)2, (Object)"num");
    private static final NSDictionary<String, Integer> tres = new NSDictionary((Object)3, (Object)"num");
    private static final NSDictionary<String, Integer> quatro = new NSDictionary((Object)4, (Object)"num");
    private static final NSDictionary<String, Integer> cinco = new NSDictionary((Object)5, (Object)"num");
    private static final NSArray<NSDictionary<String, Integer>> numbers = new NSArray(uno, (Object[])new NSDictionary[]{dos, tres, quatro, cinco});
    private static final NSArray<Integer> simpleNumbers = new NSArray((Object)1, (Object[])new Integer[]{2, 3, 4, 5});

    @Before
    public void setUp() throws Exception {
        this.ec = ERXEC.newEditingContext();
        this.headHunter = Role.createRole(this.ec);
        this.bigBoss = Role.createRole(this.ec);
        this.accountant = Role.createRole(this.ec);
        this.roles = new NSArray((Object)this.headHunter, (Object[])new Role[]{this.bigBoss, this.accountant});
        this.doctor = Role.createRole(this.ec);
        this.barber = Role.createRole(this.ec);
        this.acme = Company.createCompany(this.ec, "Acme");
        this.shinraInc = Company.createCompany(this.ec, "Shinra Inc.");
        this.tyrellCorp = Company.createCompany(this.ec, "Tyrell Corporation");
        this.sortCo = Company.createCompany(this.ec, "Sort test");
        this.moe = Employee.createEmployee(this.ec, "Moe", "Stooge", Boolean.TRUE, this.acme);
        this.larry = Employee.createEmployee(this.ec, "Larry", "Stooge", Boolean.FALSE, this.acme);
        this.curly = Employee.createEmployee(this.ec, "Curly", "Stooge", Boolean.FALSE, this.acme);
        this.tyrell = Employee.createEmployee(this.ec, "Eldon", "Tyrell", Boolean.TRUE, this.tyrellCorp);
        this.deckard = Employee.createEmployee(this.ec, "Rick", "Deckard", Boolean.FALSE, this.tyrellCorp);
        this.rachael = Employee.createEmployee(this.ec, "Rachael", "Replicant", Boolean.FALSE, this.tyrellCorp);
        this.tyrellEmployees = new NSArray((Object)this.tyrell, (Object[])new Employee[]{this.deckard, this.rachael});
        this.rufus = Employee.createEmployee(this.ec, "Rufus", "Shinra", Boolean.TRUE, this.shinraInc);
        this.rude = Employee.createEmployee(this.ec, "Rude", "Terk", Boolean.FALSE, this.shinraInc);
        this.elena = Employee.createEmployee(this.ec, "Elena", "turk", Boolean.FALSE, this.shinraInc);
        this.sephiroth = Employee.createEmployee(this.ec, "Sephiroth", "Jenova", Boolean.FALSE, this.shinraInc);
        this.shinraEmployees = new NSArray((Object)this.rufus, (Object[])new Employee[]{this.rude, this.elena, this.sephiroth});
        this.shinraNonManager = new NSArray((Object)this.rude, (Object[])new Employee[]{this.elena, this.sephiroth});
        this.shinraNonManagerNames = new NSArray((Object)this.rude.firstName(), (Object[])new String[]{this.elena.firstName(), this.sephiroth.firstName()});
        this.elena.setBestSalesTotal(BigDecimal.valueOf(10000L));
        this.rude.setBestSalesTotal(BigDecimal.valueOf(5000L));
        this.aaBb = Employee.createEmployee(this.ec, "aa", "Bb", Boolean.FALSE, this.sortCo);
        this.Abba = Employee.createEmployee(this.ec, "Ab", "ba", Boolean.FALSE, this.sortCo);
        NSTimestamp now = new NSTimestamp();
        this.paycheck5000 = Paycheck.createPaycheck(this.ec, BigDecimal.valueOf(5000L), Boolean.FALSE, now.timestampByAddingGregorianUnits(0, 0, -14, 0, 0, 0), this.rufus);
        this.paycheck10000 = Paycheck.createPaycheck(this.ec, BigDecimal.valueOf(10000L), Boolean.FALSE, now.timestampByAddingGregorianUnits(0, 0, -7, 0, 0, 0), this.rufus);
        this.paycheck15000 = Paycheck.createPaycheck(this.ec, BigDecimal.valueOf(15000L), Boolean.FALSE, now, this.rufus);
        this.paychecks = new NSArray((Object)this.paycheck5000, new Object[]{this.paycheck10000, this.paycheck15000});
        this.rufus.addToRoles(this.headHunter);
        this.rufus.addToRoles(this.bigBoss);
        this.sephiroth.addToRoles(this.headHunter);
        this.rude.addToRoles(this.accountant);
        this.rude.addToRoles(this.headHunter);
        this.elena.addToRoles(this.accountant);
        this.moe.addObjectToBothSidesOfRelationshipWithKey((EORelationshipManipulation)this.doctor, Employee.ROLES_KEY);
        this.moe.addObjectToBothSidesOfRelationshipWithKey((EORelationshipManipulation)this.barber, Employee.ROLES_KEY);
        this.ec.saveChanges();
    }

    @After
    public void tearDown() throws Exception {
        this.roles = null;
        this.shinraEmployees = null;
        this.shinraNonManager = null;
        this.shinraNonManagerNames = null;
        this.tyrellEmployees = null;
        this.paychecks = null;
        this.acme.delete();
        this.shinraInc.delete();
        this.tyrellCorp.delete();
        this.sortCo.delete();
        this.moe.delete();
        this.larry.delete();
        this.curly.delete();
        this.tyrell.delete();
        this.deckard.delete();
        this.rachael.delete();
        this.rufus.delete();
        this.rude.delete();
        this.elena.delete();
        this.sephiroth.delete();
        this.aaBb.delete();
        this.Abba.delete();
        this.paycheck5000.delete();
        this.paycheck10000.delete();
        this.paycheck15000.delete();
        this.headHunter.delete();
        this.bigBoss.delete();
        this.accountant.delete();
        this.doctor.delete();
        this.barber.delete();
        this.ec.saveChanges();
    }

    @Test
    public void testAppendString() {
        ERXKeyTest.assertEquals((String)"one", (String)new ERXKey(null).append("one").key());
        ERXKeyTest.assertEquals((String)"one", (String)new ERXKey("").append("one").key());
        ERXKeyTest.assertEquals((String)"one.two", (String)new ERXKey("one").append("two").key());
    }

    @Test
    public void testAvgNonNullERXKeyOfQ() {
        BigDecimal d = (BigDecimal)Company.EMPLOYEES.dot(ERXKey.avgNonNull((ERXKey)Employee.BEST_SALES_TOTAL)).valueInObject((Object)this.shinraInc);
        ERXKeyTest.assertTrue((BigDecimal.valueOf(7500L).compareTo(d) == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testAvgNonNull() {
        BigDecimal d = (BigDecimal)Company.EMPLOYEES.dot(Employee.BEST_SALES_TOTAL).dot(ERXKey.avgNonNull()).valueInObject((Object)this.shinraInc);
        ERXKeyTest.assertTrue((BigDecimal.valueOf(7500L).compareTo(d) == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testAtAvgNonNullERXKeyOfQ() {
        BigDecimal d = (BigDecimal)Company.EMPLOYEES.atAvgNonNull(Employee.BEST_SALES_TOTAL).valueInObject((Object)this.shinraInc);
        ERXKeyTest.assertTrue((BigDecimal.valueOf(7500L).compareTo(d) == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testAtAvgNonNull() {
        BigDecimal d = (BigDecimal)Company.EMPLOYEES.dot(Employee.BEST_SALES_TOTAL).atAvgNonNull().valueInObject((Object)this.shinraInc);
        ERXKeyTest.assertTrue((BigDecimal.valueOf(7500L).compareTo(d) == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testFetchSpecStringERXKeyOfU() {
        NSArray plebs = (NSArray)Company.EMPLOYEES.dot(ERXKey.fetchSpec((String)"plebs", (ERXKey)Employee.FIRST_NAME)).valueInObject((Object)this.shinraInc);
        ERXKeyTest.assertTrue((boolean)ERXArrayUtilities.arraysAreIdenticalSets(this.shinraNonManagerNames, (NSArray)plebs));
    }

    @Test
    public void testAtFetchSpecStringERXKeyOfU() {
        NSArray plebs = (NSArray)Company.EMPLOYEES.atFetchSpec("plebs", Employee.FIRST_NAME).valueInObject((Object)this.shinraInc);
        ERXKeyTest.assertTrue((boolean)ERXArrayUtilities.arraysAreIdenticalSets(this.shinraNonManagerNames, (NSArray)plebs));
    }

    @Test
    public void testFetchSpecString() {
        NSArray plebs = (NSArray)Company.EMPLOYEES.dot(ERXKey.fetchSpec((String)"plebs")).valueInObject((Object)this.shinraInc);
        ERXKeyTest.assertTrue((boolean)ERXArrayUtilities.arraysAreIdenticalSets(this.shinraNonManager, (NSArray)plebs));
    }

    @Test
    public void testAtFetchSpecString() {
        NSArray plebs = (NSArray)Company.EMPLOYEES.atFetchSpec("plebs").valueInObject((Object)this.shinraInc);
        ERXKeyTest.assertTrue((boolean)ERXArrayUtilities.arraysAreIdenticalSets(this.shinraNonManager, (NSArray)plebs));
    }

    @Test
    public void testFlattenERXKeyOfU() {
        Object o = Company.EMPLOYEES.dot(Employee.COMPANY).dot(Company.EMPLOYEES).dot(ERXKey.flatten()).dot(Employee.COMPANY).dot(Company.EMPLOYEES).valueInObject((Object)this.shinraInc);
        NSArray array = (NSArray)o;
        ERXKeyTest.assertTrue((array.count() == 16 ? 1 : 0) != 0);
        NSArray shinraPaychecks = (NSArray)Company.EMPLOYEES.dot(Employee.PAYCHECKS).dot(ERXKey.flatten((ERXKey)Paycheck.AMOUNT)).valueInObject((Object)this.shinraInc);
        ERXKeyTest.assertTrue((shinraPaychecks.count() == 3 ? 1 : 0) != 0);
    }

    @Test
    public void testAtFlattenERXKeyOfU() {
        BigDecimal shinraPayroll = (BigDecimal)Company.EMPLOYEES.dot(Employee.PAYCHECKS).atFlatten(Paycheck.AMOUNT).atSum().valueInObject((Object)this.shinraInc);
        ERXKeyTest.assertTrue((shinraPayroll.compareTo(new BigDecimal(30000L)) == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testFlatten() {
        NSArray shinraPaychecks = (NSArray)Company.EMPLOYEES.dot(Employee.PAYCHECKS).dot(ERXKey.flatten()).valueInObject((Object)this.shinraInc);
        ERXKeyTest.assertTrue((boolean)ERXArrayUtilities.arraysAreIdenticalSets(this.paychecks, (NSArray)shinraPaychecks));
    }

    @Test
    public void testAtFlatten() {
        NSArray shinraPaychecks = (NSArray)Company.EMPLOYEES.dot(Employee.PAYCHECKS).atFlatten().valueInObject((Object)this.shinraInc);
        ERXKeyTest.assertTrue((boolean)ERXArrayUtilities.arraysAreIdenticalSets(this.paychecks, (NSArray)shinraPaychecks));
        NSArray duplicateEmployees = (NSArray)Company.EMPLOYEES.dot(Employee.COMPANY).dot(Company.EMPLOYEES).atFlatten().valueInObject((Object)this.shinraInc);
        ERXKeyTest.assertEquals((int)16, (int)duplicateEmployees.count());
    }

    @Test
    public void testIsEmpty() {
        ERXKeyTest.assertEquals((Object)Boolean.TRUE, (Object)Employee.PAYCHECKS.dot(ERXKey.isEmpty()).valueInObject((Object)this.elena));
        ERXKeyTest.assertEquals((Object)Boolean.FALSE, (Object)Employee.PAYCHECKS.dot(ERXKey.isEmpty()).valueInObject((Object)this.rufus));
    }

    @Test
    public void testAtIsEmpty() {
        ERXKeyTest.assertEquals((Object)Boolean.TRUE, (Object)Employee.PAYCHECKS.atIsEmpty().valueInObject((Object)this.elena));
        ERXKeyTest.assertEquals((Object)Boolean.FALSE, (Object)Employee.PAYCHECKS.atIsEmpty().valueInObject((Object)this.rufus));
    }

    @Test
    public void testLimitIntegerERXKeyOfU() {
        NSArray names = (NSArray)Employee.COMPANY.dot(Company.EMPLOYEES).dot(ERXKey.limit((Integer)2, (ERXKey)Employee.FIRST_NAME)).valueInObject((Object)this.sephiroth);
        ERXKeyTest.assertTrue((names.count() == 2 ? 1 : 0) != 0);
    }

    @Test
    public void testAtLimitIntegerERXKeyOfU() {
        NSArray names = (NSArray)Employee.COMPANY.dot(Company.EMPLOYEES).atLimit(Integer.valueOf(2), Employee.FIRST_NAME).valueInObject((Object)this.sephiroth);
        ERXKeyTest.assertTrue((names.count() == 2 ? 1 : 0) != 0);
    }

    @Test
    public void testLimitInteger() {
        NSArray employees = (NSArray)Company.EMPLOYEES.dot(ERXKey.limit((Integer)2)).valueInObject((Object)this.shinraInc);
        ERXKeyTest.assertTrue((employees.count() == 2 ? 1 : 0) != 0);
    }

    @Test
    public void testAtLimitInteger() {
        NSArray employees = (NSArray)Company.EMPLOYEES.atLimit(Integer.valueOf(2)).valueInObject((Object)this.shinraInc);
        ERXKeyTest.assertTrue((employees.count() == 2 ? 1 : 0) != 0);
    }

    @Test
    public void testMedian() {
        BigDecimal d = (BigDecimal)Employee.PAYCHECKS.dot(Paycheck.AMOUNT).dot(ERXKey.median()).valueInObject((Object)this.rufus);
        ERXKeyTest.assertTrue((BigDecimal.valueOf(10000L).compareTo(d) == 0 ? 1 : 0) != 0);
        d = (BigDecimal)ERXKey.median().valueInObject((Object)new NSArray((Object)1000, new Object[]{2000, 3000, 4000}));
        ERXKeyTest.assertTrue((BigDecimal.valueOf(2500L).compareTo(d) == 0 ? 1 : 0) != 0);
        d = (BigDecimal)ERXKey.median().valueInObject((Object)new NSArray((Object)2000));
        ERXKeyTest.assertTrue((BigDecimal.valueOf(2000L).compareTo(d) == 0 ? 1 : 0) != 0);
        d = (BigDecimal)ERXKey.median().valueInObject((Object)new NSArray((Object)"1000", new Object[]{"2000", "3000", "4000"}));
        ERXKeyTest.assertTrue((BigDecimal.valueOf(2500L).compareTo(d) == 0 ? 1 : 0) != 0);
        d = (BigDecimal)ERXKey.median().valueInObject((Object)new NSArray((Object)"1000", new Object[]{"2000", "3000"}));
        ERXKeyTest.assertTrue((BigDecimal.valueOf(2000L).compareTo(d) == 0 ? 1 : 0) != 0);
        d = (BigDecimal)ERXKey.median().valueInObject((Object)new NSArray((Object)"2000"));
        ERXKeyTest.assertTrue((BigDecimal.valueOf(2000L).compareTo(d) == 0 ? 1 : 0) != 0);
        d = (BigDecimal)ERXKey.median().valueInObject((Object)NSArray.EmptyArray);
        ERXKeyTest.assertTrue((d == null ? 1 : 0) != 0);
    }

    @Test
    public void testAtMedian() {
        BigDecimal d = (BigDecimal)Employee.PAYCHECKS.dot(Paycheck.AMOUNT).atMedian().valueInObject((Object)this.rufus);
        ERXKeyTest.assertTrue((BigDecimal.valueOf(10000L).compareTo(d) == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testMedianERXKeyOfQ() {
        BigDecimal d = (BigDecimal)Employee.PAYCHECKS.dot(ERXKey.median((ERXKey)Paycheck.AMOUNT)).valueInObject((Object)this.rufus);
        ERXKeyTest.assertTrue((BigDecimal.valueOf(10000L).compareTo(d) == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testAtMedianERXKeyOfQ() {
        BigDecimal d = (BigDecimal)Employee.PAYCHECKS.atMedian(Paycheck.AMOUNT).valueInObject((Object)this.rufus);
        ERXKeyTest.assertTrue((BigDecimal.valueOf(10000L).compareTo(d) == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testObjectAtIndexIntegerERXKeyOfU() {
        String fetched = (String)Company.EMPLOYEES.atFetchSpec("plebs").atObjectAtIndex(Integer.valueOf(0)).dot(Employee.FIRST_NAME).valueInObject((Object)this.acme);
        ERXKeyTest.assertEquals((String)"Curly", (String)fetched);
    }

    @Test
    public void testAtObjectAtIndexIntegerERXKeyOfU() {
        String fetched = (String)Company.EMPLOYEES.atFetchSpec("plebs").atObjectAtIndex(Integer.valueOf(0)).dot(Employee.FIRST_NAME).valueInObject((Object)this.shinraInc);
        ERXKeyTest.assertEquals((String)"Elena", (String)fetched);
    }

    @Test
    public void testObjectAtIndexInteger() {
        Employee fetched = (Employee)((Object)Company.EMPLOYEES.atFetchSpec("plebs").dot(ERXKey.objectAtIndex((Integer)1)).valueInObject((Object)this.shinraInc));
        ERXKeyTest.assertEquals((Object)((Object)this.rude), (Object)((Object)fetched));
    }

    @Test
    public void testAtObjectAtIndexInteger() {
        Employee fetched = (Employee)((Object)Company.EMPLOYEES.atFetchSpec("plebs").atObjectAtIndex(Integer.valueOf(2)).valueInObject((Object)this.shinraInc));
        ERXKeyTest.assertEquals((Object)((Object)this.sephiroth), (Object)((Object)fetched));
    }

    @Test
    public void testSortWithKeyPath() {
        EOSortOrdering so = new EOSortOrdering("firstName.length", EOSortOrdering.CompareAscending);
        NSArray<Employee> sortedEmps = this.shinraInc.employees(null, (NSArray<EOSortOrdering>)new NSArray((Object)so), false);
        ERXKeyTest.assertTrue((boolean)((Employee)((Object)sortedEmps.objectAtIndex(0))).firstName().equals("Rude"));
    }

    @Test
    public void testRemoveNullValuesERXKeyOfU() {
        Object o = Company.EMPLOYEES.dot(Employee.BEST_SALES_TOTAL).valueInObject((Object)this.shinraInc);
        NSArray d4 = (NSArray)o;
        ERXKeyTest.assertTrue((d4.count() == 4 ? 1 : 0) != 0);
        NSArray d2 = (NSArray)Company.EMPLOYEES.dot(Employee.BEST_SALES_TOTAL).dot(ERXKey.removeNullValues()).valueInObject((Object)this.shinraInc);
        NSArray d2plus = (NSArray)Company.EMPLOYEES.dot(Employee.BEST_SALES_TOTAL).dot(ERXKey.removeNullValues((ERXKey)new ERXKey("plus"))).valueInObject((Object)this.shinraInc);
        ERXKeyTest.assertEquals(d2, d2plus);
    }

    @Test
    public void testAtRemoveNullValuesERXKeyOfU() {
        Object o = Company.EMPLOYEES.atRemoveNullValues(Employee.ROLES).dot(Role.EMPLOYEES).atFlatten().valueInObject((Object)this.acme);
        NSArray m1 = (NSArray)o;
        ERXKeyTest.assertFalse((boolean)m1.contains((Object)this.larry));
        ERXKeyTest.assertFalse((boolean)m1.contains((Object)this.curly));
        ERXKeyTest.assertTrue((boolean)m1.contains((Object)this.moe));
        ERXKeyTest.assertTrue((m1.count() == 2 ? 1 : 0) != 0);
        o = Company.EMPLOYEES.dot(Employee.ROLES).atFlatten().atRemoveNullValues(Role.EMPLOYEES).valueInObject((Object)this.acme);
        NSArray m2 = (NSArray)o;
        ERXKeyTest.assertTrue((m2.count() == 2 ? 1 : 0) != 0);
        ERXKeyTest.assertTrue((boolean)(m2.objectAtIndex(0) instanceof NSArray));
        NSArray m3 = (NSArray)m2.objectAtIndex(0);
        ERXKeyTest.assertTrue((m3.count() == 1 ? 1 : 0) != 0);
        ERXKeyTest.assertTrue((boolean)(m3.objectAtIndex(0) instanceof Employee));
        o = Company.EMPLOYEES.dot(Employee.BEST_SALES_TOTAL).valueInObject((Object)this.shinraInc);
        NSArray d4 = (NSArray)o;
        ERXKeyTest.assertTrue((d4.count() == 4 ? 1 : 0) != 0);
        NSArray d2 = (NSArray)Company.EMPLOYEES.dot(Employee.BEST_SALES_TOTAL).atRemoveNullValues().valueInObject((Object)this.shinraInc);
        NSArray d2plus = (NSArray)Company.EMPLOYEES.dot(Employee.BEST_SALES_TOTAL).atRemoveNullValues(new ERXKey("plus")).valueInObject((Object)this.shinraInc);
        ERXKeyTest.assertEquals(d2, d2plus);
    }

    @Test
    public void testRemoveNullValues() {
        Object o = Company.EMPLOYEES.dot(Employee.BEST_SALES_TOTAL).valueInObject((Object)this.shinraInc);
        NSArray d4 = (NSArray)o;
        ERXKeyTest.assertTrue((d4.count() == 4 ? 1 : 0) != 0);
        NSArray d2 = (NSArray)Company.EMPLOYEES.dot(Employee.BEST_SALES_TOTAL).dot(ERXKey.removeNullValues()).valueInObject((Object)this.shinraInc);
        ERXKeyTest.assertTrue((d2.count() == 2 ? 1 : 0) != 0);
    }

    @Test
    public void testAtRemoveNullValues() {
        Object o = Company.EMPLOYEES.dot(Employee.BEST_SALES_TOTAL).valueInObject((Object)this.shinraInc);
        NSArray d4 = (NSArray)o;
        ERXKeyTest.assertTrue((d4.count() == 4 ? 1 : 0) != 0);
        NSArray d2 = (NSArray)Company.EMPLOYEES.dot(Employee.BEST_SALES_TOTAL).atRemoveNullValues().valueInObject((Object)this.shinraInc);
        ERXKeyTest.assertTrue((d2.count() == 2 ? 1 : 0) != 0);
    }

    @Test
    public void testReverseERXKeyOfU() {
        NSArray<Employee> shinraDesc = this.shinraInc.employees((EOQualifier)Employee.MANAGER.eq((Object)Boolean.FALSE), (NSArray<EOSortOrdering>)Employee.FIRST_NAME.descs(), true);
        NSArray shinraAscReverse = (NSArray)Company.EMPLOYEES.atFetchSpec("plebs").atReverse(Employee.FIRST_NAME).valueInObject((Object)this.shinraInc);
        ERXKeyTest.assertEquals((Object)shinraDesc.valueForKey(Employee.FIRST_NAME_KEY), (Object)shinraAscReverse);
    }

    @Test
    public void testAtReverseERXKeyOfU() {
        NSArray<Employee> shinraDesc = this.shinraInc.employees((EOQualifier)Employee.MANAGER.eq((Object)Boolean.FALSE), (NSArray<EOSortOrdering>)Employee.FIRST_NAME.descs(), true);
        NSArray shinraAscReverse = (NSArray)Company.EMPLOYEES.atFetchSpec("plebs").dot(ERXKey.reverse((ERXKey)Employee.FIRST_NAME)).valueInObject((Object)this.shinraInc);
        ERXKeyTest.assertEquals((Object)shinraDesc.valueForKey(Employee.FIRST_NAME_KEY), (Object)shinraAscReverse);
    }

    @Test
    public void testReverse() {
        NSArray shinraAsc = (NSArray)Company.EMPLOYEES.atSortAsc(new ERXKey[]{Employee.FIRST_NAME}).valueInObject((Object)this.shinraInc);
        NSArray shinraDescReverse = (NSArray)Company.EMPLOYEES.atSortDesc(new ERXKey[]{Employee.FIRST_NAME}).valueInObject((Object)this.shinraInc);
        shinraDescReverse = (NSArray)ERXKey.reverse().valueInObject((Object)shinraDescReverse);
        ERXKeyTest.assertEquals(shinraAsc, shinraDescReverse);
    }

    @Test
    public void testAtReverse() {
        NSArray<Employee> shinraDesc = this.shinraInc.employees((EOQualifier)Employee.MANAGER.eq((Object)Boolean.FALSE), (NSArray<EOSortOrdering>)Employee.FIRST_NAME.descs(), true);
        NSArray shinraAscReverse = (NSArray)Company.EMPLOYEES.atFetchSpec("plebs").atReverse().valueInObject((Object)this.shinraInc);
        ERXKeyTest.assertEquals(shinraDesc, shinraAscReverse);
    }

    @Test
    public void testSort() {
        NSArray first = (NSArray)Company.EMPLOYEES.dot(ERXKey.sort((ERXKey[])new ERXKey[]{Employee.FIRST_NAME})).valueInObject((Object)this.sortCo);
        ERXKeyTest.assertEquals(new NSArray((Object)this.Abba, (Object[])new Employee[]{this.aaBb}), first);
        NSArray last = (NSArray)Company.EMPLOYEES.dot(ERXKey.sort((ERXKey[])new ERXKey[]{Employee.LAST_NAME, Employee.FIRST_NAME})).valueInObject((Object)this.sortCo);
        ERXKeyTest.assertEquals(new NSArray((Object)this.aaBb, (Object[])new Employee[]{this.Abba}), last);
    }

    @Test
    public void testAtSort() {
        NSArray first = (NSArray)Company.EMPLOYEES.atSort(new ERXKey[]{Employee.FIRST_NAME}).valueInObject((Object)this.sortCo);
        ERXKeyTest.assertEquals(new NSArray((Object)this.Abba, (Object[])new Employee[]{this.aaBb}), first);
        NSArray last = (NSArray)Company.EMPLOYEES.atSort(new ERXKey[]{Employee.LAST_NAME, Employee.FIRST_NAME}).valueInObject((Object)this.sortCo);
        ERXKeyTest.assertEquals(new NSArray((Object)this.aaBb, (Object[])new Employee[]{this.Abba}), last);
    }

    @Test
    public void testSortAsc() {
        NSArray first = (NSArray)Company.EMPLOYEES.dot(ERXKey.sortAsc((ERXKey[])new ERXKey[]{Employee.FIRST_NAME})).valueInObject((Object)this.sortCo);
        ERXKeyTest.assertEquals(new NSArray((Object)this.Abba, (Object[])new Employee[]{this.aaBb}), first);
        NSArray last = (NSArray)Company.EMPLOYEES.dot(ERXKey.sortAsc((ERXKey[])new ERXKey[]{Employee.LAST_NAME, Employee.FIRST_NAME})).valueInObject((Object)this.sortCo);
        ERXKeyTest.assertEquals(new NSArray((Object)this.aaBb, (Object[])new Employee[]{this.Abba}), last);
    }

    @Test
    public void testAtSortAsc() {
        NSArray first = (NSArray)Company.EMPLOYEES.atSortAsc(new ERXKey[]{Employee.FIRST_NAME}).valueInObject((Object)this.sortCo);
        ERXKeyTest.assertEquals(new NSArray((Object)this.Abba, (Object[])new Employee[]{this.aaBb}), first);
        NSArray last = (NSArray)Company.EMPLOYEES.atSortAsc(new ERXKey[]{Employee.LAST_NAME, Employee.FIRST_NAME}).valueInObject((Object)this.sortCo);
        ERXKeyTest.assertEquals(new NSArray((Object)this.aaBb, (Object[])new Employee[]{this.Abba}), last);
    }

    @Test
    public void testSortDesc() {
        NSArray first = (NSArray)Company.EMPLOYEES.dot(ERXKey.sortDesc((ERXKey[])new ERXKey[]{Employee.FIRST_NAME})).valueInObject((Object)this.sortCo);
        ERXKeyTest.assertEquals(new NSArray((Object)this.aaBb, (Object[])new Employee[]{this.Abba}), first);
        NSArray last = (NSArray)Company.EMPLOYEES.dot(ERXKey.sortDesc((ERXKey[])new ERXKey[]{Employee.LAST_NAME, Employee.FIRST_NAME})).valueInObject((Object)this.sortCo);
        ERXKeyTest.assertEquals(new NSArray((Object)this.Abba, (Object[])new Employee[]{this.aaBb}), last);
    }

    @Test
    public void testAtSortDesc() {
        NSArray first = (NSArray)Company.EMPLOYEES.atSortDesc(new ERXKey[]{Employee.FIRST_NAME}).valueInObject((Object)this.sortCo);
        ERXKeyTest.assertEquals(new NSArray((Object)this.aaBb, (Object[])new Employee[]{this.Abba}), first);
        NSArray last = (NSArray)Company.EMPLOYEES.atSortDesc(new ERXKey[]{Employee.LAST_NAME, Employee.FIRST_NAME}).valueInObject((Object)this.sortCo);
        ERXKeyTest.assertEquals(new NSArray((Object)this.Abba, (Object[])new Employee[]{this.aaBb}), last);
    }

    @Test
    public void testSortInsensitiveAsc() {
        NSArray first = (NSArray)Company.EMPLOYEES.dot(ERXKey.sortInsensitiveAsc((ERXKey[])new ERXKey[]{Employee.FIRST_NAME})).valueInObject((Object)this.sortCo);
        ERXKeyTest.assertEquals(new NSArray((Object)this.aaBb, (Object[])new Employee[]{this.Abba}), first);
        NSArray last = (NSArray)Company.EMPLOYEES.dot(ERXKey.sortInsensitiveAsc((ERXKey[])new ERXKey[]{Employee.LAST_NAME, Employee.FIRST_NAME})).valueInObject((Object)this.sortCo);
        ERXKeyTest.assertEquals(new NSArray((Object)this.Abba, (Object[])new Employee[]{this.aaBb}), last);
    }

    @Test
    public void testAtSortInsensitiveAsc() {
        NSArray first = (NSArray)Company.EMPLOYEES.atSortInsensitiveAsc(new ERXKey[]{Employee.FIRST_NAME}).valueInObject((Object)this.sortCo);
        ERXKeyTest.assertEquals(new NSArray((Object)this.aaBb, (Object[])new Employee[]{this.Abba}), first);
        NSArray last = (NSArray)Company.EMPLOYEES.atSortInsensitiveAsc(new ERXKey[]{Employee.LAST_NAME, Employee.FIRST_NAME}).valueInObject((Object)this.sortCo);
        ERXKeyTest.assertEquals(new NSArray((Object)this.Abba, (Object[])new Employee[]{this.aaBb}), last);
    }

    @Test
    public void testSortInsensitiveDesc() {
        NSArray first = (NSArray)Company.EMPLOYEES.atSortInsensitiveDesc(new ERXKey[]{Employee.FIRST_NAME}).valueInObject((Object)this.sortCo);
        ERXKeyTest.assertEquals(new NSArray((Object)this.Abba, (Object[])new Employee[]{this.aaBb}), first);
        NSArray last = (NSArray)Company.EMPLOYEES.atSortInsensitiveDesc(new ERXKey[]{Employee.LAST_NAME, Employee.FIRST_NAME}).valueInObject((Object)this.sortCo);
        ERXKeyTest.assertEquals(new NSArray((Object)this.aaBb, (Object[])new Employee[]{this.Abba}), last);
    }

    @Test
    public void testAtSortInsensitiveDesc() {
        NSArray first = (NSArray)Company.EMPLOYEES.dot(ERXKey.sortInsensitiveDesc((ERXKey[])new ERXKey[]{Employee.FIRST_NAME})).valueInObject((Object)this.sortCo);
        ERXKeyTest.assertEquals(new NSArray((Object)this.Abba, (Object[])new Employee[]{this.aaBb}), first);
        NSArray last = (NSArray)Company.EMPLOYEES.dot(ERXKey.sortInsensitiveDesc((ERXKey[])new ERXKey[]{Employee.LAST_NAME, Employee.FIRST_NAME})).valueInObject((Object)this.sortCo);
        ERXKeyTest.assertEquals(new NSArray((Object)this.aaBb, (Object[])new Employee[]{this.Abba}), last);
    }

    @Test
    public void testSubarrayWithRangeNSRangeERXKeyOfU() {
        NSArray acme1_1 = (NSArray)Company.EMPLOYEES.atFetchSpec("plebs").dot(ERXKey.subarrayWithRange((NSRange)new NSRange(0, 1), (ERXKey)Employee.FIRST_NAME)).valueInObject((Object)this.acme);
        ERXKeyTest.assertEquals(new NSArray((Object)"Curly"), acme1_1);
    }

    @Test
    public void testAtSubarrayWithRangeNSRangeERXKeyOfU() {
        NSArray acme1_1 = (NSArray)Company.EMPLOYEES.atFetchSpec("plebs").atSubarrayWithRange(new NSRange(1, 1), Employee.FIRST_NAME).valueInObject((Object)this.acme);
        ERXKeyTest.assertEquals(new NSArray((Object)"Larry"), acme1_1);
    }

    @Test
    public void testSubarrayWithRangeNSRange() {
        NSArray shinraAsc1_2 = (NSArray)Company.EMPLOYEES.atFetchSpec("plebs").atSubarrayWithRange(new NSRange(1, 2)).valueInObject((Object)this.shinraInc);
        ERXKeyTest.assertEquals(new NSArray((Object)this.rude, (Object[])new Employee[]{this.sephiroth}), shinraAsc1_2);
    }

    @Test
    public void testAtSubarrayWithRangeNSRange() {
        NSArray shinraAsc2_1 = (NSArray)Company.EMPLOYEES.atFetchSpec("plebs").atSubarrayWithRange(new NSRange(2, 1)).valueInObject((Object)this.shinraInc);
        ERXKeyTest.assertEquals(new NSArray((Object)this.sephiroth), shinraAsc2_1);
    }

    @Test
    public void testUniqueERXKeyOfU() {
        NSArray companyNames = (NSArray)Employee.COMPANY.atUnique(Company.NAME).valueInObject(this.tyrellEmployees);
        ERXKeyTest.assertEquals(new NSArray((Object)"Tyrell Corporation"), companyNames);
    }

    @Test
    public void testAtUniqueERXKeyOfU() {
        NSArray companyNames = (NSArray)Employee.COMPANY.dot(ERXKey.unique((ERXKey)Company.NAME)).valueInObject(this.tyrellEmployees);
        ERXKeyTest.assertEquals(new NSArray((Object)"Tyrell Corporation"), companyNames);
    }

    @Test
    public void testUnique() {
        NSArray duplicates = this.shinraEmployees.arrayByAddingObjectsFromArray(this.shinraEmployees);
        NSArray uniqued = (NSArray)ERXKey.unique().valueInObject((Object)duplicates);
        ERXKeyTest.assertTrue((boolean)ERXArrayUtilities.arraysAreIdenticalSets(this.shinraEmployees, (NSArray)uniqued));
    }

    @Test
    public void testAtUnique() {
        NSArray uniqueRoles = (NSArray)Company.EMPLOYEES.dot(Employee.ROLES).atFlatten().atUnique().valueInObject((Object)this.shinraInc);
        ERXKeyTest.assertTrue((boolean)ERXArrayUtilities.arraysAreIdenticalSets((NSArray)uniqueRoles, this.roles));
        ERXKeyTest.assertTrue((uniqueRoles.count() == 3 ? 1 : 0) != 0);
        NSArray roleArrays = (NSArray)Company.EMPLOYEES.dot(Employee.ROLES).atUnique().atFlatten().valueInObject((Object)this.shinraInc);
        ERXKeyTest.assertTrue((roleArrays.count() == 6 ? 1 : 0) != 0);
    }

    @Test
    public void testSumERXKeyOfQ() {
        BigDecimal d = (BigDecimal)Employee.PAYCHECKS.dot(ERXKey.sum((ERXKey)Paycheck.AMOUNT)).valueInObject((Object)this.rufus);
        ERXKeyTest.assertTrue((BigDecimal.valueOf(30000L).compareTo(d) == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testSum() {
        BigDecimal d = (BigDecimal)Employee.PAYCHECKS.dot(Paycheck.AMOUNT).dot(ERXKey.sum()).valueInObject((Object)this.rufus);
        ERXKeyTest.assertTrue((BigDecimal.valueOf(30000L).compareTo(d) == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testAtSumERXKeyOfQ() {
        BigDecimal d = (BigDecimal)Employee.PAYCHECKS.atSum(Paycheck.AMOUNT).valueInObject((Object)this.rufus);
        ERXKeyTest.assertTrue((BigDecimal.valueOf(30000L).compareTo(d) == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testAtSum() {
        BigDecimal d = (BigDecimal)Employee.PAYCHECKS.dot(Paycheck.AMOUNT).atSum().valueInObject((Object)this.rufus);
        ERXKeyTest.assertTrue((BigDecimal.valueOf(30000L).compareTo(d) == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testAvgERXKeyOfQ() {
        BigDecimal d = (BigDecimal)Employee.PAYCHECKS.dot(ERXKey.avg((ERXKey)Paycheck.AMOUNT)).valueInObject((Object)this.rufus);
        ERXKeyTest.assertTrue((BigDecimal.valueOf(10000L).compareTo(d) == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testAtAvgERXKeyOfQ() {
        BigDecimal d = (BigDecimal)Employee.PAYCHECKS.atAvg(Paycheck.AMOUNT).valueInObject((Object)this.rufus);
        ERXKeyTest.assertTrue((BigDecimal.valueOf(10000L).compareTo(d) == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testAvg() {
        BigDecimal d = (BigDecimal)Employee.PAYCHECKS.dot(Paycheck.AMOUNT).dot(ERXKey.avg()).valueInObject((Object)this.rufus);
        ERXKeyTest.assertTrue((BigDecimal.valueOf(10000L).compareTo(d) == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testAtAvg() {
        BigDecimal d = (BigDecimal)Employee.PAYCHECKS.dot(Paycheck.AMOUNT).atAvg().valueInObject((Object)this.rufus);
        ERXKeyTest.assertTrue((BigDecimal.valueOf(10000L).compareTo(d) == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testMinERXKeyOfU() {
        BigDecimal d = (BigDecimal)Employee.PAYCHECKS.dot(ERXKey.min((ERXKey)Paycheck.AMOUNT)).valueInObject((Object)this.rufus);
        ERXKeyTest.assertTrue((this.paycheck5000.amount().compareTo(d) == 0 ? 1 : 0) != 0);
        NSTimestamp ts = (NSTimestamp)Employee.PAYCHECKS.dot(ERXKey.min((ERXKey)Paycheck.PAYMENT_DATE)).valueInObject((Object)this.rufus);
        ERXKeyTest.assertTrue((boolean)this.paycheck5000.paymentDate().equals((Timestamp)ts));
        String s = (String)Company.EMPLOYEES.dot(ERXKey.min((ERXKey)Employee.FIRST_NAME)).valueInObject((Object)this.shinraInc);
        ERXKeyTest.assertTrue((boolean)this.elena.firstName().equals(s));
    }

    @Test
    public void testAtMinERXKeyOfU() {
        BigDecimal d = (BigDecimal)Employee.PAYCHECKS.atMin(Paycheck.AMOUNT).valueInObject((Object)this.rufus);
        ERXKeyTest.assertTrue((this.paycheck5000.amount().compareTo(d) == 0 ? 1 : 0) != 0);
        NSTimestamp ts = (NSTimestamp)Employee.PAYCHECKS.atMin(Paycheck.PAYMENT_DATE).valueInObject((Object)this.rufus);
        ERXKeyTest.assertTrue((boolean)this.paycheck5000.paymentDate().equals((Timestamp)ts));
        String s = (String)Company.EMPLOYEES.atMin(Employee.FIRST_NAME).valueInObject((Object)this.shinraInc);
        ERXKeyTest.assertTrue((boolean)this.elena.firstName().equals(s));
    }

    @Test
    public void testMin() {
        BigDecimal d = (BigDecimal)Employee.PAYCHECKS.dot(Paycheck.AMOUNT).dot(ERXKey.min()).valueInObject((Object)this.rufus);
        ERXKeyTest.assertTrue((this.paycheck5000.amount().compareTo(d) == 0 ? 1 : 0) != 0);
        NSTimestamp ts = (NSTimestamp)Employee.PAYCHECKS.dot(Paycheck.PAYMENT_DATE).dot(ERXKey.min()).valueInObject((Object)this.rufus);
        ERXKeyTest.assertTrue((boolean)this.paycheck5000.paymentDate().equals((Timestamp)ts));
        String s = (String)Company.EMPLOYEES.dot(Employee.FIRST_NAME).dot(ERXKey.min()).valueInObject((Object)this.shinraInc);
        ERXKeyTest.assertTrue((boolean)this.elena.firstName().equals(s));
    }

    @Test
    public void testAtMin() {
        BigDecimal d = (BigDecimal)Employee.PAYCHECKS.dot(Paycheck.AMOUNT).atMin().valueInObject((Object)this.rufus);
        ERXKeyTest.assertTrue((this.paycheck5000.amount().compareTo(d) == 0 ? 1 : 0) != 0);
        NSTimestamp ts = (NSTimestamp)Employee.PAYCHECKS.dot(Paycheck.PAYMENT_DATE).atMin().valueInObject((Object)this.rufus);
        ERXKeyTest.assertTrue((boolean)this.paycheck5000.paymentDate().equals((Timestamp)ts));
        String s = (String)Company.EMPLOYEES.dot(Employee.FIRST_NAME).atMin().valueInObject((Object)this.shinraInc);
        ERXKeyTest.assertTrue((boolean)this.elena.firstName().equals(s));
    }

    @Test
    public void testMaxERXKeyOfU() {
        BigDecimal d = (BigDecimal)Employee.PAYCHECKS.dot(ERXKey.max((ERXKey)Paycheck.AMOUNT)).valueInObject((Object)this.rufus);
        ERXKeyTest.assertTrue((this.paycheck15000.amount().compareTo(d) == 0 ? 1 : 0) != 0);
        NSTimestamp ts = (NSTimestamp)Employee.PAYCHECKS.dot(ERXKey.max((ERXKey)Paycheck.PAYMENT_DATE)).valueInObject((Object)this.rufus);
        ERXKeyTest.assertTrue((boolean)this.paycheck15000.paymentDate().equals((Timestamp)ts));
        String s = (String)Company.EMPLOYEES.dot(ERXKey.max((ERXKey)Employee.FIRST_NAME)).valueInObject((Object)this.shinraInc);
        ERXKeyTest.assertTrue((boolean)this.sephiroth.firstName().equals(s));
    }

    @Test
    public void testAtMaxERXKeyOfU() {
        BigDecimal d = (BigDecimal)Employee.PAYCHECKS.atMax(Paycheck.AMOUNT).valueInObject((Object)this.rufus);
        ERXKeyTest.assertTrue((this.paycheck15000.amount().compareTo(d) == 0 ? 1 : 0) != 0);
        NSTimestamp ts = (NSTimestamp)Employee.PAYCHECKS.atMax(Paycheck.PAYMENT_DATE).valueInObject((Object)this.rufus);
        ERXKeyTest.assertTrue((boolean)this.paycheck15000.paymentDate().equals((Timestamp)ts));
        String s = (String)Company.EMPLOYEES.atMax(Employee.FIRST_NAME).valueInObject((Object)this.shinraInc);
        ERXKeyTest.assertTrue((boolean)this.sephiroth.firstName().equals(s));
    }

    @Test
    public void testMax() {
        BigDecimal d = (BigDecimal)Employee.PAYCHECKS.dot(Paycheck.AMOUNT).dot(ERXKey.max()).valueInObject((Object)this.rufus);
        ERXKeyTest.assertTrue((this.paycheck15000.amount().compareTo(d) == 0 ? 1 : 0) != 0);
        NSTimestamp ts = (NSTimestamp)Employee.PAYCHECKS.dot(Paycheck.PAYMENT_DATE).dot(ERXKey.max()).valueInObject((Object)this.rufus);
        ERXKeyTest.assertTrue((boolean)this.paycheck15000.paymentDate().equals((Timestamp)ts));
        String s = (String)Company.EMPLOYEES.dot(Employee.FIRST_NAME).dot(ERXKey.max()).valueInObject((Object)this.shinraInc);
        ERXKeyTest.assertTrue((boolean)this.sephiroth.firstName().equals(s));
    }

    @Test
    public void testAtMax() {
        BigDecimal d = (BigDecimal)Employee.PAYCHECKS.dot(Paycheck.AMOUNT).atMax().valueInObject((Object)this.rufus);
        ERXKeyTest.assertTrue((this.paycheck15000.amount().compareTo(d) == 0 ? 1 : 0) != 0);
        NSTimestamp ts = (NSTimestamp)Employee.PAYCHECKS.dot(Paycheck.PAYMENT_DATE).atMax().valueInObject((Object)this.rufus);
        ERXKeyTest.assertTrue((boolean)this.paycheck15000.paymentDate().equals((Timestamp)ts));
        String s = (String)Company.EMPLOYEES.dot(Employee.FIRST_NAME).atMax().valueInObject((Object)this.shinraInc);
        ERXKeyTest.assertTrue((boolean)this.sephiroth.firstName().equals(s));
    }

    @Test
    public void testCount() {
        Integer count = (Integer)Employee.PAYCHECKS.dot(ERXKey.count()).valueInObject((Object)this.rufus);
        ERXKeyTest.assertEquals((Object)3, (Object)count);
        count = (Integer)ERXKey.count().valueInObject(this.shinraEmployees);
        ERXKeyTest.assertEquals((Object)4, (Object)count);
    }

    @Test
    public void testAtCount() {
        Integer count = (Integer)Employee.PAYCHECKS.atCount().valueInObject((Object)this.rufus);
        ERXKeyTest.assertEquals((Object)3, (Object)count);
        count = (Integer)Company.EMPLOYEES.atCount().valueInObject((Object)this.shinraInc);
        ERXKeyTest.assertEquals((Object)4, (Object)count);
        count = (Integer)Company.EMPLOYEES.dot(Employee.ROLES).atCount().valueInObject((Object)this.shinraInc);
        ERXKeyTest.assertEquals((Object)4, (Object)count);
    }

    public void testPopStdDev() {
        BigDecimal yuri = (BigDecimal)ERXKey.popStdDev().valueInObject(simpleNumbers);
        ERXKeyTest.assertTrue((BigDecimal.valueOf(Math.sqrt(2.0)).compareTo(yuri) == 0 ? 1 : 0) != 0);
    }

    public void testAtPopStdDev() {
        BigDecimal yuri = (BigDecimal)num.atPopStdDev().valueInObject(numbers);
        ERXKeyTest.assertTrue((BigDecimal.valueOf(Math.sqrt(2.0)).compareTo(yuri) == 0 ? 1 : 0) != 0);
    }

    public void testPopStdDevERXKeyOfQ() {
        BigDecimal yuri = (BigDecimal)ERXKey.popStdDev(num).valueInObject(numbers);
        ERXKeyTest.assertTrue((BigDecimal.valueOf(Math.sqrt(2.0)).compareTo(yuri) == 0 ? 1 : 0) != 0);
    }

    public void testAtPopStdDevERXKeyOfQ() {
        BigDecimal yuri = (BigDecimal)num.atPopStdDev(new ERXKey("toString")).valueInObject(numbers);
        ERXKeyTest.assertTrue((BigDecimal.valueOf(Math.sqrt(2.0)).compareTo(yuri) == 0 ? 1 : 0) != 0);
    }

    public void testStdDev() {
        BigDecimal yuri = (BigDecimal)ERXKey.stdDev().valueInObject(simpleNumbers);
        ERXKeyTest.assertTrue((BigDecimal.valueOf(Math.sqrt(2.5)).compareTo(yuri) == 0 ? 1 : 0) != 0);
    }

    public void testAtStdDev() {
        BigDecimal yuri = (BigDecimal)num.atStdDev().valueInObject(numbers);
        ERXKeyTest.assertTrue((BigDecimal.valueOf(Math.sqrt(2.5)).compareTo(yuri) == 0 ? 1 : 0) != 0);
    }

    public void testStdDevERXKeyOfQ() {
        BigDecimal yuri = (BigDecimal)ERXKey.stdDev(num).valueInObject(numbers);
        ERXKeyTest.assertTrue((BigDecimal.valueOf(Math.sqrt(2.5)).compareTo(yuri) == 0 ? 1 : 0) != 0);
    }

    public void testAtStdDevERXKeyOfQ() {
        BigDecimal yuri = (BigDecimal)num.atStdDev(new ERXKey("toString")).valueInObject(numbers);
        ERXKeyTest.assertTrue((BigDecimal.valueOf(Math.sqrt(2.5)).compareTo(yuri) == 0 ? 1 : 0) != 0);
    }
}

