/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.formatters;

import com.ibm.icu.util.GregorianCalendar;
import com.ibm.icu.util.TimeZone;
import com.webobjects.foundation.NSTimeZone;
import com.webobjects.foundation.NSTimestamp;
import er.extensions.formatters.ERXOrdinalDateFormatter;
import java.text.ParseException;
import junit.framework.Assert;
import junit.framework.TestCase;

public class ERXOrdinalDateFormatterTests
extends TestCase {
    public void testFormatNSTimestamp() {
        ERXOrdinalDateFormatter formatter = new ERXOrdinalDateFormatter("d'th'");
        formatter.setDefaultFormatTimeZone(NSTimeZone.getGMT());
        GregorianCalendar cal = new GregorianCalendar(2000, 0, 1, 23, 59, 59);
        cal.setTimeZone(TimeZone.getTimeZone((String)"GMT"));
        Assert.assertEquals((String)"1st", (String)formatter.format((Object)new NSTimestamp(cal.getTime())));
        cal.add(5, 1);
        Assert.assertEquals((String)"2nd", (String)formatter.format((Object)new NSTimestamp(cal.getTime())));
        cal.add(5, 1);
        Assert.assertEquals((String)"3rd", (String)formatter.format((Object)new NSTimestamp(cal.getTime())));
        cal.add(5, 1);
        Assert.assertEquals((String)"4th", (String)formatter.format((Object)new NSTimestamp(cal.getTime())));
        cal.add(5, 7);
        Assert.assertEquals((String)"11th", (String)formatter.format((Object)new NSTimestamp(cal.getTime())));
        cal.add(5, 1);
        Assert.assertEquals((String)"12th", (String)formatter.format((Object)new NSTimestamp(cal.getTime())));
        cal.add(5, 1);
        Assert.assertEquals((String)"13th", (String)formatter.format((Object)new NSTimestamp(cal.getTime())));
        cal.add(5, 1);
        Assert.assertEquals((String)"14th", (String)formatter.format((Object)new NSTimestamp(cal.getTime())));
        cal.add(5, 7);
        Assert.assertEquals((String)"21st", (String)formatter.format((Object)new NSTimestamp(cal.getTime())));
        cal.add(5, 1);
        Assert.assertEquals((String)"22nd", (String)formatter.format((Object)new NSTimestamp(cal.getTime())));
        cal.add(5, 1);
        Assert.assertEquals((String)"23rd", (String)formatter.format((Object)new NSTimestamp(cal.getTime())));
        cal.add(5, 1);
        Assert.assertEquals((String)"24th", (String)formatter.format((Object)new NSTimestamp(cal.getTime())));
        cal.add(5, 7);
        Assert.assertEquals((String)"31st", (String)formatter.format((Object)new NSTimestamp(cal.getTime())));
    }

    public void testFormatThenParse() throws ParseException {
        ERXOrdinalDateFormatter dateFormatter = new ERXOrdinalDateFormatter("d'th 'MMM' 'yyyy' 'HH':'mm':'ss");
        NSTimestamp timestamp = new NSTimestamp(new GregorianCalendar(2000, 0, 1).getTime());
        String formatted = dateFormatter.format(timestamp);
        NSTimestamp parsed = (NSTimestamp)dateFormatter.parseObject(formatted);
        String formatted2 = dateFormatter.format(parsed);
        ERXOrdinalDateFormatterTests.assertEquals((String)formatted, (String)formatted2);
    }
}

