/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.foundation;

import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSKeyValueCoding;
import com.webobjects.foundation.NSKeyValueCodingAdditions;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableSet;
import com.webobjects.foundation.NSSelector;
import com.webobjects.foundation.NSSet;
import com.webobjects.foundation._NSDictionaryUtilities;
import com.webobjects.foundation._NSUtilities;

public final class _NSArrayUtilities {
    private static final int _SCAN_THRESHOLD = 16;
    public static final NSSelector _nameSelector = new NSSelector("name", null);

    public static Object arrayWithGCDBase(NSArray arr) {
        return _NSArrayUtilities.arrayWithGCDBase(arr.objectsNoCopy());
    }

    public static Object arrayWithGCDBase(NSSet set) {
        return _NSArrayUtilities.arrayWithGCDBase(set.objectsNoCopy());
    }

    public static Object arrayWithGCDBase(Object[] objects) {
        int c = objects.length;
        Object[] result = new Object[c];
        for (int i = 0; i < c; ++i) {
            Object index = objects[i];
            if (index == NSKeyValueCoding.NullValue) {
                index = null;
            }
            result[i] = index;
        }
        return result;
    }

    public static NSArray indexesForObjectsIndenticalTo(NSArray self, NSArray other) {
        if (other != null) {
            int count = other.count();
            NSMutableArray result = new NSMutableArray(count);
            for (int i = 0; i < count; ++i) {
                Object object = other.objectAtIndex(i);
                int idx = self.indexOfIdenticalObject(object);
                if (idx < 0) continue;
                result.addObject(_NSUtilities.IntegerForInt(idx));
            }
            return result;
        }
        return NSArray.EmptyArray;
    }

    public static NSArray objectsAtIndexes(NSArray self, NSArray indexes) {
        if (indexes != null) {
            int count = indexes.count();
            NSMutableArray result = new NSMutableArray(count);
            for (int i = 0; i < count; ++i) {
                result.addObject(self.objectAtIndex(((Number)indexes.objectAtIndex(i)).intValue()));
            }
            return result;
        }
        return NSArray.EmptyArray;
    }

    public static NSArray closestMatchingIndexes(NSArray self, int max, boolean selectFirstOnNoMatch) {
        int count = self.count();
        NSMutableArray result = new NSMutableArray(count);
        boolean strippedBig = false;
        for (int i = 0; i < count; ++i) {
            Integer number = (Integer)self.objectAtIndex(i);
            int index = number;
            if (index < max) {
                result.addObject(number);
                continue;
            }
            strippedBig = true;
        }
        if (result.count() == 0 && count != 0 && max != 0) {
            if (selectFirstOnNoMatch || !strippedBig) {
                result.addObject(_NSUtilities.IntegerForInt(0));
            } else {
                result.addObject(_NSUtilities.IntegerForInt(max - 1));
            }
        }
        return result;
    }

    public static NSArray arrayExcludingObjectsInArray(NSArray self, NSArray array) {
        NSMutableArray result = null;
        if (self == null || array == null) {
            return self;
        }
        int count = self.count();
        int otherCount = array.count();
        if (otherCount == 0) {
            return self;
        }
        if (count * otherCount < 100) {
            while (count-- > 0) {
                Object o = self.objectAtIndex(count);
                if (array.indexOfIdenticalObject(o) >= 0) continue;
                if (result == null) {
                    result = new NSMutableArray();
                }
                result.addObject(o);
            }
        } else {
            NSMutableSet table = new NSMutableSet(otherCount);
            while (otherCount-- > 0) {
                table.addObject(array.objectAtIndex(otherCount));
            }
            while (count-- > 0) {
                Object o = self.objectAtIndex(count);
                if (table.containsObject(o)) continue;
                if (result == null) {
                    result = new NSMutableArray();
                }
                result.addObject(o);
            }
        }
        return result;
    }

    public static boolean addObjectIfAbsent(NSMutableArray self, Object object) {
        if (self.indexOfIdenticalObject(object) < 0) {
            self.addObject(object);
            return true;
        }
        return false;
    }

    public static NSMutableArray resultsOfPerformingSelector(NSArray array, NSSelector selector) {
        if (selector == null) {
            throw new IllegalStateException("Cannot execute _resultsOfPerformingSelector with a null selector");
        }
        String selectorName = null;
        NSMutableArray results = new NSMutableArray();
        int count = array.count();
        for (int i = 0; i < count; ++i) {
            Object value;
            Object object = array.objectAtIndex(i);
            if (object instanceof NSKeyValueCoding) {
                if (selectorName == null) {
                    selectorName = selector.name();
                }
                value = ((NSKeyValueCoding)object).valueForKey(selectorName);
            } else {
                value = NSSelector._safeInvokeSelector(selector, object, null);
            }
            if (value == null) continue;
            results.addObject(value);
        }
        return results;
    }

    public static NSArray arrayExcludingObjectsFromArray(NSArray array, NSArray excludeObjects) {
        NSMutableArray excludingArray = new NSMutableArray(array);
        excludingArray.removeObjectsInArray(excludeObjects);
        return excludingArray;
    }

    public static boolean containsIdenticalObjectsInArray(NSArray array1, NSArray array2) {
        int count = array1.count();
        if (array2.count() != count) {
            return false;
        }
        while (count-- != 0) {
            if (-1 != array1.indexOfIdenticalObject(array2.objectAtIndex(count))) continue;
            return false;
        }
        return true;
    }

    public static NSArray arrayWithValuesForKey(NSArray array, String key) {
        if (array == null) {
            return null;
        }
        int count = array.count();
        NSMutableArray result = new NSMutableArray();
        for (int i = 0; i < count; ++i) {
            Object val = ((NSKeyValueCodingAdditions)array.objectAtIndex(i)).valueForKeyPath(key);
            if (val == null) continue;
            result.addObject(val);
        }
        return result;
    }

    private static Object scanRange(Object[] array, String name, int min, int max) {
        for (int i = min; i < max; ++i) {
            Object object = array[i];
            String aName = (String)NSSelector._safeInvokeSelector(_nameSelector, object, null);
            if (!name.equals(aName)) continue;
            return object;
        }
        return null;
    }

    private static Object objectInRange(Object[] array, String name, int min, int max) {
        if (max - min < 16) {
            return _NSArrayUtilities.scanRange(array, name, min, max);
        }
        int mid = min + (max - min) / 2;
        Object object = array[mid];
        String aName = (String)NSSelector._safeInvokeSelector(_nameSelector, object, null);
        int comp = name.compareTo(aName);
        if (comp < 0) {
            return _NSArrayUtilities.objectInRange(array, name, min, mid);
        }
        if (comp > 0) {
            return _NSArrayUtilities.objectInRange(array, name, mid + 1, max);
        }
        return object;
    }

    public static Object objectInSortedArrayWithName(NSArray array, String name) {
        int iCount;
        if (name == null) {
            return null;
        }
        int n = iCount = array != null ? array.count() : 0;
        if (iCount == 0) {
            return null;
        }
        Object[] allObjects = array.objects();
        return _NSArrayUtilities.objectInRange(allObjects, name, 0, iCount);
    }

    public static NSMutableArray mutablePropertyList(NSArray theArray) {
        int count = theArray.count();
        NSMutableArray array = new NSMutableArray();
        for (int k = 0; k < count; ++k) {
            Object object = theArray.objectAtIndex(k);
            if (object instanceof NSDictionary) {
                object = _NSDictionaryUtilities.mutablePropertyList((NSDictionary)object);
            } else if (object instanceof NSArray) {
                object = _NSArrayUtilities.mutablePropertyList((NSArray)object);
            }
            array.addObject(object);
        }
        return array;
    }

    public static void performSelectorWithEachObjectInArray(Object object, NSSelector selector, NSArray array) {
        if (array == null) {
            return;
        }
        int iCount = array.count();
        for (int i = 0; i < iCount; ++i) {
            NSSelector._safeInvokeSelector(selector, object, new Object[]{array.objectAtIndex(i)});
        }
    }

    public static NSArray resultsOfPerformingSelectorWithEachObjectInArray(Object object, NSSelector selector, NSArray args) {
        if (args == null) {
            return null;
        }
        NSMutableArray results = new NSMutableArray();
        int iCount = args.count();
        for (int i = 0; i < iCount; ++i) {
            results.addObject(NSSelector._safeInvokeSelector(selector, object, new Object[]{args.objectAtIndex(i)}));
        }
        return results;
    }

    public static NSMutableArray mutableArrayFromArray(NSArray array) {
        if (array == null) {
            return new NSMutableArray();
        }
        return array.mutableClone();
    }
}

