/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.foundation;

import com.webobjects.foundation.NSData;
import com.webobjects.foundation.NSRange;
import com.webobjects.foundation._NSStringUtilities;
import com.webobjects.foundation._NSUtilities;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;

public class NSMutableData
extends NSData {
    public static final Class _CLASS = _NSUtilities._classWithFullySpecifiedName("com.webobjects.foundation.NSMutableData");
    static final long serialVersionUID = -1574835879605576157L;
    private static final int _DefaultInitialCapacity = 128;
    protected transient byte[] _immutableCopy;

    public NSMutableData() {
        this(128);
    }

    public NSMutableData(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException("Capacity cannot be less than 0");
        }
        this._bytes = new byte[capacity];
    }

    public NSMutableData(byte[] bytes) {
        super(bytes);
    }

    public NSMutableData(byte[] bytes, NSRange range) {
        super(bytes, range);
    }

    public NSMutableData(byte[] bytes, NSRange range, boolean noCopy) {
        super(bytes, range, noCopy);
    }

    public NSMutableData(NSData otherData) {
        super(otherData.immutableBytes(), otherData.immutableRange(), false);
    }

    public NSMutableData(InputStream inputStream, int chunkSize) throws IOException {
        super(inputStream, chunkSize);
    }

    public NSMutableData(File file) throws IOException {
        if (!file.exists()) {
            throw new IllegalArgumentException("file '" + file.getName() + "' does not exist");
        }
        this._createBytesFromInputStream(new FileInputStream(file), (int)file.length(), true);
    }

    public NSMutableData(URL url) throws IOException {
        URLConnection connection = url.openConnection();
        connection.connect();
        this._createBytesFromInputStream(connection.getInputStream(), connection.getContentLength(), true);
    }

    public NSMutableData(String value) {
        this(value, null);
    }

    public NSMutableData(String value, String encoding) {
        this(_NSStringUtilities.bytesForString(value, encoding));
    }

    protected byte[] immutableBytes() {
        if (this._immutableCopy == null) {
            int length = this.length();
            this._immutableCopy = new byte[length];
            System.arraycopy(this.bytesNoCopy(), this._offset(), this._immutableCopy, 0, length);
        }
        return this._immutableCopy;
    }

    protected NSRange immutableRange() {
        return new NSRange(0, this._range._length);
    }

    public void setLength(int length) {
        int capacity = (this._bytes != null ? this._bytes.length : 0) - this._range._location;
        if (this._bytes == null || length > capacity) {
            if (length > (capacity *= 2)) {
                capacity = length;
            }
            byte[] bytes = new byte[capacity];
            if (this._bytes != null) {
                System.arraycopy(this._bytes, this._range._location, bytes, 0, this._range._length);
            }
            this._bytes = bytes;
            this._range._location = 0;
        } else {
            for (int i = this._range._length; i < length; ++i) {
                this._bytes[this._range._location + i] = 0;
            }
        }
        this._range._length = length;
        this._immutableCopy = null;
        this._setMustRecomputeHash(true);
    }

    public void setData(NSData otherData) {
        int length = otherData.length();
        this.setLength(length);
        if (length > 0) {
            System.arraycopy(otherData.bytesNoCopy(), otherData._offset(), this._bytes, this._range._location, length);
        }
        this._setMustRecomputeHash(true);
    }

    public void resetBytesInRange(NSRange range) {
        int rangeLength;
        int rangeLocation = range.location();
        if (rangeLocation + (rangeLength = range.length()) > this._range._length) {
            throw new IllegalArgumentException("range out of bounds");
        }
        for (int i = 0; i < rangeLength; ++i) {
            this._bytes[i + this._range._location + rangeLocation] = 0;
        }
        this._immutableCopy = null;
        this._setMustRecomputeHash(true);
    }

    public void appendByte(byte singleByte) {
        this.increaseLengthBy(1);
        this._bytes[this._range._location + this._range._length - 1] = singleByte;
        this._immutableCopy = null;
        this._setMustRecomputeHash(true);
    }

    public void appendBytes(byte[] bytes, NSRange range) {
        int length = range.length();
        int location = range.location();
        if (length > 0) {
            if (location + length > bytes.length) {
                throw new IllegalArgumentException("range out of bounds for bytes");
            }
            int oldLength = this._range._length;
            this.increaseLengthBy(length);
            System.arraycopy(bytes, location, this._bytes, this._range._location + oldLength, length);
            this._immutableCopy = null;
            this._setMustRecomputeHash(true);
        }
    }

    public void appendBytes(byte[] bytes) {
        this.appendBytes(bytes, new NSRange(0, bytes.length));
    }

    public void appendData(NSData otherData) {
        this.appendBytes(otherData.bytesNoCopy(), otherData.rangeNoCopy());
    }

    public void increaseLengthBy(int additionalLength) {
        this.setLength(this.length() + additionalLength);
    }

    public Object clone() {
        return new NSMutableData(this);
    }
}

